
DROP TABLE IF EXISTS `#__action_log_config`;
CREATE TABLE `#__action_log_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) NOT NULL DEFAULT '',
  `type_alias` varchar(255) NOT NULL DEFAULT '',
  `id_holder` varchar(255) DEFAULT NULL,
  `title_holder` varchar(255) DEFAULT NULL,
  `table_name` varchar(255) DEFAULT NULL,
  `text_prefix` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;

INSERT INTO `#__action_log_config` (`id`, `type_title`, `type_alias`, `id_holder`, `title_holder`, `table_name`, `text_prefix`) VALUES
(1, 'article', 'com_content.article', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
(2, 'article', 'com_content.form', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
(3, 'banner', 'com_banners.banner', 'id', 'name', '#__banners', 'PLG_ACTIONLOG_JOOMLA'),
(4, 'user_note', 'com_users.note', 'id', 'subject', '#__user_notes', 'PLG_ACTIONLOG_JOOMLA'),
(5, 'media', 'com_media.file', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
(6, 'category', 'com_categories.category', 'id', 'title', '#__categories', 'PLG_ACTIONLOG_JOOMLA'),
(7, 'menu', 'com_menus.menu', 'id', 'title', '#__menu_types', 'PLG_ACTIONLOG_JOOMLA'),
(8, 'menu_item', 'com_menus.item', 'id', 'title', '#__menu', 'PLG_ACTIONLOG_JOOMLA'),
(9, 'newsfeed', 'com_newsfeeds.newsfeed', 'id', 'name', '#__newsfeeds', 'PLG_ACTIONLOG_JOOMLA'),
(10, 'link', 'com_redirect.link', 'id', 'old_url', '#__redirect_links', 'PLG_ACTIONLOG_JOOMLA'),
(11, 'tag', 'com_tags.tag', 'id', 'title', '#__tags', 'PLG_ACTIONLOG_JOOMLA'),
(12, 'style', 'com_templates.style', 'id', 'title', '#__template_styles', 'PLG_ACTIONLOG_JOOMLA'),
(13, 'plugin', 'com_plugins.plugin', 'extension_id', 'name', '#__extensions', 'PLG_ACTIONLOG_JOOMLA'),
(14, 'component_config', 'com_config.component', 'extension_id', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
(15, 'contact', 'com_contact.contact', 'id', 'name', '#__contact_details', 'PLG_ACTIONLOG_JOOMLA'),
(16, 'module', 'com_modules.module', 'id', 'title', '#__modules', 'PLG_ACTIONLOG_JOOMLA'),
(17, 'access_level', 'com_users.level', 'id', 'title', '#__viewlevels', 'PLG_ACTIONLOG_JOOMLA'),
(18, 'banner_client', 'com_banners.client', 'id', 'name', '#__banner_clients', 'PLG_ACTIONLOG_JOOMLA'),
(19, 'application_config', 'com_config.application', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA');

DROP TABLE IF EXISTS `#__action_logs`;
CREATE TABLE `#__action_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `message_language_key` varchar(255) NOT NULL DEFAULT '',
  `message` text NOT NULL,
  `log_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `extension` varchar(50) NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT 0,
  `item_id` int(11) NOT NULL DEFAULT 0,
  `ip_address` varchar(40) NOT NULL DEFAULT '0.0.0.0',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_user_id_logdate` (`user_id`,`log_date`),
  KEY `idx_user_id_extension` (`user_id`,`extension`),
  KEY `idx_extension_item_id` (`extension`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `#__action_logs_extensions`;
CREATE TABLE `#__action_logs_extensions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `extension` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

INSERT INTO `#__action_logs_extensions` (`id`, `extension`) VALUES
(1, 'com_banners'),
(2, 'com_cache'),
(3, 'com_categories'),
(4, 'com_config'),
(5, 'com_contact'),
(6, 'com_content'),
(7, 'com_installer'),
(8, 'com_media'),
(9, 'com_menus'),
(10, 'com_messages'),
(11, 'com_modules'),
(12, 'com_newsfeeds'),
(13, 'com_plugins'),
(14, 'com_redirect'),
(15, 'com_tags'),
(16, 'com_templates'),
(17, 'com_users'),
(18, 'com_checkin');

DROP TABLE IF EXISTS `#__action_logs_users`;
CREATE TABLE `#__action_logs_users` (
  `user_id` int(11) unsigned NOT NULL,
  `notify` tinyint(1) unsigned NOT NULL,
  `extensions` text NOT NULL,
  PRIMARY KEY (`user_id`),
  KEY `idx_notify` (`notify`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `#__assets`;
CREATE TABLE `#__assets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set parent.',
  `lft` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set rgt.',
  `level` int(10) unsigned NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_asset_name` (`name`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=217 DEFAULT CHARSET=utf8;

INSERT INTO `#__assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES
(1, 0, 1, 492, 0, 'root.1', 'Root Asset', '{"core.login.site":{"6":1,"2":1},"core.login.admin":{"6":1},"core.login.offline":[],"core.admin":{"8":1},"core.manage":{"7":1},"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"3":1}}'),
(2, 1, 2, 3, 1, 'com_admin', 'com_admin', '{}'),
(3, 1, 4, 15, 1, 'com_banners', 'com_banners', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(4, 1, 16, 17, 1, 'com_cache', 'com_cache', '{"core.admin":{"7":1},"core.manage":{"7":1}}'),
(5, 1, 18, 19, 1, 'com_checkin', 'com_checkin', '{"core.admin":{"7":1},"core.manage":{"7":1}}'),
(6, 1, 20, 21, 1, 'com_config', 'com_config', '{}'),
(7, 1, 22, 93, 1, 'com_contact', 'com_contact', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(8, 1, 94, 341, 1, 'com_content', 'com_content', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1,"12":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(9, 1, 342, 343, 1, 'com_cpanel', 'com_cpanel', '{}'),
(10, 1, 344, 345, 1, 'com_installer', 'com_installer', '{"core.admin":{"7":1},"core.manage":{"7":1},"core.create":[],"core.delete":[],"core.edit.state":[]}'),
(11, 1, 346, 347, 1, 'com_languages', 'com_languages', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(12, 1, 348, 349, 1, 'com_login', 'com_login', '{}'),
(13, 1, 350, 351, 1, 'com_mailto', 'com_mailto', '{}'),
(14, 1, 352, 353, 1, 'com_massmail', 'com_massmail', '{}'),
(15, 1, 354, 355, 1, 'com_media', 'com_media', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":{"5":1},"core.edit":[],"core.edit.state":[]}'),
(16, 1, 356, 357, 1, 'com_menus', 'com_menus', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(17, 1, 41, 42, 1, 'com_messages', 'com_messages', '{"core.admin":{"7":1},"core.manage":{"7":1}}'),
(18, 1, 360, 361, 1, 'com_modules', 'com_modules', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(19, 1, 362, 369, 1, 'com_newsfeeds', 'com_newsfeeds', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(20, 1, 370, 371, 1, 'com_plugins', 'com_plugins', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(21, 1, 372, 373, 1, 'com_redirect', 'com_redirect', '{"core.admin":{"7":1},"core.manage":[]}'),
(22, 1, 374, 375, 1, 'com_search', 'com_search', '{"core.admin":{"7":1},"core.manage":{"6":1}}'),
(23, 1, 376, 377, 1, 'com_templates', 'com_templates', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(24, 1, 378, 379, 1, 'com_users', 'com_users', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(26, 1, 380, 381, 1, 'com_wrapper', 'com_wrapper', '{}'),
(34, 8, 111, 118, 2, 'com_content.category.9', 'Uncategorised', '{"core.create":{"10":0,"12":0},"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(35, 3, 7, 8, 2, 'com_banners.category.10', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(36, 7, 27, 28, 2, 'com_contact.category.11', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(37, 19, 365, 366, 2, 'com_newsfeeds.category.12', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(39, 8, 119, 302, 2, 'com_content.category.14', 'Sample Data-Articles', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(40, 3, 9, 10, 2, 'com_banners.category.15', 'Sample Data-Banners', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(41, 7, 29, 90, 2, 'com_contact.category.16', 'Sample Data-Contact', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(42, 19, 367, 368, 2, 'com_newsfeeds.category.17', 'Sample Data-Newsfeeds', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(44, 39, 120, 251, 3, 'com_content.category.19', 'Joomla!', '{"core.create":{"10":0,"12":0},"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(45, 44, 121, 228, 4, 'com_content.category.20', 'Extensions', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(46, 45, 122, 137, 5, 'com_content.category.21', 'Components', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(47, 45, 138, 197, 5, 'com_content.category.22', 'Modules', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(48, 45, 198, 209, 5, 'com_content.category.23', 'Templates', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(49, 45, 210, 211, 5, 'com_content.category.24', 'Languages', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(50, 45, 212, 227, 5, 'com_content.category.25', 'Plugins', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(51, 39, 252, 283, 3, 'com_content.category.26', 'Park Site', '{"core.create":{"10":0,"12":0},"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(52, 51, 253, 258, 4, 'com_content.category.27', 'Park Blog', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(53, 51, 259, 280, 4, 'com_content.category.28', 'Photo Gallery', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(54, 39, 284, 297, 3, 'com_content.category.29', 'Fruit Shop Site', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(55, 54, 285, 290, 4, 'com_content.category.30', 'Growers', '{"core.create":{"12":0},"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(59, 41, 30, 31, 3, 'com_contact.category.34', 'Park Site', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(60, 41, 32, 89, 3, 'com_contact.category.35', 'Shop Site', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(61, 60, 33, 34, 4, 'com_contact.category.36', 'Staff', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(62, 60, 35, 88, 4, 'com_contact.category.37', 'Fruit Encyclopedia', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(63, 62, 36, 37, 5, 'com_contact.category.38', 'A', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(64, 62, 38, 39, 5, 'com_contact.category.39', 'B', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(65, 62, 40, 41, 5, 'com_contact.category.40', 'C', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(66, 62, 42, 43, 5, 'com_contact.category.41', 'D', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(67, 62, 44, 45, 5, 'com_contact.category.42', 'E', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(68, 62, 46, 47, 5, 'com_contact.category.43', 'F', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(69, 62, 48, 49, 5, 'com_contact.category.44', 'G', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(70, 62, 50, 51, 5, 'com_contact.category.45', 'H', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(71, 62, 52, 53, 5, 'com_contact.category.46', 'I', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(72, 62, 54, 55, 5, 'com_contact.category.47', 'J', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(73, 62, 56, 57, 5, 'com_contact.category.48', 'K', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(74, 62, 58, 59, 5, 'com_contact.category.49', 'L', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(75, 62, 60, 61, 5, 'com_contact.category.50', 'M', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(76, 62, 62, 63, 5, 'com_contact.category.51', 'N', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(77, 62, 64, 65, 5, 'com_contact.category.52', 'O', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(78, 62, 66, 67, 5, 'com_contact.category.53', 'P', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(79, 62, 68, 69, 5, 'com_contact.category.54', 'Q', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(80, 62, 70, 71, 5, 'com_contact.category.55', 'R', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(81, 62, 72, 73, 5, 'com_contact.category.56', 'S', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(82, 62, 74, 75, 5, 'com_contact.category.57', 'T', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(83, 62, 76, 77, 5, 'com_contact.category.58', 'U', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(84, 62, 78, 79, 5, 'com_contact.category.59', 'V', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(85, 62, 80, 81, 5, 'com_contact.category.60', 'W', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(86, 62, 82, 83, 5, 'com_contact.category.61', 'X', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(87, 62, 84, 85, 5, 'com_contact.category.62', 'Y', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(88, 62, 86, 87, 5, 'com_contact.category.63', 'Z', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(89, 46, 123, 124, 6, 'com_content.article.1', 'Administrator Components', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(90, 93, 140, 141, 7, 'com_content.article.2', 'Archive Module', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(91, 93, 142, 143, 7, 'com_content.article.3', 'Article Categories Module', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(92, 93, 144, 145, 7, 'com_content.article.4', 'Articles Category Module', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(93, 47, 139, 154, 6, 'com_content.category.64', 'Content Modules', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(94, 47, 155, 162, 6, 'com_content.category.65', 'User Modules', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(95, 47, 163, 176, 6, 'com_content.category.66', 'Display Modules', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(96, 47, 177, 190, 6, 'com_content.category.67', 'Utility Modules', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(97, 48, 199, 200, 6, 'com_content.category.68', 'Atomic', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(98, 48, 201, 202, 6, 'com_content.category.69', 'Beez 20', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(99, 48, 203, 204, 6, 'com_content.category.70', 'Beez5', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(100, 48, 205, 206, 6, 'com_content.category.71', 'Milky Way', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(101, 50, 213, 214, 6, 'com_content.article.5', 'Authentication', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(102, 51, 281, 282, 4, 'com_content.article.6', 'Australian Parks ', '{"core.delete":[],"core.edit":{"2":1},"core.edit.state":[]}'),
(103, 95, 164, 165, 7, 'com_content.article.7', 'Banner Module', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(104, 44, 229, 230, 4, 'com_content.article.8', 'Beginners', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(105, 46, 125, 126, 6, 'com_content.article.9', 'Contact', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(106, 46, 127, 128, 6, 'com_content.article.10', 'Content', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(107, 109, 271, 272, 6, 'com_content.article.11', 'Cradle Mountain', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(108, 53, 260, 269, 5, 'com_content.category.72', 'Animals', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(109, 53, 270, 279, 5, 'com_content.category.73', 'Scenery', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(110, 95, 166, 167, 7, 'com_content.article.12', 'Custom HTML Module', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(111, 54, 291, 292, 4, 'com_content.article.13', 'Directions', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(112, 50, 215, 216, 6, 'com_content.article.14', 'Editors', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(113, 50, 217, 218, 6, 'com_content.article.15', 'Editors-xtd', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(114, 95, 168, 169, 7, 'com_content.article.16', 'Feed Display', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(115, 52, 254, 255, 5, 'com_content.article.17', 'First Blog Post', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(116, 52, 256, 257, 5, 'com_content.article.18', 'Second Blog Post', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(117, 95, 170, 171, 7, 'com_content.article.19', 'Footer Module', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(118, 54, 293, 294, 4, 'com_content.article.20', 'Fruit Shop', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(119, 44, 231, 232, 4, 'com_content.article.21', 'Getting Help', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(120, 44, 233, 234, 4, 'com_content.article.22', 'Getting Started', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(121, 55, 286, 287, 5, 'com_content.article.23', 'Happy Orange Orchard', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(122, 44, 235, 236, 4, 'com_content.article.24', 'Joomla!', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(123, 108, 261, 262, 6, 'com_content.article.25', 'Koala', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(124, 96, 178, 179, 7, 'com_content.article.26', 'Language Switcher', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(125, 93, 146, 147, 7, 'com_content.article.27', 'Latest Articles Module', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(126, 94, 156, 157, 7, 'com_content.article.28', 'Login Module', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(127, 166, 194, 195, 7, 'com_content.article.29', 'Menu Module', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(128, 93, 148, 149, 7, 'com_content.article.30', 'Most Read Content', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(129, 93, 150, 151, 7, 'com_content.article.31', 'News Flash', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(130, 44, 237, 238, 4, 'com_content.article.32', 'Parameters', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(131, 108, 263, 264, 6, 'com_content.article.33', 'Phyllopteryx', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(132, 109, 273, 274, 6, 'com_content.article.34', 'Pinnacles', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(133, 44, 239, 240, 4, 'com_content.article.35', 'Professionals', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(134, 95, 172, 173, 7, 'com_content.article.36', 'Random Image Module', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(135, 93, 152, 153, 7, 'com_content.article.37', 'Related Items Module', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(136, 44, 241, 242, 4, 'com_content.article.38', 'Sample Sites', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(137, 46, 129, 130, 6, 'com_content.article.39', 'Search', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(138, 96, 180, 181, 7, 'com_content.article.40', 'Search Module', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(139, 50, 219, 220, 6, 'com_content.article.41', 'Search ', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(140, 39, 298, 299, 3, 'com_content.article.42', 'Site Map', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(141, 108, 265, 266, 6, 'com_content.article.43', 'Spotted Quoll', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(142, 96, 182, 183, 7, 'com_content.article.44', 'Statistics Module', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(143, 96, 184, 185, 7, 'com_content.article.45', 'Syndicate Module', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(144, 50, 221, 222, 6, 'com_content.article.46', 'System', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(145, 44, 243, 244, 4, 'com_content.article.47', 'The Joomla! Community', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(146, 44, 245, 246, 4, 'com_content.article.48', 'The Joomla! Project', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(147, 48, 207, 208, 6, 'com_content.article.49', 'Typography', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(148, 44, 247, 248, 4, 'com_content.article.50', 'Upgraders', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(149, 50, 223, 224, 6, 'com_content.article.51', 'User', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(150, 46, 131, 132, 6, 'com_content.article.52', 'Users', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(151, 44, 249, 250, 4, 'com_content.article.53', 'Using Joomla!', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(152, 46, 133, 134, 6, 'com_content.article.54', 'Weblinks', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(153, 95, 174, 175, 7, 'com_content.article.55', 'Weblinks Module', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(154, 94, 158, 159, 7, 'com_content.article.56', 'Who\'s Online', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(155, 108, 267, 268, 6, 'com_content.article.57', 'Wobbegone', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(156, 55, 288, 289, 5, 'com_content.article.58', 'Wonderful Watermelon', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(157, 96, 186, 187, 7, 'com_content.article.59', 'Wrapper Module', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(158, 46, 135, 136, 6, 'com_content.article.60', 'News Feeds', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(159, 96, 188, 189, 7, 'com_content.article.61', 'Breadcrumbs Module', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(160, 50, 225, 226, 6, 'com_content.article.62', 'Content', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(162, 109, 275, 276, 6, 'com_content.article.64', 'Blue Mountain Rain Forest', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(163, 109, 277, 278, 6, 'com_content.article.65', 'Ormiston Pound', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(165, 94, 160, 161, 7, 'com_content.article.66', 'Latest Users Module', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(166, 47, 193, 196, 6, 'com_content.category.75', 'Menu Module', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(167, 54, 295, 296, 4, 'com_content.category.76', 'Recipes', '{"core.create":{"12":1},"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(168, 34, 112, 113, 3, 'com_content.article.67', 'What\'s New in 1.5?', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(169, 176, 312, 313, 3, 'com_content.article.69', 'Joomla 3.x Fluid & Responsive Design template', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(170, 176, 306, 307, 3, 'com_content.article.70', 'Responsive Joomla 3.x Template', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(171, 176, 310, 311, 3, 'com_content.article.71', 'Joomla! Security Strike Team', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(172, 176, 308, 309, 3, 'com_content.article.72', 'Three-D Experiments', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(173, 176, 304, 305, 3, 'com_content.article.73', 'Responsive Template Joomla 3.x', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(174, 34, 114, 115, 3, 'com_content.article.74', 'Typography', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(175, 3, 11, 12, 2, 'com_banners.category.77', 'Text Ads', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(176, 8, 303, 340, 2, 'com_content.category.78', 'Template guide', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(177, 1, 444, 445, 1, 'com_jaextmanager', 'com_jaextmanager', '{}'),
(178, 34, 116, 117, 3, 'com_content.article.75', 'What\'s New in 3.x?', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(179, 176, 314, 315, 3, 'com_content.article.76', 'Menu support', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(180, 176, 316, 317, 3, 'com_content.category.79', '1 Column Grid', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(181, 176, 318, 319, 3, 'com_content.article.77', '1 Column', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(182, 176, 320, 321, 3, 'com_content.article.78', '2 Columns', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(183, 176, 322, 323, 3, 'com_content.article.79', '3 Columns', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(184, 176, 324, 325, 3, 'com_content.article.80', '4 Columns', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(185, 176, 326, 327, 3, 'com_content.article.81', '5 Columns - Full width', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(186, 176, 328, 329, 3, 'com_content.article.82', '6 Responsive layouts', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(187, 176, 330, 331, 3, 'com_content.article.83', 'Extra-wide layout', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(188, 176, 332, 333, 3, 'com_content.article.84', 'Wide layout', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(189, 176, 334, 335, 3, 'com_content.article.85', 'Normal layout', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(190, 176, 336, 337, 3, 'com_content.article.86', 'Tablet layout', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(191, 176, 338, 339, 3, 'com_content.article.87', 'Mobile layout', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(192, 7, 91, 92, 2, 'com_contact.category.80', 'Elastica banner', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(193, 3, 13, 14, 2, 'com_banners.category.81', 'Elastica sample banners', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(194, 1, 446, 447, 1, '#__ucm_content.1', '#__ucm_content.1', '[]'),
(195, 1, 448, 449, 1, '#__ucm_content.2', '#__ucm_content.2', '[]'),
(196, 1, 450, 451, 1, '#__ucm_content.3', '#__ucm_content.3', '[]'),
(197, 1, 452, 453, 1, '#__ucm_content.4', '#__ucm_content.4', '[]'),
(198, 1, 454, 455, 1, '#__ucm_content.5', '#__ucm_content.5', '[]'),
(199, 1, 456, 457, 1, '#__ucm_content.6', '#__ucm_content.6', '[]'),
(200, 1, 458, 459, 1, '#__ucm_content.7', '#__ucm_content.7', '[]'),
(201, 1, 460, 461, 1, '#__ucm_content.8', '#__ucm_content.8', '[]'),
(202, 1, 462, 463, 1, '#__ucm_content.9', '#__ucm_content.9', '[]'),
(203, 1, 464, 465, 1, '#__ucm_content.10', '#__ucm_content.10', '[]'),
(204, 1, 466, 467, 1, '#__ucm_content.11', '#__ucm_content.11', '[]'),
(205, 1, 468, 469, 1, '#__ucm_content.12', '#__ucm_content.12', '[]'),
(206, 1, 470, 471, 1, '#__ucm_content.13', '#__ucm_content.13', '[]'),
(207, 1, 472, 473, 1, 'com_finder', 'com_finder', '{}'),
(208, 1, 474, 475, 1, 'com_joomlaupdate', 'com_joomlaupdate', '{}'),
(209, 1, 476, 477, 1, 'com_tags', 'com_tags', '{}'),
(210, 1, 478, 479, 1, 'com_contenthistory', 'com_contenthistory', '{}'),
(211, 1, 480, 481, 1, 'com_ajax', 'com_ajax', '{}'),
(212, 1, 482, 483, 1, 'com_postinstall', 'com_postinstall', '{}'),
(213, 1, 484, 485, 1, 'com_fields', 'com_fields', '{}'),
(214, 1, 486, 487, 1, 'com_associations', 'com_associations', '{}'),
(215, 1, 488, 489, 1, 'com_privacy', 'com_privacy', '{}'),
(216, 1, 490, 491, 1, 'com_actionlogs', 'com_actionlogs', '{}');

DROP TABLE IF EXISTS `#__associations`;
CREATE TABLE `#__associations` (
  `id` int(11) NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',
  PRIMARY KEY (`context`,`id`),
  KEY `idx_key` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `#__banner_clients`;
CREATE TABLE `#__banner_clients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `contact` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `extrainfo` mediumtext NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `metakey` mediumtext NOT NULL,
  `own_prefix` tinyint(4) NOT NULL DEFAULT 0,
  `metakey_prefix` varchar(255) NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT -1,
  `track_clicks` tinyint(4) NOT NULL DEFAULT -1,
  `track_impressions` tinyint(4) NOT NULL DEFAULT -1,
  PRIMARY KEY (`id`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `#__banner_clients` (`id`, `name`, `contact`, `email`, `extrainfo`, `state`, `checked_out`, `checked_out_time`, `metakey`, `own_prefix`, `metakey_prefix`, `purchase_type`, `track_clicks`, `track_impressions`) VALUES
(1, 'Joomla!', 'Administrator', 'email@email.com', '', 1, 0, '0000-00-00 00:00:00', '', 0, '', -1, -1, -1);

DROP TABLE IF EXISTS `#__banner_tracks`;
CREATE TABLE `#__banner_tracks` (
  `track_date` date NOT NULL,
  `track_type` int(10) unsigned NOT NULL,
  `banner_id` int(10) unsigned NOT NULL,
  `count` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`track_date`,`track_type`,`banner_id`),
  KEY `idx_track_date` (`track_date`),
  KEY `idx_track_type` (`track_type`),
  KEY `idx_banner_id` (`banner_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `#__banners`;
CREATE TABLE `#__banners` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL DEFAULT 0,
  `type` int(11) NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(400) binary NOT NULL DEFAULT '',
  `imptotal` int(11) NOT NULL DEFAULT 0,
  `impmade` int(11) NOT NULL DEFAULT 0,
  `clicks` int(11) NOT NULL DEFAULT 0,
  `clickurl` varchar(200) NOT NULL DEFAULT '',
  `state` tinyint(3) NOT NULL DEFAULT 0,
  `catid` int(10) unsigned NOT NULL DEFAULT 0,
  `description` mediumtext NOT NULL,
  `custombannercode` varchar(2048) NOT NULL,
  `sticky` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `metakey` mediumtext NOT NULL,
  `params` mediumtext NOT NULL,
  `own_prefix` tinyint(1) NOT NULL DEFAULT 0,
  `metakey_prefix` varchar(400) NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT -1,
  `track_clicks` tinyint(4) NOT NULL DEFAULT -1,
  `track_impressions` tinyint(4) NOT NULL DEFAULT -1,
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reset` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `language` char(7) NOT NULL DEFAULT '',
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_banner_catid` (`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `#__banners` (`id`, `cid`, `type`, `name`, `alias`, `imptotal`, `impmade`, `clicks`, `clickurl`, `state`, `catid`, `description`, `custombannercode`, `sticky`, `ordering`, `metakey`, `params`, `own_prefix`, `metakey_prefix`, `purchase_type`, `track_clicks`, `track_impressions`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `reset`, `created`, `language`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `version`) VALUES
(2, 1, 0, 'Shop 1', 'shop-1', 0, 526, 1, 'http://shop.joomla.org/amazoncom-bookstores.html', 1, 15, 'Get books about Joomla! at the Joomla! book shop.', '', 0, 1, '', '{"imageurl":"images\\/banners\\/shop-ad-books.jpg","width":"","height":"","alt":"Joomla! Books"}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2020-02-06 08:15:05', 'en-GB', 0, '', '0000-00-00 00:00:00', 0, 1),
(3, 1, 0, 'Shop 2', 'shop-2', 0, 564, 0, 'http://shop.joomla.org', 1, 15, 'T Shirts, caps and more from the Joomla! Shop.', '', 0, 2, '', '{"imageurl":"images\\/banners\\/shop-ad.jpg","width":"","height":"","alt":"Joomla! Shop"}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2020-02-06 08:15:05', 'en-GB', 0, '', '0000-00-00 00:00:00', 0, 1),
(4, 1, 0, 'Support Joomla!', 'support-joomla', 0, 551, 0, 'http://contribute.joomla.org', 1, 15, 'Your contributions of time, talent and money make Joomla! possible.', '', 0, 3, '', '{"imageurl":"images\\/banners\\/white.png","width":"","height":"","alt":""}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2020-02-06 08:15:05', 'en-GB', 0, '', '0000-00-00 00:00:00', 0, 1),
(5, 1, 1, 'Joomla!', 'joomla', 0, 4028, 0, 'http://www.joomla.org', 1, 77, '', '<a href="http://www.joomla.org" target="_blank">{NAME}</a>\r\n<br/>\r\nJoomla! The most popular and widely used Open Source CMS Project in the world.', 0, 1, '', '{"imageurl":"","width":"","height":"","alt":"Joomla! The most popular and widely used Open Source CMS Project in the world."}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '2020-02-06 08:15:05', '2020-02-06 08:15:05', '*', 0, '', '0000-00-00 00:00:00', 0, 1),
(6, 1, 1, 'JoomlaCode', 'joomlacode', 0, 4026, 0, '', 1, 77, '', '<a href="http://joomlacode.org" target="_blank">{NAME}</a>\r\n<br/>\r\nJoomlaCode, development and distribution made easy.', 0, 2, '', '{"imageurl":"","width":"","height":"","alt":""}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2020-02-06 08:15:05', '2020-02-06 08:15:05', '*', 0, '', '0000-00-00 00:00:00', 0, 1),
(7, 1, 1, 'Joomla! Extensions', 'joomla-extensions', 0, 4024, 0, '', 1, 77, '', '<a href="http://extensions.joomla.org" target="_blank">{NAME}</a>\r\n<br/>\r\nJoomla! Components, Modules, Plugins and Languages by the bucket load.', 0, 3, '', '{"imageurl":"","width":"","height":"","alt":""}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2020-02-06 08:15:05', '2020-02-06 08:15:05', '*', 0, '', '0000-00-00 00:00:00', 0, 1),
(8, 1, 1, 'Joomla! Shop', 'joomla-shop', 0, 4024, 0, '', 1, 77, '', '<a href="http://shop.joomla.org" target="_blank">{NAME}</a>\r\n<br/>\r\nFor all your Joomla! merchandise.', 0, 4, '', '{"imageurl":"","width":"","height":"","alt":""}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2020-02-06 08:15:05', '2020-02-06 08:15:05', '*', 0, '', '0000-00-00 00:00:00', 0, 1),
(9, 1, 0, 'Sample banner 1', 'sample-banner-1', 0, 122, 0, 'http://www.joomlart.com', 1, 81, '', '', 1, 4, '', '{"imageurl":"images\\/banners\\/sample-banner.png","width":214,"height":100,"alt":""}', 0, '', 3, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2020-02-06 08:15:05', '2020-02-06 08:15:05', '*', 0, '', '0000-00-00 00:00:00', 0, 1),
(10, 1, 0, 'Sample banner 2', 'sample-banner-2', 0, 115, 0, '', 1, 81, '', '', 1, 5, '', '{"imageurl":"images\\/banners\\/sample-banner.png","width":214,"height":100,"alt":"http:\\/\\/www.joomlart.com"}', 0, '', 3, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2020-02-06 08:15:05', '2020-02-06 08:15:05', '*', 0, '', '0000-00-00 00:00:00', 0, 1);

DROP TABLE IF EXISTS `#__categories`;
CREATE TABLE `#__categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT 0,
  `lft` int(11) NOT NULL DEFAULT 0,
  `rgt` int(11) NOT NULL DEFAULT 0,
  `level` int(10) unsigned NOT NULL DEFAULT 0,
  `path` varchar(400) NOT NULL DEFAULT '',
  `extension` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(400) binary NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 0,
  `checked_out` int(11) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned DEFAULT NULL,
  `params` text NOT NULL,
  `metadesc` varchar(1024) NOT NULL DEFAULT '' COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) NOT NULL DEFAULT '' COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  `language` char(7) NOT NULL DEFAULT '',
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`extension`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_alias` (`alias`(100))
) ENGINE=InnoDB AUTO_INCREMENT=82 DEFAULT CHARSET=utf8;

INSERT INTO `#__categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`, `version`) VALUES
(1, 0, 0, 0, 145, 0, '', 'system', 'ROOT', 'root', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{}', '', '', '', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(9, 34, 1, 133, 134, 1, 'uncategorised', 'com_content', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', 0, '*', 1),
(10, 35, 1, 131, 132, 1, 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":"","foobar":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(11, 36, 1, 127, 128, 1, 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(12, 37, 1, 63, 64, 1, 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(14, 39, 1, 9, 58, 1, 'sample-data-articles', 'com_content', 'Sample Data-Articles', 'sample-data-articles', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(15, 40, 1, 129, 130, 1, 'sample-data-banners', 'com_banners', 'Sample Data-Banners', 'sample-data-banners', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":"","foobar":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(16, 41, 1, 65, 126, 1, 'sample-data-contact', 'com_contact', 'Sample Data-Contact', 'sample-data-contact', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(17, 42, 1, 61, 62, 1, 'sample-data-newsfeeds', 'com_newsfeeds', 'Sample Data-Newsfeeds', 'sample-data-newsfeeds', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(19, 44, 14, 10, 41, 2, 'sample-data-articles/joomla', 'com_content', 'Joomla!', 'joomla', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', 0, '*', 1),
(20, 45, 19, 11, 40, 3, 'sample-data-articles/joomla/extensions', 'com_content', 'Extensions', 'extensions', '', '<p>The Joomla! content management system lets you create webpages of various types using extensions. There are 5 basic types of extensions: components, modules, templates, languages, and plugins. Your website includes the extensions you need to create a basic website in English, but thousands of additional extensions of all types are available. The', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', 1, '*', 1),
(21, 46, 20, 12, 13, 4, 'sample-data-articles/joomla/extensions/components', 'com_content', 'Components', 'components', '', '<p>Components are larger extensions that produce the major content for your site. Each component has one or more "views" that control how content is displayed.In the Joomla! administrator there are additional extensions suce as Menus, Redirection, and the extension managers.</p>', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 42, '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', 0, '*', 1),
(22, 47, 20, 14, 25, 4, 'sample-data-articles/joomla/extensions/modules', 'com_content', 'Modules', 'modules', '', '<p>Modules are small blocks of content that can be displayed in positions on a web page. The menus on this site are displayed in modules. The core of Joomla! includes 17 separate modules ranging from login to search to random images. Each module has a name that starts mod_ but when it displays it has a title. In the descriptions in this section, the titles are the same as the names.</p>', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 42, '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', 0, '*', 1),
(23, 48, 20, 26, 35, 4, 'sample-data-articles/joomla/extensions/templates', 'com_content', 'Templates', 'templates', '', '<p>Templates give your site its look and feel. They determine layout, colors, type faces, graphics and other aspects of design that make your site unique. Your installation of Joomla comes prepackaged with four templates.</p>', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 42, '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', 0, '*', 1),
(24, 49, 20, 36, 37, 4, 'sample-data-articles/joomla/extensions/languages', 'com_content', 'Languages', 'languages', '', '<p><img src="administrator/templates/bluestork/images/header/icon-48-language.png" border="0" alt="Languages Image" align="left" />Joomla! installs in English, but translations of the interfaces, sample data and help screens are available in dozens of languages.</p>\r\n<p><a href="http://community.joomla.org/translations.html">Translation information</a></p>\r\n<p>If there is no language pack available for your language, instructions are available for creating your own translation, which you can also contribute to the community by starting a translation team to create an accredited translation.</p>\r\n<p>Translations of the interfaces are installed using the extensions manager in the site administrator and then managed using the language manager.</p>\r\n<p>If you have two or more languages installed you may enable the language switcher plugin and module. They should always be used together. If you create multilingual content and mark your content, menu items or modules as in specific languages and follow <a href="http://docs.joomla.org/Language_Switcher_Tutorial_for_Joomla_1.6">the complete instructions</a> your users will be able to select a specific content language using the module. By default both the plugin and module are disabled.</p>\r\n<p>There are a number of extensions that can help you manage translations of content available in the<a href="http://extensions.joomla.org"> Joomla! Extensions Directory</a>.</p>', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', 0, '*', 1),
(25, 50, 20, 38, 39, 4, 'sample-data-articles/joomla/extensions/plugins', 'com_content', 'Plugins', 'plugins', '', '<p>Plugins are small task oriented extensions that enhance the Joomla! framework. Some are associated with particular extensions and others, such as editors, are used across all of Joomla!. Most beginning users do not need to change any of the plugins that install with Joomla!.</p>', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 42, '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', 0, '*', 1),
(26, 51, 14, 42, 51, 2, 'sample-data-articles/park-site', 'com_content', 'Park Site', 'park-site', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', 1, 'en-GB', 1),
(27, 52, 26, 43, 44, 3, 'sample-data-articles/park-site/park-blog', 'com_content', 'Park Blog', 'park-blog', '', '<p>Here is where I will blog all about the parks of Australia.</p>\r\n<p><em>You can make a blog on your website by creating a category to write you blog posts in (this one is called Park Blog). Each blog post will be an article in that category. If you make a category blog menu link with 1 column it will look like this page, if you display the category description (this part) displayed. </em></p>\r\n<p><em>To enhance your blog you may want to add ', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', 0, 'en-GB', 1),
(28, 53, 26, 45, 50, 3, 'sample-data-articles/park-site/photo-gallery', 'com_content', 'Photo Gallery', 'photo-gallery', '', '<p><img src="images/sampledata/parks/banner_cradle.jpg" border="0" /></p>\r\n<p>These are my photos from parks I have visited (I didn\'t take them, they are all from <a href="http://commons.wikimedia.org/wiki/Main_Page">Wikimedia Commons</a>).</p>\r\n<p><em>This shows you how to make a simple image gallery using articles in com_content. </em></p>\r\n<p><em>In each article put a thumbnail image before a "readmore" and the fiull size image after it. Set the article to Show Intro Text: Hide. </em></p>', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', 0, 'en-GB', 1),
(29, 54, 14, 52, 57, 2, 'sample-data-articles/fruit-shop-site', 'com_content', 'Fruit Shop Site', 'fruit-shop-site', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', 0, '*', 1),
(30, 55, 29, 53, 54, 3, 'sample-data-articles/fruit-shop-site/growers', 'com_content', 'Growers', 'growers', '', '<p>We search the whole countryside for the best fruit growers.</p>\r\n<p><em>You can let each supplier have a page that he or she can edit. To see this in action you will need to create users who are suppliers and assign them as authors to the suppliers articles.</em></p>', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', 0, '*', 1),
(34, 59, 16, 66, 67, 2, 'sample-data-contact/park-site', 'com_contact', 'Park Site', 'park-site', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', 0, 'en-GB', 1),
(35, 60, 16, 68, 125, 2, 'sample-data-contact/shop-site', 'com_contact', 'Shop Site', 'shop-site', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(36, 61, 35, 69, 70, 3, 'sample-data-contact/shop-site/staff', 'com_contact', 'Staff', 'staff', '', '<p>Please feel free to contact our staff at any time should you need assistance.</p>', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(37, 62, 35, 71, 124, 3, 'sample-data-contact/shop-site/fruit-encyclopedia', 'com_contact', 'Fruit Encyclopedia', 'fruit-encyclopedia', '', '<p>', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(38, 63, 37, 72, 73, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/a', 'com_contact', 'A', 'a', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(39, 64, 37, 74, 75, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/b', 'com_contact', 'B', 'b', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(40, 65, 37, 76, 77, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/c', 'com_contact', 'C', 'c', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(41, 66, 37, 78, 79, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/d', 'com_contact', 'D', 'd', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(42, 67, 37, 80, 81, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/e', 'com_contact', 'E', 'e', '', '', 0, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(43, 68, 37, 82, 83, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/f', 'com_contact', 'F', 'f', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(44, 69, 37, 84, 85, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/g', 'com_contact', 'G', 'g', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(45, 70, 37, 86, 87, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/h', 'com_contact', 'H', 'h', '', '', 0, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(46, 71, 37, 88, 89, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/i', 'com_contact', 'I', 'i', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(47, 72, 37, 90, 91, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/j', 'com_contact', 'J', 'j', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(48, 73, 37, 92, 93, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/k', 'com_contact', 'K', 'k', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(49, 74, 37, 94, 95, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/l', 'com_contact', 'L', 'l', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(50, 75, 37, 96, 97, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/m', 'com_contact', 'M', 'm', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(51, 76, 37, 98, 99, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/n', 'com_contact', 'N', 'n', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(52, 77, 37, 100, 101, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/o', 'com_contact', 'O', 'o', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(53, 78, 37, 102, 103, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/p', 'com_contact', 'P', 'p', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(54, 79, 37, 104, 105, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/q', 'com_contact', 'Q', 'q', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(55, 80, 37, 106, 107, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/r', 'com_contact', 'R', 'r', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(56, 81, 37, 108, 109, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/s', 'com_contact', 'S', 's', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(57, 82, 37, 110, 111, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/t', 'com_contact', 'T', 't', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(58, 83, 37, 112, 113, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/u', 'com_contact', 'U', 'u', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(59, 84, 37, 114, 115, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/v', 'com_contact', 'V', 'v', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(60, 85, 37, 116, 117, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/w', 'com_contact', 'W', 'w', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(61, 86, 37, 118, 119, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/x', 'com_contact', 'X', 'x', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(62, 87, 37, 120, 121, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/y', 'com_contact', 'Y', 'y', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(63, 88, 37, 122, 123, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/z', 'com_contact', 'Z', 'z', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(64, 93, 22, 15, 16, 5, 'sample-data-articles/joomla/extensions/modules/articles-modules', 'com_content', 'Content Modules', 'articles-modules', '', '<p>Content modules display article and other information from the content component.</p>', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', 0, '*', 1),
(65, 94, 22, 17, 18, 5, 'sample-data-articles/joomla/extensions/modules/user-modules', 'com_content', 'User Modules', 'user-modules', '', '<p>User modules interact with the user system, allowing users to login, showing who is logged in, and showing the most recently registered users.</p>', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(66, 95, 22, 19, 20, 5, 'sample-data-articles/joomla/extensions/modules/display-modules', 'com_content', 'Display Modules', 'display-modules', '', '<p>These modules display information from components other than content and user. These include weblinks, news feeds and the media manager.</p>', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(67, 96, 22, 21, 22, 5, 'sample-data-articles/joomla/extensions/modules/utility-modules', 'com_content', 'Utility Modules', 'utility-modules', '', '<p>Utility modules provide useful functionality such as search, syndication, and statistics.</p>', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(68, 97, 23, 31, 32, 5, 'sample-data-articles/joomla/extensions/templates/atomic', 'com_content', 'Atomic', 'atomic', '', '<p>Atomic is a minimal template designed to be a skeleton for making your own template and to learn about Joomla! templating.</p>\r\n<p style="margin-top: 8px; margin-right: 0px; margin-bottom: 8px; margin-left: 0px; line-height: 1.7em; padding: 0px;">[screen shot]</p>\r\n<p style="margin-top: 8px; margin-right: 0px; margin-bottom: 8px; margin-left: 0px; line-height: 1.7em; padding: 0px;">\r\n<ul>\r\n<li>Home Page</li>\r\n<li>Typography</li>\r\n</ul>\r\n</p>', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', 0, '*', 1),
(69, 98, 23, 27, 28, 5, 'sample-data-articles/joomla/extensions/templates/beez-20', 'com_content', 'Beez 20', 'beez-20', '', '<p><img src="templates/beez_20/template_thumbnail.png" border="0" alt="Beez_20 thumbnail" align="right" style="float: right; margin: 5px,80px,5px,25px;" /></p>\r\n<p>Beez 2.0 is a versatile, easy to customize template that works for a variety of sites. It meets xxx', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', 0, '*', 1),
(70, 99, 23, 29, 30, 5, 'sample-data-articles/joomla/extensions/templates/beez5', 'com_content', 'Beez5', 'beez5', '', '<p><img src="templates/beez5/template_thumbnail.png" border="0" alt="Beez5 Thumbnail" align="right" style="float: right;" /></p>\r\n<p>', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', 0, '*', 1),
(71, 100, 23, 33, 34, 5, 'sample-data-articles/joomla/extensions/templates/milky-way', 'com_content', 'Milky Way', 'milky-way', '', '<p><img src="templates/rhuk_milkyway/template_thumbnail.png" border="0" alt="Milky Way Image" width="206" height="150" align="right" style="float: right;" /></p>\r\n<p>Milky Way is the default template for Joomla! 1.5. You can find all of the 1.5 component layouts in the _html folder if you need them for your upgraded sites.</p>\r\n<ul>\r\n<li>Typography</li>\r\n<li>Home Page</li>\r\n</ul>', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', 0, '*', 1),
(72, 108, 28, 46, 47, 4, 'sample-data-articles/park-site/photo-gallery/animals', 'com_content', 'Animals', 'animals', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', 0, 'en-GB', 1),
(73, 109, 28, 48, 49, 4, 'sample-data-articles/park-site/photo-gallery/scenery', 'com_content', 'Scenery', 'scenery', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', 0, 'en-GB', 1),
(75, 166, 22, 23, 24, 5, 'sample-data-articles/joomla/extensions/modules/menu-module', 'com_content', 'Menu Module', 'menu-module', '', '<p>Menus provide your site with structure and help your visitors navigate your site. ', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', 0, '*', 1),
(76, 167, 29, 55, 56, 3, 'sample-data-articles/fruit-shop-site/recipes', 'com_content', 'Recipes', 'recipes', '', '<p>Customers can post their favorite recipes for fruit here.</p>', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 42, '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', 0, '*', 1),
(77, 175, 1, 135, 136, 1, 'text-ads', 'com_banners', 'Text Ads', 'text-ads', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"image":""}', '', '', '{"author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(78, 176, 1, 137, 140, 1, 'template-guide', 'com_content', 'Template guide', 'template-guide', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 42, '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', 40, '*', 1),
(79, 180, 78, 138, 139, 2, 'template-guide/1-column-grid', 'com_content', '1 Column Grid', '1-column-grid', '', '<p>Lacus laoreet sit at adipiscing orci wisi Morbi elit accumsan dolor. Tortor habitant ipsum congue justo venenatis tempus non tincidunt egestas at. Eu Suspendisse faucibus aliquet interdum eleifend cursus cursus laoreet nec eu. Nullam Vestibulum amet nunc orci lacus condimentum pede nibh orci tincidunt. Auctor lacus adipiscing Nunc nibh cursus sed mus leo Phasellus risus. Dolor Nulla consectetuer gravida elit facilisis Vestibulum eu.</p>\r\n\r\n<p>Consectetuer dis scelerisque sapien quis tincidunt elit sit nec congue nunc. Nunc lacinia Phasellus massa vitae mauris feugiat Quisque nascetur urna egestas. Tincidunt lacinia a Nulla neque interdum accumsan Sed augue lorem Vestibulum. Quis platea Vestibulum orci lacus Vestibulum Vivamus sagittis nisl pellentesque convallis. Ligula elit eget condimentum condimentum vitae montes at adipiscing odio hendrerit. Pulvinar sollicitudin cursus nec et.</p>\r\n\r\n<p>Congue consectetuer Phasellus odio non Nulla commodo amet feugiat ligula pede. Convallis felis et sit nec nunc lacus tellus lobortis quam Quisque. Urna mauris magnis venenatis morbi id ullamcorper orci et condimentum adipiscing. Donec sed eu cursus Nullam et facilisis amet justo et ut. Aliquet convallis sed Aliquam Mauris Nam at.</p>\r\n\r\n<p>Consequat wisi aliquet Vivamus laoreet Proin mollis malesuada Nam sagittis sodales. Feugiat nulla Aenean lacinia tincidunt lacus Phasellus nec pede et justo. Vel libero Lorem Vestibulum fringilla eu a risus cursus id quis. Dui in pellentesque tempor vel laoreet non Vestibulum nec turpis pede. Adipiscing justo consequat et adipiscing mauris malesuada euismod nibh leo urna. Ut at.</p>\r\n\r\n<p>Mus Sed pellentesque risus volutpat consequat montes nibh semper Aenean pellentesque. Pellentesque velit auctor adipiscing orci elit at leo semper mauris tristique. Convallis sit nibh ut ac pellentesque nibh dictumst mauris volutpat pulvinar. Eu nunc Nulla Aliquam elit sit tempus malesuada Nam pretium sapien. Aliquam Vestibulum magna venenatis Aenean odio at penatibus Sed enim vitae. Amet semper nibh dictumst sit tincidunt Mauris Pellentesque eros nibh at. Sem Proin.</p>\r\n\r\n<p>Arcu Curabitur mauris felis elit id sed a tellus at nunc. Sapien condimentum eros natoque montes senectus id sit at adipiscing semper. In molestie elit Curabitur tincidunt In nibh quis et mauris metus. Neque Curabitur est Vestibulum consectetuer amet orci lorem ut Nam cursus. Fringilla pede urna tincidunt sem egestas turpis justo adipiscing purus Quisque. Elit.</p>\r\n\r\n<p>Non Aenean commodo iaculis ornare sed eget Nulla urna enim elit. At ut Mauris elit quis id a dignissim dignissim urna vel. Ac ipsum consequat orci est magna ornare metus lacus mollis elit. Cursus nulla Fusce cursus facilisi Pellentesque nunc tincidunt lacus ipsum sociis. Pretium consectetuer ut mus est ac id lacus.</p>', -2, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 42, '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', 0, '*', 1),
(80, 192, 1, 141, 142, 1, 'elastica-banner', 'com_contact', 'Elastica banner', 'elastica-banner', '', 'Demo for Elastica.', -2, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(81, 193, 1, 143, 144, 1, 'elastica-sample-banners', 'com_banners', 'Elastica sample banners', 'elastica-sample-banners', '', 'Sample banner for JA Elastica.', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 42, '2020-02-06 08:15:05', 0, '0000-00-00 00:00:00', 0, '*', 1);

DROP TABLE IF EXISTS `#__contact_details`;
CREATE TABLE `#__contact_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `alias` varchar(400) binary NOT NULL,
  `con_position` varchar(255) DEFAULT NULL,
  `address` mediumtext DEFAULT NULL,
  `suburb` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `postcode` varchar(100) DEFAULT NULL,
  `telephone` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `misc` longtext DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `imagepos` varchar(20) DEFAULT NULL,
  `email_to` varchar(255) DEFAULT NULL,
  `default_con` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `published` tinyint(1) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT 0,
  `params` mediumtext NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT 0,
  `catid` int(11) NOT NULL DEFAULT 0,
  `access` int(10) unsigned DEFAULT NULL,
  `mobile` varchar(255) NOT NULL DEFAULT '',
  `webpage` varchar(255) NOT NULL DEFAULT '',
  `sortname1` varchar(255) NOT NULL DEFAULT '',
  `sortname2` varchar(255) NOT NULL DEFAULT '',
  `sortname3` varchar(255) NOT NULL DEFAULT '',
  `language` varchar(7) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `metakey` mediumtext NOT NULL,
  `metadesc` mediumtext NOT NULL,
  `metadata` mediumtext NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT 0 COMMENT 'Set if article is featured.',
  `xreference` varchar(50) NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO `#__contact_details` (`id`, `name`, `alias`, `con_position`, `address`, `suburb`, `state`, `country`, `postcode`, `telephone`, `fax`, `misc`, `image`, `imagepos`, `email_to`, `default_con`, `published`, `checked_out`, `checked_out_time`, `ordering`, `params`, `user_id`, `catid`, `access`, `mobile`, `webpage`, `sortname1`, `sortname2`, `sortname3`, `language`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `metakey`, `metadesc`, `metadata`, `featured`, `xreference`, `publish_up`, `publish_down`, `version`, `hits`) VALUES
(1, 'Contact Name Here', 'name', 'Position', 'Street Address', 'Suburb', 'State', 'Country', 'Zip Code', 'Telephone', 'Fax', '<p>Information about or by the contact.</p>', 'images/powered_by.png', 'top', 'email@email.com', 1, 1, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"","linka_name":"Twitter","linka":"http:\\/\\/twitter.com\\/joomla","linkb_name":"YouTube","linkb":"http:\\/\\/www.youtube.com\\/user\\/joomla","linkc_name":"Ustream","linkc":"http:\\/\\/www.ustream.tv\\/joomla","linkd_name":"FriendFeed","linkd":"http:\\/\\/friendfeed.com\\/joomla","linke_name":"Scribed","linke":"http:\\/\\/www.scribd.com\\/people\\/view\\/504592-joomla","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 0, 16, 1, '', '', 'last', 'first', 'middle', 'en-GB', '0000-00-00 00:00:00', 42, '', '2020-02-06 08:15:05', 42, '', '', '{"robots":"","rights":""}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(2, 'Webmaster', 'webmaster', '', '', '', '', '', '', '', '', '', '', NULL, 'webmaster@example.com', 0, 1, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"","linka_name":"","linka":"","linkb_name":"","linkb":"","linkc_name":"","linkc":"","linkd_name":"","linkd":"","linke_name":"","linke":"","show_email_form":"1","show_email_copy":"1","banned_email":"","banned_subject":"","banned_text":"","validate_session":"1","custom_reply":"","redirect":""}', 0, 34, 1, '', '', '', '', '', 'en-GB', '0000-00-00 00:00:00', 42, '', '2020-02-06 08:15:05', 42, '', '', '{"robots":"","rights":""}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(3, 'Owner', 'owner', '', '', '', '', '', '', '', '', '<p>I\'m the owner of this store.</p>', '', NULL, '', 0, 1, 0, '0000-00-00 00:00:00', 2, '{"show_contact_category":"","show_contact_list":"","presentation_style":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"","linka_name":"","linka":"","linkb_name":"","linkb":"","linkc_name":"","linkc":"","linkd_name":"","linkd":"","linke_name":"","linke":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 0, 36, 1, '', '', '', '', '', '*', '0000-00-00 00:00:00', 42, '', '2020-02-06 08:15:05', 42, '', '', '{"robots":"","rights":""}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(4, 'Buyer', 'buyer', '', '', '', '', '', '', '', '', '<p>I am in charge of buying fruit. If you sell good fruit, contact me.</p>', '', NULL, '', 0, 1, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"0","linka_name":"","linka":"","linkb_name":"","linkb":"","linkc_name":"","linkc":"","linkd_name":"","linkd":"","linke_name":"","linke":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 0, 36, 1, '', '', '', '', '', '*', '0000-00-00 00:00:00', 42, '', '2020-02-06 08:15:05', 42, '', '', '{"robots":"","rights":""}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(5, 'Bananas', 'bananas', '', '', '', '', '', '', '', '', '<p>Bananas are a great source of potassium.</p><p>', 'images/sampledata/fruitshop/bananas_2.jpg', NULL, '', 0, 1, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"plain","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"0","linka_name":"","linka":"","linkb_name":"","linkb":"","linkc_name":"","linkc":"","linkd_name":"","linkd":"","linke_name":"","linke":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 0, 39, 1, '', 'http://en.wikipedia.org/wiki/Banana', '', '', '', '*', '0000-00-00 00:00:00', 42, '', '2020-02-06 08:15:05', 42, '', '', '{"robots":"","rights":""}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(6, 'Apples', 'apples', '', '', '', '', '', '', '', '', '<p>Applies are a versatile fruit, used for eating, cooking, and preserving.</p><p>There are more that 7500 different kinds of apples grown around the world.</p>', 'images/sampledata/fruitshop/apple.jpg', NULL, '', 0, 1, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"plain","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"0","linka_name":"","linka":"","linkb_name":"","linkb":"","linkc_name":"","linkc":"","linkd_name":"","linkd":"","linke_name":"","linke":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 0, 38, 1, '', 'http://en.wikipedia.org/wiki/Apple', '', '', '', '*', '0000-00-00 00:00:00', 42, '', '2020-02-06 08:15:05', 42, '', '', '{"robots":"","rights":""}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(7, 'Tamarind', 'tamarind', '', '', '', '', '', '', '', '', '<p>Tamarinds are a versatile fruit used around the world. In its young form it is used in hot sauces; ripened it is the basis for many freshing drinks.</p><p>', 'images/sampledata/fruitshop/tamarind.jpg', NULL, '', 0, 1, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"plain","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"","linka_name":"","linka":"","linkb_name":"","linkb":"","linkc_name":"","linkc":"","linkd_name":"","linkd":"","linke_name":"","linke":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 0, 57, 1, '', 'http://en.wikipedia.org/wiki/Tamarind', '', '', '', '*', '0000-00-00 00:00:00', 42, '', '2020-02-06 08:15:05', 42, '', '', '{"robots":"","rights":""}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(8, 'Shop Address', 'shop-address', '', '', 'Our City', 'Our Province', 'Our Country', '', '555-555-5555', '', '<p>Here are directions for how to get to our shop.</p>', '', NULL, '', 0, 1, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"","linka_name":"","linka":"","linkb_name":"","linkb":"","linkc_name":"","linkc":"","linkd_name":"","linkd":"","linke_name":"","linke":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 0, 35, 1, '', '', '', '', '', '*', '0000-00-00 00:00:00', 42, '', '2020-02-06 08:15:05', 42, '', '', '{"robots":"","rights":""}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0);

DROP TABLE IF EXISTS `#__content`;
CREATE TABLE `#__content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(400) binary NOT NULL DEFAULT '',
  `introtext` longtext NOT NULL,
  `fulltext` longtext NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT 0,
  `catid` int(10) unsigned NOT NULL DEFAULT 0,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` mediumtext NOT NULL,
  `urls` mediumtext NOT NULL,
  `attribs` varchar(5120) NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `metakey` mediumtext NOT NULL,
  `metadesc` mediumtext NOT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  `metadata` mediumtext NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT 0 COMMENT 'Set if article is featured.',
  `language` char(7) NOT NULL COMMENT 'The language code for the article.',
  `xreference` varchar(50) NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`),
  KEY `idx_alias` (`alias`(191))
) ENGINE=InnoDB AUTO_INCREMENT=88 DEFAULT CHARSET=utf8;

INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`, `note`) VALUES
(1, 89, 'Administrator Components', 'administrator-components', '<p>Lorem ipsum dolor sit amet consectetuer dolor Praesent habitasse In metus. Fermentum convallis quis sem sapien ac habitasse enim adipiscing felis ornare. Pellentesque leo risus faucibus laoreet Vestibulum scelerisque vel ante interdum In. Sed Vestibulum eget pede neque vitae laoreet eu metus id Vestibulum. Ac molestie justo et pretium ipsum ac tortor Cras iaculis In. Vivamus Aliquam lacus velit nec sit turpis.</p>\r\n\r\n<p>Ridiculus libero nec malesuada dis et a Curabitur Proin vitae a. Interdum enim urna sit nibh ut fringilla dolor Nam adipiscing dolor. Vivamus in ipsum dictumst pellentesque quis mollis condimentum dui metus dui. Praesent dis turpis malesuada orci nibh leo Proin augue tempus Lorem. Egestas mus eros Pellentesque rutrum tortor fringilla Sed semper vel felis. Felis senectus tempor natoque nibh sem laoreet justo condimentum ac quis. Cum quam facilisis.</p>\r\n\r\n<p>Volutpat et vitae lacinia ligula id Vestibulum Curabitur adipiscing pede et. Dictum vitae justo lacinia gravida Curabitur id gravida Phasellus laoreet ultrices. Orci risus sociis mauris sed sed Sed lacinia urna dui enim. Curabitur interdum interdum dui netus Vestibulum dignissim turpis felis id convallis. Congue parturient elit Vivamus faucibus Nulla at ipsum massa id leo. Ut interdum ac convallis enim tellus enim rutrum Curabitur auctor non. Vitae mattis.</p>', '', 1, 21, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":"","article_layout":""}', 6, 7, '', '', 1, 91, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(2, 90, 'Archive Module', 'archive-module', '<p>This module shows a list of the calendar months containing archived articles. After you have changed the status of an article to archived, this list will be automatically generated.', '', 1, 64, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","page_title":"","alternative_readmore":"","layout":""}', 7, 5, 'modules, content', '', 1, 3, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(3, 91, 'Article Categories Module', 'article-categories-module', '<p>This module displays a list of categories from one parent category.', '', 1, 64, '2020-02-06 08:15:05', 42, '', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","page_title":"","alternative_readmore":"","layout":""}', 7, 6, 'modules, content', '', 1, 2, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(4, 92, 'Articles Category Module', 'articles-category-module', '<p>This module allows you to display the articles in a specific category. Help.</p>\r\n<p>{loadposition articlescategoryload}</p>', '', 1, 64, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","page_title":"","alternative_readmore":"","layout":""}', 6, 7, '', 'articles,content', 1, 5, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(5, 101, 'Authentication', 'authentication', '<p>The authentication plugins operate when users login to your site or administrator. The Joomla! authentication is in operation by default but you can enable Gmail or LDAP or install a plugin for a different system. An example is included that may be used to create a new authentication plugin.</p><p>Default on:</p><ul><li>Joomla</li></ul><p>Default off:</p><ul><li>Gmail</li><li>LDAP</li></ul>', '', 1, 25, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 4, 3, '', '', 1, 4, '', 0, '*', '', ''),
(6, 102, 'Australian Parks ', 'australian-parks', '<p><img src="images/sampledata/parks/banner_cradle.jpg" border="0" alt="Cradle Park Banner" /></p><p>Welcome!</p><p>This is a basic site about the beautiful and fascinating parks of Australia.</p><p>On this site you can read all about my travels to different parks, see photos, and find links to park websites.</p><p><em>This sample site is an example of using the core of Joomla! to create a basic website, whether a "brochure site," ', '', 1, 26, '2020-02-06 08:15:05', 42, 'Parks webmaster', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 4, 1, '', '', 1, 7, '', 0, '*', '', ''),
(7, 103, 'Banner Module', 'banner-module', '<p>The banner module is used to display the banners that are managed by the banners component in the site administrator.</p><p>{loadposition bannersload}</p>', '', 1, 66, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 3, 6, '', '', 1, 4, '', 0, '*', '', ''),
(8, 104, 'Beginners', 'beginners', '<p>If this is your first Joomla site or your first web site, you have come to the right place. Joomla will help you get your website up and running quickly and easily.</p><p>Start off using your site by logging in using the administrator account you created when you installed Joomla!.</p>', '<p>Explore the articles and other resources right here on your site data to learn more about how Joomla works.(When you\'re done reading, you can delete or archive all of this.) You will also probably want to visit the beginners\' areas of the <a href="http://docs.joomla.org">Joomla documentation</a> and <a href="http://forum.joomla.org">support forums</a>.</p><p>You\'ll also want to sign up for the Joomla Security Mailing list and the Announcements mailing list. For inspiration visit the Joomla Site Showcase to see an amazing array of ways people use Joomla to tell their stories on the web.</p><p>The basic Joomla! installation will let you get a great site up and running, but when you are ready for more features the power of Joomla! is in the creative ways that developers have extended it to do all kinds of things. Visit the Joomla! Extensions Directory to see thousands of extensions that can do almost anything you could want on a website. Can\'t find what you need? You may want to find a Joomla professional on the Joomla! Resources Directory.</p><p>Want to learn more? Consider attending a Joomla! Day or other event or joining a local Joomla! Users Group. Can\'t find one near you? Start one yourself.</p>', 1, 19, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":""}', 4, 3, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(9, 105, 'Contact', 'contact', '<p>The contact component provides a way to provide contact forms and information for your site or to create a complex directory that can be used for many different purposes. Help</p>', '', 1, 21, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 4, 2, '', '', 1, 6, '', 0, '*', '', ''),
(10, 106, 'Content', 'content', '<p>The content component (com_content) is what you use to write articles. It is extremely flexible and has the largest number of built in views. Articles can be created an edited from the front end, making content the easiest component to use to create your site content. Help</p>', '', 1, 21, '2020-02-06 08:15:05', 42, '', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 4, 1, '', '', 1, 14, '', 0, '*', '', ''),
(11, 107, 'Cradle Mountain', 'cradle-mountain', '<p><img src="images/sampledata/parks/landscape/250px_cradle_mountain_seen_from_barn_bluff.jpg" border="0" alt="Cradle Mountain" style="vertical-align: middle;" /></p>', '<p><img src="images/sampledata/parks/landscape/800px_cradle_mountain_seen_from_barn_bluff.jpg" border="0" alt="Cradle Mountain" style="vertical-align: middle;" /></p><p>', 1, 73, '2020-02-06 08:15:05', 42, 'Parks Webmaster', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 4, 1, '', '', 1, 0, '', 0, '*', '', ''),
(12, 110, 'Custom HTML Module', 'custom-html-module', '<p>This Module allows you to create your own HTML Module using a WYSIWYG editor.', '', 1, 66, '2020-02-06 08:15:05', 42, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 2, 1, '', '', 1, 5, '', 0, '*', '', ''),
(13, 111, 'Directions', 'directions', '<p>Here\'s how to find our shop.</p><p>By car</p><p>Drive along Main Street to the intersection with First Avenue. ', '', 1, 29, '2020-02-06 08:15:05', 42, 'Fruit Shop Webmaster', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 3, 2, '', '', 1, 3, '', 0, '*', '', ''),
(14, 112, 'Editors', 'editors', '<p>Editors are used thoughout Joomla! where content is created. TinyMCE is the default choice in most locations although CodeMirror is used in the template manager. No Editor provides a text box for html content.</p><p>Default on:</p><ul><li>CodeMirror Help</li><li>TinyMCE Help</li><li>No Editor Help</li></ul><p>Default off:</p><ul><li>None</li></ul>', '', 1, 25, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 4, 5, '', '', 1, 3, '', 0, '*', '', ''),
(15, 113, 'Editors-xtd', 'editors-xtd', '<p>These plugins are behind the buttons found beneath your editor. They only run when an editor plugin runs.</p><p>Default on:</p><ul><li>Editor Button: Image</li><li>Editor Button: Readmore</li><li>Editor Button: Page Break</li><li>Editor Button: Article</li></ul><p>Default off:</p><ul><li>None</li></ul>', '', 1, 25, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 2, 6, '', '', 1, 2, '', 0, '*', '', ''),
(16, 114, 'Feed Display', 'feed-display', '<p>This module allows the displaying of a syndicated feed. <a href="http://docs.joomla.org/Help15:Screen.modulessite.edit.15#Feed_Display" title="Feed Display Module">Help</a></p><p>{loadposition feeddisplayload}</p>', '', 1, 66, '2020-02-06 08:15:05', 42, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 2, 2, '', '', 1, 5, '', 0, '*', '', ''),
(17, 115, 'First Blog Post', 'first-blog-post', '<p><em>Lorem Ipsum is filler text that is commonly used by designers before the content for a new site is ready.</em></p><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed faucibus purus vitae diam posuere nec eleifend elit dictum. Aenean sit amet erat purus, id fermentum lorem. Integer elementum tristique lectus, non posuere quam pretium sed. Quisque scelerisque erat at urna condimentum euismod. Fusce vestibulum facilisis est, a accumsan massa aliquam in. In auctor interdum mauris a luctus. Morbi euismod tempor dapibus. Duis dapibus posuere quam. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. In eu est nec erat sollicitudin hendrerit. Pellentesque sed turpis nunc, sit amet laoreet velit. Praesent vulputate semper nulla nec varius. Aenean aliquam, justo at blandit sodales, mauris leo viverra orci, sed sodales mauris orci vitae magna.</p>', '<p>Quisque a massa sed libero tristique suscipit. Morbi tristique molestie metus, vel vehicula nisl ultrices pretium. Sed sit amet est et sapien condimentum viverra. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Phasellus viverra tortor porta orci convallis ac cursus erat sagittis. Vivamus aliquam, purus non luctus adipiscing, orci urna imperdiet eros, sed tincidunt neque sapien et leo. Cras fermentum, dolor id tempor vestibulum, neque lectus luctus mauris, nec congue tellus arcu nec augue. Nulla quis mi arcu, in bibendum quam. Sed placerat laoreet fermentum. In varius lobortis consequat. Proin vulputate felis ac arcu lacinia adipiscing. Morbi molestie, massa id sagittis luctus, sem sapien sollicitudin quam, in vehicula quam lectus quis augue. Integer orci lectus, bibendum in fringilla sit amet, rutrum eget enim. Curabitur at libero vitae lectus gravida luctus. Nam mattis, ligula sit amet vestibulum feugiat, eros sem sodales mi, nec dignissim ante elit quis nisi. Nulla nec magna ut leo convallis sagittis ac non erat. Etiam in augue nulla, sed tristique orci. Vestibulum quis eleifend sapien.</p><p>Nam ut orci vel felis feugiat posuere ut eu lorem. In risus tellus, sodales eu eleifend sed, imperdiet id nulla. Nunc at enim lacus. Etiam dignissim, arcu quis accumsan varius, dui dui faucibus erat, in molestie mauris diam ac lacus. Sed sit amet egestas nunc. Nam sollicitudin lacinia sapien, non gravida eros convallis vitae. Integer vehicula dui a elit placerat venenatis. Nullam tincidunt ligula aliquet dui interdum feugiat. Maecenas ultricies, lacus quis facilisis vehicula, lectus diam consequat nunc, euismod eleifend metus felis eu mauris. Aliquam dapibus, ipsum a dapibus commodo, dolor arcu accumsan neque, et tempor metus arcu ut massa. Curabitur non risus vitae nisl ornare pellentesque. Pellentesque nec ipsum eu dolor sodales aliquet. Vestibulum egestas scelerisque tincidunt. Integer adipiscing ultrices erat vel rhoncus.</p><p>Integer ac lectus ligula. Nam ornare nisl id magna tincidunt ultrices. Phasellus est nisi, condimentum at sollicitudin vel, consequat eu ipsum. In venenatis ipsum in ligula tincidunt bibendum id et leo. Vivamus quis purus massa. Ut enim magna, pharetra ut condimentum malesuada, auctor ut ligula. Proin mollis, urna a aliquam rutrum, risus erat cursus odio, a convallis enim lectus ut lorem. Nullam semper egestas quam non mattis. Vestibulum venenatis aliquet arcu, consectetur pretium erat pulvinar vel. Vestibulum in aliquet arcu. Ut dolor sem, pellentesque sit amet vestibulum nec, tristique in orci. Sed lacinia metus vel purus pretium sit amet commodo neque condimentum.</p><p>Aenean laoreet aliquet ullamcorper. Nunc tincidunt luctus tellus, eu lobortis sapien tincidunt sed. Donec luctus accumsan sem, at porttitor arcu vestibulum in. Sed suscipit malesuada arcu, ac porttitor orci volutpat in. Vestibulum consectetur vulputate eros ut porttitor. Aenean dictum urna quis erat rutrum nec malesuada tellus elementum. Quisque faucibus, turpis nec consectetur vulputate, mi enim semper mi, nec porttitor libero magna ut lacus. Quisque sodales, leo ut fermentum ullamcorper, tellus augue gravida magna, eget ultricies felis dolor vitae justo. Vestibulum blandit placerat neque, imperdiet ornare ipsum malesuada sed. Quisque bibendum quam porta diam molestie luctus. Sed metus lectus, ornare eu vulputate vel, eleifend facilisis augue. Maecenas eget urna velit, ac volutpat velit. Nam id bibendum ligula. Donec pellentesque, velit eu convallis sodales, nisi dui egestas nunc, et scelerisque lectus quam ut ipsum.</p>', 1, 27, '2020-02-06 08:15:05', 42, '', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 4, 0, '', '', 1, 5, '', 0, '*', '', ''),
(18, 116, 'Second Blog Post', 'second-blog-post', '<p><em>Lorem Ipsum is text that is traditionally used by designers when working on a site before the content is ready.</em></p><p>Pellentesque bibendum metus ut dolor fermentum ut pulvinar tortor hendrerit. Nam vel odio vel diam tempus iaculis in non urna. Curabitur scelerisque, nunc id interdum vestibulum, felis elit luctus dui, ac dapibus tellus mauris tempus augue. Duis congue facilisis lobortis. Phasellus neque erat, tincidunt non lacinia sit amet, rutrum vitae nunc. Sed placerat lacinia fermentum. Integer justo sem, cursus id tristique eget, accumsan vel sapien. Curabitur ipsum neque, elementum vel vestibulum ut, lobortis a nisl. Fusce malesuada mollis purus consectetur auctor. Morbi tellus nunc, dapibus sit amet rutrum vel, laoreet quis mauris. Aenean nec sem nec purus bibendum venenatis. Mauris auctor commodo libero, in adipiscing dui adipiscing eu. Praesent eget orci ac nunc sodales varius.</p>', '<p>Nam eget venenatis lorem. Vestibulum a interdum sapien. Suspendisse potenti. Quisque auctor purus nec sapien venenatis vehicula malesuada velit vehicula. Fusce vel diam dolor, quis facilisis tortor. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Pellentesque libero nisi, pellentesque quis cursus sit amet, vehicula vitae nisl. Curabitur nec nunc ac sem tincidunt auctor. Phasellus in mattis magna. Donec consequat orci eget tortor ultricies rutrum. Mauris luctus vulputate molestie. Proin tincidunt vehicula euismod. Nam congue leo non erat cursus a adipiscing ipsum congue. Nulla iaculis purus sit amet turpis aliquam sit amet dapibus odio tincidunt. Ut augue diam, congue ut commodo pellentesque, fermentum mattis leo. Sed iaculis urna id enim dignissim sodales at a ipsum. Quisque varius lobortis mollis. Nunc purus magna, pellentesque pellentesque convallis sed, varius id ipsum. Etiam commodo mi mollis erat scelerisque fringilla. Nullam bibendum massa sagittis diam ornare rutrum.</p><p>Praesent convallis metus ut elit faucibus tempus in quis dui. Donec fringilla imperdiet nibh, sit amet fringilla velit congue et. Quisque commodo luctus ligula, vitae porttitor eros venenatis in. Praesent aliquet commodo orci id varius. Nulla nulla nibh, varius id volutpat nec, sagittis nec eros. Cras et dui justo. Curabitur malesuada facilisis neque, sed tempus massa tincidunt ut. Sed suscipit odio in lacus auctor vehicula non ut lacus. In hac habitasse platea dictumst. Sed nulla nisi, lacinia in viverra at, blandit vel tellus. Nulla metus erat, ultrices non pretium vel, varius nec sem. Morbi sollicitudin mattis lacus quis pharetra. Donec tincidunt mollis pretium. Proin non libero justo, vitae mattis diam. Integer vel elit in enim varius posuere sed vitae magna. Duis blandit tempor elementum. Vestibulum molestie dui nisi.</p><p>Curabitur volutpat interdum lorem sed tempus. Sed placerat quam non ligula lacinia sodales. Cras ultrices justo at nisi luctus hendrerit. Quisque sit amet placerat justo. In id sapien eu neque varius pharetra sed in sapien. Etiam nisl nunc, suscipit sed gravida sed, scelerisque ut nisl. Mauris quis massa nisl, aliquet posuere ligula. Etiam eget tortor mauris. Sed pellentesque vestibulum commodo. Mauris vitae est a libero dapibus dictum fringilla vitae magna.</p><p>Nulla facilisi. Praesent eget elit et mauris gravida lobortis ac nec risus. Ut vulputate ullamcorper est, volutpat feugiat lacus convallis non. Maecenas quis sem odio, et aliquam libero. Integer vel tortor eget orci tincidunt pulvinar interdum at erat. Integer ullamcorper consequat eros a pellentesque. Cras sagittis interdum enim in malesuada. Etiam non nunc neque. Fusce non ligula at tellus porta venenatis. Praesent tortor orci, fermentum sed tincidunt vel, varius vel dui. Duis pulvinar luctus odio, eget porta justo vulputate ac. Nulla varius feugiat lorem sed tempor. Phasellus pulvinar dapibus magna eget egestas. In malesuada lectus at justo pellentesque vitae rhoncus nulla ultrices. Proin ut sem sem. Donec eu suscipit ipsum. Cras eu arcu porttitor massa feugiat aliquet at quis nisl.</p>', 1, 27, '2020-02-06 08:15:05', 42, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 2, 0, '', '', 1, 0, '', 0, '*', '', ''),
(19, 117, 'Footer Module', 'footer-module', '<p>This module shows the Joomla! copyright information. <a href="http://docs.joomla.org/Help15:Screen.modulessite.edit.15#Footer" title="Footer Module">Help</a></p><p>{loadposition footerload}</p>', '', 1, 66, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 3, 3, '', '', 1, 2, '', 0, '*', '', ''),
(20, 118, 'Fruit Shop', 'fruit-shop', '<h2>Welcome to the Fruit Shop</h2><p>We sell fruits from around the world. Please use our website to learn more about our business. We hope you will come to our shop and buy some fruit.</p><p ><em>This mini site will show you how you might want to set up a site for a business, in this case one selling fruit. It shows how to use access controls to manage your site content. If you were building a real site, you would might want to extend it with e-commerce, a catalog, mailing lists or other enhancements, many of which are available through the</em><a href="http://extensions.joomla.org"><em> Joomla! Extensions Directory</em></a>.</p><p><em>To understand this site you will probably want to make one user with groups set to customer and one with group set to grower. By logging in with different privileges  you can see how access control works.</em></p>', '', 1, 29, '2020-02-06 08:15:05', 42, 'Fruit Shop Webmaster', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 3, 1, '', '', 1, 4, '', 0, '*', '', ''),
(21, 119, 'Getting Help', 'getting-help', '<p>There are lots of places you can get help with Joomla!.</p><p>In many places you will see the help icon [image]. Click on this for more information about the options and functions of items on your screen.</p><ul><li><a href="http://forum.joomla.org">Support Forums</a></li><li><a href="http://docs.joomla.org">Documentation</a></li><li><a href="http://resources.joomla.org">Professionals</a></li><li><a href="http://shop.joomla.org/amazoncom-bookstores.html">Books</a></li></ul>', '', 1, 19, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 3, 8, '', '', 1, 9, '', 0, '*', '', ''),
(22, 120, 'Getting Started', 'getting-started', '<p>It\'s easy to get started creating your website. Knowing some of the basics will help.</p><h3>What is a Content Management System?</h3><p>A content management system is software that allows you to create and manage webpages easily by separating the creation of your content from the mechanics required to present it on the web.</p><p>In this site, the content is stored in a <em>database</em>. The look and feel are created by a <em>template</em>. The Joomla! software brings together the template and the content to create web pages.</p><h3>Site and Administrator</h3><p>Your site actually has two separate sites. The site (also called the front end) is what visitors to your site will see.  The administrator (also called the back end) is only used by people managing your site. You can access the administrator by clicking the "Site Administrator" link on the "This Site" menu or by adding /administrator to the end of you domain name.</p><p>Log in to the administrator using the username and password created during the installation of Joomla!.</p><h3>Logging in</h3><p>To login to the front end of your site use the login form or the login menu link on the "This Site" menu. Use the user name an password that were created as part of the installation process. Once logged in you will be able to create and edit articles.</p><p>In managing your site, you will be able to create content that only logged in users are able to see.</p><h3>Creating an article</h3><p>Once you are logged in, a new menu will be visible.  To create a new article, click on the "submit article" link on that menu.</p><p>The new article interface gives you a lot of options, but all you need to do is add a title an put something in the content area. To make it easy to find, set the state to published an put it in the Joomla! category.</p><div>You can edit an existing article by  clicking on the edit icon (if available).</div><h3>Learn more</h3><p>There is much more to learn about how to use Joomla! to create the web site you envision. You can learn much more at the <a href="http://docs.joomla.org">Joomla! documentation site</a> and on the<a href="http://forum.joomla.org"> Joomla! forums</a>.</p>', '', 1, 19, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 2, 9, '', '', 1, 13, '', 0, '*', '', ''),
(23, 121, 'Happy Orange Orchard', 'happy-orange-orchard', '<p>At our orchard we grow the world\'s best oranges as well as other citrus fruit such as lemons and grapefruit. Our family has been tending this orchard for generations.</p>', '', 1, 30, '2020-02-06 08:15:05', 42, 'Fruit Shop Webmaster', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 2, 2, '', '', 1, 1, '', 0, '*', '', ''),
(24, 122, 'Joomla!', 'joomla', '<p>Congratulations! You have a Joomla! site! Joomla! makes your site easy to build a website just the way you want it and keep it simple to update and maintain.</p>\r\n<p>Joomla! is a flexible and powerful platform, whether you are building a small site for yourself or a huge site with hundreds of thousands of visitors. Joomla is open source, which means you can make it work just the way you want it to.</p>', '', 1, 19, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":""}', 5, 2, '', '', 1, 5, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(25, 123, 'Koala', 'koala', '<p><img src="images/sampledata/parks/animals/180px_koala_ag1.jpg" border="0" alt="Koala  Thumbnail" width="180" height="123" style="vertical-align: middle; border: 0;" /></p>', '<p><img src="images/sampledata/parks/animals/800px_koala_ag1.jpg" border="0" alt="Koala Climbing Tree" width="500" height="341" style="vertical-align: middle; border: 0;" /></p><p>', 1, 72, '2020-02-06 08:15:05', 42, 'Parks Webmaster', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 3, 2, '', '', 1, 0, '', 0, '*', '', ''),
(26, 124, 'Language Switcher', 'language-switcher', '<p>The language switcher module allows you to take advantage of the language tags that are available when content, modules and menu links are created.</p><p>This module displays a list of available Content Languages for switching between them.</p><p>When switching languages, it redirects to the Home page defined for the chosen language. Thereafter, the navigation will be the one defined for that language.</p><p><strong>The language filter plugin must be enabled for this module to work properly.</strong></p><p><strong></strong> <a href="http://docs.joomla.org/Help15:Screen.modulessite.edit.15#Language_Switcher" title="Language Switcher Module">Help</a></p><p>To view an example of the language switch moduler module, go to the site administrator and enable the language filter plugin and the language switcher module labellled "language switcher" and visit the fruit shop or park sample sites. Then follow<a href="http://docs.joomla.org/Language_Switcher_Tutorial_for_Joomla_1.6"> the instructions in this tutorial</a>.</p>', '', 1, 67, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 2, 3, '', '', 1, 3, '', 0, '*', '', ''),
(27, 125, 'Latest Articles Module', 'latest-articles-module', '<p>This Module shows a list of the most recently published and current Articles. Some that are shown may have expired even though they are the most recent. <a href="http://docs.joomla.org/Help15:Screen.modulessite.edit.15#Latest_News" title="Latest Articles">Help</a></p>\r\n<p>{loadposition articleslatestload}</p>', '', 1, 64, '2020-02-06 08:15:05', 42, '', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","page_title":"","alternative_readmore":"","layout":""}', 4, 1, 'modules, content', '', 1, 5, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(28, 126, 'Login Module', 'login-module', '<p>This module displays a username and password login form. It also displays a link to retrieve a forgotten password. If user registration is enabled (in the Global Configuration settings), another link will be shown to enable self-registration for users. <a href="http://docs.joomla.org/Help15:Screen.modulessite.edit.15#Login" title="Login">Help</a></p><p>{loadposition loginload}</p>', '', 1, 65, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 3, 2, '', '', 1, 4, '', 0, '*', '', ''),
(29, 127, 'Menu Module', 'menu-module', '<p>This module displays a menu on the site (frontend). ', '', 1, 75, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 3, 1, '', '', 1, 3, '', 0, '*', '', ''),
(30, 128, 'Most Read Content', 'most-read-content', '<p>This Module shows a list of the currently published Articles which have the highest number of page views. <a href="http://docs.joomla.org/Help15:Screen.modulessite.edit.15#Most_Read_Content" title="Most Read Content">Help</a></p>\r\n<p>{loadposition articlespopularload}</p>', '', 1, 64, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","page_title":"","alternative_readmore":"","layout":""}', 5, 2, 'modules, content', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(31, 129, 'News Flash', 'news-flash', '<p>Displays a set number of articles from a category based on date or random selection. <a href="http://docs.joomla.org/Help15:Screen.modulessite.edit.15#NewsFlash" title="News Flash Module">Help</a></p>\r\n<p>{loadposition newsflashload}</p>', '', 1, 64, '2020-02-06 08:15:05', 42, '', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","page_title":"","alternative_readmore":"","layout":""}', 3, 3, 'modules, content', '', 1, 3, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(32, 130, 'Parameters', 'parameters', '<p>As you make your Joomla! site using the extension you will control the details of the display using <em>parameter</em><strong>s</strong>. Parameters control everything from whether the author\'s name is displayed to who can view what to the number of items shown on a list.</p><p>Default parameters for each components are changed using the Options button on the component toolbar.</p><p>Parameters can also be set on an individual item, such as an article or contact and in menu links.</p><p>If you are happy with how your site looks, it is fine to leave all of the parameters set to the defaults that were created when your site was installed. As you become more experienced with Joomla! you will use parameters more.</p><p>', '', 1, 19, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 2, 10, '', '', 1, 11, '', 0, '*', '', ''),
(33, 131, 'Phyllopteryx', 'phyllopteryx', '<p><img src="images/sampledata/parks/animals/200px_phyllopteryx_taeniolatus1.jpg" border="0" style="vertical-align: middle;" /></p><p>', '<p><img src="images/sampledata/parks/animals/800px_phyllopteryx_taeniolatus1.jpg" border="0" style="vertical-align: middle;" /></p><p>', 1, 72, '2020-02-06 08:15:05', 42, 'Parks Webmaster', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 2, 3, '', '', 1, 0, '', 0, '*', '', ''),
(34, 132, 'Pinnacles', 'pinnacles', '<p><img src="images/sampledata/parks/landscape/120px_pinnacles_western_australia.jpg" border="0" alt="Kings Canyon" width="120" height="90" style="vertical-align: middle; border: 0;" /></p>', '<p><img src="images/sampledata/parks/landscape/800px_pinnacles_western_australia.jpg" border="0" alt="King\'s Canyon" width="500" height="374" style="vertical-align: middle; border: 0;" /></p><p>', 1, 73, '2020-02-06 08:15:05', 42, 'Parks Webmaster', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 3, 4, '', '', 1, 1, '', 0, '*', '', ''),
(35, 133, 'Professionals', 'professionals', '<p>Joomla! 1.6 continues development of the Joomla Framework and CMS as a powerful and flexible way to bring your vision of the web to reality. With the administrator now fully MVC, the ability to control its look and the management of extensions is now complete.</p>', '<p>Working with multiple template styles and overrides for the same views, creating the design you want is easier than it has ever been. Limiting support to PHP 5.x and above and ending legacy support for Joomla 1.0 extensions makes Joomla! lighter and faster than ever.', 1, 19, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":""}', 4, 6, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(36, 134, 'Random Image Module', 'random-image-module', '<p>This Module displays a random image from your chosen image directory. <a href="http://docs.joomla.org/Help15:Screen.modulessite.edit.15#Random_Image" title="Random Image Module">Help</a></p><p>{loadposition randomimageload}</p>', '', 1, 66, '2020-02-06 08:15:05', 42, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 2, 4, '', '', 1, 2, '', 0, '*', '', ''),
(37, 135, 'Related Items Module', 'related-items-module', '<p>This Module displays other Articles that are related to the one currently being viewed. These relations are established by the Meta Keywords.', '', 1, 64, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","page_title":"","alternative_readmore":"","layout":""}', 3, 4, 'modules, content', '', 1, 4, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(38, 136, 'Sample Sites', 'sample-sites', '<p>Your installation includes sample data, designed to show you some of the options you have for building your website. In addition to information about Joomla! there are two sample "sites within a site" designed to help you get started with builidng your own site.</p><p>The first site is a simple site about <a href="index.php?Itemid=243">Australian Parks</a>. It shows you you an quickly and easily build a personal site with just the building blocks that are part of Joomla!. It includes a personal blog, weblinks, and a very simple image gallery.</p><p>The second site is slightly more complex and represents what you might do if you are building a site for a small business, in this case a <a href="index.php/welcome.html"></a><a href="index.php?Itemid=429">Fruit Shop</a>.</p><p>In building either style site, or something completely different, you will probably want to add <a href="http://extensions.joomla.org">extensions</a> and either create or purchase your own template. Many Joomla! users start off by modifying the <a href="http://docs.joomla.org/How_do_you_modify_a_template%3F">templates</a> that come with the core distribution so that they include special images and other design elements that relate to their site\'s focus.</p>', '', 1, 19, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 3, 11, '', '', 1, 13, '', 0, '*', '', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`, `note`) VALUES
(39, 137, 'Search', 'search-component', '<p>The search component proviedes basic search functionality for the information contained in your core components. Many third part extensions also can be searched by the search component. Help</p>', '', 1, 21, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 3, 3, '', '', 1, 3, '', 0, '*', '', ''),
(40, 138, 'Search Module', 'search-module', '<p>This module will display a search box. <a href="http://docs.joomla.org/Help15:Screen.modulessite.edit.15#Search" title="Search">Help</a></p><p>{loadposition searchload}</p>', '', 1, 67, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 2, 4, '', '', 1, 2, '', 0, '*', '', ''),
(41, 139, 'Search ', 'search-plugin', '<p>The search component uses plugins to control which parts of your Joomla! site are searched. You may choose to turn off some areas to improve performance or for other reasons. Many third party Joomla! extensions have search plugins that extend where search takes place.</p><p>Default On:</p><ul><li>Content Help</li><li>Contacts Help</li><li>Weblinks', '', 1, 25, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 3, 1, '', '', 1, 2, '', 0, '*', '', ''),
(42, 140, 'Site Map', 'site-map', '<p>{loadposition sitemapload}</p><p><em>By putting all of your content into nested categories you can give users and search engines access to everything using a menu.</em></p>', '', 1, 14, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 2, 1, '', '', 1, 2, '', 0, '*', '', ''),
(43, 141, 'Spotted Quoll', 'spotted-quoll', '<p><img src="images/sampledata/parks/animals/220px_spottedquoll_2005_seanmcclean.jpg" border="0" alt="Spotted Quoll" style="vertical-align: middle; border: 0;" /></p>', '<p><img src="images/sampledata/parks/animals/789px_spottedquoll_2005_seanmcclean.jpg" border="0" alt="Spotted Quoll" style="vertical-align: middle;" /></p><p>', 1, 72, '2020-02-06 08:15:05', 42, 'Parks Webmaster', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 2, 4, '', '', 1, 0, '', 0, '*', '', ''),
(44, 142, 'Statistics Module', 'statistics', '<p>The Statistics Module shows information about your server installation together with statistics on the Web site users, number of Articles in your database and the number of Web links you provide.</p><p>{loadposition statisticsload}</p>', '', 1, 67, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 3, 5, '', '', 1, 2, '', 0, '*', '', ''),
(45, 143, 'Syndicate Module', 'syndicate-module', '<p>The syndicate module allows you to display a link that allows users to take a feed from your site. It will only display on pages for which feeds are possible. That means it will not display on single article, contact or weblinks pages, such as this one. <a href="http://docs.joomla.org/Help15:Screen.modulessite.edit.15#Syndicate" title="Synicate Module">Help</a></p><p>{loadposition syndicateload}</p>', '', 1, 67, '2020-02-06 08:15:05', 42, '', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 2, 6, '', '', 1, 3, '', 0, '*', '', ''),
(46, 144, 'System', 'system', '<p>System plugins operate every time a page on your site loads. They control such things as your URLS, whether users can check a "remember me" box on the login module, and whether caching is enabled. ', '', 1, 25, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 3, 2, '', '', 1, 2, '', 0, '*', '', ''),
(47, 145, 'The Joomla! Community', 'the-joomla-community', '<p>Joomla! means All Together, and it is a community of people all working and having fun together that makes Joomla! possible. Thousands of people each year participate in the Joomla! community, and we hope you will be one of them.<a href="index.php?option=com_content&view=article&catid=40&id=27">Archive Module</a></p><p>People with all kinds of skills, of all skill levels and from around the world are welcome to join in. Participate in the <a href="http://joomla.org">Joomla.org</a> family of websites (the<a href="http://forum.joomla.org"> forum </a>is a great place to start). Come to a <a href="http://community.joomla.org/events.html">Joomla! event</a>. Join or start a <a href="http://community.joomla.org/user-groups.html">Joomla! Users Group</a>. Whether you are a developer, site administrator, designer, end user or fan, there are ways for you to participate and contribute.</p>', '', 1, 19, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 2, 4, '', '', 1, 13, '', 0, '*', '', ''),
(48, 146, 'The Joomla! Project', 'the-joomla-project', '<p>The Joomla! Project consists of all of the people who make and support the Joomla! Web Platform and Content Management System.</p><p>Our mission is to provide a flexible platform for digital publishing and collaboration.</p><p>The core values are:</p><ul><li>Freedom</li><li>Equality</li><li>Trust</li><li>Community</li><li>Collaboration</li><li>Usability</li></ul><p>In our vision, we see:</p><ul><li>People publishing and collaborating in their communities and around the world</li><li>Software that is free, secure, and high-quality</li><li>A community that is enjoyable and rewarding to participate in</li><li>People around the world using their preferred languages</li><li>A project that acts autonomously</li><li>A project that is socially responsible</li><li>A project dedicated to maintaining the trust of its users</li></ul><p>There are millions of users around the world and thousands of people who contribute to the Joomla! Project. They work in three main groups: the Production Working Group, responsible for everything that goes into software and documentation; the Community Working Group, responsible for creating a nurturing the community; and Open Source Matters, the non profit organization responsible for managing legal, financial and organizational issues.</p><p>Joomla! is a free and open source project, which uses the GNU General Public License', '', 1, 19, '2020-02-06 08:15:05', 42, '', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 3, 1, '', '', 1, 12, '', 0, '*', '', ''),
(49, 147, 'Typography', 'typography', '<h1>H1 ABCDEFGHIJKLMNOPQRSTUVWXYZ abcdefghijklmonpqrstuvwzyz</h1><h2>H2 ABCDEFGHIJKLMNOPQRSTUVWXYZ abcdefghijklmonpqrstuvwzyz</h2><h3>H3 ABCDEFGHIJKLMNOPQRSTUVWXYZ abcdefghijklmonpqrstuvwzyz</h3><h4>H4 ABCDEFGHIJKLMNOPQRSTUVWXYZ abcdefghijklmonpqrstuvwzyz</h4><h5>H5 ABCDEFGHIJKLMNOPQRSTUVWXYZ abcdefghijklmonpqrstuvwzyz</h5><h6>H6 ABCDEFGHIJKLMNOPQRSTUVWXYZ abcdefghijklmonpqrstuvwzyz</h6><p>P The quick brown fox ran over the lazy dog. THE QUICK BROWN FOX RAN OVER THE LAZY DOG.</p><ul><li>Item</li><li>Item</li><li>Item<br /> <ul><li>Item</li><li>Item</li><li>Item<br /> <ul><li>Item</li><li>Item</li><li>Item</li></ul></li></ul></li></ul><ol><li>tem</li><li>Item</li><li>Item<br /> <ol><li>Item</li><li>Item</li><li>Item<br /><ol><li>Item</li><li>Item</li><li>Item</li></ol></li></ol> </li></ol>', '', -2, 23, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 2, 1, '', '', 1, 14, '', 0, '*', '', ''),
(50, 148, 'Upgraders', 'upgraders', '<p>If you are an experienced Joomla! 1.5 user, 1.6 will seem very familiar. There are new templates and improved user interfaces, but most functionality is the same. The biggest changes are improved access control (ACL) and nested categories.</p>', '<p>The new user manager which will let you manage who has access to what in your site. You can leave access groups exactly the way you had them in Joomla 1.5 or make them as complicated as you want. You can learn more about<a href="http://docs.joomla.org/ACL_Tutorial_for_Joomla_1.6"> how access control works</a> in on the <a href="http://docs.joomla.org">Joomla! Documentation sit</a></p><p>In Joomla 1.5 and 1.0 content was organized into sections and categories. In 1.6 sections are gone, and you can create categories within categories, going as deep as you want. The sample data provides many examples of the use of nested categories.</p><p>All layouts have been redesigned to improve accessibility and flexibility. If you would like to keep the 1.5 layouts, you can find them in the html folder of the MilkyWay template. Simply copy the layouts you want to the html folder of your template.</p><p>Updating your site and extensions when needed is easier than ever thanks to installer improvements.</p><p>To learn more about how to<a href="http://docs.joomla.org/Migrating_from_1.5_to_1.6"> move a Joomla! 1.5 site to a Joomla! 1.6 installation read this article</a>.</p>', 1, 19, '2020-02-06 08:15:05', 42, '', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":""}', 3, 5, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(51, 149, 'User', 'user-plugins', '<p>Default on:</p><ul><li>Joomla Help</li></ul><p>Default off:</p><p>Two new plugins are available in 1.6 but are disabled by default.</p><ul><li>Contact Creator', '', 1, 25, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 3, 4, '', '', 1, 2, '', 0, '*', '', ''),
(52, 150, 'Users', 'users-component', '<p>The users extension lets your site visitors register, login and logout, change their passwords and other information, and recover lost passwords. In the administrator it allows you to create, block and manage users and create user groups and access levels. Help</p>\r\n<p>Please note that some of the user views will not display if you are not logged in to the site.</p>', '', 1, 21, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 4, 5, '', '', 1, 4, '', 0, '*', '', ''),
(53, 151, 'Using Joomla!', 'using-joomla', '<p>With Joomla! You can create anything from a simple personal website to a complex ecommerce or social site with millions of visitors.</p><p>This section of the sample data provides you with a brief introduction to Joomla! concepts and reference material to help you understand how Joomla! works.</p><p><em>When you not longer need the sample data, you can can simply unpublish the sample data category found within each extension in the site administrator or you may completely delete each item and all of the categories. </em></p>', '', 1, 19, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 2, 7, '', '', 1, 25, '', 0, '*', '', ''),
(54, 152, 'Weblinks', 'weblinks', '<p>Weblinks (com_weblinks) is a component that provides a structured way to organize external links and present them in a visually attractive, consistent and informative way. Help</p>', '', 1, 21, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 3, 6, '', '', 1, 10, '', 0, '*', '', ''),
(55, 153, 'Weblinks Module', 'weblinks-module', '<p>This module displays the list of weblinks in a category. ', '', 1, 66, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 2, 5, '', '', 1, 3, '', 0, '*', '', ''),
(56, 154, 'Who\'s Online', 'whos-online', '<p>The Who\'s Online Module displays the number of Anonymous Users (e.g. Guests) and Registered Users (ones logged in) that are currently accessing the Web site. <a href="http://docs.joomla.org/Help15:Screen.modulessite.edit.15#Who.27s_Online" title="Who\'s Online">Help</a></p><p>{loadposition whosonlineload}</p>', '', 1, 65, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 2, 1, '', '', 1, 3, '', 0, '*', '', ''),
(57, 155, 'Wobbegone', 'wobbegone', '<p><img src="images/sampledata/parks/animals/180px_wobbegong.jpg" border="0" alt="Wobbegone" style="vertical-align: middle; border: 0;" /></p>', '<p><img src="images/sampledata/parks/animals/800px_wobbegong.jpg" border="0" style="vertical-align: middle; border: 0;" /></p><p>Source: http://en.wikipedia.org/wiki/File:Wobbegong.jpg</p><p>Author: Richard Ling</p><p>Rights: GNU Free Documentation License v 1.2 or later</p>', 1, 72, '2020-02-06 08:15:05', 42, 'Parks Webmaster', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 2, 1, '', '', 1, 0, '', 0, '*', '', ''),
(58, 156, 'Wonderful Watermelon', 'wonderful-watermelon', '<p>Watermelon is a wonderful and healthy treat. We grow the world\'s sweetest watermelon. We have the largest watermelon patch in our country.</p>', '', 1, 30, '2020-02-06 08:15:05', 42, 'Fruit Shop Webmaster', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 2, 1, '', '', 1, 0, '', 0, '*', '', ''),
(59, 157, 'Wrapper Module', 'wrapper-module', '<p>This module shows an iFrame window to specified location. <a href="http://docs.joomla.org/Help15:Screen.modulessite.edit.15#Wrapper" title="Wrapper Module">Help</a></p><p>{loadposition wrapperload}</p>', '', 1, 67, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 2, 1, '', '', 1, 1, '', 0, '*', '', ''),
(60, 158, 'News Feeds', 'news-feeds', '<p>News Feeds (com_newsfeeds) provides a way to organize and present news feeds. News feeds are a way that you present information from another site on your site. For example, the joomla.org website has numerous feeds that you an incorporate on your site. You an use menus to present a single feed, a list of feeds in a category, or or a list of all feed categories. Help</p>', '', 1, 21, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 2, 4, '', '', 1, 3, '', 0, '*', '', ''),
(61, 159, 'Breadcrumbs Module', 'breadcrumbs-module', '<p>Breadcrumbs provide a pathway for users to navigate through the site. <a href="http://docs.joomla.org/Help15:Screen.modulessite.edit.15#Breadcrumbs" title="Breacrumbs Module">Help</a></p><p>{loadposition breadcrumbsload}</p>', '', 1, 67, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 2, 2, '', '', 1, 3, '', 0, '*', '', ''),
(62, 160, 'Content', 'content-plugins', '<p>Content plugins run when specific kinds of pages are loaded. They do things ranging from protecting email addresses from harvesters to creating page breaks.</p><p>Default on:</p><ul><li>Email Cloaking Help</li><li>Load Module Help</li><li>Page Break Help</li><li>Page Navigation Help</li><li>Rating Help</li></ul><p>Default off:</p><ul><li>Code Highlighting (Geshi) Help</li></ul>', '', 1, 25, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 2, 7, '', '', 1, 3, '', 0, '*', '', ''),
(64, 162, 'Blue Mountain Rain Forest', 'blue-mountain-rain-forest', '<p><img src="images/sampledata/parks/landscape/120px_rainforest_bluemountainsnsw.jpg" border="0" alt="Rain Forest Blue Mountrains" /></p>', '<p><img src="images/sampledata/parks/landscape/727px_rainforest_bluemountainsnsw.jpg" border="0" alt="Rain Forest Blue Mountrains" style="vertical-align: middle;" /></p><p>', 1, 73, '2020-02-06 08:15:05', 42, 'Parks Webmaster', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 2, 2, '', '', 1, 0, '', 0, '*', '', ''),
(65, 163, 'Ormiston Pound', 'ormiston-pound', '<p><img src="images/sampledata/parks/landscape/180px_ormiston_pound.jpg" border="0" alt="Ormiston Pound" style="border: 0;" /></p>', '<p><img src="images/sampledata/parks/landscape/800px_ormiston_pound.jpg" border="0" alt="Ormiston Pound" height="375" style="vertical-align: middle; border: 0;" /></p><p>', 1, 73, '2020-02-06 08:15:05', 42, 'Parks Webmaster', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 3, 3, '', '', 1, 0, '', 0, '*', '', ''),
(66, 165, 'Latest Users Module', 'latest-users-module', '<p>This module displays the latest registered users. Help</p>\r\n<p>{loadposition userslatestload}</p>', '', 1, 65, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"1","link_titles":"","show_intro":"","show_category":"1","link_category":"1","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 3, 3, '', '', 1, 4, '', 0, '*', '', ''),
(67, 168, 'What\'s New in 1.5?', 'whats-new-in-15', '<p>As with previous releases, Joomla! provides a unified and easy-to-use framework for delivering content for Web sites of all kinds. To support the changing nature of the Internet and emerging Web technologies, Joomla! required substantial restructuring of its core functionality and we also used this effort to simplify many challenges within the current user interface. Joomla! 1.5 has many new features.</p>\r\n<p style="margin-bottom: 0in;">In Joomla! 1.5, you\'\'ll notice:</p>\r\n<ul>\r\n<li>Substantially improved usability, manageability, and scalability far beyond the original Mambo foundations</li>\r\n<li>Expanded accessibility to support internationalisation, double-byte characters and right-to-left support for Arabic, Farsi, and Hebrew languages among others</li>\r\n<li>Extended integration of external applications through Web services</li>\r\n<li>Enhanced content delivery, template and presentation capabilities to support accessibility standards and content delivery to any destination</li>\r\n<li>A more sustainable and flexible framework for Component and Extension developers</li>\r\n<li>Backward compatibility with previous releases of Components, Templates, Modules, and other Extensions</li>\r\n</ul>', '', 2, 9, '2020-02-06 08:15:05', 42, 'Joomla! 1.5', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 1, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(68, 117, 'Getting Help', 'footer-module', '<p>There are lots of places you can get help with Joomla!.</p>\r\n<p>In many places you will see the help icon [image]. Click on this for more information about the options and functions of items on your screen.</p>\r\n<ul>\r\n<li><a href="http://forum.joomla.org">Support Forums</a></li>\r\n<li><a href="http://docs.joomla.org">Documentation</a></li>\r\n<li><a href="http://resources.joomla.org">Professionals</a></li>\r\n<li><a href="http://shop.joomla.org/amazoncom-bookstores.html">Books</a></li>\r\n</ul>', '', 1, 19, '2020-02-06 08:15:05', 42, 'Joomla!', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 4, 3, '', '', 1, 2, '', 0, '*', '', ''),
(69, 169, 'Joomla 3.x Fluid & Responsive Design template', 'joomla-3-x-fluid-responsive-design-template', '<p><img src="images/stories/demo/sam-3.jpg" border="0" alt="Sample image" title="Sample image" /></p>\r\n<p><strong>Lorem ipsum</strong> dolor sit amet consectetuer velit nunc tellus gravida Lorem. Orci neque mauris nibh ligula mauris Aenean eu sit sem laoreet. Et ipsum accumsan dis et semper rhoncus Vestibulum ut et est. Leo In Praesent sed Lorem nascetur id tempus et ac semper.</p>\r\n', '\r\n<p>Tellus massa Vivamus orci habitant adipiscing cursus nonummy pretium nunc ipsum. Praesent justo tempor egestas eget id nulla Maecenas convallis odio nibh. Eleifend Vivamus odio Integer ut id malesuada nonummy elit pede Donec. Vivamus vel consectetuer pellentesque eu malesuada vitae parturient ante quis dui. Vestibulum ac Nulla risus magna ornare neque Quisque pellentesque sed Curabitur. Mattis sodales faucibus In Morbi lorem Sed.</p>\r\n<p>Nibh Morbi egestas Ut Suspendisse lacus Phasellus Vestibulum pretium Vestibulum tellus. Et sociis quis pretium Nunc Sed congue est laoreet nibh convallis. Ante tincidunt risus et pede Cras montes mauris nibh fermentum faucibus. Elit neque nunc justo justo orci tellus tempus fermentum libero ipsum. Ante sed fringilla id tempor tellus pretium Nam ut sodales consequat. Nonummy justo id Nulla nisl auctor risus velit congue nibh nibh. Cursus velit.</p>\r\n<p>Et In quis Cras felis convallis volutpat Aliquam penatibus Nunc tellus. In justo ac orci diam et lorem eu metus orci et. Ligula dictumst tincidunt vel vel quam metus at libero In non. Elit nec et non Morbi libero Curabitur Aenean accumsan ut Sed. Convallis convallis id sapien augue id Donec tempus convallis Praesent ut. Massa ante tincidunt.</p>\r\n<p>Nec orci ipsum rhoncus Sed ipsum velit facilisi Donec Vestibulum Vestibulum. Aenean Vestibulum Ut turpis tincidunt adipiscing sodales dolor felis Pellentesque enim. Tincidunt porttitor metus pharetra Vivamus lobortis dui senectus malesuada semper neque. Ultrices penatibus nulla malesuada Morbi dis Donec Vestibulum Curabitur dui Sed. Urna hac Phasellus odio faucibus dui Quisque amet velit eu consequat. Vestibulum wisi tellus et porttitor ante purus Fusce adipiscing pede orci. Semper.</p>\r\n<p>Parturient et Nam enim et orci wisi auctor consequat ante accumsan. Rhoncus Cras neque id lobortis mauris lorem adipiscing pede Cum vel. Pretium id Vestibulum Phasellus senectus fringilla justo orci magna Curabitur metus. Id sed consectetuer Nunc wisi dolor interdum ut wisi quis tincidunt. Sed vitae et non quis et est fringilla Sed ut augue. Lobortis sagittis dui porttitor gravida semper Donec Pellentesque libero quis.</p>\r\n<p>Suspendisse pellentesque Integer vitae Phasellus libero malesuada nulla parturient et porttitor. Quisque mauris laoreet cursus auctor ipsum dictum libero accumsan cursus sed. Nec risus condimentum Aliquam ut condimentum id Lorem Maecenas sit pellentesque. Interdum id Pellentesque wisi Sed mauris feugiat Sed ac et congue. Eget tellus quis tortor dis wisi auctor libero nibh aliquet odio. Sapien mattis cursus dolor congue elit velit fermentum.</p>', 1, 78, '2020-02-06 08:15:05', 42, '', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 20, 16, 'design Joomla 3.x responsive template, mobile design Joomla 3.x template, Joomla 3.x web design', '3.x Joomla responsive design features on handheld devices.', 1, 67, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', '', ''),
(70, 170, 'Responsive Joomla 3.x Template', 'responsive-joomla-3-x-template', '<p><img src="images/stories/demo/sam-1.jpg" alt="Sample image" title="Sample image" /></p>\r\n<p>Gravida id at Aenean natoque et consequat a Fusce Suspendisse turpis. Ut platea tincidunt Sed ut nibh justo augue adipiscing ac nibh. In habitasse tellus Vestibulum semper nibh dui In justo Sed consequat. Morbi id turpis enim et eget Nam at orci sapien scelerisque. Odio id dictum id elit Donec Vestibulum at nec in a. Hendrerit eleifend vel enim rutrum id.</p>\r\n', '\r\n<h2>So, what’s responsive web design?</h2>\r\n<p>Auctor sem dictum urna volutpat elit vitae consectetuer penatibus orci id. Orci ac feugiat et Lorem porttitor habitasse eget wisi velit adipiscing. Quis lacus lorem Nullam id eu nisl cursus pharetra cursus molestie. Convallis eu nulla porttitor id vel vel mattis Aliquam lacus vitae. Auctor et orci mauris elit eros.</p>\r\n<p>Ac pellentesque Maecenas leo pharetra sit In ipsum elit at Morbi. Donec dictum tincidunt et hendrerit id id fames semper nec tincidunt. Dui justo eu sed Phasellus id nisl pede at enim Curabitur. Lacus Maecenas penatibus vel sed Curabitur leo at a in sed. Vestibulum fames Nulla dolor libero sociis <a href="#" title="Sample link">ipsum habitasse laoreet tellus.</a></p>\r\n<h2>Flexible grid</h2>\r\n<p>Nibh Morbi egestas Ut Suspendisse lacus Phasellus Vestibulum pretium Vestibulum tellus. Et sociis quis pretium Nunc Sed congue est laoreet nibh convallis. Ante tincidunt risus et pede Cras montes mauris nibh fermentum faucibus. Elit neque nunc justo justo orci tellus tempus fermentum libero ipsum. Ante sed fringilla id tempor tellus pretium Nam ut sodales consequat. Nonummy justo id Nulla nisl auctor risus velit congue nibh nibh. Cursus velit.</p>\r\n<p>Et In quis Cras felis convallis volutpat Aliquam penatibus Nunc tellus. In justo ac orci diam et lorem eu metus orci et. Ligula dictumst tincidunt vel vel quam metus at libero In non. Elit nec et non Morbi libero Curabitur Aenean accumsan ut Sed. Convallis convallis id sapien augue id Donec tempus convallis Praesent ut. Massa ante tincidunt.</p>\r\n<p class="ja-typo-box box-sticky"><strong>This is a sticky</strong>. Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n<h2>Responsive Typography</h2>\r\n<p>Nec orci ipsum rhoncus Sed ipsum velit facilisi Donec Vestibulum Vestibulum. Aenean Vestibulum Ut turpis tincidunt adipiscing sodales dolor felis Pellentesque enim. Tincidunt porttitor metus pharetra Vivamus lobortis dui senectus malesuada semper neque. Ultrices penatibus nulla malesuada Morbi dis Donec Vestibulum Curabitur dui Sed. Urna hac Phasellus odio faucibus dui Quisque amet velit eu consequat. Vestibulum wisi tellus et porttitor ante purus Fusce adipiscing pede orci. Semper.</p>\r\n<ul>\r\n<li>Aliquam penatibus Nunc tellus</li>\r\n<li>Ultrices penatibus nulla malesuada Morbi dis Donec</li>\r\n<li>Vestibulum wisi tellus et porttitor ante purus</li>\r\n</ul>\r\n<h2>Does your site need to be responsive?</h2>\r\n<p>Parturient et Nam enim et orci wisi auctor consequat ante accumsan. Rhoncus Cras neque id lobortis mauris lorem adipiscing pede Cum vel. Pretium id Vestibulum Phasellus senectus fringilla justo orci magna Curabitur metus. Id sed consectetuer Nunc wisi dolor interdum ut wisi quis tincidunt. Sed vitae et non quis et est fringilla Sed ut augue. Lobortis sagittis dui porttitor gravida semper Donec Pellentesque libero quis.</p>', 1, 78, '2020-02-06 08:15:05', 42, '', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 28, 15, 'Responsive Joomla 3.x Template, Responsive Web Design, Mobile Joomla 3.x template', 'Responsive Joomla 3.x template for works on most mobile devices.', 1, 208, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', '', ''),
(71, 171, 'Joomla! Security Strike Team', 'joomla-security-strike-team', '<p>The Joomla! Project has assembled a top-notch team of experts to form the new Joomla! Security Strike Team. This new team will solely focus on investigating and resolving security issues. Instead of working in relative secrecy, the JSST will have a strong public-facing presence at the <a href="http://developer.joomla.org/security.html" target="_blank" title="Joomla! Security Center">Joomla! Security Center</a>.</p>\r\n\r\n', '\r\n\r\n<p>The new JSST will call the new <a href="http://developer.joomla.org/security.html" target="_blank" title="Joomla! Security Center">Joomla! Security Center</a> their home base. The Security Center provides a public presence for <a href="http://developer.joomla.org/security/news.html" target="_blank" title="Joomla! Security News">security issues</a> and a platform for the JSST to <a href="http://developer.joomla.org/security/articles-tutorials.html" target="_blank" title="Joomla! Security Articles">help the general public better understand security</a> and how it relates to Joomla!. The Security Center also offers users a clearer understanding of how security issues are handled. There\'s also a <a href="http://feeds.joomla.org/JoomlaSecurityNews" target="_blank" title="Joomla! Security News Feed">news feed</a>, which provides subscribers an up-to-the-minute notification of security issues as they arise.</p>', 1, 78, '2020-02-06 08:15:05', 42, '', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":"","article_layout":""}', 4, 12, '', '', 1, 3, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(72, 172, 'Three-D Experiments', 'three-d-experiments', '<p>Tellus massa Vivamus orci habitant adipiscing cursus nonummy pretium nunc ipsum. Praesent justo tempor egestas eget id nulla Maecenas convallis odio nibh. Eleifend Vivamus odio Integer ut id malesuada nonummy elit pede Donec. Vivamus vel consectetuer pellentesque eu malesuada vitae parturient ante quis dui. Vestibulum ac Nulla risus magna ornare neque Quisque pellentesque sed Curabitur. Mattis sodales faucibus In Morbi lorem Sed.</p>\r\n', '\r\n<p>Lobortis Donec elit enim volutpat magna mauris nec id augue mauris. Convallis urna pellentesque mi leo porta et ac nisl habitant Donec. Quis tempus Curabitur quis Nulla elit Vestibulum justo neque cursus at. Auctor semper pede In vitae amet Vivamus Sed nibh et Phasellus. Nibh Curabitur lobortis a Nullam tortor convallis pede justo hac Vestibulum. Ut.</p>', 1, 78, '2020-02-06 08:15:05', 42, '', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 6, 14, '', '', 1, 11, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(73, 173, 'Responsive Template Joomla 3.x', 'responsive-template-joomla-3-x', '<p><img src="images/stories/demo/sam-2.jpg" border="0" alt="Sample image" title="Sample image" /></p>\r\n<p>Ut et ante pretium ornare natoque ut eget urna non in. Risus congue Maecenas laoreet gravida id in augue malesuada id id. Feugiat vitae Suspendisse ut id nonummy dapibus molestie at rutrum et. Dui dolor vel accumsan In interdum non sapien et <a href="#" title="Sample link">Phasellus odio.</a></p>\r\n', '\r\n<p>Auctor sem dictum urna volutpat elit vitae consectetuer penatibus orci id. Orci ac feugiat et Lorem porttitor habitasse eget wisi velit adipiscing. Quis lacus lorem Nullam id eu nisl cursus pharetra cursus molestie. Convallis eu nulla porttitor id vel vel mattis Aliquam lacus vitae. Auctor et orci mauris elit eros.</p>\r\n<h2>The Concept Of Responsive Web Design</h2>\r\n<p>Ac pellentesque Maecenas leo pharetra sit In ipsum elit at Morbi. Donec dictum tincidunt et hendrerit id id fames semper nec tincidunt. Dui justo eu sed Phasellus id nisl pede at enim Curabitur. Lacus Maecenas penatibus vel sed Curabitur leo at a in sed. Vestibulum fames Nulla dolor libero sociis ipsum habitasse laoreet tellus.</p>\r\n<h2>Flexible Images</h2>\r\n<p>Nibh Morbi egestas Ut Suspendisse lacus Phasellus Vestibulum pretium Vestibulum tellus. Et sociis quis pretium Nunc Sed congue est laoreet nibh convallis. Ante tincidunt risus et pede Cras montes mauris nibh fermentum faucibus. Elit neque nunc justo justo orci tellus tempus fermentum libero ipsum. Ante sed fringilla id tempor tellus pretium Nam ut sodales consequat. Nonummy justo id Nulla nisl auctor risus velit congue nibh nibh. Cursus velit.</p>\r\n<h2>Adjusting Screen Resolution</h2>\r\n<p>Et In quis Cras felis convallis volutpat Aliquam penatibus Nunc tellus. In justo ac orci diam et lorem eu metus orci et. Ligula dictumst tincidunt vel vel quam metus at libero In non. Elit nec et non Morbi libero Curabitur Aenean accumsan ut Sed. Convallis convallis id sapien augue id Donec tempus convallis Praesent ut. Massa ante tincidunt.</p>', 1, 78, '2020-02-06 08:15:05', 42, '', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 23, 13, 'Joomla 3.x templates design, 3.x Joomla design template, Joomla 3.x mobile design', 'Joomla 3.x responsive design user guide for Joomla lovers.', 1, 47, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', '', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`, `note`) VALUES
(74, 174, 'Typography', 'typography', '<div id="ja-typo">\r\n<p>This page presents most of typographical aspects of JA T3v2 Framework. <span class="highlight">Make your readers happy</span> with great Typography and User Experience!</p>\r\n<div class="ja-typo-blockswrap clearfix">\r\n<h1 class="ja-typo-title"><span>Preformatted text</span></h1>\r\n<div class="ja-typo-blockrow cols-1 clearfix">\r\n<div class="ja-typo-block">\r\n<h2 class="ja-typo-title"><span>Headings</span></h2>\r\n<div class="ja-typo-blockct clearfix">\r\n<h1>This is a sample Heading 1. Lorem ipsum.</h1>\r\n<h2>This is a sample Heading 2. Lorem ipsum.</h2>\r\n<h3>This is a sample Heading 3. Lorem ipsum.</h3>\r\n<h4>This is a sample Heading 4. Lorem ipsum.</h4>\r\n<h5>This is a sample Heading 5. Lorem ipsum.</h5>\r\n</div>\r\n</div>\r\n</div>\r\n<div class="ja-typo-blockrow cols-1 clearfix">\r\n<div class="ja-typo-block">\r\n<h2 class="ja-typo-title"><span>Special Content</span></h2>\r\n<div class="ja-typo-blockct clearfix">\r\n<p>Below is a sample of <strong>pre</strong> tag or <strong>code</strong> class:</p>\r\n<pre>#ja-rightcol {\r\n  width: 180px;\r\n  float: right;\r\n  color: #EEEEEE;\r\n}\r\n</pre>\r\n<p>This is a <span class="highlight">highlight phrase</span>. Use <strong>class="highlight"</strong>.</p>\r\n</div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<h2 class="ja-typo-title"><span>Blockquote</span></h2>\r\n<div class="ja-typo-blockct clearfix">\r\n<blockquote><span class="open">T</span>his is a sample <strong>Blockquote</strong>. Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</blockquote>\r\n<blockquote><span class="open">T</span>his is a sample Blockquote. Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.<span class="close">!</span></blockquote>\r\n</div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<h2 class="ja-typo-title"><span>Dropcaps</span></h2>\r\n<div class="ja-typo-blockct clearfix">\r\n<p><span class="dropcap">T</span>his is a Magazine Style Drop Cap. The first  letter in this paragraph is big. JA Templates bring into your Jooomla  template the magazine drop cap technique and CSS2 includes the  first-letter pseudo class.</p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class="ja-typo-blockswrap clearfix">\r\n<h1 class="ja-typo-title"><span>Lists Style</span></h1>\r\n<div class="ja-typo-blockrow cols-3 clearfix">\r\n<div class="ja-typo-block first clearfix">\r\n<h2 class="ja-typo-title"><span>Ordered List</span></h2>\r\n<div class="ja-typo-blockct clearfix"><ol>\r\n<li>This is a sample <strong>Ordered List</strong>.</li>\r\n<li>Lorem ipsum dolor sit amet consectetur</li>\r\n<li>Lorem ipsum dolor sit amet consectetur</li>\r\n<li>Lorem ipsum dolor sit amet consectetur</li>\r\n</ol></div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<h2 class="ja-typo-title"><span>Un-Ordered List</span></h2>\r\n<div class="ja-typo-blockct clearfix">\r\n<ul>\r\n<li>This is a sample <strong>Unordered List</strong>.</li>\r\n<li>Lorem ipsum dolor sit amet consectetur</li>\r\n<li>Lorem ipsum dolor sit amet consectetur</li>\r\n<li>Lorem ipsum dolor sit amet consectetur</li>\r\n</ul>\r\n</div>\r\n</div>\r\n<div class="ja-typo-block last clearfix">\r\n<h2 class="ja-typo-title"><span>Definition List</span></h2>\r\n<div class="ja-typo-blockct clearfix"><dl> <dt>This is a sample <strong>Definition List</strong>.</dt> <dd>Condimentum quis.</dd> <dd>Congue Quisque augue elit dolor.</dd> <dd>Congue Quisque augue elit dolor.</dd> </dl></div>\r\n</div>\r\n</div>\r\n<div class="ja-typo-blockrow cols-3 clearfix">\r\n<h2 class="ja-typo-title"><span>Special Unordered Lists</span></h2>\r\n<div class="ja-typo-block">\r\n<div class="ja-typo-blockct clearfix">\r\n<ul class="ja-typo-list list-arrow">\r\n<li><span class="icon"> </span>This is a sample <strong>Arrow list</strong>.</li>\r\n<li><span class="icon"> </span>Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</li>\r\n<li><span class="icon"> </span>This is a sample Arrowlist.</li>\r\n</ul>\r\n</div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<div class="ja-typo-blockct clearfix">\r\n<ul class="ja-typo-list list-star">\r\n<li><span class="icon"> </span>This is a sample <strong>Star list</strong>.</li>\r\n<li><span class="icon"> </span>Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</li>\r\n<li><span class="icon"> </span>This is a sample Starlist.</li>\r\n</ul>\r\n</div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<div class="ja-typo-blockct clearfix">\r\n<ul class="ja-typo-list list-check">\r\n<li><span class="icon"> </span>This is a sample <strong>Check list</strong>.</li>\r\n<li><span class="icon"> </span>Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</li>\r\n<li><span class="icon"> </span>This is a sample Checklist.</li>\r\n</ul>\r\n</div>\r\n</div>\r\n</div>\r\n<div class="ja-typo-blockrow cols-3 clearfix">\r\n<h2 class="ja-typo-title"><span>Block Number</span></h2>\r\n<div class="ja-typo-block">\r\n<div class="ja-typo-blockct clearfix">\r\n<p class="blocknumber blocknumber-1"><span class="bignumber">01</span>Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n<p class="blocknumber blocknumber-1"><span class="bignumber">02</span>Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n<p class="blocknumber blocknumber-1"><span class="bignumber">03</span>Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n</div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<div class="ja-typo-blockct clearfix">\r\n<p class="blocknumber blocknumber-2"><span class="bignumber">A</span>Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n<p class="blocknumber blocknumber-2"><span class="bignumber">B</span>Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n<p class="blocknumber blocknumber-2"><span class="bignumber">C</span>Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n</div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<div class="ja-typo-blockct clearfix">\r\n<p class="blocknumber blocknumber-3"><span class="bignumber">a</span>Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n<p class="blocknumber blocknumber-3"><span class="bignumber">b</span>Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n<p class="blocknumber blocknumber-3"><span class="bignumber">c</span>Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class="ja-typo-blockswrap clearfix">\r\n<h1 class="ja-typo-title"><span>Icons Style</span></h1>\r\n<div class="ja-typo-blockrow cols-2 clearfix">\r\n<div class="ja-typo-block">\r\n<div class="ja-typo-blockct clearfix">\r\n<p class="ja-typo-icon icon-error"><span class="icon"> </span>Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n<p class="ja-typo-icon icon-message"><span class="icon"> </span>Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n<p class="ja-typo-icon icon-tips"><span class="icon"> </span>Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n<p class="ja-typo-icon icon-key"><span class="icon"> </span>Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n<p class="ja-typo-icon icon-tag"><span class="icon"> </span>Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n</div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<div class="ja-typo-blockct clearfix">\r\n<p class="ja-typo-icon icon-cart"><span class="icon"> </span>Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n<p class="ja-typo-icon icon-doc"><span class="icon"> </span>Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n<p class="ja-typo-icon icon-note"><span class="icon"> </span>Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n<p class="ja-typo-icon icon-photo"><span class="icon"> </span>Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n<p class="ja-typo-icon icon-mobi"><span class="icon"> </span>Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class="ja-typo-blockswrap clearfix">\r\n<h1 class="ja-typo-title"><span>Bubbles</span></h1>\r\n<div class="ja-typo-blockrow cols-3 clearfix">\r\n<div class="ja-typo-block">\r\n<h2 class="ja-typo-title"><span>Grey Bubbles</span></h2>\r\n<div class="ja-typo-blockct clearfix">\r\n<div class="ja-typo-bubble bubble-1">\r\n<div class="ja-typo-bubblect">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla dapibus sapien vel mauris viverra quis euismod dui tincidunt. Phasellus laoreet mattis est, eu vulputate sapien.</div>\r\n<p class="ja-typo-bubble-meta"><span class="ja-typo-bubble-arrow"> </span> <span class="ja-typo-bubble-author">Author Name</span></p>\r\n</div>\r\n<div class="ja-typo-bubble bubble-2">\r\n<div class="ja-typo-bubblect">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla dapibus sapien vel mauris viverra quis euismod dui tincidunt. Phasellus laoreet mattis est, eu vulputate sapien.</div>\r\n<p class="ja-typo-bubble-meta"><span class="ja-typo-bubble-arrow"> </span> <span class="ja-typo-bubble-author">Author Name</span></p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<h2 class="ja-typo-title"><span>Blue Bubbles</span></h2>\r\n<div class="ja-typo-blockct clearfix">\r\n<div class="ja-typo-bubble bubble-3">\r\n<div class="ja-typo-bubblect">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla dapibus sapien vel mauris viverra quis euismod dui tincidunt. Phasellus laoreet mattis est, eu vulputate sapien.</div>\r\n<p class="ja-typo-bubble-meta"><span class="ja-typo-bubble-arrow"> </span> <span class="ja-typo-bubble-author">Author Name</span></p>\r\n</div>\r\n<div class="ja-typo-bubble bubble-4">\r\n<div class="ja-typo-bubblect">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla dapibus sapien vel mauris viverra quis euismod dui tincidunt. Phasellus laoreet mattis est, eu vulputate sapien.</div>\r\n<p class="ja-typo-bubble-meta"><span class="ja-typo-bubble-arrow"> </span> <span class="ja-typo-bubble-author">Author Name</span></p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<h2 class="ja-typo-title"><span>Black Bubbles</span></h2>\r\n<div class="ja-typo-blockct clearfix">\r\n<div class="ja-typo-bubble bubble-5">\r\n<div class="ja-typo-bubblect">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla dapibus sapien vel mauris viverra quis euismod dui tincidunt. Phasellus laoreet mattis est, eu vulputate sapien.</div>\r\n<p class="ja-typo-bubble-meta"><span class="ja-typo-bubble-arrow"> </span> <span class="ja-typo-bubble-author">Author Name</span></p>\r\n</div>\r\n<div class="ja-typo-bubble bubble-6">\r\n<div class="ja-typo-bubblect">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla dapibus sapien vel mauris viverra quis euismod dui tincidunt. Phasellus laoreet mattis est, eu vulputate sapien.</div>\r\n<p class="ja-typo-bubble-meta"><span class="ja-typo-bubble-arrow"> </span> <span class="ja-typo-bubble-author">Author Name</span></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class="ja-typo-blockrow cols-3 clearfix">\r\n<div class="ja-typo-block">\r\n<h2 class="ja-typo-title"><span>Rounded Grey Bubbles</span></h2>\r\n<div class="ja-typo-blockct clearfix">\r\n<div class="ja-typo-bubble bubble-rounded bubble-1">\r\n<div class="ja-typo-bubblect">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla dapibus sapien vel mauris viverra quis euismod dui tincidunt. Phasellus laoreet mattis est, eu vulputate sapien.</div>\r\n<p class="ja-typo-bubble-meta"><span class="ja-typo-bubble-arrow"> </span> <span class="ja-typo-bubble-author">Author Name</span></p>\r\n</div>\r\n<div class="ja-typo-bubble bubble-rounded bubble-2">\r\n<div class="ja-typo-bubblect">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla dapibus sapien vel mauris viverra quis euismod dui tincidunt. Phasellus laoreet mattis est, eu vulputate sapien.</div>\r\n<p class="ja-typo-bubble-meta"><span class="ja-typo-bubble-arrow"> </span> <span class="ja-typo-bubble-author">Author Name</span></p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<h2 class="ja-typo-title"><span>Rounded Blue Bubbles</span></h2>\r\n<div class="ja-typo-blockct clearfix">\r\n<div class="ja-typo-bubble bubble-rounded bubble-3">\r\n<div class="ja-typo-bubblect">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla dapibus sapien vel mauris viverra quis euismod dui tincidunt. Phasellus laoreet mattis est, eu vulputate sapien.</div>\r\n<p class="ja-typo-bubble-meta"><span class="ja-typo-bubble-arrow"> </span> <span class="ja-typo-bubble-author">Author Name</span></p>\r\n</div>\r\n<div class="ja-typo-bubble bubble-rounded bubble-4">\r\n<div class="ja-typo-bubblect">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla dapibus sapien vel mauris viverra quis euismod dui tincidunt. Phasellus laoreet mattis est, eu vulputate sapien.</div>\r\n<p class="ja-typo-bubble-meta"><span class="ja-typo-bubble-arrow"> </span> <span class="ja-typo-bubble-author">Author Name</span></p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<h2 class="ja-typo-title"><span>Rounded Black Bubbles</span></h2>\r\n<div class="ja-typo-blockct clearfix">\r\n<div class="ja-typo-bubble bubble-rounded bubble-5">\r\n<div class="ja-typo-bubblect">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla dapibus sapien vel mauris viverra quis euismod dui tincidunt. Phasellus laoreet mattis est, eu vulputate sapien.</div>\r\n<p class="ja-typo-bubble-meta"><span class="ja-typo-bubble-arrow"> </span> <span class="ja-typo-bubble-author">Author Name</span></p>\r\n</div>\r\n<div class="ja-typo-bubble bubble-rounded bubble-6">\r\n<div class="ja-typo-bubblect">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla dapibus sapien vel mauris viverra quis euismod dui tincidunt. Phasellus laoreet mattis est, eu vulputate sapien.</div>\r\n<p class="ja-typo-bubble-meta"><span class="ja-typo-bubble-arrow"> </span> <span class="ja-typo-bubble-author">Author Name</span></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class="ja-typo-blockswrap clearfix">\r\n<h1 class="ja-typo-title"><span>Message Boxes &amp; Legend Styles</span></h1>\r\n<div class="ja-typo-blockrow cols-3 clearfix">\r\n<div class="ja-typo-block">\r\n<h2 class="ja-typo-title"><span>Message Boxes with Icons</span></h2>\r\n<div class="ja-typo-blockct clearfix">\r\n<p class="ja-typo-box box-sticky"><strong>This is a sticky</strong>. Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n<p class="ja-typo-box box-download"><strong>This is a download box</strong>. Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n</div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<h2 class="ja-typo-title"><span>Message Boxes - Style 1</span></h2>\r\n<div class="ja-typo-blockct clearfix">\r\n<p class="ja-typo-box box-grey-1"><strong>This is a grey box</strong>. Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n<p class="ja-typo-box box-hilite-1"><strong>This is a hilite box</strong>. Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n</div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<h2 class="ja-typo-title"><span>Message Boxes - Style 2</span></h2>\r\n<div class="ja-typo-blockct clearfix">\r\n<p class="ja-typo-box box-grey-2"><strong>This is a grey box</strong>. Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n<p class="ja-typo-box box-hilite-2"><strong>This is a hilite box</strong>. Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class="ja-typo-blockrow cols-3 clearfix">\r\n<div class="ja-typo-block">\r\n<h2 class="ja-typo-title"><span>Rounded Message Boxes with Icons</span></h2>\r\n<div class="ja-typo-blockct clearfix">\r\n<p class="ja-typo-box box-rounded box-sticky"><strong>This is a sticky</strong>. Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n<p class="ja-typo-box box-rounded box-download"><strong>This is a download box</strong>. Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n</div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<h2 class="ja-typo-title"><span>Rounded Message Boxes - Style 1</span></h2>\r\n<div class="ja-typo-blockct clearfix">\r\n<p class="ja-typo-box box-rounded box-grey-1"><strong>This is a grey box</strong>. Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n<p class="ja-typo-box box-rounded box-hilite-1"><strong>This is a hilite box</strong>. Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n</div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<h2 class="ja-typo-title"><span>Rounded Message Boxes - Style 2</span></h2>\r\n<div class="ja-typo-blockct clearfix">\r\n<p class="ja-typo-box box-rounded box-grey-2"><strong>This is a grey box</strong>. Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n<p class="ja-typo-box box-rounded box-hilite-2"><strong>This is a hilite box</strong>. Lorem ipsum dolor sit amet consectetuer rutrum dignissim et neque id. Interdum pharetra in a metus congue In Sed Pellentesque tincidunt pharetra.</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class="ja-typo-blockrow cols-2 clearfix">\r\n<h2 class="ja-typo-title"><span>Legends</span></h2>\r\n<div class="ja-typo-block">\r\n<div class="ja-typo-blockct clearfix">\r\n<div class="ja-typo-legend legend-1">\r\n<h3 class="legend-title">Legend - Style 1</h3>\r\nLorem ipsum dolor sit amet consectetuer at elit augue In lorem. Quis Donec libero at Vivamus mi fringilla neque commodo at vitae.</div>\r\n</div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<div class="ja-typo-blockct clearfix">\r\n<div class="ja-typo-legend legend-2">\r\n<h3 class="legend-title">Legend - Style 2</h3>\r\nLorem ipsum dolor sit amet consectetuer at elit augue In lorem. Quis Donec libero at Vivamus mi fringilla neque commodo at vitae.</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class="ja-typo-blockrow cols-2 clearfix">\r\n<h2 class="ja-typo-title"><span>Rounded Legends</span></h2>\r\n<div class="ja-typo-block">\r\n<div class="ja-typo-blockct clearfix">\r\n<div class="ja-typo-legend legend-rounded legend-1">\r\n<h3 class="legend-title">Rounded Legend - Style 1</h3>\r\nLorem ipsum dolor sit amet consectetuer at elit augue In lorem. Quis Donec libero at Vivamus mi fringilla neque commodo at vitae.</div>\r\n</div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<div class="ja-typo-blockct clearfix">\r\n<div class="ja-typo-legend legend-rounded legend-2">\r\n<h3 class="legend-title">Rounded Legend - Style 2</h3>\r\nLorem ipsum dolor sit amet consectetuer at elit augue In lorem. Quis Donec libero at Vivamus mi fringilla neque commodo at vitae.</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class="ja-typo-blockswrap clearfix">\r\n<h1 class="ja-typo-title"><span>Buttons &amp; Tags</span></h1>\r\n<div class="ja-typo-blockrow cols-1 clearfix">\r\n<div class="ja-typo-block">\r\n<h2 class="ja-typo-title"><span>Big Buttons</span></h2>\r\n<div class="ja-typo-blockct clearfix"><a class="ja-typo-btn btn-blue ja-typo-btn-big btn-big-blue" href="#"><span>Button Text</span></a> <a class="ja-typo-btn btn-green ja-typo-btn-big btn-big-green" href="#"><span>Button Text</span></a> <a class="ja-typo-btn btn-red ja-typo-btn-big btn-big-red" href="#"><span>Button Text</span></a> <a class="ja-typo-btn btn-orange ja-typo-btn-big btn-big-orange" href="#"><span>Button Text</span></a> <a class="ja-typo-btn btn-black ja-typo-btn-big btn-big-black" href="#"><span>Button Text</span></a> <a class="ja-typo-btn btn-grey ja-typo-btn-big btn-big-grey" href="#"><span>Button Text</span></a></div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<h2 class="ja-typo-title"><span>Icon Buttons</span></h2>\r\n<div class="ja-typo-blockct clearfix"><a class="ja-typo-btn ja-typo-btn-icn btn-icn-save" href="#"><span><span>Button Text</span></span></a> <a class="ja-typo-btn ja-typo-btn-icn btn-icn-tip" href="#"><span><span>Button Text</span></span></a> <a class="ja-typo-btn ja-typo-btn-icn btn-icn-warning" href="#"><span><span>Button Text</span></span></a> <a class="ja-typo-btn ja-typo-btn-icn btn-icn-info" href="#"><span><span>Button Text</span></span></a> <a class="ja-typo-btn ja-typo-btn-icn btn-icn-ok" href="#"><span><span>Button Text</span></span></a></div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<h2 class="ja-typo-title"><span>Small Buttons</span></h2>\r\n<div class="ja-typo-blockct clearfix"><a class="ja-typo-btn btn-blue ja-typo-btn-sm btn-sm-blue" href="#"><span>Button Text</span></a> <a class="ja-typo-btn btn-green ja-typo-btn-sm btn-sm-green" href="#"><span>Button Text</span></a> <a class="ja-typo-btn btn-red ja-typo-btn-sm btn-sm-red" href="#"><span>Button Text</span></a> <a class="ja-typo-btn btn-orange ja-typo-btn-sm btn-sm-orange" href="#"><span>Button Text</span></a> <a class="ja-typo-btn btn-black ja-typo-btn-sm btn-sm-black" href="#"><span>Button Text</span></a> <a class="ja-typo-btn btn-grey ja-typo-btn-sm btn-sm-grey" href="#"><span>Button Text</span></a></div>\r\n</div>\r\n</div>\r\n<div class="ja-typo-blockrow cols-1 clearfix">\r\n<div class="ja-typo-block">\r\n<h2 class="ja-typo-title"><span>Rounded Big Buttons</span></h2>\r\n<div class="ja-typo-blockct clearfix"><a class="ja-typo-btn btn-rounded-big btn-blue ja-typo-btn-big btn-big-blue" href="#"><span>Button Text</span></a> <a class="ja-typo-btn btn-rounded-big btn-green ja-typo-btn-big btn-big-green" href="#"><span>Button Text</span></a> <a class="ja-typo-btn btn-rounded-big btn-red ja-typo-btn-big btn-big-red" href="#"><span>Button Text</span></a> <a class="ja-typo-btn btn-rounded-big btn-orange ja-typo-btn-big btn-big-orange" href="#"><span>Button Text</span></a> <a class="ja-typo-btn btn-rounded-big btn-black ja-typo-btn-big btn-big-black" href="#"><span>Button Text</span></a> <a class="ja-typo-btn btn-rounded-big btn-grey ja-typo-btn-big btn-big-grey" href="#"><span>Button Text</span></a></div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<h2 class="ja-typo-title"><span>Rounded Icon Buttons</span></h2>\r\n<div class="ja-typo-blockct clearfix"><a class="ja-typo-btn btn-rounded-icn ja-typo-btn-icn btn-icn-save" href="#"><span><span>Button Text</span></span></a> <a class="ja-typo-btn btn-rounded-icn ja-typo-btn-icn btn-icn-tip" href="#"><span><span>Button Text</span></span></a> <a class="ja-typo-btn btn-rounded-icn ja-typo-btn-icn btn-icn-warning" href="#"><span><span>Button Text</span></span></a> <a class="ja-typo-btn btn-rounded-icn ja-typo-btn-icn btn-icn-info" href="#"><span><span>Button Text</span></span></a> <a class="ja-typo-btn btn-rounded-icn ja-typo-btn-icn btn-icn-ok" href="#"><span><span>Button Text</span></span></a></div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<h2 class="ja-typo-title"><span>Rounded Small Buttons</span></h2>\r\n<div class="ja-typo-blockct clearfix"><a class="ja-typo-btn btn-rounded-sm btn-blue ja-typo-btn-sm btn-sm-blue" href="#"><span>Button Text</span></a> <a class="ja-typo-btn btn-rounded-sm btn-green ja-typo-btn-sm btn-sm-green" href="#"><span>Button Text</span></a> <a class="ja-typo-btn btn-rounded-sm btn-red ja-typo-btn-sm btn-sm-red" href="#"><span>Button Text</span></a> <a class="ja-typo-btn btn-rounded-sm btn-orange ja-typo-btn-sm btn-sm-orange" href="#"><span>Button Text</span></a> <a class="ja-typo-btn btn-rounded-sm btn-black ja-typo-btn-sm btn-sm-black" href="#"><span>Button Text</span></a> <a class="ja-typo-btn btn-rounded-sm btn-grey ja-typo-btn-sm btn-sm-grey" href="#"><span>Button Text</span></a></div>\r\n</div>\r\n</div>\r\n<div class="ja-typo-blockrow cols-2 clearfix">\r\n<div class="ja-typo-block">\r\n<h2 class="ja-typo-title"><span>Squared Tags</span></h2>\r\n<div class="ja-typo-blockct clearfix">\r\n<p>This is a sample <span class="ja-typo-tag tag-grey">Inline Tag</span>. Use this to provide useful information.</p>\r\n<p>This is a sample <span class="ja-typo-tag tag-blue">Inline Tag</span>. Use this to provide useful information.</p>\r\n<p>This is a sample <span class="ja-typo-tag tag-green">Inline Tag</span>. Use this to provide useful information.</p>\r\n<p>This is a sample <span class="ja-typo-tag tag-red">Inline Tag</span>. Use this to provide useful information.</p>\r\n<p>This is a sample <span class="ja-typo-tag tag-orange">Inline Tag</span>. Use this to provide useful information.</p>\r\n<p>This is a sample <span class="ja-typo-tag tag-black">Inline Tag</span>. Use this to provide useful information.</p>\r\n</div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<h2 class="ja-typo-title"><span>Rounded Tags</span></h2>\r\n<div class="ja-typo-blockct clearfix">\r\n<p>This is a sample <span class="ja-typo-tag tag-rounded tag-grey">Inline Tag</span>. Use this to provide useful information.</p>\r\n<p>This is a sample <span class="ja-typo-tag tag-rounded tag-blue">Inline Tag</span>. Use this to provide useful information.</p>\r\n<p>This is a sample <span class="ja-typo-tag tag-rounded tag-green">Inline Tag</span>. Use this to provide useful information.</p>\r\n<p>This is a sample <span class="ja-typo-tag tag-rounded tag-red">Inline Tag</span>. Use this to provide useful information.</p>\r\n<p>This is a sample <span class="ja-typo-tag tag-rounded tag-orange">Inline Tag</span>. Use this to provide useful information.</p>\r\n<p>This is a sample <span class="ja-typo-tag tag-rounded tag-black">Inline Tag</span>. Use this to provide useful information.</p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class="ja-typo-blockswrap clearfix">\r\n<h1 class="ja-typo-title"><span>Special Module Style</span></h1>\r\n<div class="ja-typo-blockrow cols-4 clearfix">\r\n<div class="ja-typo-block">\r\n<div class="ja-typo-blockct clearfix">\r\n<div class="moduletable moduletable_badge badge-top"><span class="badge"> </span>\r\n<div class="ja-box-ct">Use module suffix: <strong>_badge badge-top</strong> to put this badge on any module you like!</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<div class="ja-typo-blockct clearfix">\r\n<div class="moduletable moduletable_badge badge-new"><span class="badge"> </span>\r\n<div class="ja-box-ct">Use module suffix: <strong>_badge badge-new</strong> to put this badge on any module you like!</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<div class="ja-typo-blockct clearfix">\r\n<div class="moduletable moduletable_badge badge-pick"><span class="badge"> </span>\r\n<div class="ja-box-ct">Use module suffix: <strong>_badge badge-pick</strong> to put this badge on any module you like!</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<div class="ja-typo-blockct clearfix">\r\n<div class="moduletable moduletable_badge badge-hot" style="margin-right: 0;"><span class="badge"> </span>\r\n<div class="ja-box-ct">Use module suffix: <strong>_badge badge-hot</strong> to put this badge on any module you like!</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class="ja-typo-blockswrap clearfix">\r\n<h1 class="ja-typo-title"><span>Forms</span></h1>\r\n<div class="ja-typo-blockrow cols-3 clearfix">\r\n<h2 class="ja-typo-title"><span>Form Fieldset</span></h2>\r\n<div class="ja-typo-block">\r\n<div class="ja-typo-blockct clearfix"><fieldset> <legend>Templates Fieldset</legend> Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla dapibus sapien vel mauris viverra quis euismod dui tincidunt. Phasellus laoreet mattis est, eu vulputate sapien suscipit ac. </fieldset></div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<div class="ja-typo-blockct clearfix"><fieldset class="ja-typo-fieldset fieldset-1"> <legend>Special Fieldset - Style 1</legend> Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla dapibus sapien vel mauris viverra quis euismod dui tincidunt. Phasellus laoreet mattis est. </fieldset></div>\r\n</div>\r\n<div class="ja-typo-block">\r\n<div class="ja-typo-blockct clearfix"><fieldset class="ja-typo-fieldset fieldset-2"> <legend>Special Fieldset - Style 2</legend> Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla dapibus sapien vel mauris viverra quis euismod dui tincidunt. Phasellus laoreet mattis est. </fieldset></div>\r\n</div>\r\n</div>\r\n<div class="ja-typo-blockrow cols-1 clearfix">\r\n<h2 class="ja-typo-title"><span>Form Elements</span></h2>\r\n<div class="ja-typo-block">\r\n<div class="ja-typo-blockct clearfix"><form>\r\n<p><label for="input">Sample Input 1</label> <br /> <input class="inputbox" name="input" type="input" /></p>\r\n<p><label for="input">Sample Input 2</label> <br /> <input class="inputbox" name="input" type="input" /></p>\r\n<p><input type="radio" /><label for="radio">Sample Radio Input</label> <input type="checkbox" /><label for="checkbox">Sample CheckBox Input</label></p>\r\n<p><label for="select">Sample Select Field:</label><br /> <select id="select"><option>Option One</option><option>Option Two</option></select></p>\r\n<p><label for="textarea">Sample Textarea Field:</label><br /> <textarea class="inputbox" cols="80" rows="5">Textarea text</textarea></p>\r\n<p><button>Submit Button</button> <button>Reset Button</button></p>\r\n</form></div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>', '', -2, 9, '2020-02-06 08:15:05', 42, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":""}', 1, 1, '', '', 1, 271, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(75, 178, 'What\'s New in 3.x?', 'what-s-new-in-3-x', '<p>The Joomla Project is pleased to announce the availability<a href="http://joomlacode.org/gf/download/frsrelease/16287/70842/Joomla_2.5.0_Beta1-Full_Package.zip"> </a>for download. This is the second release made within the new six-month release cycle that started with the delivery of Joomla 1.6 in January 2011.</p>\r\n<h1>What is this release for?</h1>\r\n<p>There are several goals for this release:</p>\r\n<ol>\r\n<li>To allow advance testing of sites and custom extensions so that site administrators and developers can report any problems before the final release.</li>\r\n<li>To raise awareness that the end of the current development cycle is fast approaching.</li>\r\n<li>To allow testing of the upgrade from version 1.7 to 2.5.0.</li>\r\n</ol>', '', 1, 9, '2020-02-06 08:15:05', 42, '', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 5, 0, 'Joomla 3.x templates design, 3.x Joomla design template, Joomla 3.x mobile design', '3.x Joomla responsive design features on handheld devices.', 1, 7, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(76, 179, 'Menu support', 'menu-support', '<p>Lorem ipsum dolor sit amet consectetuer Vivamus Donec vitae parturient et. Platea nunc amet suscipit In libero Aliquam pede arcu Suspendisse nulla. Aenean elit in quis Nunc ac urna Duis urna diam accumsan. Et diam nibh ut Suspendisse ut Sed enim orci eu cursus. Semper adipiscing mus Duis odio convallis quis dui nunc tincidunt ac. Facilisi Vivamus tincidunt fringilla purus a tincidunt arcu est vel turpis. Vel enim.</p>\r\n\r\n<p>Curabitur felis Donec Proin mauris Curabitur a augue risus morbi amet. Ipsum enim pellentesque nascetur montes Curabitur Curabitur scelerisque magnis Curabitur ligula. Condimentum vitae interdum Vestibulum Donec malesuada interdum congue pretium Ut Curabitur. Id Ut nunc tellus condimentum quis morbi Aenean Donec Integer tincidunt. Augue odio suscipit ante venenatis nibh nascetur tincidunt condimentum adipiscing risus. Auctor nibh interdum feugiat faucibus libero dictumst condimentum congue Quisque gravida. Sollicitudin et.</p>\r\n\r\n<p>Nunc id tortor elit In vel Pellentesque et aliquet faucibus lacinia. Tristique In vitae Ut tristique turpis sed libero Curabitur Nullam at. Neque Curabitur Donec Nam Pellentesque tellus libero a accumsan Phasellus eu. Lorem Curabitur In tempor In wisi est nec et Nunc tellus. Metus porta pretium Donec augue id Maecenas ante Curabitur nibh.</p>\r\n\r\n<p>Lobortis Nulla Nunc eros semper nisl facilisi nibh non a augue. In Ut vitae pede et vel malesuada a malesuada mauris Morbi. Pede Curabitur felis pulvinar et risus iaculis Curabitur lobortis condimentum et. Condimentum platea nunc velit augue semper sem pede metus enim id. Laoreet natoque massa elit netus In justo neque tincidunt Nam dolor. Justo tellus habitant.</p>\r\n', '', 1, 78, '2020-02-06 08:15:05', 42, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":"","article_layout":""}', 1, 11, '', '', 1, 3, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(77, 181, '1 Column', '1-column-grid', '<p>Lacus laoreet sit at adipiscing orci wisi Morbi elit accumsan dolor. Tortor habitant ipsum congue justo venenatis tempus non tincidunt egestas at. Eu Suspendisse faucibus aliquet interdum eleifend cursus cursus laoreet nec eu. Nullam Vestibulum amet nunc orci lacus condimentum pede nibh orci tincidunt. Auctor lacus adipiscing Nunc nibh cursus sed mus leo Phasellus risus. Dolor Nulla consectetuer gravida elit facilisis Vestibulum eu.</p>\r\n<p>Consectetuer dis scelerisque sapien quis tincidunt elit sit nec congue nunc. Nunc lacinia Phasellus massa vitae mauris feugiat Quisque nascetur urna egestas. Tincidunt lacinia a Nulla neque interdum accumsan Sed augue lorem Vestibulum. Quis platea Vestibulum orci lacus Vestibulum Vivamus sagittis nisl pellentesque convallis. Ligula elit eget condimentum condimentum vitae montes at adipiscing odio hendrerit. Pulvinar sollicitudin cursus nec et.</p>\r\n<p>Congue consectetuer Phasellus odio non Nulla commodo amet feugiat ligula pede. Convallis felis et sit nec nunc lacus tellus lobortis quam Quisque.</p>', '', 1, 78, '2020-02-06 08:15:05', 42, '', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 8, 10, '', '', 1, 22, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(78, 182, '2 Columns', '2-columns-grid', '<p>Lorem ipsum dolor sit amet consectetuer pulvinar eleifend tellus sapien sit. Id consequat ut et pretium quis pede laoreet libero urna laoreet. Mauris in orci urna Vestibulum Maecenas egestas suscipit Nullam vel odio. Sagittis non porttitor tempus leo eget elit consectetuer Aliquam ligula Nullam. Mauris lacus venenatis in Vivamus Aenean Aliquam felis turpis leo mattis. Leo sed pretium.</p>\r\n<p>Lacus laoreet sit at adipiscing orci wisi Morbi elit accumsan dolor. Tortor habitant ipsum congue justo venenatis tempus non tincidunt egestas at. Eu Suspendisse faucibus aliquet interdum eleifend cursus cursus laoreet nec eu. Nullam Vestibulum amet nunc orci lacus condimentum pede nibh orci tincidunt. Auctor lacus adipiscing Nunc nibh cursus sed mus leo Phasellus risus. Dolor Nulla consectetuer gravida elit facilisis Vestibulum eu.</p>\r\n<p>Consectetuer dis scelerisque sapien quis tincidunt elit sit nec congue nunc. Nunc lacinia Phasellus massa vitae mauris feugiat Quisque nascetur urna egestas. Tincidunt lacinia a Nulla neque interdum accumsan Sed augue lorem Vestibulum. Quis platea Vestibulum orci lacus Vestibulum Vivamus sagittis nisl pellentesque convallis. Ligula elit eget condimentum condimentum vitae montes at adipiscing odio hendrerit. Pulvinar sollicitudin cursus nec et.</p>\r\n<p>Congue consectetuer Phasellus odio non Nulla commodo amet feugiat ligula pede. Convallis felis et sit nec nunc lacus tellus lobortis quam Quisque. Urna mauris magnis venenatis morbi id ullamcorper orci et condimentum adipiscing. Donec sed eu cursus Nullam et facilisis amet justo et ut. Aliquet convallis sed Aliquam Mauris Nam at.</p>\r\n<p>Consequat wisi aliquet Vivamus laoreet Proin mollis malesuada Nam sagittis sodales. Feugiat nulla Aenean lacinia tincidunt lacus Phasellus nec pede et justo. Vel libero Lorem Vestibulum fringilla eu a risus cursus id quis. Dui in pellentesque tempor vel laoreet non Vestibulum nec turpis pede. Adipiscing justo consequat et adipiscing mauris malesuada euismod nibh leo urna. Ut at.</p>\r\n<p>Mus Sed pellentesque risus volutpat consequat montes nibh semper Aenean pellentesque. Pellentesque velit auctor adipiscing orci elit at leo semper mauris tristique. Convallis sit nibh ut ac pellentesque nibh dictumst mauris volutpat pulvinar. Eu nunc Nulla Aliquam elit sit tempus malesuada Nam pretium sapien. Aliquam Vestibulum magna venenatis Aenean odio at penatibus Sed enim vitae. Amet semper nibh dictumst sit tincidunt Mauris Pellentesque eros nibh at. Sem Proin.</p>\r\n<p>Arcu Curabitur mauris felis elit id sed a tellus at nunc. Sapien condimentum eros natoque montes senectus id sit at adipiscing semper. In molestie elit Curabitur tincidunt In nibh quis et mauris metus. Neque Curabitur est Vestibulum consectetuer amet orci lorem ut Nam cursus. Fringilla pede urna tincidunt sem egestas turpis justo adipiscing purus Quisque. Elit.</p>', '', 1, 78, '2020-02-06 08:15:05', 42, '', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 9, '', '', 1, 20, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(79, 183, '3 Columns', '3-columns', '<p>Congue consectetuer Phasellus odio non Nulla commodo amet feugiat ligula pede. Convallis felis et sit nec nunc lacus tellus lobortis quam Quisque. Urna mauris magnis venenatis morbi id ullamcorper orci et condimentum adipiscing. Donec sed eu cursus Nullam et facilisis amet justo et ut. Aliquet convallis sed Aliquam Mauris Nam at.</p>\r\n<p>Consequat wisi aliquet Vivamus laoreet Proin mollis malesuada Nam sagittis sodales. Feugiat nulla Aenean lacinia tincidunt lacus Phasellus nec pede et justo. Vel libero Lorem Vestibulum fringilla eu a risus cursus id quis. Dui in pellentesque tempor vel laoreet non Vestibulum nec turpis pede. Adipiscing justo consequat et adipiscing mauris malesuada euismod nibh leo urna. Ut at.</p>\r\n<p>Mus Sed pellentesque risus volutpat consequat montes nibh semper Aenean pellentesque. Pellentesque velit auctor adipiscing orci elit at leo semper mauris tristique. Convallis sit nibh ut ac pellentesque nibh dictumst mauris volutpat pulvinar. Eu nunc Nulla Aliquam elit sit tempus malesuada Nam pretium sapien. Aliquam Vestibulum magna venenatis Aenean odio at penatibus Sed enim vitae. Amet semper nibh dictumst sit tincidunt Mauris Pellentesque eros nibh at. Sem Proin.</p>\r\n<p>Arcu Curabitur mauris felis elit id sed a tellus at nunc. Sapien condimentum eros natoque montes senectus id sit at adipiscing semper. In molestie elit Curabitur tincidunt In nibh quis et mauris metus. Neque Curabitur est Vestibulum consectetuer amet orci lorem ut Nam cursus. Fringilla pede urna tincidunt sem egestas turpis justo adipiscing purus Quisque. Elit.</p>\r\n<p>Non Aenean commodo iaculis ornare sed eget Nulla urna enim elit. At ut Mauris elit quis id a dignissim dignissim urna vel. Ac ipsum consequat orci est magna ornare metus lacus mollis elit. Cursus nulla Fusce cursus facilisi Pellentesque nunc tincidunt lacus ipsum sociis. Pretium consectetuer ut mus est ac id lacus.</p>\r\n<p>Eget Quisque augue justo congue venenatis Curabitur enim Morbi pellentesque ut. Ut felis tincidunt vel lacus in ligula ipsum scelerisque mauris euismod. Vestibulum at id Morbi fames tellus nunc vestibulum Suspendisse lorem est. Turpis tincidunt fringilla purus Vivamus pulvinar quis nibh ridiculus velit at. Wisi egestas lobortis odio pretium ut Vivamus pulvinar hendrerit dis Pellentesque. In sagittis dui elit lacinia pretium Vivamus urna adipiscing hendrerit.</p>\r\n<p>Nam pellentesque ac pulvinar platea eros Pellentesque ac ligula dapibus sociis. Libero Nulla adipiscing magna ante morbi ridiculus at vestibulum accumsan convallis. Et et condimentum velit lorem Cras ac tortor elit pretium ante. Enim porta condimentum Donec congue Sed sed nisl Donec id tincidunt. Nam mollis feugiat magnis convallis fermentum platea magna id ullamcorper nunc. Augue tempus dolor sed commodo nisl pretium.</p>', '', 1, 78, '2020-02-06 08:15:05', 42, '', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 8, '', '', 1, 12, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`, `note`) VALUES
(80, 184, '4 Columns', '4-columns', '<p>Congue consectetuer Phasellus odio non Nulla commodo amet feugiat ligula pede. Convallis felis et sit nec nunc lacus tellus lobortis quam Quisque. Urna mauris magnis venenatis morbi id ullamcorper orci et condimentum adipiscing. Donec sed eu cursus Nullam et facilisis amet justo et ut. Aliquet convallis sed Aliquam Mauris Nam at.</p>\r\n<p>Consequat wisi aliquet Vivamus laoreet Proin mollis malesuada Nam sagittis sodales. Feugiat nulla Aenean lacinia tincidunt lacus Phasellus nec pede et justo. Vel libero Lorem Vestibulum fringilla eu a risus cursus id quis. Dui in pellentesque tempor vel laoreet non Vestibulum nec turpis pede. Adipiscing justo consequat et adipiscing mauris malesuada euismod nibh leo urna. Ut at.</p>\r\n<p>Mus Sed pellentesque risus volutpat consequat montes nibh semper Aenean pellentesque. Pellentesque velit auctor adipiscing orci elit at leo semper mauris tristique. Convallis sit nibh ut ac pellentesque nibh dictumst mauris volutpat pulvinar. Eu nunc Nulla Aliquam elit sit tempus malesuada Nam pretium sapien. Aliquam Vestibulum magna venenatis Aenean odio at penatibus Sed enim vitae. Amet semper nibh dictumst sit tincidunt Mauris Pellentesque eros nibh at. Sem Proin.</p>\r\n<p>Arcu Curabitur mauris felis elit id sed a tellus at nunc. Sapien condimentum eros natoque montes senectus id sit at adipiscing semper. In molestie elit Curabitur tincidunt In nibh quis et mauris metus. Neque Curabitur est Vestibulum consectetuer amet orci lorem ut Nam cursus. Fringilla pede urna tincidunt sem egestas turpis justo adipiscing purus Quisque. Elit.</p>\r\n<p>Non Aenean commodo iaculis ornare sed eget Nulla urna enim elit. At ut Mauris elit quis id a dignissim dignissim urna vel. Ac ipsum consequat orci est magna ornare metus lacus mollis elit. Cursus nulla Fusce cursus facilisi Pellentesque nunc tincidunt lacus ipsum sociis. Pretium consectetuer ut mus est ac id lacus.</p>\r\n<p>Eget Quisque augue justo congue venenatis Curabitur enim Morbi pellentesque ut. Ut felis tincidunt vel lacus in ligula ipsum scelerisque mauris euismod. Vestibulum at id Morbi fames tellus nunc vestibulum Suspendisse lorem est. Turpis tincidunt fringilla purus Vivamus pulvinar quis nibh ridiculus velit at. Wisi egestas lobortis odio pretium ut Vivamus pulvinar hendrerit dis Pellentesque. In sagittis dui elit lacinia pretium Vivamus urna adipiscing hendrerit.</p>\r\n<p>Nam pellentesque ac pulvinar platea eros Pellentesque ac ligula dapibus sociis. Libero Nulla adipiscing magna ante morbi ridiculus at vestibulum accumsan convallis. Et et condimentum velit lorem Cras ac tortor elit pretium ante. Enim porta condimentum Donec congue Sed sed nisl Donec id tincidunt. Nam mollis feugiat magnis convallis fermentum platea magna id ullamcorper nunc. Augue tempus dolor sed commodo nisl pretium.</p>', '', 1, 78, '2020-02-06 08:15:05', 42, '', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 7, '', '', 1, 15, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(81, 185, '5 Columns - Full width', '5-columns', '<p>Congue consectetuer Phasellus odio non Nulla commodo amet feugiat ligula pede. Convallis felis et sit nec nunc lacus tellus lobortis quam Quisque. Urna mauris magnis venenatis morbi id ullamcorper orci et condimentum adipiscing. Donec sed eu cursus Nullam et facilisis amet justo et ut. Aliquet convallis sed Aliquam Mauris Nam at.</p>\r\n<p>Consequat wisi aliquet Vivamus laoreet Proin mollis malesuada Nam sagittis sodales. Feugiat nulla Aenean lacinia tincidunt lacus Phasellus nec pede et justo. Vel libero Lorem Vestibulum fringilla eu a risus cursus id quis. Dui in pellentesque tempor vel laoreet non Vestibulum nec turpis pede. Adipiscing justo consequat et adipiscing mauris malesuada euismod nibh leo urna. Ut at.</p>\r\n<p>Mus Sed pellentesque risus volutpat consequat montes nibh semper Aenean pellentesque. Pellentesque velit auctor adipiscing orci elit at leo semper mauris tristique. Convallis sit nibh ut ac pellentesque nibh dictumst mauris volutpat pulvinar. Eu nunc Nulla Aliquam elit sit tempus malesuada Nam pretium sapien. Aliquam Vestibulum magna venenatis Aenean odio at penatibus Sed enim vitae. Amet semper nibh dictumst sit tincidunt Mauris Pellentesque eros nibh at. Sem Proin.</p>\r\n<p>Arcu Curabitur mauris felis elit id sed a tellus at nunc. Sapien condimentum eros natoque montes senectus id sit at adipiscing semper. In molestie elit Curabitur tincidunt In nibh quis et mauris metus. Neque Curabitur est Vestibulum consectetuer amet orci lorem ut Nam cursus. Fringilla pede urna tincidunt sem egestas turpis justo adipiscing purus Quisque. Elit.</p>\r\n<p>Non Aenean commodo iaculis ornare sed eget Nulla urna enim elit. At ut Mauris elit quis id a dignissim dignissim urna vel. Ac ipsum consequat orci est magna ornare metus lacus mollis elit. Cursus nulla Fusce cursus facilisi Pellentesque nunc tincidunt lacus ipsum sociis. Pretium consectetuer ut mus est ac id lacus.</p>\r\n<p>Eget Quisque augue justo congue venenatis Curabitur enim Morbi pellentesque ut. Ut felis tincidunt vel lacus in ligula ipsum scelerisque mauris euismod. Vestibulum at id Morbi fames tellus nunc vestibulum Suspendisse lorem est. Turpis tincidunt fringilla purus Vivamus pulvinar quis nibh ridiculus velit at. Wisi egestas lobortis odio pretium ut Vivamus pulvinar hendrerit dis Pellentesque. In sagittis dui elit lacinia pretium Vivamus urna adipiscing hendrerit.</p>\r\n<p>Nam pellentesque ac pulvinar platea eros Pellentesque ac ligula dapibus sociis. Libero Nulla adipiscing magna ante morbi ridiculus at vestibulum accumsan convallis. Et et condimentum velit lorem Cras ac tortor elit pretium ante. Enim porta condimentum Donec congue Sed sed nisl Donec id tincidunt. Nam mollis feugiat magnis convallis fermentum platea magna id ullamcorper nunc. Augue tempus dolor sed commodo nisl pretium.</p>', '', 1, 78, '2020-02-06 08:15:05', 42, '', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 6, 6, '', '', 1, 21, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(82, 186, '6 Responsive layouts', '6-responsive-layouts', '<h2>1. Extra layout</h2>\r\n\r\n<img src="images/stories/demo/sam-5.jpg" alt="Extra layout" title="Extra layout - 6 Columns" class="caption" />\r\n\r\n<p>Senectus vitae dignissim elit Pellentesque natoque laoreet Nullam velit ac lobortis. Non vel nibh tellus tristique In est neque volutpat ut sem. Convallis convallis justo wisi sed id orci feugiat faucibus nunc risus. Risus pede ante Mauris ullamcorper eu tellus consectetuer velit libero vel. Nisl dolor libero feugiat velit turpis Vestibulum urna senectus odio consectetuer. Congue Aliquam mauris sed tellus penatibus non accumsan mauris Duis wisi. Pellentesque.</p>\r\n\r\n<h2>2. Wide layout</h2>\r\n\r\n<img src="images/stories/demo/sam-6.jpg" alt="Wide layout" title="Wide layout - 5 Columns" class="caption" />\r\n\r\n<p>Ipsum turpis accumsan cursus elit augue Morbi nibh Nullam amet purus. Cursus urna nunc Curabitur leo feugiat sagittis quis velit sit at. Tellus orci dolor dignissim Vivamus congue condimentum gravida Quisque tristique ut. At In eros adipiscing amet Phasellus cursus sed metus Aenean Curabitur. Eget Cum interdum odio justo malesuada Lorem quam pretium sem egestas. Curabitur et convallis et orci quam.</p>\r\n\r\n<h2>3. Normal layout</h2>\r\n\r\n<img src="images/stories/demo/sam-7.jpg" alt="Normal layout" title="Normal layout - 4 Columns" class="caption" />\r\n\r\n<p>Et tempus ante a congue adipiscing Nam et a justo malesuada. Nonummy velit enim ac ut pede libero wisi tempor adipiscing at. Scelerisque egestas volutpat a faucibus montes nunc urna enim Vestibulum wisi. Lacus tempus pede accumsan egestas volutpat orci tempor ut vel sagittis. Lorem Morbi leo tellus quis justo sem adipiscing convallis Vestibulum.</p>\r\n\r\n<h2>4. Tablet layout</h2>\r\n\r\n<img src="images/stories/demo/sam-8.jpg" alt="Tablet layout" align="left" title="Tablet layout" />\r\n<p>Non netus interdum pretium augue Proin wisi sapien mi turpis Phasellus. Felis felis Nullam orci tortor egestas lacinia neque a id neque. Diam ornare urna Phasellus orci Mauris commodo Quisque Curabitur Nullam faucibus. Sed id eget Suspendisse consequat semper porta platea elit at Sed. Elit neque wisi ipsum ante In at vitae volutpat felis et. Amet tincidunt.</p>\r\n\r\n<p>Non netus interdum pretium augue Proin wisi sapien mi turpis Phasellus. Felis felis Nullam orci tortor egestas lacinia neque a id neque. Diam ornare urna Phasellus orci Mauris commodo Quisque Curabitur Nullam faucibus. Sed id eget Suspendisse consequat semper porta platea elit at Sed. Elit neque wisi ipsum ante In at vitae volutpat felis et. Amet tincidunt.</p>\r\n\r\n<h2 style="clear: both; overflow: hidden;">5. Mobile layout</h2>\r\n\r\n<img src="images/stories/demo/sam-10.jpg" alt="Mobile layout" align="left" title="Mobile layout" />\r\n<p>Justo Vestibulum velit pede Vestibulum a Mauris purus risus vel vel. Tincidunt Curabitur magna Fusce tellus et sit dictum sollicitudin pretium libero. Mollis Morbi Maecenas consectetuer Vivamus sed eu eu nunc lobortis vel. Vel amet orci mauris mauris vitae dis eros pede consectetuer tempor. Ridiculus dolor Curabitur mi semper In laoreet aliquam habitasse id convallis. Nonummy.</p>\r\n\r\n<h2 style="clear: both;">6. Mobile port layout</h2>\r\n\r\n<img src="images/stories/demo/sam-9.jpg" alt="Mobile layout" align="left" title="Mobile layout" />\r\n<p>Quis volutpat nibh quam Vestibulum ante congue rhoncus congue nibh augue. Enim Vestibulum quis sem facilisi a id nibh tincidunt wisi enim. Laoreet sit semper ac Vestibulum vel pretium Curabitur ipsum adipiscing nibh. Leo Sed Nam quis eget egestas nunc enim volutpat nonummy Cum. Mattis metus ridiculus semper ante ipsum lobortis pulvinar Quisque ut tellus. Lobortis aliquet nunc ac.</p>', '', 1, 78, '2020-02-06 08:15:05', 42, '', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":"","article_layout":""}', 14, 5, '', '', 1, 18, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(83, 187, 'Extra-wide layout', 'extra-wide-layout', '<p><img src="images/stories/guide/layouts.png" alt="All layout" /></p>\r\n<p>There are 2 width size modes of the content block: in Homepage (considered as list page mode) and in detail page mode. In the Homepage, the width of the content block = 2 grids while in the detail page mode, the width of content block is 3 grids. The above image shows you the layout of homepage of our <span class="highlight">template --&gt; content block = 2 grid.</span></p>\r\n', '\r\n<p>To configure for the width of content in homepage and content page (detail page mode), navigate to: <span class="highlight">[your_site] / templates / ja_elastica / css / layout.css</span> The code for this configuration is located in the line from 86-&gt;93, you can change the width here.</p>\r\n<p><strong>Note:</strong></p>\r\n<ul>\r\n<li>If there are too many modules, some modules will be auto moved to display under the content block so that your layout will always be nice.</li>\r\n<li>The settings is the same is for 3 layout types (extra-wide, wide and normal)</li>\r\n</ul>\r\n{codecitation} /* Main Content */ #ja-content { width: 720px; /* 3 grids */ } .ja-frontpage #ja-content { width: 480px; /* Frontpage Content 2 grids */ } {/codecitation}\r\n<p>The width of the layout is not defined as the way shown in the section above. The width of the layout = 5 grids + extra-column, so we need to know where the extra-column is defined and how it works.</p>\r\n<p><strong class="guide-step">Step 1: </strong>you need to note some important information in the file: [your_site] / templates / ja_elastica / blocks / extra-col.php. This file is to define width of the extra column, select css file to display when satisfying defined condition.</p>\r\n{codecitation} &lt;?php // Add css for this extra-wide layout $this-&gt;addCSS (\'css/layout-extra-wide.css\', \'only screen and (min-width:1440px)\'); {/codecitation}\r\n<p class="code-block-caption">This code is to add css file (css/layout-extra-wide.css) for the extra-wide layout.</p>\r\n{codecitation}{/codecitation}\r\n<p class="code-block-caption">This code is to define width and style of the extra-column.</p>\r\n<p><strong class="guide-step">Step 2: </strong> define the width of the extra-wide layout. Navigate to: <strong>[your_site] / templates / ja_elastica / core / etc / layout-extra-wide.css</strong></p>\r\n{codecitation} .main { max-width: 1440px !important; width: 1440px !important; } #ja-main { width: 1200px ; float: left; } {/codecitation}\r\n<p><strong class="guide-step">Step 3: </strong> you need to define the extra-col block it in the: [your_site] / templates / ja_elastica / core / etc / layouts / default.xml file ( the line 26 as default).</p>\r\n{codecitation} position-7, position-5 extra-col {/codecitation}', 1, 78, '2020-02-06 08:15:05', 42, '', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 26, 4, '', '', 1, 111, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(84, 188, 'Wide layout', 'wide-layout', '<p><img src="images/stories/guide/layouts.png" alt="All layout" /></p>\r\n<p>This layout is quite similar to the extra-wide layout, except the extra-column is removed.</p>\r\n<p>To define width of the layout, please navigate to: <span class="highlight">[your_site] / templates / ja_elastica / core / etc / layouts / default.xml</span>. The file <strong>default.xml</strong> is to define width range of each layout.</p>\r\n', '\r\n<div class="img-caption"><img src="images/stories/guide/define-layout-wide.png" alt="Define layout" />\r\n<p>This file is to define layout with size</p>\r\n</div>\r\n<p>{codecitation}css/layout-wide.css{/codecitation}</p>\r\n<p>As defined here, the layout has <span class="highlight">minimum width = 1236 px</span> and <span class="highlight">maximum « 1440 px</span>. And with the condition, the layout will use the layout-wide.css file under the <span class="highlight">[your_site] / templates / ja_elastica / css</span> folder to be the style of the template.</p>\r\n<div class="img-caption"><img src="images/stories/guide/wide-layout.png" alt="Define layout" />\r\n<p>When the layout is put in width of 1236px to 1439, the template will get the style of the css file</p>\r\n</div>', 1, 78, '2020-02-06 08:15:05', 42, '', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 17, 3, '', '', 1, 33, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(85, 189, 'Normal layout', 'normal-layout', '<p><img src="images/stories/guide/layouts.png" alt="All layout" /></p>\r\n<p>The normal layout uses 4 grids. In Homepage, the content block width = 2 grids. In Detail page mode, the content block width = 3 grids.</p>\r\n<p>How the modules are changed when layout is changed from Wide layout to Normal layout?</p>\r\n<p>The modules in the grid 5 (in Wide layout) will be moved to available grids in Normal layout [grid 3 and 4 or under the content block (in Homepage) and grid 4 or under the content block (in detail page)] in the order from left to right. The moved modules will be located under the modules already in the grids.</p>\r\n', '\r\n<p>To define width of the layout, please navigate to: your_site / templates / ja_t3_blank_featured / core / etc / layouts / default.xml. The file default.xml is to define width range of each layout.</p>\r\n<p>{codecitation}css/layout-normal.css{/codecitation}</p>\r\n<p>As defined here, the layout has minimum width = 986 px and maximum = 1235 px. And with the condition, the layout will use the layout-normal.css file under the your_site / templates / ja_t3_blank_featured / css folder to be the style of the template.</p>', 1, 78, '2020-02-06 08:15:05', 42, '', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 9, 2, '', '', 1, 25, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(86, 190, 'Tablet layout', 'tablet-layout', '<img src="images/stories/guide/layouts.png" alt="All layout" />\r\n\r\n<p>There are 2 layout types for tablet. The first one is Tablet Portrait layout and Tablet Lanscape layout ( the Landscape layout is the Normal Layout).</p>\r\n\r\n<p>The Portrait layout uses 3 grids. The content block has width of 3 grids in both homepage and detail page so all modules will be displayed under the content block.</p>\r\n\r\n', '\r\n\r\n<h3>Portrait layout</h3>\r\n\r\n<h3>Front-end Appearance</h3>\r\n<p>To define width of the layout, please navigate to: <span class="highlight">[your_site] / templates / ja_elastica / core / etc / layouts / default.xml.</span> The file <span class="highlight">default.xml</span> is to define width range of each layout.</p>\r\n\r\n{codecitation}\r\n<file media="only screen and (min-width:720px) and (max-width: 985px)">css/layout-tablet.css</file>  \r\n{/codecitation}\r\n\r\n<p>As defined here, the layout has minimum width = 720px and maximum = 985 px. And with the condition, the layout will use the <span class="highlight">layout-tablet.css</span> file under the <span class="highlight">[your_site] / templates / ja_elastica / css</span> folder to be the style of the template.</p>', 1, 78, '2020-02-06 08:15:05', 42, '', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 11, 1, '', '', 1, 28, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', ''),
(87, 191, 'Mobile layout', 'mobile-layout', '<p>There are 2 layout types for mobile. The first one is Tablet <strong>Portrait layout</strong> and Tablet Lanscape layout ( the <strong>Landscape layout</strong> is the Normal Layout). The mobile layout uses percentage (%) as unit to define width of the layout. The full width of the layout is 100%, from that, you can define width for each element in the template.</p>\r\n\r\n<h3>Mobile Landscape layout</h3>\r\n<p><strong>Front-end Appearance</strong></p>\r\n<p>To define width of the layout, please navigate to: [your_site] / templates / ja_elastica / core / etc / layouts / default.xml. The file default.xml is to define width range of each layout.</p>\r\n\r\n\r\n', '\r\n\r\n{codecitation}\r\n<file media="only screen and (max-width:719px)">css/layout-mobile.css</file>  \r\n{/codecitation}\r\n\r\n<p>As defined here, the layout has maximum width = 719 px. And with the condition, the layout will use the layout-mobile.css file under the your_site/templates/elastica/css folder to be the style of the layout ( the Css file contains configuration for style of the layout including: width, font size, logo size, ... )</p>\r\n\r\n{codecitation}\r\n.main {\r\n  width: 100%;\r\n}\r\n\r\n.column {\r\n  float: none;\r\n  width: 100% !important;\r\n}\r\n\r\n/* MASONRY PRESETS (240px*5 Grids)\r\n--------------------------------------------------------- */\r\n/* Sizes---*/\r\n.ja-masonry {\r\n  width: 49%;\r\n}\r\n\r\n.grid-double,\r\n.grid-tripple {\r\n  width: 100%;\r\n}\r\n{/codecitation}\r\n\r\n<p>As defined in the code above, the width is re-defined. In mobile landscape layout, the ja-masonry (grid) is converted to percentage (%). One grid is now = 49% width in mobile landscape layout, and grid-double, grid-tripple are now = 100% width (full width). You can change the rate here.</p>\r\n\r\n<h3>Mobile Portrait layout</h3>\r\n<h4>Front-end Appearance</h4>\r\n<p>To define width of the layout, please navigate to: your_site/templates/elastica/core/etc/layouts/default.xml. The file default.xml is to define width range of each layout.</p>\r\n\r\n{codecitation}\r\n<file media="only screen and (max-width:479px)">css/layout-mobile-port.css</file> \r\n{/codecitation}\r\n\r\n<p>As defined here, the layout has maximum width = 479 px. And with the condition, the layout will use the layout-mobile-port.css file under the your_site / templates / elastica / css folder to be the style of the layout.</p>\r\n\r\n{codecitation}\r\n/* MASONRY PRESETS (240px*5 Grids)\r\n--------------------------------------------------------- */\r\n/* Sizes---*/\r\n.ja-masonry,\r\n.grid-double,\r\n.grid-tripple,\r\n#ja-header .main,\r\n#ja-content,\r\n.item {\r\n  float: none !important;\r\n  width: 100% !important;\r\n}\r\n{/codecitation}\r\n\r\n<p>As the code defined, in the mobile portrait layout, .ja-masonry, .grid-double, .grid-tripple are now = 100% width (full width) ---> content and modules have same size (all are = 100%).</p>\r\n', 1, 78, '2020-02-06 08:15:05', 42, '', '2020-02-06 08:15:05', 42, 0, '0000-00-00 00:00:00', '2020-02-06 08:15:05', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 11, 0, '', '', 1, 33, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '', '');

DROP TABLE IF EXISTS `#__content_frontpage`;
CREATE TABLE `#__content_frontpage` (
  `content_id` int(11) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__content_frontpage` (`content_id`, `ordering`) VALUES
(69, 3),
(70, 1),
(73, 2);

DROP TABLE IF EXISTS `#__content_rating`;
CREATE TABLE `#__content_rating` (
  `content_id` int(11) NOT NULL DEFAULT 0,
  `rating_sum` int(10) unsigned NOT NULL DEFAULT 0,
  `rating_count` int(10) unsigned NOT NULL DEFAULT 0,
  `lastip` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `#__content_types`;
CREATE TABLE `#__content_types` (
  `type_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) NOT NULL DEFAULT '',
  `type_alias` varchar(400) NOT NULL DEFAULT '',
  `table` varchar(255) NOT NULL DEFAULT '',
  `rules` mediumtext NOT NULL,
  `field_mappings` mediumtext NOT NULL,
  `router` varchar(255) NOT NULL DEFAULT '',
  `content_history_options` varchar(5120) NOT NULL COMMENT 'JSON string for com_contenthistory options',
  PRIMARY KEY (`type_id`),
  KEY `idx_alias` (`type_alias`(100))
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;

INSERT INTO `#__content_types` (`type_id`, `type_title`, `type_alias`, `table`, `rules`, `field_mappings`, `router`, `content_history_options`) VALUES
(1, 'Article', 'com_content.article', '{"special":{"dbtable":"#__content","key":"id","type":"Content","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__core_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"state","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"introtext", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"attribs", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"urls", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"asset_id", "note":"note"}, "special":{"fulltext":"fulltext"}}', 'ContentHelperRoute::getArticleRoute', '{"formFile":"administrator\\/components\\/com_content\\/models\\/forms\\/article.xml", "hideFields":["asset_id","checked_out","checked_out_time","version"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits", "ordering"],"convertToInt":["publish_up", "publish_down", "featured", "ordering"],"displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ]}'),
(2, 'Weblink', 'com_weblinks.weblink', '{"special":{"dbtable":"#__weblinks","key":"id","type":"Weblink","prefix":"WeblinksTable","config":"array()"},"common":{"dbtable":"#__core_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":[{"core_content_item_id":"id","core_title":"title","core_state":"state","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"description", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"urls", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"null"}], "special": []}', 'WeblinksHelperRoute::getWeblinkRoute', '{"formFile":"administrator\\/components\\/com_weblinks\\/models\\/forms\\/weblink.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","featured","images"], "ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits", "ordering"], "convertToInt":["publish_up", "publish_down", "featured", "ordering"], "displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ]}'),
(3, 'Contact', 'com_contact.contact', '{"special":{"dbtable":"#__contact_details","key":"id","type":"Contact","prefix":"ContactTable","config":"array()"},"common":{"dbtable":"#__core_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":[{"core_content_item_id":"id","core_title":"name","core_state":"published","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"address", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"image", "core_urls":"webpage", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"null"}], "special": [{"con_position":"con_position","suburb":"suburb","state":"state","country":"country","postcode":"postcode","telephone":"telephone","fax":"fax","misc":"misc","email_to":"email_to","default_con":"default_con","user_id":"user_id","mobile":"mobile","sortname1":"sortname1","sortname2":"sortname2","sortname3":"sortname3"}]}', 'ContactHelperRoute::getContactRoute', '{"formFile":"administrator\\/components\\/com_contact\\/models\\/forms\\/contact.xml","hideFields":["default_con","checked_out","checked_out_time","version","xreference"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits", "ordering"],"convertToInt":["publish_up", "publish_down", "featured", "ordering"], "displayLookup":[ {"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ] }'),
(4, 'Newsfeed', 'com_newsfeeds.newsfeed', '{"special":{"dbtable":"#__newsfeeds","key":"id","type":"Newsfeed","prefix":"NewsfeedsTable","config":"array()"},"common":{"dbtable":"#__core_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":[{"core_content_item_id":"id","core_title":"name","core_state":"published","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"description", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"link", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"null"}], "special": [{"numarticles":"numarticles","cache_time":"cache_time","rtl":"rtl"}]}', 'NewsfeedsHelperRoute::getNewsfeedRoute', '{"formFile":"administrator\\/components\\/com_newsfeeds\\/models\\/forms\\/newsfeed.xml","hideFields":["asset_id","checked_out","checked_out_time","version"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits", "ordering"],"convertToInt":["publish_up", "publish_down", "featured", "ordering"],"displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}'),
(5, 'User', 'com_users.user', '{"special":{"dbtable":"#__users","key":"id","type":"User","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__core_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":[{"core_content_item_id":"id","core_title":"name","core_state":"null","core_alias":"username","core_created_time":"registerdate","core_modified_time":"lastvisitDate","core_body":"null", "core_hits":"null","core_publish_up":"null","core_publish_down":"null","access":"null", "core_params":"params", "core_featured":"null", "core_metadata":"null", "core_language":"null", "core_images":"null", "core_urls":"null", "core_version":"null", "core_ordering":"null", "core_metakey":"null", "core_metadesc":"null", "core_catid":"null", "core_xreference":"null", "asset_id":"null"}], "special": [{}]}', 'UsersHelperRoute::getUserRoute', ''),
(6, 'Article Category', 'com_content.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__core_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":[{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}], "special": [{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}]}', 'ContentHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(7, 'Contact Category', 'com_contact.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__core_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":[{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}], "special": [{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}]}', 'ContactHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(8, 'Newsfeeds Category', 'com_newsfeeds.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__core_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":[{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}], "special": [{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}]}', 'NewsfeedsHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(9, 'Weblinks Category', 'com_weblinks.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__core_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":[{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}], "special": [{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}]}', 'WeblinksHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(10, 'Tag', 'com_tags.tag', '{"special":{"dbtable":"#__tags","key":"tag_id","type":"Tag","prefix":"TagsTable","config":"array()"},"common":{"dbtable":"#__core_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":[{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"urls", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"null", "core_xreference":"null", "asset_id":"null"}], "special": [{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path"}]}', 'TagsHelperRoute::getTagRoute', '{"formFile":"administrator\\/components\\/com_tags\\/models\\/forms\\/tag.xml", "hideFields":["checked_out","checked_out_time","version", "lft", "rgt", "level", "path", "urls", "publish_up", "publish_down"],"ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"}, {"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}'),
(11, 'Banner', 'com_banners.banner', '{"special":{"dbtable":"#__banners","key":"id","type":"Banner","prefix":"BannersTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"name","core_state":"published","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"description", "core_hits":"null","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"link", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"null", "asset_id":"null"}, "special":{"imptotal":"imptotal", "impmade":"impmade", "clicks":"clicks", "clickurl":"clickurl", "custombannercode":"custombannercode", "cid":"cid", "purchase_type":"purchase_type", "track_impressions":"track_impressions", "track_clicks":"track_clicks"}}', '', '{"formFile":"administrator\\/components\\/com_banners\\/models\\/forms\\/banner.xml", "hideFields":["checked_out","checked_out_time","version", "reset"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "imptotal", "impmade", "reset"], "convertToInt":["publish_up", "publish_down", "ordering"], "displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}, {"sourceColumn":"cid","targetTable":"#__banner_clients","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}'),
(12, 'Banners Category', 'com_banners.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special": {"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', '', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"], "convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(13, 'Banner Client', 'com_banners.client', '{"special":{"dbtable":"#__banner_clients","key":"id","type":"Client","prefix":"BannersTable"}}', '', '', '', '{"formFile":"administrator\\/components\\/com_banners\\/models\\/forms\\/client.xml", "hideFields":["checked_out","checked_out_time"], "ignoreChanges":["checked_out", "checked_out_time"], "convertToInt":[], "displayLookup":[]}'),
(14, 'User Notes', 'com_users.note', '{"special":{"dbtable":"#__user_notes","key":"id","type":"Note","prefix":"UsersTable"}}', '', '', '', '{"formFile":"administrator\\/components\\/com_users\\/models\\/forms\\/note.xml", "hideFields":["checked_out","checked_out_time", "publish_up", "publish_down"],"ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time"], "convertToInt":["publish_up", "publish_down"],"displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}, {"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}'),
(15, 'User Notes Category', 'com_users.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', '', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"], "convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}');

DROP TABLE IF EXISTS `#__contentitem_tag_map`;
CREATE TABLE `#__contentitem_tag_map` (
  `type_alias` varchar(255) NOT NULL DEFAULT '',
  `core_content_id` int(10) unsigned NOT NULL COMMENT 'PK from the core content table',
  `content_item_id` int(11) NOT NULL COMMENT 'PK from the content type table',
  `tag_id` int(10) unsigned NOT NULL COMMENT 'PK from the tag table',
  `tag_date` timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'Date of most recent save for this tag-item',
  `type_id` mediumint(8) NOT NULL COMMENT 'PK from the content_type table',
  UNIQUE KEY `uc_ItemnameTagid` (`type_id`,`content_item_id`,`tag_id`),
  KEY `idx_tag_type` (`tag_id`,`type_id`),
  KEY `idx_date_id` (`tag_date`,`tag_id`),
  KEY `idx_core_content_id` (`core_content_id`)
) ENGINE=InnoDB COMMENT='Maps items from content tables to tags' DEFAULT CHARSET=utf8;

INSERT INTO `#__contentitem_tag_map` (`type_alias`, `core_content_id`, `content_item_id`, `tag_id`, `tag_date`, `type_id`) VALUES
('com_content.article', 13, 69, 5, '2020-02-06 08:15:05', 1),
('com_content.article', 13, 69, 14, '2020-02-06 08:15:05', 1),
('com_content.article', 13, 69, 15, '2020-02-06 08:15:05', 1),
('com_content.article', 8, 70, 4, '2020-02-06 08:15:05', 1),
('com_content.article', 8, 70, 5, '2020-02-06 08:15:05', 1),
('com_content.article', 8, 70, 9, '2020-02-06 08:15:05', 1),
('com_content.article', 10, 72, 4, '2020-02-06 08:15:05', 1),
('com_content.article', 10, 72, 13, '2020-02-06 08:15:05', 1),
('com_content.article', 12, 73, 3, '2020-02-06 08:15:05', 1),
('com_content.article', 12, 73, 5, '2020-02-06 08:15:05', 1),
('com_content.article', 12, 73, 14, '2020-02-06 08:15:05', 1),
('com_content.article', 6, 77, 2, '2020-02-06 08:15:05', 1),
('com_content.article', 6, 77, 6, '2020-02-06 08:15:05', 1),
('com_content.article', 6, 77, 7, '2020-02-06 08:15:05', 1),
('com_content.article', 5, 78, 3, '2020-02-06 08:15:05', 1),
('com_content.article', 5, 78, 7, '2020-02-06 08:15:05', 1),
('com_content.article', 5, 78, 9, '2020-02-06 08:15:05', 1),
('com_content.article', 4, 79, 2, '2020-02-06 08:15:05', 1),
('com_content.article', 4, 79, 6, '2020-02-06 08:15:05', 1),
('com_content.article', 4, 79, 8, '2020-02-06 08:15:05', 1),
('com_content.article', 3, 80, 2, '2020-02-06 08:15:05', 1),
('com_content.article', 3, 80, 4, '2020-02-06 08:15:05', 1),
('com_content.article', 3, 80, 9, '2020-02-06 08:15:05', 1),
('com_content.article', 2, 81, 3, '2020-02-06 08:15:05', 1),
('com_content.article', 2, 81, 7, '2020-02-06 08:15:05', 1),
('com_content.article', 2, 81, 9, '2020-02-06 08:15:05', 1),
('com_content.article', 1, 83, 3, '2020-02-06 08:15:05', 1),
('com_content.article', 1, 83, 5, '2020-02-06 08:15:05', 1),
('com_content.article', 1, 83, 8, '2020-02-06 08:15:05', 1),
('com_content.article', 9, 84, 3, '2020-02-06 08:15:05', 1),
('com_content.article', 9, 84, 4, '2020-02-06 08:15:05', 1),
('com_content.article', 9, 84, 7, '2020-02-06 08:15:05', 1),
('com_content.article', 9, 84, 8, '2020-02-06 08:15:05', 1),
('com_content.article', 7, 85, 3, '2020-02-06 08:15:05', 1),
('com_content.article', 7, 85, 5, '2020-02-06 08:15:05', 1),
('com_content.article', 7, 85, 8, '2020-02-06 08:15:05', 1),
('com_content.article', 11, 86, 5, '2020-02-06 08:15:05', 1),
('com_content.article', 11, 86, 11, '2020-02-06 08:15:05', 1),
('com_content.article', 11, 86, 12, '2020-02-06 08:15:05', 1);

DROP TABLE IF EXISTS `#__extensions`;
CREATE TABLE `#__extensions` (
  `extension_id` int(11) NOT NULL AUTO_INCREMENT,
  `package_id` int(11) NOT NULL DEFAULT 0 COMMENT 'Parent package ID for extensions installed as a package.',
  `name` varchar(100) NOT NULL,
  `type` varchar(20) NOT NULL,
  `element` varchar(100) NOT NULL,
  `folder` varchar(100) NOT NULL,
  `client_id` tinyint(3) NOT NULL,
  `enabled` tinyint(3) NOT NULL DEFAULT 0,
  `access` int(10) unsigned DEFAULT NULL,
  `protected` tinyint(3) NOT NULL DEFAULT 0,
  `manifest_cache` mediumtext NOT NULL,
  `params` mediumtext NOT NULL,
  `custom_data` mediumtext NOT NULL,
  `system_data` mediumtext NOT NULL,
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) DEFAULT 0,
  `state` int(11) DEFAULT 0,
  PRIMARY KEY (`extension_id`),
  KEY `element_clientid` (`element`,`client_id`),
  KEY `element_folder_clientid` (`element`,`folder`,`client_id`),
  KEY `extension` (`type`,`element`,`folder`,`client_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10048 DEFAULT CHARSET=utf8;

INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(1, 0, 'com_mailto', 'component', 'com_mailto', '', 0, 1, 1, 1, '{"name":"com_mailto","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MAILTO_XML_DESCRIPTION","group":"","filename":"mailto"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(2, 0, 'com_wrapper', 'component', 'com_wrapper', '', 0, 1, 1, 1, '{"name":"com_wrapper","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_WRAPPER_XML_DESCRIPTION","group":"","filename":"wrapper"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(3, 0, 'com_admin', 'component', 'com_admin', '', 1, 1, 1, 1, '{"name":"com_admin","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_ADMIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(4, 0, 'com_banners', 'component', 'com_banners', '', 1, 1, 1, 0, '{"name":"com_banners","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_BANNERS_XML_DESCRIPTION","group":"","filename":"banners"}', '{"purchase_type":"3","track_impressions":"0","track_clicks":"0","metakey_prefix":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(5, 0, 'com_cache', 'component', 'com_cache', '', 1, 1, 1, 1, '{"name":"com_cache","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CACHE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(6, 0, 'com_categories', 'component', 'com_categories', '', 1, 1, 1, 1, '{"name":"com_categories","type":"component","creationDate":"December 2007","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CATEGORIES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(7, 0, 'com_checkin', 'component', 'com_checkin', '', 1, 1, 1, 1, '{"name":"com_checkin","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CHECKIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(8, 0, 'com_contact', 'component', 'com_contact', '', 1, 1, 1, 0, '{"name":"com_contact","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CONTACT_XML_DESCRIPTION","group":"","filename":"contact"}', '{"show_contact_category":"hide","show_contact_list":"0","presentation_style":"sliders","show_name":"1","show_position":"1","show_email":"0","show_street_address":"1","show_suburb":"1","show_state":"1","show_postcode":"1","show_country":"1","show_telephone":"1","show_mobile":"1","show_fax":"1","show_webpage":"1","show_misc":"1","show_image":"1","image":"","allow_vcard":"0","show_articles":"0","show_profile":"0","show_links":"0","linka_name":"","linkb_name":"","linkc_name":"","linkd_name":"","linke_name":"","contact_icons":"0","icon_address":"","icon_email":"","icon_telephone":"","icon_mobile":"","icon_fax":"","icon_misc":"","show_headings":"1","show_position_headings":"1","show_email_headings":"0","show_telephone_headings":"1","show_mobile_headings":"0","show_fax_headings":"0","allow_vcard_headings":"0","show_suburb_headings":"1","show_state_headings":"1","show_country_headings":"1","show_email_form":"1","show_email_copy":"1","banned_email":"","banned_subject":"","banned_text":"","validate_session":"1","custom_reply":"0","redirect":"","show_category_crumb":"0","metakey":"","metadesc":"","robots":"","author":"","rights":"","xreference":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(9, 0, 'com_cpanel', 'component', 'com_cpanel', '', 1, 1, 1, 1, '{"name":"com_cpanel","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CPANEL_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10, 0, 'com_installer', 'component', 'com_installer', '', 1, 1, 1, 1, '{"name":"com_installer","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_INSTALLER_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(11, 0, 'com_languages', 'component', 'com_languages', '', 1, 1, 1, 1, '{"name":"com_languages","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_LANGUAGES_XML_DESCRIPTION","group":""}', '{"administrator":"en-GB","site":"en-GB"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(12, 0, 'com_login', 'component', 'com_login', '', 1, 1, 1, 1, '{"name":"com_login","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_LOGIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(13, 0, 'com_media', 'component', 'com_media', '', 1, 1, 0, 1, '{"name":"com_media","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MEDIA_XML_DESCRIPTION","group":"","filename":"media"}', '{"upload_extensions":"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS","upload_maxsize":"10485760","file_path":"images","image_path":"images","restrict_uploads":"1","allowed_media_usergroup":"3","check_mime":"1","image_extensions":"bmp,gif,jpg,png","ignore_extensions":"","upload_mime":"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/x-shockwave-flash,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip","upload_mime_illegal":"text\\/html","enable_flash":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(14, 0, 'com_menus', 'component', 'com_menus', '', 1, 1, 1, 1, '{"name":"com_menus","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MENUS_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(15, 0, 'com_messages', 'component', 'com_messages', '', 1, 1, 1, 1, '{"name":"com_messages","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MESSAGES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(16, 0, 'com_modules', 'component', 'com_modules', '', 1, 1, 1, 1, '{"name":"com_modules","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MODULES_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(17, 0, 'com_newsfeeds', 'component', 'com_newsfeeds', '', 1, 1, 1, 0, '{"name":"com_newsfeeds","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_NEWSFEEDS_XML_DESCRIPTION","group":"","filename":"newsfeeds"}', '{"show_feed_image":"1","show_feed_description":"1","show_item_description":"1","feed_word_count":"0","show_headings":"1","show_name":"1","show_articles":"0","show_link":"1","show_description":"1","show_description_image":"1","display_num":"","show_pagination_limit":"1","show_pagination":"1","show_pagination_results":"1","show_cat_items":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(18, 0, 'com_plugins', 'component', 'com_plugins', '', 1, 1, 1, 1, '{"name":"com_plugins","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_PLUGINS_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(19, 0, 'com_search', 'component', 'com_search', '', 1, 1, 1, 1, '{"name":"com_search","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_SEARCH_XML_DESCRIPTION","group":"","filename":"search"}', '{"enabled":"0","show_date":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(20, 0, 'com_templates', 'component', 'com_templates', '', 1, 1, 1, 1, '{"name":"com_templates","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_TEMPLATES_XML_DESCRIPTION","group":""}', '{"template_positions_display":"0","upload_limit":"2","image_formats":"gif,bmp,jpg,jpeg,png","source_formats":"txt,less,ini,xml,js,php,css","font_formats":"woff,ttf,otf","compressed_formats":"zip"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(22, 0, 'com_content', 'component', 'com_content', '', 1, 1, 0, 1, '{"name":"com_content","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CONTENT_XML_DESCRIPTION","group":"","filename":"content"}', '{"article_layout":"_:default","show_title":"1","link_titles":"1","show_intro":"1","show_category":"1","link_category":"1","show_parent_category":"0","link_parent_category":"0","show_author":"0","link_author":"0","show_create_date":"0","show_modify_date":"0","show_publish_date":"1","show_item_navigation":"0","show_vote":"0","show_readmore":"1","show_readmore_title":"0","readmore_limit":"100","show_icons":"1","show_print_icon":"1","show_email_icon":"1","show_hits":"1","show_noauth":"0","category_layout":"_:blog","show_category_title":"0","show_description":"0","show_description_image":"0","maxLevel":"1","show_empty_categories":"0","show_no_articles":"1","show_subcat_desc":"1","show_cat_num_articles":"0","show_base_description":"1","maxLevelcat":"-1","show_empty_categories_cat":"0","show_subcat_desc_cat":"1","show_cat_num_articles_cat":"1","num_leading_articles":"1","num_intro_articles":"4","num_columns":"2","num_links":"4","multi_column_order":"0","show_subcategory_content":"0","show_pagination_limit":"1","filter_field":"hide","show_headings":"1","list_show_date":"0","date_format":"","list_show_hits":"1","list_show_author":"1","orderby_pri":"order","orderby_sec":"rdate","order_date":"published","show_pagination":"2","show_pagination_results":"1","show_feed_link":"1","feed_summary":"0","filters":{"1":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"6":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"7":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"2":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"3":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"4":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"5":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"10":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"12":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"8":{"filter_type":"NONE","filter_tags":"","filter_attributes":""}}}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(23, 0, 'com_config', 'component', 'com_config', '', 1, 1, 0, 1, '{"name":"com_config","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CONFIG_XML_DESCRIPTION","group":""}', '{"filters":{"1":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"6":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"7":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"2":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"3":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"4":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"5":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"10":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"12":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"8":{"filter_type":"NONE","filter_tags":"","filter_attributes":""}}}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(24, 0, 'com_redirect', 'component', 'com_redirect', '', 1, 1, 0, 1, '{"name":"com_redirect","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_REDIRECT_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(25, 0, 'com_users', 'component', 'com_users', '', 1, 1, 0, 1, '{"name":"com_users","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_USERS_XML_DESCRIPTION","group":"","filename":"users"}', '{"allowUserRegistration":"1","new_usertype":"2","useractivation":"1","frontend_userparams":"1","mailSubjectPrefix":"","mailBodySuffix":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(29, 0, 'com_tags', 'component', 'com_tags', '', 1, 1, 1, 1, '{"name":"com_tags","type":"component","creationDate":"December 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.1.0","description":"COM_TAGS_XML_DESCRIPTION","group":"","filename":"tags"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(30, 0, 'com_contenthistory', 'component', 'com_contenthistory', '', 1, 1, 1, 0, '{"name":"com_contenthistory","type":"component","creationDate":"May 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"COM_CONTENTHISTORY_XML_DESCRIPTION","group":"","filename":"contenthistory"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(31, 0, 'com_ajax', 'component', 'com_ajax', '', 1, 1, 1, 1, '{"name":"com_ajax","type":"component","creationDate":"August 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"COM_AJAX_XML_DESCRIPTION","group":"","filename":"ajax"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(32, 0, 'com_postinstall', 'component', 'com_postinstall', '', 1, 1, 1, 1, '{"name":"com_postinstall","type":"component","creationDate":"September 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"COM_POSTINSTALL_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(33, 0, 'com_fields', 'component', 'com_fields', '', 1, 1, 1, 0, '{"name":"com_fields","type":"component","creationDate":"March 2016","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"COM_FIELDS_XML_DESCRIPTION","group":"","filename":"fields"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(34, 0, 'com_associations', 'component', 'com_associations', '', 1, 1, 1, 0, '{"name":"com_associations","type":"component","creationDate":"January 2017","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"COM_ASSOCIATIONS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(35, 0, 'com_privacy', 'component', 'com_privacy', '', 1, 1, 1, 1, '{"name":"com_privacy","type":"component","creationDate":"May 2018","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.9.0","description":"COM_PRIVACY_XML_DESCRIPTION","group":"","filename":"privacy"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(36, 0, 'com_actionlogs', 'component', 'com_actionlogs', '', 1, 1, 1, 1, '{"name":"com_actionlogs","type":"component","creationDate":"May 2018","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.9.0","description":"COM_ACTIONLOGS_XML_DESCRIPTION","group":""}', '{"ip_logging":0,"csv_delimiter":",","loggable_extensions":["com_banners","com_cache","com_categories","com_checkin","com_config","com_contact","com_content","com_installer","com_media","com_menus","com_messages","com_modules","com_newsfeeds","com_plugins","com_redirect","com_tags","com_templates","com_users"]}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(105, 0, 'FOF', 'library', 'fof', '', 0, 1, 1, 1, '{"name":"FOF","type":"library","creationDate":"2015-04-22 13:15:32","author":"Nicholas K. Dionysopoulos \\/ Akeeba Ltd","copyright":"(C)2011-2015 Nicholas K. Dionysopoulos","authorEmail":"nicholas@akeebabackup.com","authorUrl":"https:\\/\\/www.akeebabackup.com","version":"2.4.3","description":"LIB_FOF_XML_DESCRIPTION","group":"","filename":"fof"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(200, 0, 'mod_articles_archive', 'module', 'mod_articles_archive', '', 0, 1, 1, 1, '{"name":"mod_articles_archive","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION","group":"","filename":"mod_articles_archive"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(201, 0, 'mod_articles_latest', 'module', 'mod_articles_latest', '', 0, 1, 1, 1, '{"name":"mod_articles_latest","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LATEST_NEWS_XML_DESCRIPTION","group":"","filename":"mod_articles_latest"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(202, 0, 'mod_articles_popular', 'module', 'mod_articles_popular', '', 0, 1, 1, 0, '{"name":"mod_articles_popular","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_POPULAR_XML_DESCRIPTION","group":"","filename":"mod_articles_popular"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(203, 0, 'mod_banners', 'module', 'mod_banners', '', 0, 1, 1, 1, '{"name":"mod_banners","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_BANNERS_XML_DESCRIPTION","group":"","filename":"mod_banners"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(204, 0, 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', 0, 1, 1, 1, '{"name":"mod_breadcrumbs","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_BREADCRUMBS_XML_DESCRIPTION","group":"","filename":"mod_breadcrumbs"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(205, 0, 'mod_custom', 'module', 'mod_custom', '', 0, 1, 1, 1, '{"name":"mod_custom","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_CUSTOM_XML_DESCRIPTION","group":"","filename":"mod_custom"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(206, 0, 'mod_feed', 'module', 'mod_feed', '', 0, 1, 1, 1, '{"name":"mod_feed","type":"module","creationDate":"July 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FEED_XML_DESCRIPTION","group":"","filename":"mod_feed"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(207, 0, 'mod_footer', 'module', 'mod_footer', '', 0, 1, 1, 1, '{"name":"mod_footer","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FOOTER_XML_DESCRIPTION","group":"","filename":"mod_footer"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(208, 0, 'mod_login', 'module', 'mod_login', '', 0, 1, 1, 1, '{"name":"mod_login","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LOGIN_XML_DESCRIPTION","group":"","filename":"mod_login"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(209, 0, 'mod_menu', 'module', 'mod_menu', '', 0, 1, 1, 1, '{"name":"mod_menu","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_MENU_XML_DESCRIPTION","group":"","filename":"mod_menu"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(210, 0, 'mod_articles_news', 'module', 'mod_articles_news', '', 0, 1, 1, 0, '{"name":"mod_articles_news","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_NEWS_XML_DESCRIPTION","group":"","filename":"mod_articles_news"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(211, 0, 'mod_random_image', 'module', 'mod_random_image', '', 0, 1, 1, 0, '{"name":"mod_random_image","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_RANDOM_IMAGE_XML_DESCRIPTION","group":"","filename":"mod_random_image"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(212, 0, 'mod_related_items', 'module', 'mod_related_items', '', 0, 1, 1, 0, '{"name":"mod_related_items","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_RELATED_XML_DESCRIPTION","group":"","filename":"mod_related_items"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(213, 0, 'mod_search', 'module', 'mod_search', '', 0, 1, 1, 0, '{"name":"mod_search","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_SEARCH_XML_DESCRIPTION","group":"","filename":"mod_search"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(214, 0, 'mod_stats', 'module', 'mod_stats', '', 0, 1, 1, 0, '{"name":"mod_stats","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_STATS_XML_DESCRIPTION","group":"","filename":"mod_stats"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(215, 0, 'mod_syndicate', 'module', 'mod_syndicate', '', 0, 1, 1, 1, '{"name":"mod_syndicate","type":"module","creationDate":"May 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_SYNDICATE_XML_DESCRIPTION","group":"","filename":"mod_syndicate"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(216, 0, 'mod_users_latest', 'module', 'mod_users_latest', '', 0, 1, 1, 1, '{"name":"mod_users_latest","type":"module","creationDate":"December 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_USERS_LATEST_XML_DESCRIPTION","group":"","filename":"mod_users_latest"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(218, 0, 'mod_whosonline', 'module', 'mod_whosonline', '', 0, 1, 1, 0, '{"name":"mod_whosonline","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_WHOSONLINE_XML_DESCRIPTION","group":"","filename":"mod_whosonline"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(219, 0, 'mod_wrapper', 'module', 'mod_wrapper', '', 0, 1, 1, 0, '{"name":"mod_wrapper","type":"module","creationDate":"October 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_WRAPPER_XML_DESCRIPTION","group":"","filename":"mod_wrapper"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(220, 0, 'mod_articles_category', 'module', 'mod_articles_category', '', 0, 1, 1, 1, '{"name":"mod_articles_category","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION","group":"","filename":"mod_articles_category"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(221, 0, 'mod_articles_categories', 'module', 'mod_articles_categories', '', 0, 1, 1, 1, '{"name":"mod_articles_categories","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION","group":"","filename":"mod_articles_categories"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(222, 0, 'mod_languages', 'module', 'mod_languages', '', 0, 1, 1, 1, '{"name":"mod_languages","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.5.0","description":"MOD_LANGUAGES_XML_DESCRIPTION","group":"","filename":"mod_languages"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(300, 0, 'mod_custom', 'module', 'mod_custom', '', 1, 1, 1, 1, '{"name":"mod_custom","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_CUSTOM_XML_DESCRIPTION","group":"","filename":"mod_custom"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(301, 0, 'mod_feed', 'module', 'mod_feed', '', 1, 1, 1, 0, '{"name":"mod_feed","type":"module","creationDate":"July 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FEED_XML_DESCRIPTION","group":"","filename":"mod_feed"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(302, 0, 'mod_latest', 'module', 'mod_latest', '', 1, 1, 1, 0, '{"name":"mod_latest","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LATEST_XML_DESCRIPTION","group":"","filename":"mod_latest"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(303, 0, 'mod_logged', 'module', 'mod_logged', '', 1, 1, 1, 0, '{"name":"mod_logged","type":"module","creationDate":"January 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LOGGED_XML_DESCRIPTION","group":"","filename":"mod_logged"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(304, 0, 'mod_login', 'module', 'mod_login', '', 1, 1, 1, 1, '{"name":"mod_login","type":"module","creationDate":"March 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LOGIN_XML_DESCRIPTION","group":"","filename":"mod_login"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(305, 0, 'mod_menu', 'module', 'mod_menu', '', 1, 1, 1, 0, '{"name":"mod_menu","type":"module","creationDate":"March 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_MENU_XML_DESCRIPTION","group":"","filename":"mod_menu"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(307, 0, 'mod_popular', 'module', 'mod_popular', '', 1, 1, 1, 0, '{"name":"mod_popular","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_POPULAR_XML_DESCRIPTION","group":"","filename":"mod_popular"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(308, 0, 'mod_quickicon', 'module', 'mod_quickicon', '', 1, 1, 1, 1, '{"name":"mod_quickicon","type":"module","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_QUICKICON_XML_DESCRIPTION","group":"","filename":"mod_quickicon"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(309, 0, 'mod_status', 'module', 'mod_status', '', 1, 1, 1, 0, '{"name":"mod_status","type":"module","creationDate":"February 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_STATUS_XML_DESCRIPTION","group":"","filename":"mod_status"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(310, 0, 'mod_submenu', 'module', 'mod_submenu', '', 1, 1, 1, 0, '{"name":"mod_submenu","type":"module","creationDate":"February 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_SUBMENU_XML_DESCRIPTION","group":"","filename":"mod_submenu"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(311, 0, 'mod_title', 'module', 'mod_title', '', 1, 1, 1, 0, '{"name":"mod_title","type":"module","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_TITLE_XML_DESCRIPTION","group":"","filename":"mod_title"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(312, 0, 'mod_toolbar', 'module', 'mod_toolbar', '', 1, 1, 1, 1, '{"name":"mod_toolbar","type":"module","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_TOOLBAR_XML_DESCRIPTION","group":"","filename":"mod_toolbar"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(316, 0, 'mod_tags_popular', 'module', 'mod_tags_popular', '', 0, 1, 1, 0, '{"name":"mod_tags_popular","type":"module","creationDate":"January 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.1.0","description":"MOD_TAGS_POPULAR_XML_DESCRIPTION","group":"","filename":"mod_tags_popular"}', '{"maximum":"5","timeframe":"alltime","owncache":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(317, 0, 'mod_tags_similar', 'module', 'mod_tags_similar', '', 0, 1, 1, 0, '{"name":"mod_tags_similar","type":"module","creationDate":"January 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.1.0","description":"MOD_TAGS_SIMILAR_XML_DESCRIPTION","group":"","filename":"mod_tags_similar"}', '{"maximum":"5","matchtype":"any","owncache":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(319, 0, 'mod_latestactions', 'module', 'mod_latestactions', '', 1, 1, 1, 0, '{"name":"mod_latestactions","type":"module","creationDate":"May 2018","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.9.0","description":"MOD_LATESTACTIONS_XML_DESCRIPTION","group":"","filename":"mod_latestactions"}', '{}', '', '', 0, '1970-01-01 00:00:00', 0, 0),
(320, 0, 'mod_privacy_dashboard', 'module', 'mod_privacy_dashboard', '', 1, 1, 1, 0, '{"name":"mod_privacy_dashboard","type":"module","creationDate":"June 2018","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.9.0","description":"MOD_PRIVACY_DASHBOARD_XML_DESCRIPTION","group":"","filename":"mod_privacy_dashboard"}', '{}', '', '', 0, '1970-01-01 00:00:00', 0, 0),
(400, 0, 'plg_authentication_gmail', 'plugin', 'gmail', 'authentication', 0, 0, 1, 0, '{"name":"plg_authentication_gmail","type":"plugin","creationDate":"February 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_GMAIL_XML_DESCRIPTION","group":"","filename":"gmail"}', '{"applysuffix":"0","suffix":"","verifypeer":"1","user_blacklist":""}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(401, 0, 'plg_authentication_joomla', 'plugin', 'joomla', 'authentication', 0, 1, 1, 1, '{"name":"plg_authentication_joomla","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_AUTH_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(402, 0, 'plg_authentication_ldap', 'plugin', 'ldap', 'authentication', 0, 0, 1, 0, '{"name":"plg_authentication_ldap","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_LDAP_XML_DESCRIPTION","group":"","filename":"ldap"}', '{"host":"","port":"389","use_ldapV3":"0","negotiate_tls":"0","no_referrals":"0","auth_method":"bind","base_dn":"","search_string":"","users_dn":"","username":"admin","password":"bobby7","ldap_fullname":"fullName","ldap_email":"mail","ldap_uid":"uid"}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(404, 0, 'plg_content_emailcloak', 'plugin', 'emailcloak', 'content', 0, 1, 1, 0, '{"name":"plg_content_emailcloak","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION","group":"","filename":"emailcloak"}', '{"mode":"1"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(406, 0, 'plg_content_loadmodule', 'plugin', 'loadmodule', 'content', 0, 1, 1, 0, '{"name":"plg_content_loadmodule","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_LOADMODULE_XML_DESCRIPTION","group":"","filename":"loadmodule"}', '{"style":"rounded"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(407, 0, 'plg_content_pagebreak', 'plugin', 'pagebreak', 'content', 0, 1, 1, 1, '{"name":"plg_content_pagebreak","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION","group":"","filename":"pagebreak"}', '{"title":"1","multipage_toc":"1","showall":"1"}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(408, 0, 'plg_content_pagenavigation', 'plugin', 'pagenavigation', 'content', 0, 1, 1, 1, '{"name":"plg_content_pagenavigation","type":"plugin","creationDate":"January 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_PAGENAVIGATION_XML_DESCRIPTION","group":"","filename":"pagenavigation"}', '{"position":"1"}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(409, 0, 'plg_content_vote', 'plugin', 'vote', 'content', 0, 1, 1, 1, '{"name":"plg_content_vote","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_VOTE_XML_DESCRIPTION","group":"","filename":"vote"}', '{}', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(410, 0, 'plg_editors_codemirror', 'plugin', 'codemirror', 'editors', 0, 1, 1, 1, '{"name":"plg_editors_codemirror","type":"plugin","creationDate":"28 March 2011","author":"Marijn Haverbeke","copyright":"Copyright (C) 2014 - 2017 by Marijn Haverbeke <marijnh@gmail.com> and others","authorEmail":"marijnh@gmail.com","authorUrl":"http:\\/\\/codemirror.net\\/","version":"5.40.0","description":"PLG_CODEMIRROR_XML_DESCRIPTION","group":"","filename":"codemirror"}', '{"lineNumbers":"1","lineWrapping":"1","matchTags":"1","matchBrackets":"1","marker-gutter":"1","autoCloseTags":"1","autoCloseBrackets":"1","autoFocus":"1","theme":"default","tabmode":"indent"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(411, 0, 'plg_editors_none', 'plugin', 'none', 'editors', 0, 1, 1, 1, '{"name":"plg_editors_none","type":"plugin","creationDate":"September 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_NONE_XML_DESCRIPTION","group":"","filename":"none"}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(412, 0, 'plg_editors_tinymce', 'plugin', 'tinymce', 'editors', 0, 1, 1, 1, '{"name":"plg_editors_tinymce","type":"plugin","creationDate":"2005-2019","author":"Tiny Technologies, Inc","copyright":"Tiny Technologies, Inc","authorEmail":"N\\/A","authorUrl":"https:\\/\\/www.tiny.cloud","version":"4.5.11","description":"PLG_TINY_XML_DESCRIPTION","group":"","filename":"tinymce"}', '{"mode":"1","skin":"0","compressed":"0","cleanup_startup":"0","cleanup_save":"2","entity_encoding":"raw","lang_mode":"0","lang_code":"en","text_direction":"ltr","content_css":"1","content_css_custom":"","relative_urls":"1","newlines":"0","invalid_elements":"script,applet,iframe","extended_elements":"","toolbar":"top","toolbar_align":"left","html_height":"550","html_width":"750","element_path":"1","fonts":"1","paste":"1","searchreplace":"1","insertdate":"1","format_date":"%Y-%m-%d","inserttime":"1","format_time":"%H:%M:%S","colors":"1","table":"1","smilies":"1","media":"1","hr":"1","directionality":"1","fullscreen":"1","style":"1","layer":"1","xhtmlxtras":"1","visualchars":"1","nonbreaking":"1","template":"1","blockquote":"1","wordcount":"1","advimage":"1","advlink":"1","autosave":"1","contextmenu":"1","inlinepopups":"1","safari":"0","custom_plugin":"","custom_button":""}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(413, 0, 'plg_editors-xtd_article', 'plugin', 'article', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_article","type":"plugin","creationDate":"October 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_ARTICLE_XML_DESCRIPTION","group":"","filename":"article"}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(414, 0, 'plg_editors-xtd_image', 'plugin', 'image', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_image","type":"plugin","creationDate":"August 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_IMAGE_XML_DESCRIPTION","group":"","filename":"image"}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(415, 0, 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_pagebreak","type":"plugin","creationDate":"August 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION","group":"","filename":"pagebreak"}', '{}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(416, 0, 'plg_editors-xtd_readmore', 'plugin', 'readmore', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_readmore","type":"plugin","creationDate":"March 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_READMORE_XML_DESCRIPTION","group":"","filename":"readmore"}', '{}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(417, 0, 'plg_search_categories', 'plugin', 'categories', 'search', 0, 1, 1, 0, '{"name":"plg_search_categories","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION","group":"","filename":"categories"}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(418, 0, 'plg_search_contacts', 'plugin', 'contacts', 'search', 0, 1, 1, 0, '{"name":"plg_search_contacts","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_CONTACTS_XML_DESCRIPTION","group":"","filename":"contacts"}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(419, 0, 'plg_search_content', 'plugin', 'content', 'search', 0, 1, 1, 0, '{"name":"plg_search_content","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_CONTENT_XML_DESCRIPTION","group":"","filename":"content"}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(420, 0, 'plg_search_newsfeeds', 'plugin', 'newsfeeds', 'search', 0, 1, 1, 0, '{"name":"plg_search_newsfeeds","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_NEWSFEEDS_XML_DESCRIPTION","group":"","filename":"newsfeeds"}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(422, 0, 'plg_system_cache', 'plugin', 'cache', 'system', 0, 0, 1, 1, '{"name":"plg_system_cache","type":"plugin","creationDate":"February 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CACHE_XML_DESCRIPTION","group":"","filename":"cache"}', '{"browsercache":"0","cachetime":"15"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(423, 0, 'plg_system_debug', 'plugin', 'debug', 'system', 0, 1, 1, 0, '{"name":"plg_system_debug","type":"plugin","creationDate":"December 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_DEBUG_XML_DESCRIPTION","group":"","filename":"debug"}', '{"profile":"1","queries":"1","memory":"1","language_files":"1","language_strings":"1","strip-first":"1","strip-prefix":"","strip-suffix":""}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(424, 0, 'plg_system_log', 'plugin', 'log', 'system', 0, 1, 1, 1, '{"name":"plg_system_log","type":"plugin","creationDate":"April 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_LOG_XML_DESCRIPTION","group":"","filename":"log"}', '{}', '', '', 0, '0000-00-00 00:00:00', 3, 0);
INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(425, 0, 'plg_system_redirect', 'plugin', 'redirect', 'system', 0, 1, 1, 1, '{"name":"plg_system_redirect","type":"plugin","creationDate":"April 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_REDIRECT_XML_DESCRIPTION","group":"","filename":"redirect"}', '{}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(426, 0, 'plg_system_remember', 'plugin', 'remember', 'system', 0, 1, 1, 1, '{"name":"plg_system_remember","type":"plugin","creationDate":"April 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_REMEMBER_XML_DESCRIPTION","group":"","filename":"remember"}', '{}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(427, 0, 'plg_system_sef', 'plugin', 'sef', 'system', 0, 1, 1, 0, '{"name":"plg_system_sef","type":"plugin","creationDate":"December 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEF_XML_DESCRIPTION","group":"","filename":"sef"}', '{}', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(428, 0, 'plg_user_contactcreator', 'plugin', 'contactcreator', 'user', 0, 0, 1, 1, '{"name":"plg_user_contactcreator","type":"plugin","creationDate":"August 2009","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTACTCREATOR_XML_DESCRIPTION","group":"","filename":"contactcreator"}', '{"autowebpage":"","category":"34","autopublish":"0"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(429, 0, 'plg_user_joomla', 'plugin', 'joomla', 'user', 0, 1, 1, 0, '{"name":"plg_user_joomla","type":"plugin","creationDate":"December 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_USER_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}', '{"autoregister":"1"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(430, 0, 'plg_user_profile', 'plugin', 'profile', 'user', 0, 0, 1, 1, '{"name":"plg_user_profile","type":"plugin","creationDate":"January 2008","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_USER_PROFILE_XML_DESCRIPTION","group":"","filename":"profile"}', '{"register-require_address1":"0","register-require_address2":"0","register-require_city":"0","register-require_region":"0","register-require_country":"0","register-require_postal_code":"0","register-require_phone":"0","register-require_website":"0","profile-require_address1":"1","profile-require_address2":"1","profile-require_city":"1","profile-require_region":"1","profile-require_country":"1","profile-require_postal_code":"1","profile-require_phone":"1","profile-require_website":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(431, 0, 'plg_extension_joomla', 'plugin', 'joomla', 'extension', 0, 1, 1, 1, '{"name":"plg_extension_joomla","type":"plugin","creationDate":"May 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(432, 0, 'plg_system_languagefilter', 'plugin', 'languagefilter', 'system', 0, 0, 1, 1, '{"name":"plg_system_languagefilter","type":"plugin","creationDate":"July 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION","group":"","filename":"languagefilter"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(447, 0, 'plg_finder_tags', 'plugin', 'tags', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_tags","type":"plugin","creationDate":"February 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_TAGS_XML_DESCRIPTION","group":"","filename":"tags"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(448, 0, 'plg_twofactorauth_totp', 'plugin', 'totp', 'twofactorauth', 0, 0, 1, 0, '{"name":"plg_twofactorauth_totp","type":"plugin","creationDate":"August 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"PLG_TWOFACTORAUTH_TOTP_XML_DESCRIPTION","group":"","filename":"totp"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(449, 0, 'plg_authentication_cookie', 'plugin', 'cookie', 'authentication', 0, 1, 1, 0, '{"name":"plg_authentication_cookie","type":"plugin","creationDate":"July 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_AUTH_COOKIE_XML_DESCRIPTION","group":"","filename":"cookie"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(450, 0, 'plg_twofactorauth_yubikey', 'plugin', 'yubikey', 'twofactorauth', 0, 0, 1, 0, '{"name":"plg_twofactorauth_yubikey","type":"plugin","creationDate":"September 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"PLG_TWOFACTORAUTH_YUBIKEY_XML_DESCRIPTION","group":"","filename":"yubikey"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(451, 0, 'plg_search_tags', 'plugin', 'tags', 'search', 0, 0, 1, 0, '{"name":"plg_search_tags","type":"plugin","creationDate":"March 2014","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_TAGS_XML_DESCRIPTION","group":"","filename":"tags"}', '{"search_limit":"50","show_tagged_items":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(452, 0, 'plg_system_updatenotification', 'plugin', 'updatenotification', 'system', 0, 1, 1, 0, '{"name":"plg_system_updatenotification","type":"plugin","creationDate":"May 2015","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.5.0","description":"PLG_SYSTEM_UPDATENOTIFICATION_XML_DESCRIPTION","group":"","filename":"updatenotification"}', '{"lastrun":1580976905}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(453, 0, 'plg_editors-xtd_module', 'plugin', 'module', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_module","type":"plugin","creationDate":"October 2015","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.5.0","description":"PLG_MODULE_XML_DESCRIPTION","group":"","filename":"module"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(454, 0, 'plg_system_stats', 'plugin', 'stats', 'system', 0, 1, 1, 0, '{"name":"plg_system_stats","type":"plugin","creationDate":"November 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.5.0","description":"PLG_SYSTEM_STATS_XML_DESCRIPTION","group":"","filename":"stats"}', '{"mode":1,"lastrun":1580976950,"unique_id":"0e07bd9cf77784daebed2a71c9c1d2eb7862415a","interval":12}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(455, 0, 'plg_installer_packageinstaller', 'plugin', 'packageinstaller', 'installer', 0, 1, 1, 1, '{"name":"plg_installer_packageinstaller","type":"plugin","creationDate":"May 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.6.0","description":"PLG_INSTALLER_PACKAGEINSTALLER_PLUGIN_XML_DESCRIPTION","group":"","filename":"packageinstaller"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(456, 0, 'PLG_INSTALLER_FOLDERINSTALLER', 'plugin', 'folderinstaller', 'installer', 0, 1, 1, 1, '{"name":"PLG_INSTALLER_FOLDERINSTALLER","type":"plugin","creationDate":"May 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.6.0","description":"PLG_INSTALLER_FOLDERINSTALLER_PLUGIN_XML_DESCRIPTION","group":"","filename":"folderinstaller"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(457, 0, 'PLG_INSTALLER_URLINSTALLER', 'plugin', 'urlinstaller', 'installer', 0, 1, 1, 1, '{"name":"PLG_INSTALLER_URLINSTALLER","type":"plugin","creationDate":"May 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.6.0","description":"PLG_INSTALLER_URLINSTALLER_PLUGIN_XML_DESCRIPTION","group":"","filename":"urlinstaller"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(458, 0, 'plg_quickicon_phpversioncheck', 'plugin', 'phpversioncheck', 'quickicon', 0, 1, 1, 1, '{"name":"plg_quickicon_phpversioncheck","type":"plugin","creationDate":"August 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_QUICKICON_PHPVERSIONCHECK_XML_DESCRIPTION","group":"","filename":"phpversioncheck"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(459, 0, 'plg_editors-xtd_menu', 'plugin', 'menu', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_menu","type":"plugin","creationDate":"August 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_EDITORS-XTD_MENU_XML_DESCRIPTION","group":"","filename":"menu"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(460, 0, 'plg_editors-xtd_contact', 'plugin', 'contact', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_contact","type":"plugin","creationDate":"October 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_EDITORS-XTD_CONTACT_XML_DESCRIPTION","group":"","filename":"contact"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(461, 0, 'plg_system_fields', 'plugin', 'fields', 'system', 0, 1, 1, 0, '{"name":"plg_system_fields","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_SYSTEM_FIELDS_XML_DESCRIPTION","group":"","filename":"fields"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(462, 0, 'plg_fields_calendar', 'plugin', 'calendar', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_calendar","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_CALENDAR_XML_DESCRIPTION","group":"","filename":"calendar"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(463, 0, 'plg_fields_checkboxes', 'plugin', 'checkboxes', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_checkboxes","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_CHECKBOXES_XML_DESCRIPTION","group":"","filename":"checkboxes"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(464, 0, 'plg_fields_color', 'plugin', 'color', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_color","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_COLOR_XML_DESCRIPTION","group":"","filename":"color"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(465, 0, 'plg_fields_editor', 'plugin', 'editor', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_editor","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_EDITOR_XML_DESCRIPTION","group":"","filename":"editor"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(466, 0, 'plg_fields_imagelist', 'plugin', 'imagelist', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_imagelist","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_IMAGELIST_XML_DESCRIPTION","group":"","filename":"imagelist"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(467, 0, 'plg_fields_integer', 'plugin', 'integer', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_integer","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_INTEGER_XML_DESCRIPTION","group":"","filename":"integer"}', '{"multiple":"0","first":"1","last":"100","step":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(468, 0, 'plg_fields_list', 'plugin', 'list', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_list","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_LIST_XML_DESCRIPTION","group":"","filename":"list"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(469, 0, 'plg_fields_media', 'plugin', 'media', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_media","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_MEDIA_XML_DESCRIPTION","group":"","filename":"media"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(470, 0, 'plg_fields_radio', 'plugin', 'radio', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_radio","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_RADIO_XML_DESCRIPTION","group":"","filename":"radio"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(471, 0, 'plg_fields_sql', 'plugin', 'sql', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_sql","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_SQL_XML_DESCRIPTION","group":"","filename":"sql"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(472, 0, 'plg_fields_text', 'plugin', 'text', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_text","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_TEXT_XML_DESCRIPTION","group":"","filename":"text"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(473, 0, 'plg_fields_textarea', 'plugin', 'textarea', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_textarea","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_TEXTAREA_XML_DESCRIPTION","group":"","filename":"textarea"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(474, 0, 'plg_fields_url', 'plugin', 'url', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_url","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_URL_XML_DESCRIPTION","group":"","filename":"url"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(475, 0, 'plg_fields_user', 'plugin', 'user', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_user","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_USER_XML_DESCRIPTION","group":"","filename":"user"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(476, 0, 'plg_fields_usergrouplist', 'plugin', 'usergrouplist', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_usergrouplist","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_USERGROUPLIST_XML_DESCRIPTION","group":"","filename":"usergrouplist"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(477, 0, 'plg_content_fields', 'plugin', 'fields', 'content', 0, 1, 1, 0, '{"name":"plg_content_fields","type":"plugin","creationDate":"February 2017","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_CONTENT_FIELDS_XML_DESCRIPTION","group":"","filename":"fields"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(478, 0, 'plg_editors-xtd_fields', 'plugin', 'fields', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_fields","type":"plugin","creationDate":"February 2017","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_EDITORS-XTD_FIELDS_XML_DESCRIPTION","group":"","filename":"fields"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(480, 0, 'plg_system_sessiongc', 'plugin', 'sessiongc', 'system', 0, 1, 1, 0, '{"name":"plg_system_sessiongc","type":"plugin","creationDate":"February 2018","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.8.6","description":"PLG_SYSTEM_SESSIONGC_XML_DESCRIPTION","group":"","filename":"sessiongc"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(481, 0, 'plg_fields_repeatable', 'plugin', 'repeatable', 'fields', 0, 1, 1, 0, '{"name":"plg_fields_repeatable","type":"plugin","creationDate":"April 2018","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.9.0","description":"PLG_FIELDS_REPEATABLE_XML_DESCRIPTION","group":"","filename":"repeatable"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(482, 0, 'plg_content_confirmconsent', 'plugin', 'confirmconsent', 'content', 0, 0, 1, 0, '{"name":"plg_content_confirmconsent","type":"plugin","creationDate":"May 2018","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.9.0","description":"PLG_CONTENT_CONFIRMCONSENT_XML_DESCRIPTION","group":"","filename":"confirmconsent"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(483, 0, 'PLG_SYSTEM_ACTIONLOGS', 'plugin', 'actionlogs', 'system', 0, 0, 1, 0, '{"name":"PLG_SYSTEM_ACTIONLOGS","type":"plugin","creationDate":"May 2018","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.9.0","description":"PLG_SYSTEM_ACTIONLOGS_XML_DESCRIPTION","group":"","filename":"actionlogs"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(484, 0, 'PLG_ACTIONLOG_JOOMLA', 'plugin', 'joomla', 'actionlog', 0, 1, 1, 0, '{"name":"PLG_ACTIONLOG_JOOMLA","type":"plugin","creationDate":"May 2018","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.9.0","description":"PLG_ACTIONLOG_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(485, 0, 'plg_system_privacyconsent', 'plugin', 'privacyconsent', 'system', 0, 0, 1, 0, '{"name":"plg_system_privacyconsent","type":"plugin","creationDate":"April 2018","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.9.0","description":"PLG_SYSTEM_PRIVACYCONSENT_XML_DESCRIPTION","group":"","filename":"privacyconsent"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(486, 0, 'plg_system_logrotation', 'plugin', 'logrotation', 'system', 0, 1, 1, 0, '{"name":"plg_system_logrotation","type":"plugin","creationDate":"May 2018","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.9.0","description":"PLG_SYSTEM_LOGROTATION_XML_DESCRIPTION","group":"","filename":"logrotation"}', '{"lastrun":1580976906}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(487, 0, 'plg_privacy_user', 'plugin', 'user', 'privacy', 0, 1, 1, 0, '{"name":"plg_privacy_user","type":"plugin","creationDate":"May 2018","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.9.0","description":"PLG_PRIVACY_USER_XML_DESCRIPTION","group":"","filename":"user"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(488, 0, 'plg_quickicon_privacycheck', 'plugin', 'privacycheck', 'quickicon', 0, 1, 1, 0, '{"name":"plg_quickicon_privacycheck","type":"plugin","creationDate":"June 2018","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.9.0","description":"PLG_QUICKICON_PRIVACYCHECK_XML_DESCRIPTION","group":"","filename":"privacycheck"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(489, 0, 'plg_user_terms', 'plugin', 'terms', 'user', 0, 0, 1, 0, '{"name":"plg_user_terms","type":"plugin","creationDate":"June 2018","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.9.0","description":"PLG_USER_TERMS_XML_DESCRIPTION","group":"","filename":"terms"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(490, 0, 'plg_privacy_contact', 'plugin', 'contact', 'privacy', 0, 1, 1, 0, '{"name":"plg_privacy_contact","type":"plugin","creationDate":"July 2018","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.9.0","description":"PLG_PRIVACY_CONTACT_XML_DESCRIPTION","group":"","filename":"contact"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(491, 0, 'plg_privacy_content', 'plugin', 'content', 'privacy', 0, 1, 1, 0, '{"name":"plg_privacy_content","type":"plugin","creationDate":"July 2018","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.9.0","description":"PLG_PRIVACY_CONTENT_XML_DESCRIPTION","group":"","filename":"content"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(492, 0, 'plg_privacy_message', 'plugin', 'message', 'privacy', 0, 1, 1, 0, '{"name":"plg_privacy_message","type":"plugin","creationDate":"July 2018","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.9.0","description":"PLG_PRIVACY_MESSAGE_XML_DESCRIPTION","group":"","filename":"message"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(493, 0, 'plg_privacy_actionlogs', 'plugin', 'actionlogs', 'privacy', 0, 1, 1, 0, '{"name":"plg_privacy_actionlogs","type":"plugin","creationDate":"July 2018","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.9.0","description":"PLG_PRIVACY_ACTIONLOGS_XML_DESCRIPTION","group":"","filename":"actionlogs"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(494, 0, 'plg_captcha_recaptcha_invisible', 'plugin', 'recaptcha_invisible', 'captcha', 0, 0, 1, 0, '{"name":"plg_captcha_recaptcha_invisible","type":"plugin","creationDate":"November 2017","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.8","description":"PLG_CAPTCHA_RECAPTCHA_INVISIBLE_XML_DESCRIPTION","group":"","filename":"recaptcha_invisible"}', '{"public_key":"","private_key":"","theme":"clean"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(495, 0, 'plg_privacy_consents', 'plugin', 'consents', 'privacy', 0, 1, 1, 0, '{"name":"plg_privacy_consents","type":"plugin","creationDate":"July 2018","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.9.0","description":"PLG_PRIVACY_CONSENTS_XML_DESCRIPTION","group":"","filename":"consents"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(504, 0, 'hathor', 'template', 'hathor', '', 1, 1, 1, 0, '{"name":"hathor","type":"template","creationDate":"May 2010","author":"Andrea Tarr","copyright":"Copyright (C) 2005 - 2020 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"","version":"3.0.0","description":"TPL_HATHOR_XML_DESCRIPTION","group":"","filename":"templateDetails"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(600, 802, 'English (en-GB)', 'language', 'en-GB', '', 0, 1, 1, 1, '{"name":"English (en-GB)","type":"language","creationDate":"January 2020","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.9.15","description":"en-GB site language","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(601, 802, 'English (en-GB)', 'language', 'en-GB', '', 1, 1, 1, 1, '{"name":"English (en-GB)","type":"language","creationDate":"January 2020","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.9.15","description":"en-GB administrator language","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(700, 0, 'files_joomla', 'file', 'joomla', '', 0, 1, 1, 1, '{"name":"files_joomla","type":"file","creationDate":"January 2020","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.9.15","description":"FILES_JOOMLA_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(802, 0, 'English (en-GB) Language Pack', 'package', 'pkg_en-GB', '', 0, 1, 1, 1, '{"name":"English (en-GB) Language Pack","type":"package","creationDate":"January 2020","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.9.15.1","description":"en-GB language pack","group":"","filename":"pkg_en-GB"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10001, 0, 'JA T3 Framework', 'plugin', 'jat3', 'system', 0, 1, 1, 0, '{"name":"JA T3 Framework","type":"plugin","creationDate":"May 24, 2018","author":"www.JoomlArt.com","copyright":"Copyright (C), J.O.O.M Solutions Co., Ltd. All Rights Reserved.","authorEmail":"webmaster@joomlart.com","authorUrl":"http:\\/\\/www.joomlart.com","version":"2.7.6","description":"\\n\\t\\n\\t\\t<h1>T3 Framework - JoomlArt Template Framework for Joomla 2.5 and Joomla 3.x<\\/h1>\\n\\t\\t<div style=\'font-weight: normal\'>\\n\\t\\t<p><span style=\'color: #ff6600;\'>\\n\\t\\t<strong>Features:<\\/strong><\\/span>\\n\\t\\tThis plugin is required for JA T3 Framework based templates to work.<\\/p>\\n\\t\\t\\n\\t\\t<strong><span style=\'color: #ff0000;\'>Usage Instruction:<\\/span><\\/strong><br \\/>\\n\\t\\t<ul>\\n\\t\\t<li>Enable the JA T3 plugin in Plugin manager<\\/li>\\n\\t\\t<\\/ul>\\n\\t\\t<strong><span style=\'color: #ff0000;\'>Upgrade Method:<\\/span><br \\/><\\/strong>\\n\\t\\t<ul>\\n\\t\\t  <li>You can install new version directly over this version. Uninstallation is not required. <\\/li>\\n\\t\\t  <li>Follow upgrade instructions and backup site \\/ plugin before upgrading<\\/li>\\n\\t\\t  <\\/ul>\\n\\t\\n\\t\\t<span style=\'color: #008000;\'><strong>Links:<\\/strong><\\/span><br \\/>\\n\\t\\t<ul>\\n\\t\\t<li><a target=\\"_blank\\" href=\\"https:\\/\\/www.joomlart.com\\/documentation\\/wiki-ja-t3v2-joomla-2-5\\/developer-guide\\">Userguide<\\/a><\\/li>\\n\\t\\t <li><a target=\'_blank\' href=\'http:\\/\\/update.joomlart.com\\/\'>Updates &amp; Versions<\\/a><\\/li>\\n\\t\\t <li><a target=\'_blank\' href=\'http:\\/\\/www.joomlart.com\\/forums\\/forumdisplay.php?241\'>JA T3 Framework Forum<\\/a><\\/li>\\n\\t\\t<\\/ul>\\n\\t\\t<p>Copyright 2004 - 2018 <a href=\'http:\\/\\/www.joomlart.com\\/\' title=\'Visit Joomlart.com!\'>JoomlArt.com<\\/a>.<\\/p>\\n\\t\\t<\\/div>\\n\\t\\t\\n\\t\\t","group":"","filename":"jat3"}', '{}', '', '', 0, '0000-00-00 00:00:00', 1000, 0),
(10002, 0, 'com_jaextmanager', 'component', 'com_jaextmanager', '', 1, 1, 0, 0, '{"name":"com_jaextmanager","type":"component","creationDate":"May 29th, 2018","author":"JoomlArt","copyright":"Copyright (C), J.O.O.M Solutions Co., Ltd. All Rights Reserved.","authorEmail":"webmaster@joomlart.com","authorUrl":"http:\\/\\/www.joomlart.com","version":"2.6.4","description":"JA Extension Manager Component","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10013, 0, 'ja_elastica', 'template', 'ja_elastica', '', 0, 1, 1, 0, '{"name":"ja_elastica","type":"template","creationDate":"Nov 02, 2017","author":"JoomlArt.com","copyright":"Copyright (C), J.O.O.M Solutions Co., Ltd. All Rights Reserved.","authorEmail":"webmaster@joomlart.com","authorUrl":"http:\\/\\/www.joomlart.com","version":"2.5.7","description":"\\n<p>Joomlart broke new ground in the Joomla! community by unveiling <strong>JA Elastica<\\/strong>, the <strong>FIRST<\\/strong> Joomla! template with a <strong>Responsive Web Design and as our gift to the community, we offer it FREE! for all. Support forums are however restrcited to paid active members only.<\\/strong> <\\/p>\\n\\n<p>JA Elastica truly is one template to serve all.  With its exclusive Responsive coding, JA Elastica adapts and transforms to fit the screen area of any device - be it a 30 inch extra wide monitor to the smallest iPhone screen.\\n\\n<p>The template uses the <a href=\\u201dhttp:\\/\\/masonry.desandro.com\\/\\u201d>jQuery Masonry script<\\/a>.\\n<p>This template does not support RTL CSS style<\\/p>\\n\\n<p><strong>Resources :<\\/strong><\\/p>\\n\\n<p>|\\n<a href=\'http:\\/\\/www.joomlart.com\\/joomla\\/templates\\/ja-elastica\' title=\'Home\' target=\'_blank\' > Template Home Page<\\/a> |\\n<a href=\'http:\\/\\/joomla-templates.joomlart.com\\/ja_elastica\' title=\'Demo\' target=\'_blank\' > Demo<\\/a> |\\n<a href=\'http:\\/\\/www.joomlart.com\\/forums\\/forumdisplay.php?339\' title=\'forum\' target=\'_blank\' >Forum<\\/a> |\\n<a href=\'http:\\/\\/www.joomlart.com\\/documentation\\/joomla-templates\\/ja-elastica\' title=\'forum\' target=\'_blank\' >Documentation<\\/a> |<\\/p>\\n<p>\\n<a href=\'http:\\/\\/wiki.joomlart.com\\/wiki\\/JA_T3_Framework_2\\/Overview\' title=\'T3 wiki\' target=\'_blank\' >T3 Framework Wiki<\\/a> |\\n<a href=\'http:\\/\\/update.joomlart.com\' title=\'Updates\' target=\'_blank\' >Updates<\\/a> |\\n<a href=\'http:\\/\\/pm.joomlart.com\\/browse\\/JATCELASTICAJ17\' title=\'Changelog\' target=\'_blank\' >JIRA<\\/a> |\\n<a href=\'http:\\/\\/www.joomlart.com\\/forums\\/downloads.php?do=cat&id=20433\' title=\'Downloads\' target=\'_blank\' >Downloads<\\/a> |\\n<\\/p>\\n\\t\\t","group":"","filename":"templateDetails"}', '[]', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10014, 0, 'com_finder', 'component', 'com_finder', '', 1, 1, 1, 0, '{"name":"com_finder","type":"component","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_FINDER_XML_DESCRIPTION","group":"","filename":"finder"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10015, 0, 'LIB_JOOMLA', 'library', 'joomla', '', 0, 1, 1, 0, '{"name":"LIB_JOOMLA","type":"library","creationDate":"2008","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"https:\\/\\/www.joomla.org","version":"13.1","description":"LIB_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}', '{"mediaversion":"66ad6712912a1944f7e34091ad6f5437"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10016, 0, 'LIB_PHPUTF8', 'library', 'phputf8', '', 0, 1, 1, 0, '{"name":"LIB_PHPUTF8","type":"library","creationDate":"2006","author":"Harry Fuecks","copyright":"Copyright various authors","authorEmail":"hfuecks@gmail.com","authorUrl":"http:\\/\\/sourceforge.net\\/projects\\/phputf8","version":"0.5","description":"LIB_PHPUTF8_XML_DESCRIPTION","group":"","filename":"phputf8"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10017, 0, 'mod_finder', 'module', 'mod_finder', '', 0, 1, 1, 0, '{"name":"mod_finder","type":"module","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FINDER_XML_DESCRIPTION","group":"","filename":"mod_finder"}', '{"searchfilter":"","show_autosuggest":"1","show_advanced":"0","moduleclass_sfx":"","field_size":"25","show_label":"1","label_pos":"top","show_button":"0","button_pos":"right","opensearch":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10018, 0, 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', 1, 1, 1, 0, '{"name":"mod_multilangstatus","type":"module","creationDate":"September 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_MULTILANGSTATUS_XML_DESCRIPTION","group":"","filename":"mod_multilangstatus"}', '{"cache":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10019, 0, 'plg_captcha_recaptcha', 'plugin', 'recaptcha', 'captcha', 0, 1, 1, 0, '{"name":"plg_captcha_recaptcha","type":"plugin","creationDate":"December 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.4.0","description":"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION","group":"","filename":"recaptcha"}', '{"public_key":"","private_key":"","theme":"clean"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10020, 0, 'plg_content_finder', 'plugin', 'finder', 'content', 0, 0, 1, 0, '{"name":"plg_content_finder","type":"plugin","creationDate":"December 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_FINDER_XML_DESCRIPTION","group":"","filename":"finder"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10021, 0, 'plg_content_joomla', 'plugin', 'joomla', 'content', 0, 1, 1, 0, '{"name":"plg_content_joomla","type":"plugin","creationDate":"November 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}', '{"check_categories":"1","email_new_fe":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10022, 0, 'plg_finder_categories', 'plugin', 'categories', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_categories","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_CATEGORIES_XML_DESCRIPTION","group":"","filename":"categories"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10023, 0, 'plg_finder_contacts', 'plugin', 'contacts', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_contacts","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_CONTACTS_XML_DESCRIPTION","group":"","filename":"contacts"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10024, 0, 'plg_finder_content', 'plugin', 'content', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_content","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_CONTENT_XML_DESCRIPTION","group":"","filename":"content"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10025, 0, 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_newsfeeds","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION","group":"","filename":"newsfeeds"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10027, 0, 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', 'quickicon', 0, 1, 1, 0, '{"name":"plg_quickicon_extensionupdate","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION","group":"","filename":"extensionupdate"}', '{"context":"mod_quickicon"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10028, 0, 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', 'quickicon', 0, 1, 1, 0, '{"name":"plg_quickicon_joomlaupdate","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION","group":"","filename":"joomlaupdate"}', '{"context":"mod_quickicon"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10029, 0, 'plg_system_highlight', 'plugin', 'highlight', 'system', 0, 1, 1, 0, '{"name":"plg_system_highlight","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION","group":"","filename":"highlight"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10031, 0, 'plg_system_languagecode', 'plugin', 'languagecode', 'system', 0, 0, 1, 0, '{"name":"plg_system_languagecode","type":"plugin","creationDate":"November 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION","group":"","filename":"languagecode"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10032, 0, 'plg_system_logout', 'plugin', 'logout', 'system', 0, 1, 1, 0, '{"name":"plg_system_logout","type":"plugin","creationDate":"April 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION","group":"","filename":"logout"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10033, 0, 'plg_system_p3p', 'plugin', 'p3p', 'system', 0, 1, 1, 0, '{"name":"plg_system_p3p","type":"plugin","creationDate":"September 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_P3P_XML_DESCRIPTION","group":"","filename":"p3p"}', '{"header":"NOI ADM DEV PSAi COM NAV OUR OTRo STP IND DEM"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10034, 0, 'mod_version', 'module', 'mod_version', '', 1, 1, 1, 0, '{"name":"mod_version","type":"module","creationDate":"January 2012","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_VERSION_XML_DESCRIPTION","group":"","filename":"mod_version"}', '{"format":"short","product":"1","cache":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10035, 0, 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', 1, 1, 1, 0, '{"name":"com_joomlaupdate","type":"component","creationDate":"February 2012","author":"Joomla! Project","copyright":"(C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.6.2","description":"COM_JOOMLAUPDATE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10036, 0, 'beez3', 'template', 'beez3', '', 0, 1, 1, 0, '{"name":"beez3","type":"template","creationDate":"25 November 2009","author":"Angie Radtke","copyright":"Copyright (C) 2005 - 2020 Open Source Matters, Inc. All rights reserved.","authorEmail":"a.radtke@derauftritt.de","authorUrl":"http:\\/\\/www.der-auftritt.de","version":"3.1.0","description":"TPL_BEEZ3_XML_DESCRIPTION","group":"","filename":"templateDetails"}', '{"wrapperSmall":"53","wrapperLarge":"72","sitetitle":"","sitedescription":"","navposition":"center","templatecolor":"nature","backgroundcolor":"#eee"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10037, 0, 'protostar', 'template', 'protostar', '', 0, 1, 1, 0, '{"name":"protostar","type":"template","creationDate":"4\\/30\\/2012","author":"Kyle Ledbetter","copyright":"Copyright (C) 2005 - 2020 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"","version":"1.0","description":"TPL_PROTOSTAR_XML_DESCRIPTION","group":"","filename":"templateDetails"}', '{"templateColor":"#08C","templateBackgroundColor":"#F4F6F7","logoFile":"","sitetitle":"","sitedescription":"","googleFont":"1","googleFontName":"Open+Sans","fluidContainer":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10038, 0, 'isis', 'template', 'isis', '', 1, 1, 1, 0, '{"name":"isis","type":"template","creationDate":"3\\/30\\/2012","author":"Kyle Ledbetter","copyright":"Copyright (C) 2005 - 2020 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"","version":"1.0","description":"TPL_ISIS_XML_DESCRIPTION","group":"","filename":"templateDetails"}', '{"templateColor":"#13294A","headerColor":"#184A7D","logoFile":"","admin_menus":"1","displayHeader":"1","statusFixed":"1","stickyToolbar":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10039, 0, 'mod_stats_admin', 'module', 'mod_stats_admin', '', 1, 1, 1, 0, '{"name":"mod_stats_admin","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_STATS_XML_DESCRIPTION","group":"","filename":"mod_stats_admin"}', '{"serverinfo":"0","siteinfo":"0","counter":"0","increase":"0","cache":"1","cache_time":"900","cachemode":"static"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10040, 0, 'LIB_IDNA', 'library', 'idna_convert', '', 0, 1, 1, 0, '{"name":"LIB_IDNA","type":"library","creationDate":"2004","author":"phlyLabs","copyright":"2004-2011 phlyLabs Berlin, http:\\/\\/phlylabs.de","authorEmail":"phlymail@phlylabs.de","authorUrl":"http:\\/\\/phlylabs.de","version":"0.8.0","description":"LIB_IDNA_XML_DESCRIPTION","group":"","filename":"idna_convert"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10041, 0, 'LIB_PHPASS', 'library', 'phpass', '', 0, 1, 1, 0, '{"name":"LIB_PHPASS","type":"library","creationDate":"2004-2006","author":"Solar Designer","copyright":"","authorEmail":"solar@openwall.com","authorUrl":"http:\\/\\/www.openwall.com\\/phpass\\/","version":"0.3","description":"LIB_PHPASS_XML_DESCRIPTION","group":"","filename":"phpass"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10043, 0, 'plg_content_contact', 'plugin', 'contact', 'content', 0, 0, 1, 0, '{"name":"plg_content_contact","type":"plugin","creationDate":"January 2014","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.2","description":"PLG_CONTENT_CONTACT_XML_DESCRIPTION","group":"","filename":"contact"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10044, 0, 'English (en-GB) Language Pack', 'package', 'pkg_en-GB', '', 0, 1, 1, 1, '{"name":"English (en-GB) Language Pack","type":"package","creationDate":"January 2020","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.9.15.1","description":"en-GB language pack","group":"","filename":"pkg_en-GB"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10045, 0, 'mod_sampledata', 'module', 'mod_sampledata', '', 1, 1, 1, 0, '{"name":"mod_sampledata","type":"module","creationDate":"July 2017","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.8.0","description":"MOD_SAMPLEDATA_XML_DESCRIPTION","group":"","filename":"mod_sampledata"}', '[]', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10046, 0, 'plg_sampledata_blog', 'plugin', 'blog', 'sampledata', 0, 0, 1, 0, '{"name":"plg_sampledata_blog","type":"plugin","creationDate":"July 2017","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.8.0","description":"PLG_SAMPLEDATA_BLOG_XML_DESCRIPTION","group":"","filename":"blog"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0);

DROP TABLE IF EXISTS `#__fields`;
CREATE TABLE `#__fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0,
  `context` varchar(255) NOT NULL DEFAULT '',
  `group_id` int(10) unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `label` varchar(255) NOT NULL DEFAULT '',
  `default_value` text NOT NULL,
  `type` varchar(255) NOT NULL DEFAULT 'text',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT 0,
  `required` tinyint(1) NOT NULL DEFAULT 0,
  `checked_out` int(11) NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT 0,
  `params` text NOT NULL,
  `fieldparams` text NOT NULL,
  `language` char(7) NOT NULL DEFAULT '',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `access` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_user_id` (`created_user_id`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `#__fields_categories`;
CREATE TABLE `#__fields_categories` (
  `field_id` int(11) NOT NULL DEFAULT 0,
  `category_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`field_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `#__fields_groups`;
CREATE TABLE `#__fields_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0,
  `context` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT 0,
  `checked_out` int(11) NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT 0,
  `params` text NOT NULL,
  `language` char(7) NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `access` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `#__fields_values`;
CREATE TABLE `#__fields_values` (
  `field_id` int(10) unsigned NOT NULL,
  `item_id` varchar(255) NOT NULL COMMENT 'Allow references to items which have strings as ids, eg. none db systems.',
  `value` text NOT NULL,
  KEY `idx_field_id` (`field_id`),
  KEY `idx_item_id` (`item_id`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `#__jaem_services`;
CREATE TABLE `#__jaem_services` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ws_name` varchar(255) NOT NULL,
  `ws_mode` varchar(50) NOT NULL DEFAULT 'local',
  `ws_uri` varchar(255) NOT NULL,
  `ws_user` varchar(100) NOT NULL,
  `ws_pass` varchar(100) NOT NULL,
  `ws_default` tinyint(1) NOT NULL DEFAULT 0,
  `ws_core` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `#__jaem_services` (`id`, `ws_name`, `ws_mode`, `ws_uri`, `ws_user`, `ws_pass`, `ws_default`, `ws_core`) VALUES
(1, 'Local Service', 'local', '', '', '', 1, 1),
(2, 'JoomlArt Updates', 'remote', 'http://update.joomlart.com/service/', '', '', 0, 1);

DROP TABLE IF EXISTS `#__languages`;
CREATE TABLE `#__languages` (
  `lang_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0,
  `lang_code` char(7) binary NOT NULL,
  `title` varchar(50) NOT NULL,
  `title_native` varchar(50) NOT NULL,
  `sef` varchar(50) NOT NULL,
  `image` varchar(50) NOT NULL,
  `description` varchar(512) NOT NULL,
  `metakey` mediumtext NOT NULL,
  `metadesc` mediumtext NOT NULL,
  `sitename` varchar(1024) NOT NULL DEFAULT '',
  `published` int(11) NOT NULL DEFAULT 0,
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`lang_id`),
  UNIQUE KEY `idx_sef` (`sef`),
  UNIQUE KEY `idx_langcode` (`lang_code`),
  KEY `idx_ordering` (`ordering`),
  KEY `idx_access` (`access`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `#__languages` (`lang_id`, `asset_id`, `lang_code`, `title`, `title_native`, `sef`, `image`, `description`, `metakey`, `metadesc`, `sitename`, `published`, `access`, `ordering`) VALUES
(1, 0, 'en-GB', 'English (UK)', 'English (UK)', 'en', 'en', '', '', '', '', 1, 0, 0),
(3, 0, 'xx-XX', 'xx (Test)', 'xx (Test)', 'xx', 'br', '', '', '', '', -2, 0, 0);

DROP TABLE IF EXISTS `#__menu`;
CREATE TABLE `#__menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menutype` varchar(24) NOT NULL COMMENT 'The type of menu this item belongs to. FK to #__menu_types.menutype',
  `title` varchar(255) NOT NULL COMMENT 'The display title of the menu item.',
  `alias` varchar(400) binary NOT NULL COMMENT 'The SEF alias of the menu item.',
  `note` varchar(255) NOT NULL DEFAULT '',
  `path` varchar(1024) NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',
  `link` varchar(1024) NOT NULL COMMENT 'The actually link the menu item refers to.',
  `type` varchar(16) NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',
  `published` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'The published state of the menu link.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT 1 COMMENT 'The parent menu item in the menu tree.',
  `level` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'The relative level in the tree.',
  `component_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to #__extensions.id',
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to #__users.id',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'The time the menu item was checked out.',
  `browserNav` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'The click behaviour of the link.',
  `access` int(10) unsigned DEFAULT NULL,
  `img` varchar(255) NOT NULL COMMENT 'The image of the menu item.',
  `template_style_id` int(10) unsigned NOT NULL DEFAULT 0,
  `params` varchar(10240) NOT NULL COMMENT 'JSON encoded data for the menu item.',
  `lft` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set rgt.',
  `home` tinyint(3) unsigned NOT NULL DEFAULT 0 COMMENT 'Indicates if this menu item is the home or default page.',
  `language` char(7) NOT NULL DEFAULT '',
  `client_id` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_client_id_parent_id_alias_language` (`client_id`,`parent_id`,`alias`(100),`language`),
  KEY `idx_componentid` (`component_id`,`menutype`,`published`,`access`),
  KEY `idx_menutype` (`menutype`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_path` (`path`(100))
) ENGINE=InnoDB AUTO_INCREMENT=559 DEFAULT CHARSET=utf8;

INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(1, '', 'Menu_Item_Root', 'root', '', '', '', '', 1, 0, 0, 0, 0, '0000-00-00 00:00:00', 0, 0, '', 0, '', 0, 311, 0, '*', 0),
(2, 'main', 'com_banners', 'Banners', '', 'Banners', 'index.php?option=com_banners', 'component', 1, 1, 1, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 3, 12, 0, '*', 1),
(3, 'main', 'com_banners', 'Banners', '', 'Banners/Banners', 'index.php?option=com_banners', 'component', 1, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 4, 5, 0, '*', 1),
(4, 'main', 'com_banners_categories', 'Categories', '', 'Banners/Categories', 'index.php?option=com_categories&extension=com_banners', 'component', 1, 2, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-cat', 0, '', 6, 7, 0, '*', 1),
(5, 'main', 'com_banners_clients', 'Clients', '', 'Banners/Clients', 'index.php?option=com_banners&view=clients', 'component', 1, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-clients', 0, '', 8, 9, 0, '*', 1),
(6, 'main', 'com_banners_tracks', 'Tracks', '', 'Banners/Tracks', 'index.php?option=com_banners&view=tracks', 'component', 1, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-tracks', 0, '', 10, 11, 0, '*', 1),
(7, 'main', 'com_contact', 'Contacts', '', 'Contacts', 'index.php?option=com_contact', 'component', 1, 1, 1, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 13, 18, 0, '*', 1),
(8, 'main', 'com_contact_contacts', 'Contacts', '', 'Contacts/Contacts', 'index.php?option=com_contact', 'component', 1, 7, 2, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 14, 15, 0, '*', 1),
(9, 'main', 'com_contact_categories', 'Categories', '', 'Contacts/Categories', 'index.php?option=com_categories&extension=com_contact', 'component', 1, 7, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact-cat', 0, '', 16, 17, 0, '*', 1),
(10, 'main', 'com_messages', 'Messaging', '', 'Messaging', 'index.php?option=com_messages', 'component', 1, 1, 1, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages', 0, '', 19, 24, 0, '*', 1),
(11, 'main', 'com_messages_add', 'New Private Message', '', 'Messaging/New Private Message', 'index.php?option=com_messages&task=message.add', 'component', 1, 10, 2, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages-add', 0, '', 20, 21, 0, '*', 1),
(13, 'main', 'com_newsfeeds', 'News Feeds', '', 'News Feeds', 'index.php?option=com_newsfeeds', 'component', 1, 1, 1, 17, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds', 0, '', 25, 30, 0, '*', 1),
(14, 'main', 'com_newsfeeds_feeds', 'Feeds', '', 'News Feeds/Feeds', 'index.php?option=com_newsfeeds', 'component', 1, 13, 2, 17, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds', 0, '', 26, 27, 0, '*', 1),
(15, 'main', 'com_newsfeeds_categories', 'Categories', '', 'News Feeds/Categories', 'index.php?option=com_categories&extension=com_newsfeeds', 'component', 1, 13, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds-cat', 0, '', 28, 29, 0, '*', 1),
(16, 'main', 'com_redirect', 'Redirect', '', 'Redirect', 'index.php?option=com_redirect', 'component', 1, 1, 1, 24, 0, '0000-00-00 00:00:00', 0, 0, 'class:redirect', 0, '', 37, 38, 0, '*', 1),
(17, 'main', 'com_search', 'Search', '', 'Search', 'index.php?option=com_search', 'component', 1, 1, 1, 19, 0, '0000-00-00 00:00:00', 0, 0, 'class:search', 0, '', 31, 32, 0, '*', 1),
(201, 'usermenu', 'Your Profile', 'your-profile', '', 'your-profile', 'index.php?option=com_users&view=profile', 'component', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 211, 212, 0, '*', 0),
(207, 'top', 'Joomla.org', 'joomlaorg', '', 'joomlaorg', 'http://joomla.org', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":""}', 209, 210, 0, '*', 0),
(229, 'aboutjoomla', 'Single Contact', 'single-contact', '', 'using-joomla/extensions/components/contact-component/single-contact', 'index.php?option=com_contact&view=contact&id=1', 'component', 1, 270, 5, 8, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_category_crumb":"","presentation_style":"","show_contact_category":"","show_contact_list":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_links":"","linka_name":"","linkb_name":"","linkc_name":"","linkd_name":"","linke_name":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 63, 64, 0, '*', 0),
(234, 'parks', 'Park Blog', 'park-blog', '', 'park-blog', 'index.php?option=com_content&view=category&layout=blog&id=27', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"maxLevel":"","show_empty_categories":"","show_description":"1","show_description_image":"1","show_category_title":"","show_cat_num_articles":"","num_leading_articles":"1","num_intro_articles":"4","num_columns":"1","num_links":"4","multi_column_order":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"2","show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_feed_link":"1","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 215, 216, 0, 'en-GB', 0),
(242, 'parks', 'Write a Blog Post', 'write-a-blog-post', '', 'write-a-blog-post', 'index.php?option=com_content&view=form&layout=edit', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 3, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 217, 218, 0, 'en-GB', 0),
(243, 'parks', 'Parks Home', 'parks-home', '', 'parks-home', 'index.php?option=com_content&view=article&id=6', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"0","link_titles":"","show_intro":"","show_category":"0","link_category":"0","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"0","show_icons":"","show_print_icon":"0","show_email_icon":"0","show_hits":"0","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 213, 214, 0, 'en-GB', 0),
(244, 'parks', 'Image Gallery', 'image-gallery', '', 'image-gallery', 'index.php?option=com_content&view=categories&id=28', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_base_description":"1","categories_description":"","maxLevelcat":"","show_empty_categories_cat":"","show_subcat_desc_cat":"","show_cat_num_articles_cat":"","drill_down_layout":"1","show_category_title":"","show_description":"1","show_description_image":"1","maxLevel":"-1","show_empty_categories":"","show_subcat_desc":"","show_cat_num_articles":"","num_leading_articles":"1","num_intro_articles":"4","num_columns":"2","num_links":"4","multi_column_order":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_pagination_limit":"","filter_field":"","show_headings":"","list_show_date":"","date_format":"","list_show_hits":"","list_show_author":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 219, 224, 0, 'en-GB', 0),
(251, 'aboutjoomla', 'Contact Categories', 'contact-categories', '', 'using-joomla/extensions/components/contact-component/contact-categories', 'index.php?option=com_contact&view=categories&id=16', 'component', 1, 270, 5, 8, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_base_description":"","categories_description":"","maxLevel":"-1","show_empty_categories":"","show_description":"","show_description_image":"","show_cat_num_articles":"","display_num":"","show_headings":"","filter_field":"","show_pagination":"","show_noauth":"","presentation_style":"sliders","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_links":"1","linka_name":"","linkb_name":"","linkc_name":"","linkd_name":"","linke_name":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 59, 60, 0, '*', 0),
(252, 'aboutjoomla', 'News Feed Categories', 'new-feed-categories', '', 'using-joomla/extensions/components/news-feeds-component/new-feed-categories', 'index.php?option=com_newsfeeds&view=categories&id=0', 'component', 1, 267, 5, 17, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_base_description":"1","categories_description":"Because this links to the root category the \\"uncategorised\\" category is displayed. ","maxLevel":"-1","show_empty_categories":"1","show_description":"1","show_description_image":"1","show_cat_num_articles":"1","display_num":"","show_headings":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_noauth":"","show_feed_image":"","show_feed_description":"","show_item_description":"","feed_character_count":"0","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 69, 70, 0, '*', 0),
(253, 'aboutjoomla', 'News Feed Category', 'news-feed-category', '', 'using-joomla/extensions/components/news-feeds-component/news-feed-category', 'index.php?option=com_newsfeeds&view=category&id=17', 'component', 1, 267, 5, 17, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"maxLevel":"-1","show_empty_categories":"","show_description":"","show_description_image":"","show_cat_num_articles":"","display_num":"","show_headings":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_noauth":"","show_feed_image":"","show_feed_description":"","show_item_description":"","feed_character_count":"0","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 73, 74, 0, '*', 0),
(254, 'aboutjoomla', 'Single News Feed', 'single-news-feed', '', 'using-joomla/extensions/components/news-feeds-component/single-news-feed', 'index.php?option=com_newsfeeds&view=newsfeed&id=4', 'component', 1, 267, 5, 17, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_feed_image":"","show_feed_description":"","show_item_description":"","feed_character_count":"0","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 71, 72, 0, '*', 0),
(255, 'aboutjoomla', 'Search', 'search', '', 'using-joomla/extensions/components/search-component/search', 'index.php?option=com_search&view=search', 'component', 1, 276, 5, 19, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"search_areas":"1","show_date":"1","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 91, 92, 0, '*', 0),
(256, 'aboutjoomla', 'Archived articles', 'archived-articles', '', 'using-joomla/extensions/components/content-component/archived-articles', 'index.php?option=com_content&view=archive', 'component', 1, 266, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"orderby_sec":"","order_date":"","display_num":"","filter_field":"","show_category":"1","link_category":"1","show_title":"1","link_titles":"1","show_intro":"1","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_readmore":"","show_hits":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 53, 54, 0, '*', 0),
(257, 'aboutjoomla', 'Single Article', 'single-article', '', 'using-joomla/extensions/components/content-component/single-article', 'index.php?option=com_content&view=article&id=6', 'component', 1, 266, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 43, 44, 0, '*', 0),
(259, 'aboutjoomla', 'Article Category Blog', 'article-category-blog', '', 'using-joomla/extensions/components/content-component/article-category-blog', 'index.php?option=com_content&view=category&layout=blog&id=27', 'component', 1, 266, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"maxLevel":"","show_empty_categories":"","show_description":"0","show_description_image":"0","show_category_title":"","show_cat_num_articles":"","num_leading_articles":"1","num_intro_articles":"4","num_columns":"2","num_links":"4","multi_column_order":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"2","show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_feed_link":"1","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 47, 48, 0, '*', 0),
(260, 'aboutjoomla', 'Article Category List', 'article-category-list', '', 'using-joomla/extensions/components/content-component/article-category-list', 'index.php?option=com_content&view=category&id=19', 'component', 1, 266, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"maxLevel":"","show_category_title":"","page_subheading":"","show_empty_categories":"","show_description":"","show_description_image":"","show_cat_num_articles":"","display_num":"","show_headings":"","list_show_title":"","list_show_date":"","date_format":"","list_show_hits":"","list_show_author":"","filter_field":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_limit":"","show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","article-allow_ratings":"","article-allow_comments":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 49, 50, 0, '*', 0),
(262, 'aboutjoomla', 'Featured Articles', 'featured-articles', '', 'using-joomla/extensions/components/content-component/featured-articles', 'index.php?option=com_content&view=featured', 'component', 1, 266, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"maxLevel":"","show_empty_categories":"","show_description":"","show_description_image":"","show_cat_num_articles":"","num_leading_articles":"1","num_intro_articles":"4","num_columns":"2","num_links":"4","multi_column_order":"1","orderby_pri":"","orderby_sec":"front","order_date":"","show_pagination":"2","show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_feed_link":"1","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 51, 52, 0, '*', 0),
(263, 'aboutjoomla', 'Submit Article', 'submit-article', '', 'using-joomla/extensions/components/content-component/submit-article', 'index.php?option=com_content&view=form&layout=edit', 'component', 1, 266, 5, 22, 0, '0000-00-00 00:00:00', 0, 3, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 55, 56, 0, '*', 0),
(266, 'aboutjoomla', 'Content Component', 'content-component', '', 'using-joomla/extensions/components/content-component', 'index.php?option=com_content&view=article&id=10', 'component', 1, 268, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"article-allow_ratings":"","article-allow_comments":"","show_category":"","link_category":"","show_title":"","link_titles":"","show_intro":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 42, 57, 0, '*', 0),
(267, 'aboutjoomla', 'News Feeds Component', 'news-feeds-component', '', 'using-joomla/extensions/components/news-feeds-component', 'index.php?option=com_content&view=article&id=60', 'component', 1, 268, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":1,"page_title":"Newsfeeds Categories View ","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 68, 75, 0, '*', 0),
(268, 'aboutjoomla', 'Components', 'components', '', 'using-joomla/extensions/components', 'index.php?option=com_content&view=category&layout=blog&id=21', 'component', 1, 277, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_category_title":"","show_description":"1","show_description_image":"","maxLevel":"","show_empty_categories":"","show_subcat_desc":"","show_cat_num_articles":"","page_subheading":"","num_leading_articles":"0","num_intro_articles":"7","num_columns":"1","num_links":"0","multi_column_order":"","orderby_pri":"","orderby_sec":"order","order_date":"","show_pagination":"0","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","show_category":"0","link_category":"","show_parent_category":"0","link_parent_category":"","show_author":"0","link_author":"0","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"0","show_readmore":"","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"0","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 41, 96, 0, '*', 0),
(270, 'aboutjoomla', 'Contact Component', 'contact-component', '', 'using-joomla/extensions/components/contact-component', 'index.php?option=com_content&view=article&id=9', 'component', 1, 268, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 58, 67, 0, '*', 0),
(271, 'aboutjoomla', 'Users Component', 'users-component', '', 'using-joomla/extensions/components/users-component', 'index.php?option=com_content&view=article&id=52', 'component', 1, 268, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 76, 89, 0, '*', 0),
(272, 'aboutjoomla', 'Article Categories', 'article-categories', '', 'using-joomla/extensions/components/content-component/article-categories', 'index.php?option=com_content&view=categories&id=14', 'component', 1, 266, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_base_description":"","categories_description":"","maxLevel":"-1","show_empty_categories":"","show_description":"","show_description_image":"","show_cat_num_articles":"","display_num":"","category_layout":"","show_headings":"","show_date":"","date_format":"","filter_field":"","num_leading_articles":"1","num_intro_articles":"4","num_columns":"2","num_links":"4","multi_column_order":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 45, 46, 0, '*', 0),
(273, 'aboutjoomla', 'Administrator Components', 'administrator-components', '', 'using-joomla/extensions/components/administrator-components', 'index.php?option=com_content&view=article&id=1', 'component', 1, 268, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 94, 95, 0, '*', 0),
(275, 'aboutjoomla', 'Contact Single Category', 'contact-single-category', '', 'using-joomla/extensions/components/contact-component/contact-single-category', 'index.php?option=com_contact&view=category&catid=26&id=36', 'component', 1, 270, 5, 8, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"maxLevel":"-1","show_empty_categories":"","show_description":"","show_description_image":"","show_cat_num_articles":"","display_num":"20","show_headings":"","filter_field":"","show_pagination":"","show_noauth":"","presentation_style":"sliders","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_links":"1","linka_name":"","linkb_name":"","linkc_name":"","linkd_name":"","linke_name":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":"","show_feed_link":"1","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 61, 62, 0, '*', 0),
(276, 'aboutjoomla', 'Search Component', 'search-component', '', 'using-joomla/extensions/components/search-component', 'index.php?option=com_content&view=article&id=39', 'component', 1, 268, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 90, 93, 0, '*', 0),
(277, 'aboutjoomla', 'Using Extensions', 'extensions', '', 'using-joomla/extensions', 'index.php?option=com_content&view=categories&id=20', 'component', 1, 280, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_base_description":"1","categories_description":"","maxLevelcat":"1","show_empty_categories_cat":"1","show_subcat_desc_cat":"1","show_cat_num_articles_cat":"0","drill_down_layout":"0","show_category_title":"","show_description":"1","show_description_image":"1","maxLevel":"1","show_empty_categories":"1","show_subcat_desc":"","show_cat_num_articles":"","num_leading_articles":"1","num_intro_articles":"4","num_columns":"2","num_links":"4","multi_column_order":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_pagination_limit":"","filter_field":"","show_headings":"","list_show_date":"","date_format":"","list_show_hits":"","list_show_author":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 40, 197, 0, '*', 0),
(278, 'aboutjoomla', 'The Joomla! Project', 'the-joomla-project', '', 'the-joomla-project', 'index.php?option=com_content&view=article&id=48', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"1","link_titles":"","show_intro":"","show_category":"0","link_category":"","show_parent_category":"0","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"0","show_icons":"1","show_print_icon":"","show_email_icon":"","show_hits":"0","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 205, 206, 0, '*', 0),
(279, 'aboutjoomla', 'The Joomla! Community', 'the-joomla-community', '', 'the-joomla-community', 'index.php?option=com_content&view=article&id=47', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"0","show_intro":"","show_category":"0","link_category":"","show_parent_category":"0","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"0","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 207, 208, 0, '*', 0),
(280, 'aboutjoomla', 'Using Joomla!', 'using-joomla', '', 'using-joomla', 'index.php?option=com_content&view=article&id=53', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 117, '{"show_title":"1","link_titles":"0","show_intro":"1","show_category":"0","link_category":"","show_parent_category":"0","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"0","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"0","show_noauth":"0","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 39, 202, 0, '*', 0),
(281, 'aboutjoomla', 'Modules', 'modules', '', 'using-joomla/extensions/modules', 'index.php?option=com_content&view=categories&id=22', 'component', 1, 277, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_base_description":"1","categories_description":"","maxLevelcat":"1","show_empty_categories_cat":"","show_subcat_desc_cat":"1","show_cat_num_articles_cat":"","drill_down_layout":"0","show_category_title":"","show_description":"1","show_description_image":"1","maxLevel":"1","show_empty_categories":"1","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","num_leading_articles":"0","num_intro_articles":"5","num_columns":"1","num_links":"0","multi_column_order":"","orderby_pri":"order","orderby_sec":"order","order_date":"","show_pagination":"","show_pagination_results":"","show_pagination_limit":"","filter_field":"","show_headings":"","list_show_date":"","date_format":"","list_show_hits":"","list_show_author":"","show_title":"1","link_titles":"","show_intro":"","show_category":"0","link_category":"0","show_parent_category":"0","link_parent_category":"","show_author":"0","link_author":"0","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"0","show_vote":"","show_readmore":"0","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"0","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 97, 152, 0, '*', 0),
(282, 'aboutjoomla', 'Templates', 'templates', '', 'using-joomla/extensions/templates', 'index.php?option=com_content&view=categories&id=23', 'component', 1, 277, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_base_description":"1","categories_description":"","maxLevel":"2","show_empty_categories":"1","show_description":"1","show_description_image":"","show_cat_num_articles":"","display_num":"","category_layout":"","show_headings":"","show_date":"","date_format":"","filter_field":"","num_leading_articles":"0","num_intro_articles":"4","num_columns":"2","num_links":"4","multi_column_order":"","orderby_pri":"","orderby_sec":"order","order_date":"","show_pagination":"0","show_noauth":"","show_title":"1","link_titles":"1","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"Templates","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 153, 178, 0, '*', 0),
(283, 'aboutjoomla', 'Languages', 'languages', '', 'using-joomla/extensions/languages', 'index.php?option=com_content&view=category&layout=blog&id=24', 'component', 1, 277, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"maxLevel":"","show_empty_categories":"","show_description":"1","show_description_image":"1","show_category_title":"1","show_cat_num_articles":"","num_leading_articles":"1","num_intro_articles":"4","num_columns":"2","num_links":"4","multi_column_order":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 179, 180, 0, '*', 0),
(284, 'aboutjoomla', 'Plugins', 'plugins', '', 'using-joomla/extensions/plugins', 'index.php?option=com_content&view=category&layout=blog&id=25', 'component', 1, 277, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"maxLevel":"","show_empty_categories":"","show_description":"1","show_description_image":"","show_category_title":"1","show_cat_num_articles":"","num_leading_articles":"0","num_intro_articles":"7","num_columns":"1","num_links":"0","multi_column_order":"","orderby_pri":"","orderby_sec":"order","order_date":"","show_pagination":"","show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"0","link_category":"0","show_parent_category":"0","link_parent_category":"0","show_author":"0","link_author":"","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"","show_readmore":"","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"0","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 181, 196, 0, '*', 0),
(285, 'aboutjoomla', 'Typography Atomic', 'typography-atomic', '', 'using-joomla/extensions/templates/atomic/typography-atomic', 'index.php?option=com_content&view=article&id=49', 'component', 1, 422, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 3, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 167, 168, 0, '*', 0),
(286, 'aboutjoomla', 'Typography Milky Way', 'typography-milky-way', '', 'using-joomla/extensions/templates/milky-way/typography-milky-way', 'index.php?option=com_content&view=article&id=49', 'component', 1, 421, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 1, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"0","link_category":"0","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"","show_icons":"1","show_print_icon":"1","show_email_icon":"1","show_hits":"0","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 173, 174, 0, '*', 0),
(296, 'parks', 'Park Links', 'park-links', '', 'park-links', 'index.php?option=com_weblinks&view=category&id=31', 'component', 1, 1, 1, 21, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"maxLevel":"-1","show_empty_categories":"","show_description":"1","show_description_image":"1","show_cat_num_articles":"","display_num":"","show_headings":"0","orderby_pri":"","show_pagination":"","show_noauth":"","show_feed_link":"1","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 225, 226, 0, 'en-GB', 0),
(300, 'aboutjoomla', 'Latest Users', 'latest-users', '', 'using-joomla/extensions/modules/user-modules/latest-users', 'index.php?option=com_content&view=article&id=66', 'component', 1, 412, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 119, 120, 0, '*', 0),
(301, 'aboutjoomla', 'Who\'s Online', 'whos-online', '', 'using-joomla/extensions/modules/user-modules/whos-online', 'index.php?option=com_content&view=article&id=56', 'component', 1, 412, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 121, 122, 0, '*', 0),
(302, 'aboutjoomla', 'Most Read', 'most-read', '', 'using-joomla/extensions/modules/content-modules/most-read', 'index.php?option=com_content&view=article&id=30', 'component', 1, 411, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 103, 104, 0, '*', 0),
(303, 'aboutjoomla', 'Menu', 'menu', '', 'using-joomla/extensions/modules/menu-modules/menu', 'index.php?option=com_content&view=article&id=29', 'component', 1, 415, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 99, 100, 0, '*', 0),
(304, 'aboutjoomla', 'Statistics', 'statistics', '', 'using-joomla/extensions/modules/utility-modules/statistics', 'index.php?option=com_content&view=article&id=44', 'component', 1, 414, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 143, 144, 0, '*', 0),
(305, 'aboutjoomla', 'Banner', 'banner', '', 'using-joomla/extensions/modules/display-modules/banner', 'index.php?option=com_content&view=article&id=7', 'component', 1, 413, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 129, 130, 0, '*', 0),
(306, 'aboutjoomla', 'Search', 'search', '', 'using-joomla/extensions/modules/utility-modules/search', 'index.php?option=com_content&view=article&id=40', 'component', 1, 414, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 145, 146, 0, '*', 0),
(307, 'aboutjoomla', 'Random Image', 'random-image', '', 'using-joomla/extensions/modules/display-modules/random-image', 'index.php?option=com_content&view=article&id=36', 'component', 1, 413, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 127, 128, 0, '*', 0),
(309, 'aboutjoomla', 'News Flash', 'news-flash', '', 'using-joomla/extensions/modules/content-modules/news-flash', 'index.php?option=com_content&view=article&id=31', 'component', 1, 411, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 105, 106, 0, '*', 0),
(310, 'aboutjoomla', 'Latest Articles', 'latest-articles', '', 'using-joomla/extensions/modules/content-modules/latest-articles', 'index.php?option=com_content&view=article&id=27', 'component', 1, 411, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 107, 108, 0, '*', 0),
(311, 'aboutjoomla', 'Syndicate', 'syndicate', '', 'using-joomla/extensions/modules/utility-modules/syndicate', 'index.php?option=com_content&view=article&id=45', 'component', 1, 414, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 141, 142, 0, '*', 0);
INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(312, 'aboutjoomla', 'Login', 'login', '', 'using-joomla/extensions/modules/user-modules/login', 'index.php?option=com_content&view=article&id=28', 'component', 1, 412, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 123, 124, 0, '*', 0),
(313, 'aboutjoomla', 'Wrapper', 'wrapper', '', 'using-joomla/extensions/modules/display-modules/wrapper', 'index.php?option=com_content&view=article&id=59', 'component', 1, 413, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 135, 136, 0, '*', 0),
(316, 'aboutjoomla', 'Home Page Atomic', 'home-page-atomic', '', 'using-joomla/extensions/templates/atomic/home-page-atomic', 'index.php?option=com_content&view=featured', 'component', 1, 422, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 3, '{"maxLevel":"","show_empty_categories":"","show_description":"","show_description_image":"","show_cat_num_articles":"","num_leading_articles":"1","num_intro_articles":"3","num_columns":"3","num_links":"0","multi_column_order":"1","orderby_pri":"","orderby_sec":"front","order_date":"","show_pagination":"2","show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_feed_link":"1","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 169, 170, 0, '*', 0),
(317, 'aboutjoomla', 'System', 'system', '', 'using-joomla/extensions/plugins/system', 'index.php?option=com_content&view=article&id=46', 'component', 1, 284, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 194, 195, 0, '*', 0),
(318, 'aboutjoomla', 'Authentication', 'authentication', '', 'using-joomla/extensions/plugins/authentication', 'index.php?option=com_content&view=article&id=5', 'component', 1, 284, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 182, 183, 0, '*', 0),
(319, 'aboutjoomla', 'Content', 'content', '', 'using-joomla/extensions/plugins/content', 'index.php?option=com_content&view=article&id=62', 'component', 1, 284, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 184, 185, 0, '*', 0),
(320, 'aboutjoomla', 'Editors', 'editors', '', 'using-joomla/extensions/plugins/editors', 'index.php?option=com_content&view=article&id=14', 'component', 1, 284, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 186, 187, 0, '*', 0),
(321, 'aboutjoomla', 'Editors Extended', 'editors-extended', '', 'using-joomla/extensions/plugins/editors-extended', 'index.php?option=com_content&view=article&id=15', 'component', 1, 284, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 188, 189, 0, '*', 0),
(322, 'aboutjoomla', 'Search', 'search', '', 'using-joomla/extensions/plugins/search', 'index.php?option=com_content&view=article&id=41', 'component', 1, 284, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 190, 191, 0, '*', 0),
(323, 'aboutjoomla', 'User', 'user', '', 'using-joomla/extensions/plugins/user', 'index.php?option=com_content&view=article&id=51', 'component', 1, 284, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 192, 193, 0, '*', 0),
(324, 'aboutjoomla', 'Footer', 'footer', '', 'using-joomla/extensions/modules/display-modules/footer', 'index.php?option=com_content&view=article&id=19', 'component', 1, 413, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 133, 134, 0, '*', 0),
(325, 'aboutjoomla', 'Archive', 'archive', '', 'using-joomla/extensions/modules/content-modules/archive', 'index.php?option=com_content&view=article&id=2', 'component', 1, 411, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 109, 110, 0, '*', 0),
(326, 'aboutjoomla', 'Related Items', 'related-items', '', 'using-joomla/extensions/modules/content-modules/related-items', 'index.php?option=com_content&view=article&id=37', 'component', 1, 411, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 111, 112, 0, '*', 0),
(399, 'parks', 'Animals', 'animals', '', 'image-gallery/animals', 'index.php?option=com_content&view=category&layout=blog&id=72', 'component', 1, 244, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"maxLevel":"","show_empty_categories":"","show_description":"1","show_description_image":"0","show_category_title":"","show_cat_num_articles":"","num_leading_articles":"0","num_intro_articles":"6","num_columns":"2","num_links":"4","multi_column_order":"1","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"2","show_noauth":"","show_title":"","link_titles":"","show_intro":"0","show_category":"1","link_category":"1","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"1","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_feed_link":"1","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 220, 221, 0, 'en-GB', 0),
(400, 'parks', 'Scenery', 'scenery', '', 'image-gallery/scenery', 'index.php?option=com_content&view=category&layout=blog&id=73', 'component', 1, 244, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"maxLevel":"","show_empty_categories":"","show_description":"0","show_description_image":"0","show_category_title":"","show_cat_num_articles":"","num_leading_articles":"0","num_intro_articles":"4","num_columns":"2","num_links":"4","multi_column_order":"1","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"2","show_noauth":"","show_title":"","link_titles":"","show_intro":"0","show_category":"1","link_category":"","show_parent_category":"0","link_parent_category":"0","show_author":"0","link_author":"0","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"1","show_readmore":"1","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"0","show_feed_link":"1","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 222, 223, 0, 'en-GB', 0),
(402, 'aboutjoomla', 'Login Form', 'login-form', '', 'using-joomla/extensions/components/users-component/login-form', 'index.php?option=com_users&view=login', 'component', 1, 271, 5, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"login_redirect_url":"","logindescription_show":"1","login_description":"","login_image":"","logout_redirect_url":"","logoutdescription_show":"1","logout_description":"","logout_image":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 77, 78, 0, '*', 0),
(403, 'aboutjoomla', 'User Profile', 'user-profile', '', 'using-joomla/extensions/components/users-component/user-profile', 'index.php?option=com_users&view=profile', 'component', 1, 271, 5, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 79, 80, 0, '*', 0),
(404, 'aboutjoomla', 'Edit User Profile', 'edit-user-profile', '', 'using-joomla/extensions/components/users-component/edit-user-profile', 'index.php?option=com_users&view=profile&layout=edit', 'component', 1, 271, 5, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 81, 82, 0, '*', 0),
(405, 'aboutjoomla', 'Registration Form', 'registration-form', '', 'using-joomla/extensions/components/users-component/registration-form', 'index.php?option=com_users&view=registration', 'component', 1, 271, 5, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 83, 84, 0, '*', 0),
(406, 'aboutjoomla', 'Username Reminder Request', 'username-reminder', '', 'using-joomla/extensions/components/users-component/username-reminder', 'index.php?option=com_users&view=remind', 'component', 1, 271, 5, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 85, 86, 0, '*', 0),
(409, 'aboutjoomla', 'Password Reset', 'password-reset', '', 'using-joomla/extensions/components/users-component/password-reset', 'index.php?option=com_users&view=reset', 'component', 1, 271, 5, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 87, 88, 0, '*', 0),
(410, 'aboutjoomla', 'Feed Display', 'feed-display', '', 'using-joomla/extensions/modules/display-modules/feed-display', 'index.php?option=com_content&view=article&id=16', 'component', 1, 413, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 131, 132, 0, '*', 0),
(411, 'aboutjoomla', 'Content Modules', 'content-modules', '', 'using-joomla/extensions/modules/content-modules', 'index.php?option=com_content&view=category&id=64', 'component', 1, 281, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"maxLevel":"0","show_category_title":"1","page_subheading":"","show_empty_categories":"1","show_description":"1","show_description_image":"","show_cat_num_articles":"","display_num":"0","show_headings":"0","list_show_title":"1","list_show_date":"0","date_format":"","list_show_hits":"0","list_show_author":"0","filter_field":"hide","orderby_pri":"","orderby_sec":"order","order_date":"","show_pagination":"","show_pagination_limit":"0","show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"1","link_category":"1","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 102, 117, 0, '*', 0),
(412, 'aboutjoomla', 'User Modules', 'user-modules', '', 'using-joomla/extensions/modules/user-modules', 'index.php?option=com_content&view=category&id=65', 'component', 1, 281, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"maxLevel":"0","show_category_title":"1","page_subheading":"","show_empty_categories":"","show_description":"1","show_description_image":"","show_cat_num_articles":"","display_num":"0","show_headings":"0","list_show_title":"1","list_show_date":"","date_format":"","list_show_hits":"0","list_show_author":"0","filter_field":"hide","orderby_pri":"","orderby_sec":"order","order_date":"","show_pagination":"","show_pagination_limit":"0","show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"1","link_category":"1","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 118, 125, 0, '*', 0),
(413, 'aboutjoomla', 'Display Modules', 'display-modules', '', 'using-joomla/extensions/modules/display-modules', 'index.php?option=com_content&view=category&id=66', 'component', 1, 281, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"maxLevel":"0","show_category_title":"1","page_subheading":"","show_empty_categories":"","show_description":"1","show_description_image":"1","show_cat_num_articles":"","display_num":"0","show_headings":"0","list_show_title":"1","list_show_date":"","date_format":"","list_show_hits":"0","list_show_author":"0","filter_field":"hide","orderby_pri":"","orderby_sec":"order","order_date":"","show_pagination":"","show_pagination_limit":"0","show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"1","link_category":"1","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 126, 139, 0, '*', 0),
(414, 'aboutjoomla', 'Utility Modules', 'utility-modules', '', 'using-joomla/extensions/modules/utility-modules', 'index.php?option=com_content&view=category&id=67', 'component', 1, 281, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"maxLevel":"0","show_category_title":"1","page_subheading":"","show_empty_categories":"","show_description":"1","show_description_image":"1","show_cat_num_articles":"","display_num":"0","show_headings":"0","list_show_title":"0","list_show_date":"0","date_format":"","list_show_hits":"0","list_show_author":"0","filter_field":"","orderby_pri":"","orderby_sec":"order","order_date":"","show_pagination":"","show_pagination_limit":"0","show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"1","link_category":"1","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 140, 151, 0, '*', 0),
(415, 'aboutjoomla', 'Menu Module', 'menu-modules', '', 'using-joomla/extensions/modules/menu-modules', 'index.php?option=com_content&view=category&id=75', 'component', 1, 281, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"maxLevel":"","show_category_title":"","page_subheading":"","show_empty_categories":"","show_description":"","show_description_image":"","show_cat_num_articles":"","display_num":"","show_headings":"","list_show_title":"","list_show_date":"","date_format":"","list_show_hits":"","list_show_author":"","filter_field":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_limit":"","show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 98, 101, 0, '*', 0),
(416, 'aboutjoomla', 'Breadcrumbs', 'breadcrumbs', '', 'using-joomla/extensions/modules/utility-modules/breadcrumbs', 'index.php?option=com_content&view=article&id=61', 'component', 1, 414, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 147, 148, 0, '*', 0),
(418, 'aboutjoomla', 'Custom HTML', 'custom-html', '', 'using-joomla/extensions/modules/display-modules/custom-html', 'index.php?option=com_content&view=article&id=12', 'component', 1, 413, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 137, 138, 0, '*', 0),
(419, 'aboutjoomla', 'Beez 2', 'beez-2', '', 'using-joomla/extensions/templates/beez-2', 'index.php?option=com_content&view=category&layout=blog&id=69', 'component', 1, 282, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"maxLevel":"","show_empty_categories":"","show_description":"1","show_description_image":"","show_category_title":"","show_cat_num_articles":"","num_leading_articles":"1","num_intro_articles":"4","num_columns":"2","num_links":"4","multi_column_order":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 154, 159, 0, '*', 0),
(421, 'aboutjoomla', 'Milky Way', 'milky-way', '', 'using-joomla/extensions/templates/milky-way', 'index.php?option=com_content&view=category&layout=blog&id=71', 'component', 1, 282, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"maxLevel":"","show_empty_categories":"","show_description":"1","show_description_image":"","show_category_title":"1","show_cat_num_articles":"","num_leading_articles":"1","num_intro_articles":"4","num_columns":"2","num_links":"4","multi_column_order":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 172, 177, 0, '*', 0),
(422, 'aboutjoomla', 'Atomic', 'atomic', '', 'using-joomla/extensions/templates/atomic', 'index.php?option=com_content&view=category&layout=blog&id=68', 'component', 1, 282, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"maxLevel":"","show_empty_categories":"","show_description":"1","show_description_image":"","show_category_title":"","show_cat_num_articles":"","num_leading_articles":"2","num_intro_articles":"4","num_columns":"2","num_links":"4","multi_column_order":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 166, 171, 0, '*', 0),
(423, 'aboutjoomla', 'Typography Beez 2', 'typography-beez-2', '', 'using-joomla/extensions/templates/beez-2/typography-beez-2', 'index.php?option=com_content&view=article&id=49', 'component', 1, 419, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 155, 156, 0, '*', 0),
(424, 'aboutjoomla', 'Home Page Beez 2', 'home-page-beez-2', '', 'using-joomla/extensions/templates/beez-2/home-page-beez-2', 'index.php?option=com_content&view=featured', 'component', 1, 419, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"maxLevel":"","show_empty_categories":"","show_description":"","show_description_image":"","show_cat_num_articles":"","num_leading_articles":"1","num_intro_articles":"3","num_columns":"3","num_links":"0","multi_column_order":"1","orderby_pri":"","orderby_sec":"front","order_date":"","show_pagination":"2","show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_feed_link":"1","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 157, 158, 0, '*', 0),
(427, 'fruitshop', 'Fruit Encyclopedia', 'fruit-encyclopedia', '', 'fruit-encyclopedia', 'index.php?option=com_contact&view=categories&id=37', 'component', 0, 1, 1, 8, 0, '0000-00-00 00:00:00', 0, 1, '', 6, '{"show_base_description":"1","categories_description":"","maxLevel":"-1","show_empty_categories":"1","show_description":"1","show_description_image":"1","show_cat_num_articles":"1","display_num":"","show_headings":"0","filter_field":"hide","show_pagination":"","show_noauth":"","presentation_style":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_links":"1","linka_name":"","linkb_name":"","linkc_name":"","linkd_name":"","linke_name":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":" categories-listalphabet","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 229, 230, 0, '*', 0),
(429, 'fruitshop', 'Welcome', 'welcome', 'Fruit store front page', 'welcome', 'index.php?option=com_content&view=article&id=20', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 6, '{"show_noauth":"","show_title":"0","link_titles":"0","show_intro":"1","show_category":"0","link_category":"0","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"0","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"0","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 227, 228, 0, '*', 0),
(430, 'fruitshop', 'Contact Us', 'contact-us', '', 'contact-us', 'index.php?option=com_contact&view=contact&id=1', 'component', 1, 1, 1, 8, 0, '0000-00-00 00:00:00', 0, 1, '', 6, '{"presentation_style":"","show_contact_category":"","show_contact_list":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_links":"1","linka_name":"","linkb_name":"","linkc_name":"","linkd_name":"","linke_name":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"mega_showtitle":"1","mega_desc":"","mega_cols":"1","mega_group":"0","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"0"}', 233, 234, 0, '*', 0),
(431, 'fruitshop', 'Growers', 'growers', '', 'growers', 'index.php?option=com_content&view=category&layout=blog&id=30', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 6, '{"maxLevel":"0","show_empty_categories":"","show_description":"1","show_description_image":"","show_category_title":"1","show_cat_num_articles":"","num_leading_articles":"5","num_intro_articles":"0","num_columns":"1","num_links":"4","multi_column_order":"","orderby_pri":"","orderby_sec":"alpha","order_date":"","show_pagination":"","show_noauth":"","show_title":"1","link_titles":"1","show_intro":"1","show_category":"0","link_category":"","show_parent_category":"0","link_parent_category":"0","show_author":"0","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"0","show_item_navigation":"","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"0","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 231, 232, 0, '*', 0),
(432, 'fruitshop', 'Login ', 'shop-login', '', 'shop-login', 'index.php?option=com_users&view=login', 'component', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 6, '{"login_redirect_url":"http:\\/\\/localhost\\/joomla_development\\/trunk071110\\/index.php\\/welcome.html","logindescription_show":"1","login_description":"","login_image":"","logout_redirect_url":"http:\\/\\/localhost\\/joomla_development\\/trunk071110\\/index.php\\/welcome.html","logoutdescription_show":"1","logout_description":"","logout_image":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 235, 236, 0, '*', 0),
(433, 'fruitshop', 'Directions', 'directions', '', 'directions', 'index.php?option=com_content&view=article&id=13', 'component', 0, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 6, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 237, 238, 0, '*', 0),
(435, 'mainmenu', 'Home', 'homepage', '', 'homepage', 'index.php?option=com_content&view=featured', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"featured_categories":[""],"layout_type":"blog","num_leading_articles":"1","num_intro_articles":"4","num_columns":"2","num_links":"2","multi_column_order":"1","orderby_pri":"","orderby_sec":"front","order_date":"","show_pagination":"2","show_pagination_results":"","show_title":"1","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"0","link_parent_category":"0","show_author":"0","link_author":"0","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"0","show_vote":"","show_readmore":"1","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"0","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"Joomla 3.x Responsive Web Design","show_page_heading":0,"page_heading":"","pageclass_sfx":" ja-frontpage","menu-meta_description":"Joomla 3.x responsive design user guide for Joomla lovers.","menu-meta_keywords":"Joomla 3.x templates design, 3.x Joomla design template, Joomla 3.x mobile design","robots":"","secure":0,"mega_showtitle":"1","mega_desc":"T3 Blank\'s Home","mega_cols":"1","mega_group":"0","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"0"}', 1, 2, 1, '*', 0),
(436, 'aboutjoomla', 'Getting Help', 'getting-help', '', 'using-joomla/getting-help', 'index.php?option=com_content&view=article&id=21', 'component', 1, 280, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 117, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"0","link_category":"","show_parent_category":"0","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"0","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"0","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 200, 201, 0, '*', 0),
(437, 'aboutjoomla', 'Getting Started', 'getting-started', '', 'getting-started', 'index.php?option=com_content&view=article&id=22', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 117, '{"show_title":"1","link_titles":"0","show_intro":"","show_category":"0","link_category":"","show_parent_category":"0","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"0","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"0","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 35, 36, 0, '*', 0),
(443, 'aboutjoomla', 'Article Categories', 'article-categories-view', '', 'using-joomla/extensions/modules/content-modules/article-categories-view', 'index.php?option=com_content&view=article&id=3', 'component', 1, 411, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 113, 114, 0, '*', 0),
(447, 'aboutjoomla', 'Language Switcher', 'language-switcher', '', 'using-joomla/extensions/modules/utility-modules/language-switcher', 'index.php?option=com_content&view=article&id=26', 'component', 1, 414, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 149, 150, 0, '*', 0),
(449, 'usermenu', 'Submit an Article', 'submit-an-article', '', 'submit-an-article', 'index.php?option=com_content&view=form&layout=edit', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 271, 272, 0, '*', 0),
(451, 'aboutjoomla', 'Milky Way Home', 'milky-way-home', '', 'using-joomla/extensions/templates/milky-way/milky-way-home', 'index.php?option=com_content&view=featured', 'component', 1, 421, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 1, '{"maxLevel":"","show_empty_categories":"","show_description":"","show_description_image":"","show_cat_num_articles":"","num_leading_articles":"1","num_intro_articles":"3","num_columns":"3","num_links":"0","multi_column_order":"","orderby_pri":"","orderby_sec":"front","order_date":"","show_pagination":"","show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 175, 176, 0, '*', 0),
(452, 'aboutjoomla', 'Featured Contacts', 'featured-contacts', '', 'using-joomla/extensions/components/contact-component/featured-contacts', 'index.php?option=com_contact&view=featured&id=16', 'component', 1, 270, 5, 8, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"maxLevel":"-1","show_empty_categories":"","show_description":"","show_description_image":"","show_cat_num_articles":"","display_num":"","show_headings":"","filter_field":"","show_pagination":"","show_noauth":"","presentation_style":"sliders","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_links":"1","linka_name":"","linkb_name":"","linkc_name":"","linkd_name":"","linke_name":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":1,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 65, 66, 0, '*', 0),
(453, 'aboutjoomla', 'Parameters', 'parameters', '', 'using-joomla/parameters', 'index.php?option=com_content&view=article&id=32', 'component', 1, 280, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 117, '{"show_noauth":"1","show_title":"1","link_titles":"1","show_intro":"1","show_category":"1","link_category":"1","show_parent_category":"1","link_parent_category":"1","show_author":"1","link_author":"1","show_create_date":"1","show_modify_date":"1","show_publish_date":"1","show_item_navigation":"1","show_icons":"1","show_print_icon":"1","show_email_icon":"1","show_hits":"1","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 198, 199, 0, '*', 0),
(456, 'aboutjoomla', 'Beez5', 'beez5', '', 'using-joomla/extensions/templates/beez5', 'index.php?option=com_content&view=category&layout=blog&id=70', 'component', 1, 282, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"maxLevel":"","show_empty_categories":"","show_description":"1","show_description_image":"","show_category_title":"","show_cat_num_articles":"","num_leading_articles":"1","num_intro_articles":"4","num_columns":"2","num_links":"4","multi_column_order":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":1,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 160, 165, 0, '*', 0),
(457, 'aboutjoomla', 'Typography Beez5', 'typography-beez-5', '', 'using-joomla/extensions/templates/beez5/typography-beez-5', 'index.php?option=com_content&view=article&id=49', 'component', 1, 456, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":1,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 161, 162, 0, '*', 0),
(458, 'aboutjoomla', 'Home Page Beez5', 'home-page-beez5', '', 'using-joomla/extensions/templates/beez5/home-page-beez5', 'index.php?option=com_content&view=featured', 'component', 1, 456, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"maxLevel":"","show_empty_categories":"","show_description":"","show_description_image":"","show_cat_num_articles":"","num_leading_articles":"1","num_intro_articles":"3","num_columns":"3","num_links":"0","multi_column_order":"","orderby_pri":"","orderby_sec":"front","order_date":"","show_pagination":"","show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":1,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 163, 164, 0, '*', 0);
INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(459, 'aboutjoomla', 'Article Category', 'article-category', '', 'using-joomla/extensions/modules/content-modules/article-category', 'index.php?option=com_content&view=article&id=4', 'component', 1, 411, 5, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","robots":"","rights":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":1,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","secure":0}', 115, 116, 0, '*', 0),
(462, 'fruitshop', 'Add a recipe', 'add-a-recipe', '', 'add-a-recipe', 'index.php?option=com_content&view=form&layout=edit', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 4, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":1,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 273, 274, 0, '*', 0),
(463, 'fruitshop', 'Recipes', 'recipes', '', 'recipes', 'index.php?option=com_content&view=category&id=76', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 6, '{"maxLevel":"0","show_category_title":"1","page_subheading":"","show_empty_categories":"0","show_description":"1","show_description_image":"","show_cat_num_articles":"","display_num":"","show_headings":"","list_show_title":"","list_show_date":"","date_format":"","list_show_hits":"","list_show_author":"","filter_field":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_limit":"","show_noauth":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","show_page_heading":0,"page_title":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 275, 276, 0, '*', 0),
(464, 'top', 'Home', 'home', '', 'home', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"aliasoptions":"435","menu-anchor_title":"","menu-anchor_css":"","menu_image":""}', 203, 204, 0, '*', 0),
(506, 'mainmenu', 'Explore', 'explore', '', 'explore', 'index.php?option=com_content&view=category&layout=blog&id=78', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"layout_type":"blog","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","page_subheading":"","num_leading_articles":"1","num_intro_articles":"4","num_columns":"1","num_links":"4","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"mega_showtitle":"1","mega_desc":"Don\'t be surprised..","mega_cols":"3","mega_group":"0","mega_width":"","mega_colw":"200","mega_colxw":"colw1=240","mega_class":"","mega_subcontent":"0"}', 239, 270, 0, '*', 0),
(507, 'mainmenu', '6 Responsive layouts', 'all-responsive-layout', '', 'explore/all-responsive-layout', 'index.php?option=com_content&view=article&id=82', 'component', 1, 506, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"mega_showtitle":"1","mega_desc":"","mega_cols":"1","mega_group":"1","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"0"}', 240, 251, 0, '*', 0),
(508, 'mainmenu', 'About Joomla! 3.x', 'about-joomla-3-x', '', 'about-joomla-3-x', 'index.php?option=com_content&view=article&id=1', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"mega_showtitle":"1","mega_desc":"The best CMS ever!","mega_cols":"2","mega_group":"0","mega_width":"","mega_colw":"200","mega_colxw":"colw2=368","mega_class":"","mega_subcontent":"0"}', 283, 308, 0, '*', 0),
(509, 'mainmenu', 'What\'s New in 3.x?', 'what-s-new-in-3-x', '', 'about-joomla-3-x/what-s-new-in-3-x', 'index.php?option=com_content&view=article&id=75', 'component', 1, 508, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"mega_showtitle":"1","mega_desc":"","mega_cols":"1","mega_group":"1","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"0"}', 284, 303, 0, '*', 0),
(510, 'mainmenu', 'Archived Articles', 'archived-articles', '', 'about-joomla-3-x/archived-articles', 'index.php?option=com_content&view=archive', 'component', 0, 508, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"orderby_sec":"alpha","order_date":"created","display_num":"5","filter_field":"hide","introtext_limit":"100","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_title":"","link_titles":"","show_intro":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_readmore":"","show_hits":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"mega_showtitle":"0","mega_desc":"","mega_cols":"1","mega_group":"1","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"pos","mega_subcontent_pos_positions":["mega1","mega2"]}', 304, 305, 0, '*', 0),
(511, 'mainmenu', 'Other links', 'other-links', '', 'about-joomla-3-x/other-links', '', 'separator', 1, 508, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu_image":"","menu_text":1,"mega_showtitle":"0","mega_desc":"","mega_cols":"1","mega_group":"1","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"pos","mega_subcontent_pos_positions":["mega1"]}', 306, 307, 0, '*', 0),
(529, 'mainmenu', 'Joomla! Extensions', 'joomla-extensions', '', 'about-joomla-3-x/what-s-new-in-3-x/joomla-extensions', 'index.php?option=com_content&view=category&layout=blog&id=20', 'component', 1, 509, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","page_subheading":"","num_leading_articles":"1","num_intro_articles":"4","num_columns":"2","num_links":"4","multi_column_order":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"mega_showtitle":"1","mega_desc":"","mega_cols":"1","mega_group":"0","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"0"}', 285, 286, 0, '*', 0),
(530, 'mainmenu', 'The Joomla! Project', 'the-joomla-project', '', 'about-joomla-3-x/what-s-new-in-3-x/the-joomla-project', 'index.php?option=com_content&view=category&layout=blog&id=26', 'component', 1, 509, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","page_subheading":"","num_leading_articles":"1","num_intro_articles":"4","num_columns":"2","num_links":"4","multi_column_order":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"mega_showtitle":"1","mega_desc":"","mega_cols":"1","mega_group":"0","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"0"}', 287, 288, 0, '*', 0),
(531, 'mainmenu', 'The Joomla! Community', 'the-joomla-community', '', 'about-joomla-3-x/what-s-new-in-3-x/the-joomla-community', 'index.php?option=com_content&view=article&id=69', 'component', 0, 509, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"mega_showtitle":"1","mega_desc":"","mega_cols":"1","mega_group":"0","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"0"}', 289, 290, 0, '*', 0),
(532, 'mainmenu', 'The News', 'the-news', '', 'about-joomla-3-x/what-s-new-in-3-x/the-news', 'index.php?option=com_content&view=category&layout=blog&id=29', 'component', 1, 509, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","page_subheading":"","num_leading_articles":"1","num_intro_articles":"4","num_columns":"1","num_links":"4","multi_column_order":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"mega_showtitle":"1","mega_desc":"","mega_cols":"1","mega_group":"0","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"0"}', 295, 296, 0, '*', 0),
(533, 'mainmenu', 'Newsfeeds', 'newsfeeds', '', 'about-joomla-3-x/what-s-new-in-3-x/example-pages/newsfeeds', 'index.php?option=com_newsfeeds&view=categories&id=0', 'component', 0, 534, 4, 17, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_base_description":"","categories_description":"","maxLevelcat":"","show_empty_categories_cat":"","show_subcat_desc_cat":"","show_cat_items_cat":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_subcat_desc":"","show_cat_items":"","show_pagination_limit":"","show_headings":"","show_articles":"","show_link":"","show_pagination":"","show_pagination_results":"","show_feed_image":"","show_feed_description":"","show_item_description":"","feed_character_count":"0","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"mega_showtitle":"1","mega_desc":"","mega_cols":"1","mega_group":"0","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"0"}', 292, 293, 0, '*', 0),
(534, 'mainmenu', 'Example Pages', 'example-pages', '', 'about-joomla-3-x/what-s-new-in-3-x/example-pages', 'index.php?option=com_content&view=article&id=73', 'component', 1, 509, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"mega_showtitle":"1","mega_desc":"","mega_cols":"1","mega_group":"0","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"0"}', 291, 294, 0, '*', 0),
(536, 'main', 'com_jaextmanager', 'ja-ext-manager', '', 'ja-ext-manager', 'index.php?option=com_jaextmanager', 'component', 1, 1, 1, 10002, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_jaextmanager/assets/images/jauc.png', 0, '', 277, 278, 0, '', 1),
(537, 'mainmenu', 'Menu support', 'menu-support', '', 'explore/others-featured/menu-support', 'index.php?option=com_content&view=article&id=76', 'component', 1, 551, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"mega_showtitle":"1","mega_desc":"","mega_cols":"1","mega_group":"0","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"0"}', 265, 266, 0, '*', 0),
(538, 'mainmenu', 'Contents Grid', '2011-11-25-10-25-50', '', 'explore/2011-11-25-10-25-50', '#', 'url', 1, 506, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"mega_showtitle":"1","mega_desc":"","mega_cols":"1","mega_group":"1","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"0"}', 252, 263, 0, '*', 0),
(539, 'mainmenu', '1 Column', '1-column', '', 'explore/2011-11-25-10-25-50/1-column', 'index.php?option=com_content&view=article&id=77', 'component', 1, 538, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"0","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":" content-grid-single","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"mega_showtitle":"1","mega_desc":"","mega_cols":"1","mega_group":"0","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"0"}', 253, 254, 0, '*', 0),
(540, 'mainmenu', '2 Columns', '2-columns', '', 'explore/2011-11-25-10-25-50/2-columns', 'index.php?option=com_content&view=article&id=78', 'component', 1, 538, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":" content-grid-double","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"mega_showtitle":"1","mega_desc":"","mega_cols":"1","mega_group":"0","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"0"}', 255, 256, 0, '*', 0),
(541, 'mainmenu', '3 Columns', '3-columns', '', 'explore/2011-11-25-10-25-50/3-columns', 'index.php?option=com_content&view=article&id=79', 'component', 1, 538, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":" content-grid-tripple","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"mega_showtitle":"1","mega_desc":"","mega_cols":"1","mega_group":"0","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"0"}', 257, 258, 0, '*', 0),
(542, 'mainmenu', '4 Columns', '4-columns', '', 'explore/2011-11-25-10-25-50/4-columns', 'index.php?option=com_content&view=article&id=80', 'component', 1, 538, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":" content-grid-quadruple","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"mega_showtitle":"1","mega_desc":"","mega_cols":"1","mega_group":"0","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"0"}', 259, 260, 0, '*', 0),
(543, 'mainmenu', '5 Columns', '5-columns', '', 'explore/2011-11-25-10-25-50/5-columns', 'index.php?option=com_content&view=article&id=81', 'component', 1, 538, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":" content-grid-mass","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"mega_showtitle":"1","mega_desc":"","mega_cols":"1","mega_group":"0","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"0"}', 261, 262, 0, '*', 0),
(544, 'mainmenu', 'Modules Class Suffix', '2011-11-26-04-13-06', '', 'explore/others-featured/2011-11-26-04-13-06', '#', 'url', 1, 551, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"mega_showtitle":"1","mega_desc":"","mega_cols":"1","mega_group":"0","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"0"}', 267, 268, 0, '*', 0),
(545, 'mainmenu', 'Contact', 'contact', '', 'about-joomla-3-x/what-s-new-in-3-x/contact', 'index.php?option=com_contact&view=contact&id=1', 'component', 1, 509, 3, 8, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"presentation_style":"plain","show_contact_category":"","show_contact_list":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_links":"","linka_name":"","linkb_name":"","linkc_name":"","linkd_name":"","linke_name":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"mega_showtitle":"1","mega_desc":"","mega_cols":"1","mega_group":"0","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"0"}', 297, 298, 0, '*', 0),
(546, 'mainmenu', 'Extra-wide layout', 'extra-wide-layout', '', 'explore/all-responsive-layout/extra-wide-layout', 'index.php?option=com_content&view=article&id=83', 'component', 1, 507, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"mega_showtitle":"1","mega_desc":"","mega_cols":"1","mega_group":"0","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"0"}', 241, 242, 0, '*', 0),
(547, 'mainmenu', 'Wide layout', 'wide-layout', '', 'explore/all-responsive-layout/wide-layout', 'index.php?option=com_content&view=article&id=84', 'component', 1, 507, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"mega_showtitle":"1","mega_desc":"","mega_cols":"1","mega_group":"0","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"0"}', 243, 244, 0, '*', 0),
(548, 'mainmenu', 'Normal layout', 'normal-layout', '', 'explore/all-responsive-layout/normal-layout', 'index.php?option=com_content&view=article&id=85', 'component', 1, 507, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"mega_showtitle":"1","mega_desc":"","mega_cols":"1","mega_group":"0","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"0"}', 245, 246, 0, '*', 0),
(549, 'mainmenu', 'Tablet layout', 'tablet-layout', '', 'explore/all-responsive-layout/tablet-layout', 'index.php?option=com_content&view=article&id=86', 'component', 1, 507, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"mega_showtitle":"1","mega_desc":"","mega_cols":"1","mega_group":"0","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"0"}', 247, 248, 0, '*', 0),
(550, 'mainmenu', 'Mobile layout', 'mobile-layout', '', 'explore/all-responsive-layout/mobile-layout', 'index.php?option=com_content&view=article&id=87', 'component', 1, 507, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"mega_showtitle":"1","mega_desc":"","mega_cols":"1","mega_group":"0","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"0"}', 249, 250, 0, '*', 0),
(551, 'mainmenu', 'Others featured', 'others-featured', '', 'explore/others-featured', '', 'separator', 1, 506, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu_image":"","menu_text":1,"mega_showtitle":"1","mega_desc":"","mega_cols":"1","mega_group":"1","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"0"}', 264, 269, 0, '*', 0),
(552, 'main', 'COM_FINDER', 'com-finder', '', 'com-finder', 'index.php?option=com_finder', 'component', 1, 1, 1, 10014, 0, '0000-00-00 00:00:00', 0, 1, 'class:finder', 0, '', 279, 280, 0, '', 1),
(553, 'main', 'com_finder', 'Smart Search', '', 'Smart Search', 'index.php?option=com_finder', 'component', 1, 1, 1, 27, 0, '0000-00-00 00:00:00', 0, 0, 'class:finder', 0, '', 33, 34, 0, '*', 1),
(554, 'main', 'com_joomlaupdate', 'com-joomlaupdate', '', 'com-joomlaupdate', 'index.php?option=com_joomlaupdate', 'component', 1, 1, 1, 10035, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '', 281, 282, 0, '', 1),
(555, 'mainmenu', 'Demo Joomla Tags', 'demo-joomla-tags', '', 'about-joomla-3-x/what-s-new-in-3-x/demo-joomla-tags', 'index.php?option=com_tags&view=tag&id[0]=5&tag_list_language_filter=', 'component', 1, 509, 3, 29, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_tag_title":"","tag_list_show_tag_image":"","tag_list_show_tag_description":"","tag_list_image":"","tag_list_description":"","show_tag_num_items":"","tag_list_orderby":"","tag_list_orderby_direction":"","tag_list_show_item_image":"","tag_list_show_item_description":"","tag_list_item_maximum_characters":0,"filter_field":"","show_pagination_limit":"","show_pagination":"","show_pagination_results":"","return_any_or_all":"","include_children":"","maximum":200,"show_feed_link":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"mega_showtitle":"1","mega_desc":"","mega_cols":"1","mega_group":"0","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"0"}', 299, 300, 0, '*', 0),
(556, 'mainmenu', 'Demo Joomla Tag Item', 'demo-joomla-tag-item', '', 'about-joomla-3-x/what-s-new-in-3-x/demo-joomla-tag-item', 'index.php?option=com_content&view=article&id=83', 'component', 1, 509, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_tags":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"mega_showtitle":"1","mega_desc":"","mega_cols":"1","mega_group":"0","mega_width":"","mega_colw":"","mega_colxw":"","mega_class":"","mega_subcontent":"0"}', 301, 302, 0, '*', 0),
(558, 'main', 'com_associations', 'multilingual-associations', '', 'multilingual-associations', 'index.php?option=com_associations', 'component', 1, 1, 1, 34, 0, '0000-00-00 00:00:00', 0, 1, 'class:associations', 0, '{}', 309, 310, 0, '*', 1);

DROP TABLE IF EXISTS `#__menu_types`;
CREATE TABLE `#__menu_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0,
  `menutype` varchar(24) NOT NULL,
  `title` varchar(48) NOT NULL,
  `description` varchar(255) NOT NULL DEFAULT '',
  `client_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_menutype` (`menutype`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO `#__menu_types` (`id`, `asset_id`, `menutype`, `title`, `description`, `client_id`) VALUES
(2, 0, 'usermenu', 'User Menu', 'A Menu for logged in Users', 0),
(3, 0, 'top', 'Top', 'Links for major types of users', 0),
(4, 0, 'aboutjoomla', 'About Joomla', 'All about Joomla!', 0),
(5, 0, 'parks', 'Australian Parks', 'Main menu for a site about Australian  parks', 0),
(6, 0, 'mainmenu', 'Main Menu', 'Simple Home Menu', 0),
(7, 0, 'fruitshop', 'Fruit Shop', 'Menu for the sample shop site.', 0);

DROP TABLE IF EXISTS `#__messages`;
CREATE TABLE `#__messages` (
  `message_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id_from` int(10) unsigned NOT NULL DEFAULT 0,
  `user_id_to` int(10) unsigned NOT NULL DEFAULT 0,
  `folder_id` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `state` tinyint(1) NOT NULL DEFAULT 0,
  `priority` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `subject` varchar(255) NOT NULL DEFAULT '',
  `message` mediumtext NOT NULL,
  PRIMARY KEY (`message_id`),
  KEY `useridto_state` (`user_id_to`,`state`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `#__messages_cfg`;
CREATE TABLE `#__messages_cfg` (
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `cfg_name` varchar(100) NOT NULL DEFAULT '',
  `cfg_value` varchar(255) NOT NULL DEFAULT '',
  UNIQUE KEY `idx_user_var_name` (`user_id`,`cfg_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `#__modules`;
CREATE TABLE `#__modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `title` varchar(100) NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `position` varchar(50) DEFAULT NULL,
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT 0,
  `module` varchar(50) DEFAULT NULL,
  `access` int(10) unsigned DEFAULT NULL,
  `showtitle` tinyint(3) unsigned NOT NULL DEFAULT 1,
  `params` varchar(5120) NOT NULL DEFAULT '',
  `client_id` tinyint(4) NOT NULL DEFAULT 0,
  `language` char(7) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `published` (`published`,`access`),
  KEY `newsfeeds` (`module`,`published`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=118 DEFAULT CHARSET=utf8;

INSERT INTO `#__modules` (`id`, `asset_id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES
(1, 0, 'Main Menu', '', '', 5, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{"menutype":"mainmenu","base":"","startLevel":"1","endLevel":"0","showAllChildren":"0","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"_menu","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(2, 0, 'Login', '', '', 1, 'login', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_login', 1, 1, '', 1, '*'),
(3, 0, 'Popular Articles', '', '', 3, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_popular', 3, 1, '{"count":"5","catid":"","user_id":"0","layout":"","moduleclass_sfx":"","cache":"0"}', 1, '*'),
(4, 0, 'Recently Added Articles', '', '', 4, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_latest', 3, 1, '{"count":"5","ordering":"c_dsc","catid":"","user_id":"0","layout":"","moduleclass_sfx":"","cache":"0"}', 1, '*'),
(8, 0, 'Toolbar', '', '', 1, 'toolbar', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_toolbar', 3, 1, '', 1, '*'),
(9, 0, 'Quick Icons', '', '', 1, 'icon', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_quickicon', 3, 1, '', 1, '*'),
(10, 0, 'Logged-in Users', '', '', 2, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_logged', 3, 1, '', 1, '*'),
(12, 0, 'Admin Menu', '', '', 1, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 3, 1, '{"layout":"","moduleclass_sfx":"","shownew":"1","showhelp":"1","cache":"0"}', 1, '*'),
(13, 0, 'Admin Submenu', '', '', 1, 'submenu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_submenu', 3, 1, '', 1, '*'),
(14, 0, 'User Status', '', '', 1, 'status', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_status', 3, 1, '', 1, '*'),
(15, 0, 'Title', '', '', 1, 'title', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_title', 3, 1, '', 1, '*'),
(16, 0, 'Login Form', '', '', 9, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_login', 1, 1, '{"pretext":"","posttext":"","login":"","logout":"","greeting":"1","name":"0","usesecure":"0","layout":"_:default","moduleclass_sfx":"","cache":"0"}', 0, '*'),
(17, 0, 'Breadcrumbs', '', '', 1, 'position-2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_breadcrumbs', 1, 1, '{"moduleclass_sfx":"","showHome":"1","homeText":"Home","showComponent":"1","separator":"","cache":"1","cache_time":"900","cachemode":"itemid"}', 0, '*'),
(18, 0, 'Banners', '', '', 3, 'position-5', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_banners', 1, 1, '{"target":"1","count":"1","cid":"1","catid":["27"],"tag_search":"0","ordering":"0","header_text":"","footer_text":"","layout":"","moduleclass_sfx":"","cache":"1","cache_time":"900"}', 0, '*'),
(19, 0, 'User Menu', '', '', 23, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 2, 1, '{"menutype":"usermenu","base":"","startLevel":"1","endLevel":"0","showAllChildren":"0","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"_menu","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(20, 0, 'Top', '', '', 1, 'position-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{"menutype":"top","startLevel":"1","endLevel":"0","showAllChildren":"0","tag_id":"","class_sfx":"","maxdepth":"10","window_open":"","layout":"","moduleclass_sfx":"","cache":"0"}', 0, '*'),
(22, 0, 'Australian Parks ', '', '', 2, 'user7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{"menutype":"parks","startLevel":"1","endLevel":"0","showAllChildren":"0","tag_id":"","class_sfx":"","window_open":"","moduleclass_sfx":"","cache":"0","cache_time":"900","cachemode":"itemid"}', 0, 'en-GB'),
(23, 0, 'About Joomla!', '', '', 19, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{"menutype":"aboutjoomla","base":"","startLevel":"1","endLevel":"0","showAllChildren":"0","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"_menu","cache":"0","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(25, 0, 'Site Map', '', '', 1, 'sitemapload', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 0, '{"menutype":"mainmenu","startLevel":"2","endLevel":"3","showAllChildren":"1","tag_id":"","class_sfx":"sitemap","window_open":"","layout":"","moduleclass_sfx":"","cache":"0","cache_time":"900","cachemode":"itemid"}', 0, '*'),
(26, 0, 'This Site', '', '', 25, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_menu', 1, 1, '{"menutype":"mainmenu","startLevel":"1","endLevel":"1","showAllChildren":"0","tag_id":"","class_sfx":"","window_open":"","layout":"","moduleclass_sfx":"_menu","cache":"0","cache_time":"900","cachemode":"itemid"}', 0, '*'),
(27, 0, 'Archived Articles', '', '', 1, 'archiveload', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_archive', 1, 1, '{"count":"10","layout":"","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(28, 0, 'Latest News', '', '', 1, 'articleslatestload', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_latest', 1, 1, '{"catid":["19"],"count":"5","ordering":"c_dsc","user_id":"0","show_featured":"","layout":"","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(29, 0, 'Articles Most Read', '', '', 1, 'articlespopularload', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_popular', 1, 1, '{"show_front":"1","count":"5","catid":["26","29"],"layout":"","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(30, 0, 'Feed Display', '', '', 1, 'feeddisplayload', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_feed', 1, 1, '{"rssurl":"http:\\/\\/community.joomla.org\\/blogs\\/community.feed?type=rss","rssrtl":"0","rsstitle":"1","rssdesc":"1","rssimage":"1","rssitems":"3","rssitemdesc":"1","word_count":"0","layout":"","moduleclass_sfx":"","cache":"1","cache_time":"900"}', 0, '*'),
(31, 0, 'News Flash: Latest', '', '', 1, 'newsflashload', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news', 1, 1, '{"catid":["20"],"image":"0","item_title":"0","link_titles":"","item_heading":"h4","showLastSeparator":"1","readmore":"1","count":"1","ordering":"a.publish_up","layout":"horizontal","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid"}', 0, '*'),
(32, 0, 'News Flash: Random', '', '', 1, 'newsflashload', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news', 1, 1, '{"catid":["19"],"image":"0","item_title":"0","link_titles":"","item_heading":"h4","showLastSeparator":"1","readmore":"0","count":"1","ordering":"rand()","layout":"vertical","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid"}', 0, '*'),
(33, 0, 'Random Image', '', '', 1, 'randomimageload', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_random_image', 1, 1, '{"type":"jpg","folder":"images\\/sampledata\\/parks\\/animals","link":"","width":"180","height":"","layout":"","moduleclass_sfx":"","cache":"0"}', 0, '*'),
(34, 0, 'Articles Related Items', '', '', 1, 'relateditemsload', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_related_items', 1, 1, '{"showDate":"0","layout":"","moduleclass_sfx":"","owncache":"1"}', 0, '*'),
(35, 0, 'Search', '', '', 1, 'search', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_search', 1, 1, '{"label":"","width":"20","text":"","button":"","button_pos":"right","imagebutton":"","button_text":"","set_itemid":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid"}', 0, '*'),
(36, 0, 'Statistics', '', '', 1, 'statisticsload', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_stats', 1, 1, '{"serverinfo":"1","siteinfo":"1","counter":"1","increase":"0","layout":"","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(37, 0, 'Syndicate Feeds', '', '', 1, 'syndicateload', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_syndicate', 1, 1, '{"text":"Feed Entries","format":"rss","layout":"","moduleclass_sfx":"","cache":"0"}', 0, '*'),
(38, 0, 'Users Latest', '', '', 1, 'userslatestload', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_users_latest', 1, 1, '{"shownumber":"5","linknames":"0","linktowhat":"0","layout":"","moduleclass_sfx":"","cache":"0","cache_time":"900","cachemode":"static"}', 0, '*'),
(39, 0, 'Who\'s Online', '', '', 18, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_whosonline', 1, 1, '{"showmode":"2","layout":"_:default","moduleclass_sfx":"","cache":"0","filter_groups":"0","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(40, 0, 'Wrapper', '', '', 1, 'wrapperload', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_wrapper', 1, 1, '{"url":"http:\\/\\/fsf.org","add":"1","scrolling":"auto","width":"100%","height":"200","height_auto":"1","target":"","layout":"","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(41, 0, 'Footer', '', '', 2, 'footer', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_footer', 1, 1, '{"moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(44, 0, 'Login', '', '', 1, 'loginload', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_login', 1, 1, '{"pretext":"","posttext":"","login":"280","logout":"280","greeting":"1","name":"0","usesecure":"0","layout":"","moduleclass_sfx":"","cache":"0"}', 0, '*'),
(45, 0, 'Menu', '', '', 1, 'menuload', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{"menutype":"mainmenu","startLevel":"1","endLevel":"0","showAllChildren":"0","tag_id":"","class_sfx":"","window_open":"","layout":"","moduleclass_sfx":"","cache":"0","cache_time":"900","cachemode":"itemid"}', 0, '*'),
(47, 0, 'Latest Park Blogs', '', '', 6, 'user6', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_latest', 1, 1, '{"count":"5","ordering":"c_dsc","user_id":"0","show_featured":"","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, 'en-GB'),
(48, 0, 'Custom HTML', '', '<p>This is a custom html module. That means you can enter whatever content you want.</p>', 1, 'customload', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","layout":"","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(52, 0, 'Breadcrumbs', '', '', 1, 'breadcrumbsload', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_breadcrumbs', 1, 1, '{"showHome":"1","homeText":"Home","showLast":"1","separator":"","layout":"","moduleclass_sfx":"","cache":"0","cache_time":"900","cachemode":"itemid"}', 0, '*'),
(56, 0, 'Banners', '', '', 1, 'footer', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_banners', 1, 1, '{"target":"1","count":"1","cid":"1","catid":["15"],"tag_search":"0","ordering":"random","header_text":"","footer_text":"","moduleclass_sfx":"","cache":"1","cache_time":"900"}', 0, '*'),
(57, 0, 'Fruit Shop', '', '', 1, 'user9', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{"menutype":"fruitshop","startLevel":"1","endLevel":"0","showAllChildren":"0","tag_id":"","class_sfx":"","window_open":"","moduleclass_sfx":"","cache":"0","cache_time":"900","cachemode":"itemid"}', 0, '*'),
(58, 0, 'Special!', '', '<h1>This week we have a special, half price on delicious oranges!</h1><div>Only for our special customers!</div><div>Use the code: Joomla! when ordering</div><p><em>This module can only be seen by people in the customers group or higher.</em></p>', 1, 'position-12', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 4, 1, '{"prepare_content":"1","layout":"","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(61, 0, 'Articles Categories', '', '', 1, 'articlescategoriesload', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_categories', 1, 1, '{"parent":"29","show_description":"0","show_children":"0","maxlevel":"0","count":"0","layout":"","moduleclass_sfx":"","owncache":"1","cache_time":"900"}', 0, '*'),
(62, 0, 'Language Switcher', '', '', 3, 'position-4', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_languages', 1, 1, '{"header_text":"","footer_text":"","image":"1","layout":"","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(63, 0, 'Search', '', '', 1, 'position-0', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_search', 1, 1, '{"width":"20","text":"","button":"","button_pos":"right","imagebutton":"1","button_text":"","set_itemid":"","layout":"","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid"}', 0, '*'),
(64, 0, 'Language Switcher', '', '', 1, 'languageswitcherload', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_languages', 1, 1, '{"header_text":"","footer_text":"","image":"1","layout":"","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(65, 0, 'About Fruit Shop', '', '<p>The Fruit Shop site shows a number of Joomla! features.</p><p>The template uses classes in cascading style sheets to change the layout of items, such as creating the horizontal alphabetical list in the Fruit Encyclopedia.</p><p> </p>', 1, 'position-4', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","layout":"","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(67, 0, 'Extensions', '', '', 20, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_menu', 1, 1, '{"menutype":"aboutjoomla","startLevel":"1","endLevel":"6","showAllChildren":"0","tag_id":"","class_sfx":"-menu","window_open":"","layout":"","moduleclass_sfx":"","cache":"0","cache_time":"900","cachemode":"itemid"}', 0, '*'),
(68, 0, 'About Parks', '', '<p>The Parks sample site is designed as a simple site that can be routinely updated from the front end of Joomla!.</p><p>As a site, it is largely focused on a blog which can be updated using the front end article submission.</p><p>New weblinks can also be added through the front end.</p><p>A simple image gallery uses com_content with thumbnails displayed in a blog layout and full size images shown in article layout.</p><p>The Parks site features the language switch module. All of the content and modules are tagged as English (en-GB). If a second language pack is added with sample data this can be filtered using the language switch.</p><p>Parks uses HTML5 which is a major web standard (along with XHTML which is used in other areas of sample data).</p>', 2, 'position-4', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","layout":"","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(69, 0, 'Articles Category', '', '', 1, 'articlescategoryload', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_category', 1, 1, '{"mode":"normal","show_on_article_page":"1","show_front":"show","count":"0","category_filtering_type":"1","catid":["72"],"show_child_category_articles":"0","levels":"1","author_filtering_type":"1","created_by":[""],"author_alias_filtering_type":"1","created_by_alias":[""],"excluded_articles":"","date_filtering":"off","date_field":"a.created","start_date_range":"","end_date_range":"","relative_date":"30","article_ordering":"a.title","article_ordering_direction":"ASC","article_grouping":"none","article_grouping_direction":"ksort","month_year_format":"F Y","item_heading":"4","show_date":"0","show_date_field":"created","show_date_format":"Y-m-d H:i:s","show_category":"0","show_hits":"0","show_author":"0","show_introtext":"0","introtext_limit":"100","layout":"","moduleclass_sfx":"","owncache":"1","cache_time":"900"}', 0, '*'),
(70, 0, 'Search (Atomic Template)', '', '', 1, 'atomic-search', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_search', 1, 0, '{"width":"20","text":"","button":"","button_pos":"right","imagebutton":"","button_text":"","set_itemid":"","layout":"","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid"}', 0, '*'),
(71, 0, 'Top Menu (Atomic Template)', '', '', 1, 'atomic-topmenu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 0, '{"menutype":"aboutjoomla","startLevel":"1","endLevel":"0","showAllChildren":"0","tag_id":"","class_sfx":"","window_open":"","layout":"","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid"}', 0, '*'),
(72, 0, 'Top Quote (Atomic Template)', '', '<hr />\r\n<h2 class="alt">Powerful Content Management and a Simple Extensible Framework.</h2>\r\n<hr />', 1, 'atomic-topquote', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"1","layout":"","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(73, 0, 'Bottom Left Column (Atomic Template)', '', '<h6>This is a nested column</h6>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.</p>', 1, 'atomic-bottomleft', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"1","layout":"","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(74, 0, 'Bottom Middle Column (Atomic Template)', '', '<h6>This is another nested column</h6>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.</p>', 1, 'atomic-bottommiddle', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"1","layout":"","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(75, 0, 'Sidebar (Atomic Template)', '', '<h3>A <span class="alt">Simple</span> Sidebar</h3>\r\n<p>Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Cras ornare mattis nunc. Mauris venenatis, pede sed aliquet vehicula, lectus tellus pulvinar neque, non cursus sem nisi vel augue.</p>\r\n<p class="quiet">Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Cras ornare mattis nunc. Mauris venenatis, pede sed aliquet vehicula, lectus tellus pulvinar neque, non cursus sem nisi vel augue.</p>\r\n<h5>Incremental leading</h5>\r\n<p class="incr">Vestibulum ante ipsum primis in faucibus orci luctus vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Cras ornare mattis nunc. Mauris venenatis, pede sed aliquet vehicula, lectus tellus pulvinar neque, non cursus sem nisi vel augue. sed aliquet vehicula, lectus tellus.</p>\r\n<p class="incr">Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Cras ornare mattis nunc. Mauris venenatis, pede sed aliquet vehicula, lectus tellus pulvinar neque, non cursus sem nisi vel augue. sed aliquet vehicula, lectus tellus pulvinar neque, non cursus sem nisi vel augue. ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Cras ornare mattis nunc. Mauris venenatis, pede sed aliquet vehicula, lectus tellus pulvinar neque, non cursus sem nisi vel augue. sed aliquet vehicula, lectus tellus pulvinar neque, non cursus sem nisi vel augue.</p>', 1, 'atomic-sidebar', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"1","layout":"","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(76, 0, 'Login (Atomic Template)', '', '', 2, 'atomic-sidebar', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_login', 1, 0, '{"pretext":"","posttext":"","login":"","logout":"","greeting":"1","name":"0","usesecure":"0","layout":"","moduleclass_sfx":"","cache":"0"}', 0, '*'),
(77, 0, 'What is Joomla?', '', '<img src="images/stories/demo/sam-6.png" border="0" alt="Global" align="left" style="margin-right: 10px;" /> <a href="http://www.joomla.org" target="_blank" title="Joomla">Joomla</a> is an award-winning content management system (CMS), which enables you to build Web sites and powerful online applications <a href="http://www.joomla.org" target="_blank" title="Joomla">...</a>', 1, 'user1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(78, 0, 'What\'s Module?', '', '<img src="images/stories/demo/sam-8.png" border="0" alt="Global" align="left" style="margin-right: 10px;" /> <a href="http://docs.joomla.org/What_is_module_chrome%3F" target="_blank" title="Module chrome">Module chrome</a> allows template designers to have a certain amount of control over the way the output from a Module is displayed in their <a href="http://docs.joomla.org/What_is_module_chrome%3F" target="_blank" title="Module chrome">...</a>', 1, 'user2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(79, 0, 'What is Component?', '', '<img src="images/stories/demo/sam-7.png" border="0" alt="Global" align="left" style="margin-right: 10px;" /> A component is a kind of Joomla! <a href="http://docs.joomla.org/Extension" target="_blank" title="Extension">extension</a>. Ultrices justo lorem ante pede scelerisque sodales accumsan...', 1, 'user3', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(80, 0, 'What is plugin?', '', '<img src="images/stories/demo/sam-9.png" border="0" alt="Global" align="left" style="margin-right: 10px;" /> <a href="http://docs.joomla.org/Plugin" target="_blank" title="Plugin">A plugin</a> is a kind of Joomla! extension. Plugins provide routines which are associated with trigger events within Joomla.When a particular <a href="http://docs.joomla.org/Plugin" target="_blank" title="Plugin">...</a>', 1, 'user4', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(81, 0, 'Joomla Tutorial', '', '<p><strong>How to Apply a Module Class Suffix in Joomla! 1.6?</strong></p>\r\n<ol>\r\n<li>Login to backend</li>\r\n<li>Go to the Module Manager</li>\r\n<li>Select the Module you want to edit</li>\r\n<li>Type the Module Class Suffix into the parameters to the right</li>\r\n<li>Save the Setting</li>\r\n</ol>', 4, 'position-5', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', -2, 'mod_custom', 1, 1, '{"prepare_content":"1","layout":"","moduleclass_sfx":"badge-new","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(82, 0, 'Download', '', '<img src="images/stories/demo/sam-12.jpg" alt="Responsive web design" />\r\n\r\nResize browser to see the magic. And experience the ride with your wide screen, laptop, ipad, kindle, iphone or any handheld device.', 1, 'mega1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(83, 0, 'Features Highlight', '', '<p>JA T3 template frameworks, you can:</p>\r\n<p><strong>- Support multi &amp; flexible layout</strong></p>\r\n<p><strong>- Iphone + Handheld support</strong></p>\r\n<p><strong>- Menu system is second to none</strong></p>\r\n<p><strong>- SEO &amp; Fast loading..</strong></p>\r\n<p><a href="http://www.joomlart.com/forums/downloads.php?do=cat&amp;id=145" title="download t3 framework">Download</a> - <a href="http://wiki.joomlart.com/wiki/JA_T3_Framework_2/Overview" title="wiki">wiki</a></p>', 1, 'mega2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(84, 0, 'Vimeo', '', '<param name="width" value="300" />\r\n<param name="height" value="170" />\r\n<param name="allowfullscreen" value="true" />\r\n<param name="allowscriptaccess" value="always" />\r\n<param name="wmode" value="transparent" />\r\n<param name="src" value="http://vimeo.com/moogaloop.swf?clip_id=7047863&server=vimeo.com&show_title=1&show_byline=1&show_portrait=0&color=&fullscreen=1" />\r\n', 1, 'vimeo', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"1","layout":"","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(85, 0, 'Advertisement', '', '', 2, 'extra-col', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_banners', 1, 1, '{"target":"0","count":"4","cid":"1","catid":["77"],"tag_search":"0","ordering":"0","header_text":"Featured Links:","footer_text":"<a href=\\"http:\\/\\/www.joomla.org\\">Ads by Joomla!<\\/a>","layout":"_:default","moduleclass_sfx":"_text grid-mass hide-in-normal","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(86, 0, 'Top Message', '', 'This is the Blank & Clean template of JoomlArt T3 Framework. <a href="http://demo.t3.joomlart.com">Live demo</a> - <a href="http://www.joomlart.com/joomla/t3-framework-and-ja-purity-templates">More Info</a> - <a href="http://wiki.joomlart.com/wiki/JA_T3_Framework_2/Overview">Documentation</a> - <a href="http://wiki.joomlart.com/wiki/JA_T3_Framework_2/Guides">Developer Guide</a><br /> This demo will be refreshed every hour. You can access <a href="../../../../joomla16/administrator/index.php" title="administrator"><strong>Joomla Back-end Administration</strong></a> with user <span style="color:blue;"><strong>admin</strong></span>, password <span style="color:blue;"><strong>admin</strong></span>\r\n<a target="_blank" href="http://www.joomlart.com/joomla/jat3-framework/" class="ja-icon-video"><span>Video</span></a>', 1, 'top-panel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', -2, 'mod_custom', 1, 0, '{"prepare_content":"1","layout":"","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(87, 0, 'Advertisement', '', '<div class="bannergroup_text">\r\n<div class="bannerheader">Featured Links:</div>\r\n<div class="banneritem_text"><a href="../../../../joomla16/index.php?option=com_banners&task=click&bid=3" target="_blank">Joomla!</a> <br /> Joomla! The most popular and widely used Open Source CMS Project in the world.</div>\r\n<div class="banneritem_text"><a href="../../../../joomla16/index.php?option=com_banners&task=click&bid=4" target="_blank">JoomlaCode</a> <br /> JoomlaCode, development and distribution made easy.</div>\r\n<div class="banneritem_text"><a href="../../../../joomla16/index.php?option=com_banners&task=click&bid=5" target="_blank">Joomla! Extensions</a> <br /> Joomla! Components, Modules, Plugins and Languages by the bucket load.</div>\r\n<div class="banneritem_text"><a href="../../../../joomla16/index.php?option=com_banners&task=click&bid=6" target="_blank">Joomla! Shop</a> <br /> For all your Joomla! merchandise.</div>\r\n<div class="bannerfooter_text"><a href="http://www.joomla.org">Ads by Joomla!</a></div>\r\n</div>', 6, 'position-5', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', -2, 'mod_custom', 1, 1, '{"prepare_content":"1","moduleclass_sfx":"_text","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(89, 0, 'Joomla Tutorial', '', '<p><strong>How to Apply a Module Class Suffix in Joomla 2.5?</strong></p>\r\n<ol>\r\n<li>Login to backend.</li>\r\n<li>Go to the Module Manager.</li>\r\n<li>Select the Module you want to edit.</li>\r\n<li>Type the Module Class Suffix into the parameters to the right.</li>\r\n<li>Save the Setting.</li>\r\n</ol>', 2, 'position-5', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":" grid-double","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(91, 0, 'Top Message', '', 'This is the Blank &amp; Clean template of JoomlArt T3 Framework. <a href="../">Live demo</a> - <a href="http://www.joomlart.com/joomla/t3-framework-and-ja-purity-templates">More Info</a> - <a href="http://wiki.joomlart.com/wiki/JA_T3_Framework_2/Overview">Documentation</a> - <a href="http://wiki.joomlart.com/wiki/JA_T3_Framework_2/Guides">Developer Guide</a><br /> This demo will be refreshed every hour. You can access <a href="administrator/index.php" title="administrator"><strong>Joomla Back-end Administration</strong></a> with user <span style="color: blue;"><strong>admin</strong></span>, password <span style="color: blue;"><strong>admin</strong></span> <a class="ja-icon-video" href="http://www.joomlart.com/joomla/jat3-framework/" target="_blank"><span>Video</span></a>', 0, 'top-panel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(92, 0, 'Template features', '', '<div class="ja-innerdiv clearfix">\r\n<strong class="txt-red">1. Responsive</strong><br />\r\nPellentesque auctor leo fringilla pulvinar.\r\n</div>\r\n\r\n<div class="ja-innerdiv clearfix">\r\n<strong class="txt-green">2. Grid System</strong><br />\r\nPellentesque auctor leo fringilla pulvinar.\r\n</div>\r\n\r\n<div class="ja-innerdiv clearfix">\r\n<strong class="txt-blue">3. Multiple Block style</strong><br />\r\nPellentesque auctor leo fringilla pulvinar.\r\n</div>', 7, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":" mod-contrast contrast-dark","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(93, 0, 'Responsive Quote', '', '<div class="big-quote">\r\n<blockquote>JA Elastica is our first responsive web design!</blockquote>\r\n</div>\r\n<p><span class="author">_ JoomlArt</span></p>', 8, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":" mod-contrast contrast-red","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(94, 0, 'Our Gallery', '', '<img src="images/stories/demo/sam-4.jpg" alt="Sample image" />\r\n\r\n<div style="margin-top: 5px;"><strong><small>Source: </small></strong> <a href="www.wallbase.net" title="Source" target="_blank">www.wallbase.net</a></div>', 14, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":" badge-photo","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(95, 0, 'Contrast head blue', '', 'Vitae vitae urna eros Curabitur ipsum et eget Lorem sem nibh. Dui Nunc pharetra tincidunt urna nibh quis ante feugiat justo pellentesque. Fringilla penatibus egestas laoreet enim In amet accumsan Sed felis semper.', 24, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', -2, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":" mod-contrast-head contrast-head-blue","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(96, 0, 'Badge hot', '', 'Vitae vitae urna eros curabitur ipsum et eget <strong><a href="#" title="Sample link">lorem sem nibh</a></strong>. Dui nunc pharetra tincidunt urna nibh.', 10, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":" badge-hot","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(97, 0, 'Twitter with Responsive Joomla 2.5', '', '<div id="ja-twitter-wrap">\r\n<p>Did you guys try out this responsive Joomla 2.5 web design?</p>\r\n<span class="date">_ about 3 hours ago</span></div>', 4, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":" grid-double mod-contrast contrast-blue","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(98, 0, 'My love song', '', '<img src="images/stories/demo/audio-bg.png" alt="Audio" />\r\n\r\nEtiam pellentesque magna id lacus imperdiet ac vulputate enim semper. Donec tincidunt.', 15, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":" badge-audio","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(99, 0, 'Hot video', '', '<a href="http://www.youtube.com/watch?v=aBvyc5P7Fsg" title="JA Elastica - Web Responsive Design Template for Joomla! "><img src="images/stories/demo/sample-video.jpg" alt="Sample video" title="Sample video" /></a>\r\n\r\n<p>Quis eros Aliquam et diam ac a dolor nec nunc accumsan. Vitae velit tortor nunc dolor turpis.</p>', 12, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":" badge-video","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(100, 0, 'Badge new', '', 'Pellentesque sed aliquet mauris iaculis pretium dapibus porttitor. tincidunt sem quam Morbi nulla elit a tortor vitae.', 11, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":" badge-new","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(101, 0, 'Blue module', '', '<p class="blocktag"><span class="bigicon">&nbsp;</span>Sapien condimentum tellus ac In a eget molestie lacus et porttitor facilisi.</p>', 16, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":" mod-contrast contrast-blue","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(102, 0, 'Dark module', '', '<p class="blockmobile"><span class="bigicon">&nbsp;</span>Sapien condimentum tellus ac In a eget molestie lacus et porttitor.</p>', 21, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":" mod-contrast contrast-dark","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(103, 0, 'Green module', '', '<p class="blocklink"><span class="bigicon">&nbsp;</span>Sapien condimentum tellus ac In a eget molestie lacus et porttitor.</p>', 22, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":" mod-contrast contrast-green","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(104, 0, 'Extra column', '', 'Parturient et Nam enim et orci wisi auctor consequat ante accumsan.', 1, 'extra-col', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":" hide-in-normal","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(105, 0, 'Red module', '', '<p class="blockheart"><span class="bigicon">&nbsp;</span>Sapien condimentum tellus ac In a eget molestie lacus et porttitor.</p>', 13, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":" mod-contrast contrast-red","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(106, 0, 'Badge top', '', 'Lacinia mollis leo wisi ridiculus <a href="#" title="Sample title">sed pellentesque</a> condimentum condimentum nunc tincidunt.', 6, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":" badge-top","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(107, 0, 'Violet module', '', '<p class="blockquestion"><span class="bigicon">&nbsp;</span>Sapien condimentum tellus ac In a eget molestie lacus et porttitor.</p>', 17, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":" mod-contrast contrast-violet","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(108, 0, 'Responsive Web Design', '', 'Sagittis interdum Ut semper tempus adipiscing Curabitur wisi eu at Cras. Id eros eu consequat quis fringilla volutpat urna ut Ut eu. A velit quam amet In urna ut Vivamus Lorem sed vitae. Tellus interdum Curabitur sollicitudin justo congue id nisl ac porta sociis. “<strong>lobortis eros ultrices tortor augue tristique.</strong>” ', 3, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":" grid-double badge-hot","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(109, 0, 'Banner', '', '<a href="http://www.joomlart.com/ipad2/" title="Sample link"><img src="images/banners/ipad2.jpg" alt="Sample banner" /></a>', 1, 'extra-col', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"_blank","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(110, 0, 'JA Social', '', '<ul class="ja-social">\r\n<li class="social-twitter"><a href="http://twitter.com/joomlart" title="Twitter">Twitter</a></li>\r\n<li class="social-facebook"><a href="http://www.facebook.com/joomlart" title="Facebook">Facebook</a></li>\r\n<li class="social-gplus"><a href="https://plus.google.com/u/0/116006606347148002866/posts" title="Google+">Google+</a></li>\r\n<li class="social-rss"><a href="#" title="RSS">RSS</a></li>\r\n</ul>', 1, 'social', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(111, 0, 'Partners logo', '', '<img src="images/stories/demo/partners.png" alt="Partners logo" />', 1, 'footer', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static"}', 0, '*'),
(112, 0, 'Sample banner 1', '', '', 1, 'extra-col', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_banners', 1, 0, '{"target":"1","count":"5","cid":"1","catid":["81"],"tag_search":"0","ordering":"0","header_text":"","footer_text":"","layout":"_:default","moduleclass_sfx":"_blank","cache":"1","cache_time":"900"}', 0, '*'),
(113, 0, 'Joomla Version', '', '', 1, 'footer', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_version', 3, 1, '{"format":"short","product":"1","layout":"_:default","moduleclass_sfx":"","cache":"0"}', 1, '*'),
(116, 0, 'Popular Tags', '', '', 1, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_tags_popular', 1, 1, '{"maximum":"10","timeframe":"alltime","layout":"_:default","moduleclass_sfx":" grid-double","owncache":"1","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(117, 0, 'Similar Tags', '', '', 2, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_tags_similar', 1, 1, '{"maximum":"10","matchtype":"any","layout":"_:default","moduleclass_sfx":" grid-double","owncache":"1","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*');

DROP TABLE IF EXISTS `#__modules_menu`;
CREATE TABLE `#__modules_menu` (
  `moduleid` int(11) NOT NULL DEFAULT 0,
  `menuid` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`moduleid`,`menuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__modules_menu` (`moduleid`, `menuid`) VALUES
(1, 201),
(1, 207),
(1, 227),
(1, 229),
(1, 234),
(1, 242),
(1, 243),
(1, 244),
(1, 249),
(1, 251),
(1, 252),
(1, 253),
(1, 254),
(1, 255),
(1, 256),
(1, 257),
(1, 259),
(1, 260),
(1, 262),
(1, 263),
(1, 265),
(1, 266),
(1, 267),
(1, 268),
(1, 270),
(1, 271),
(1, 272),
(1, 273),
(1, 274),
(1, 275),
(1, 276),
(1, 277),
(1, 278),
(1, 279),
(1, 280),
(1, 281),
(1, 282),
(1, 283),
(1, 284),
(1, 285),
(1, 286),
(1, 296),
(1, 300),
(1, 301),
(1, 302),
(1, 303),
(1, 304),
(1, 305),
(1, 306),
(1, 307),
(1, 309),
(1, 310),
(1, 311),
(1, 312),
(1, 313),
(1, 316),
(1, 317),
(1, 318),
(1, 319),
(1, 320),
(1, 321),
(1, 322),
(1, 323),
(1, 324),
(1, 325),
(1, 326),
(1, 399),
(1, 400),
(1, 402),
(1, 403),
(1, 404),
(1, 405),
(1, 406),
(1, 409),
(1, 410),
(1, 411),
(1, 412),
(1, 413),
(1, 414),
(1, 415),
(1, 416),
(1, 417),
(1, 418),
(1, 419),
(1, 421),
(1, 422),
(1, 423),
(1, 424),
(1, 427),
(1, 429),
(1, 430),
(1, 431),
(1, 432),
(1, 433),
(1, 435),
(1, 436),
(1, 437),
(1, 443),
(1, 447),
(1, 449),
(1, 451),
(1, 452),
(1, 453),
(1, 456),
(1, 457),
(1, 458),
(1, 459),
(1, 462),
(1, 463),
(1, 464),
(1, 506),
(1, 507),
(1, 508),
(1, 509),
(1, 510),
(1, 511),
(1, 529),
(1, 530),
(1, 531),
(1, 532),
(1, 533),
(1, 534),
(1, 535),
(1, 537),
(1, 538),
(1, 539),
(1, 540),
(1, 541),
(1, 542),
(1, 544),
(1, 545),
(1, 546),
(1, 547),
(1, 548),
(1, 549),
(1, 550),
(1, 551),
(1, 555),
(1, 556),
(2, 0),
(3, 0),
(4, 0),
(6, 0),
(7, 0),
(8, 0),
(9, 0),
(10, 0),
(12, 0),
(13, 0),
(14, 0),
(15, 0),
(16, 435),
(17, 0),
(18, 0),
(19, -556),
(19, -463),
(19, -462),
(19, -433),
(19, -432),
(19, -431),
(19, -430),
(19, -429),
(19, -427),
(19, -400),
(19, -399),
(19, -296),
(19, -244),
(19, -243),
(19, -242),
(19, -234),
(20, 0),
(22, 234),
(22, 242),
(22, 243),
(22, 244),
(22, 296),
(22, 399),
(22, 400),
(22, 435),
(23, 201),
(23, 207),
(23, 227),
(23, 229),
(23, 234),
(23, 242),
(23, 243),
(23, 244),
(23, 249),
(23, 251),
(23, 252),
(23, 253),
(23, 254),
(23, 255),
(23, 256),
(23, 257),
(23, 259),
(23, 260),
(23, 262),
(23, 263),
(23, 265),
(23, 266),
(23, 267),
(23, 268),
(23, 270),
(23, 271),
(23, 272),
(23, 273),
(23, 274),
(23, 275),
(23, 276),
(23, 277),
(23, 278),
(23, 279),
(23, 280),
(23, 281),
(23, 282),
(23, 283),
(23, 284),
(23, 285),
(23, 286),
(23, 296),
(23, 300),
(23, 301),
(23, 302),
(23, 303),
(23, 304),
(23, 305),
(23, 306),
(23, 307),
(23, 309),
(23, 310),
(23, 311),
(23, 312),
(23, 313),
(23, 316),
(23, 317),
(23, 318),
(23, 319),
(23, 320),
(23, 321),
(23, 322),
(23, 323),
(23, 324),
(23, 325),
(23, 326),
(23, 399),
(23, 400),
(23, 402),
(23, 403),
(23, 404),
(23, 405),
(23, 406),
(23, 409),
(23, 410),
(23, 411),
(23, 412),
(23, 413),
(23, 414),
(23, 415),
(23, 416),
(23, 417),
(23, 418),
(23, 419),
(23, 421),
(23, 422),
(23, 423),
(23, 424),
(23, 427),
(23, 429),
(23, 430),
(23, 431),
(23, 432),
(23, 433),
(23, 435),
(23, 436),
(23, 437),
(23, 443),
(23, 447),
(23, 449),
(23, 451),
(23, 452),
(23, 453),
(23, 456),
(23, 457),
(23, 458),
(23, 459),
(23, 462),
(23, 463),
(23, 464),
(23, 506),
(23, 507),
(23, 508),
(23, 509),
(23, 510),
(23, 511),
(23, 529),
(23, 530),
(23, 531),
(23, 532),
(23, 533),
(23, 534),
(23, 535),
(23, 537),
(23, 538),
(23, 539),
(23, 544),
(23, 545),
(23, 546),
(23, 547),
(23, 549),
(23, 550),
(23, 551),
(23, 555),
(25, 294),
(26, -463),
(26, -462),
(26, -433),
(26, -432),
(26, -431),
(26, -430),
(26, -429),
(26, -427),
(26, -400),
(26, -399),
(26, -296),
(26, -244),
(26, -243),
(26, -242),
(26, -238),
(26, -234),
(27, 325),
(28, 310),
(29, 302),
(30, 410),
(31, 309),
(32, 309),
(33, 307),
(34, 326),
(35, 0),
(36, 304),
(37, 311),
(38, 300),
(39, 201),
(39, 207),
(39, 227),
(39, 229),
(39, 234),
(39, 242),
(39, 243),
(39, 244),
(39, 249),
(39, 251),
(39, 252),
(39, 253),
(39, 254),
(39, 255),
(39, 256),
(39, 257),
(39, 259),
(39, 260),
(39, 262),
(39, 263),
(39, 265),
(39, 266),
(39, 267),
(39, 268),
(39, 270),
(39, 271),
(39, 272),
(39, 273),
(39, 274),
(39, 275),
(39, 276),
(39, 277),
(39, 278),
(39, 279),
(39, 280),
(39, 281),
(39, 282),
(39, 283),
(39, 284),
(39, 285),
(39, 286),
(39, 296),
(39, 300),
(39, 301),
(39, 302),
(39, 303),
(39, 304),
(39, 305),
(39, 306),
(39, 307),
(39, 309),
(39, 310),
(39, 311),
(39, 312),
(39, 313),
(39, 316),
(39, 317),
(39, 318),
(39, 319),
(39, 320),
(39, 321),
(39, 322),
(39, 323),
(39, 324),
(39, 325),
(39, 326),
(39, 399),
(39, 400),
(39, 402),
(39, 403),
(39, 404),
(39, 405),
(39, 406),
(39, 409),
(39, 410),
(39, 411),
(39, 412),
(39, 413),
(39, 414),
(39, 415),
(39, 416),
(39, 417),
(39, 418),
(39, 419),
(39, 421),
(39, 422),
(39, 423),
(39, 424),
(39, 427),
(39, 429),
(39, 430),
(39, 431),
(39, 432),
(39, 433),
(39, 435),
(39, 436),
(39, 437),
(39, 443),
(39, 447),
(39, 449),
(39, 451),
(39, 452),
(39, 453),
(39, 456),
(39, 457),
(39, 458),
(39, 459),
(39, 462),
(39, 463),
(39, 464),
(39, 506),
(39, 507),
(39, 508),
(39, 509),
(39, 510),
(39, 511),
(39, 529),
(39, 530),
(39, 531),
(39, 532),
(39, 533),
(39, 534),
(39, 535),
(39, 555),
(40, 313),
(41, 0),
(44, 312),
(45, 303),
(47, 234),
(47, 242),
(47, 243),
(47, 244),
(47, 296),
(47, 399),
(47, 400),
(47, 435),
(48, 418),
(52, 294),
(52, 416),
(56, 0),
(57, 435),
(57, 464),
(58, 427),
(58, 429),
(58, 430),
(58, 431),
(58, 432),
(58, 433),
(58, 462),
(58, 463),
(60, 227),
(60, 229),
(60, 249),
(60, 251),
(60, 252),
(60, 253),
(60, 254),
(60, 255),
(60, 256),
(60, 257),
(60, 259),
(60, 260),
(60, 262),
(60, 263),
(60, 265),
(60, 266),
(60, 267),
(60, 270),
(60, 271),
(60, 272),
(60, 273),
(60, 274),
(60, 275),
(60, 276),
(60, 281),
(60, 282),
(60, 283),
(60, 284),
(60, 285),
(60, 286),
(60, 300),
(60, 301),
(60, 302),
(60, 303),
(60, 304),
(60, 305),
(60, 306),
(60, 307),
(60, 309),
(60, 310),
(60, 311),
(60, 312),
(60, 313),
(60, 314),
(60, 316),
(60, 317),
(60, 318),
(60, 319),
(60, 320),
(60, 321),
(60, 322),
(60, 323),
(60, 324),
(60, 325),
(60, 326),
(60, 402),
(60, 403),
(60, 404),
(60, 405),
(60, 406),
(60, 409),
(60, 410),
(60, 411),
(60, 412),
(60, 413),
(60, 414),
(60, 415),
(60, 416),
(60, 417),
(60, 418),
(60, 419),
(60, 420),
(60, 421),
(60, 422),
(60, 423),
(60, 424),
(60, 425),
(60, 426),
(61, 443),
(62, 231),
(62, 234),
(62, 242),
(62, 243),
(62, 244),
(62, 296),
(62, 399),
(62, 400),
(63, 0),
(64, 447),
(65, 427),
(65, 429),
(65, 430),
(65, 431),
(65, 432),
(65, 433),
(65, 462),
(65, 463),
(69, 459),
(70, 285),
(70, 316),
(71, 285),
(71, 316),
(72, 285),
(72, 316),
(73, 285),
(73, 316),
(74, 285),
(74, 316),
(75, 285),
(75, 316),
(76, 285),
(76, 316),
(77, 435),
(78, 435),
(79, 435),
(80, 435),
(82, 0),
(83, 0),
(85, 201),
(85, 207),
(85, 227),
(85, 229),
(85, 234),
(85, 242),
(85, 243),
(85, 244),
(85, 249),
(85, 251),
(85, 252),
(85, 253),
(85, 254),
(85, 255),
(85, 256),
(85, 257),
(85, 259),
(85, 260),
(85, 262),
(85, 263),
(85, 265),
(85, 266),
(85, 267),
(85, 268),
(85, 270),
(85, 271),
(85, 272),
(85, 273),
(85, 274),
(85, 275),
(85, 276),
(85, 277),
(85, 278),
(85, 279),
(85, 280),
(85, 281),
(85, 282),
(85, 283),
(85, 284),
(85, 285),
(85, 286),
(85, 296),
(85, 300),
(85, 301),
(85, 302),
(85, 303),
(85, 304),
(85, 305),
(85, 306),
(85, 307),
(85, 309),
(85, 310),
(85, 311),
(85, 312),
(85, 313),
(85, 316),
(85, 317),
(85, 318),
(85, 319),
(85, 320),
(85, 321),
(85, 322),
(85, 323),
(85, 324),
(85, 325),
(85, 326),
(85, 399),
(85, 400),
(85, 402),
(85, 403),
(85, 404),
(85, 405),
(85, 406),
(85, 409),
(85, 410),
(85, 411),
(85, 412),
(85, 413),
(85, 414),
(85, 415),
(85, 416),
(85, 417),
(85, 418),
(85, 419),
(85, 421),
(85, 422),
(85, 423),
(85, 424),
(85, 427),
(85, 429),
(85, 430),
(85, 431),
(85, 432),
(85, 433),
(85, 435),
(85, 436),
(85, 437),
(85, 443),
(85, 447),
(85, 449),
(85, 451),
(85, 452),
(85, 453),
(85, 456),
(85, 457),
(85, 458),
(85, 459),
(85, 462),
(85, 463),
(85, 464),
(85, 506),
(85, 507),
(85, 508),
(85, 509),
(85, 510),
(85, 511),
(85, 529),
(85, 530),
(85, 531),
(85, 532),
(85, 533),
(85, 534),
(85, 535),
(85, 550),
(85, 555),
(85, 556),
(87, 201),
(87, 207),
(87, 227),
(87, 229),
(87, 234),
(87, 242),
(87, 243),
(87, 244),
(87, 249),
(87, 251),
(87, 252),
(87, 253),
(87, 254),
(87, 255),
(87, 256),
(87, 257),
(87, 259),
(87, 260),
(87, 262),
(87, 263),
(87, 265),
(87, 266),
(87, 267),
(87, 268),
(87, 270),
(87, 271),
(87, 272),
(87, 273),
(87, 274),
(87, 275),
(87, 276),
(87, 277),
(87, 278),
(87, 279),
(87, 280),
(87, 281),
(87, 282),
(87, 283),
(87, 284),
(87, 285),
(87, 286),
(87, 296),
(87, 300),
(87, 301),
(87, 302),
(87, 303),
(87, 304),
(87, 305),
(87, 306),
(87, 307),
(87, 309),
(87, 310),
(87, 311),
(87, 312),
(87, 313),
(87, 316),
(87, 317),
(87, 318),
(87, 319),
(87, 320),
(87, 321),
(87, 322),
(87, 323),
(87, 324),
(87, 325),
(87, 326),
(87, 399),
(87, 400),
(87, 402),
(87, 403),
(87, 404),
(87, 405),
(87, 406),
(87, 409),
(87, 410),
(87, 411),
(87, 412),
(87, 413),
(87, 414),
(87, 415),
(87, 416),
(87, 417),
(87, 418),
(87, 419),
(87, 421),
(87, 422),
(87, 423),
(87, 424),
(87, 427),
(87, 429),
(87, 430),
(87, 431),
(87, 432),
(87, 433),
(87, 435),
(87, 436),
(87, 437),
(87, 443),
(87, 444),
(87, 447),
(87, 449),
(87, 451),
(87, 452),
(87, 453),
(87, 456),
(87, 457),
(87, 458),
(87, 459),
(87, 462),
(87, 463),
(87, 464),
(87, 506),
(87, 507),
(87, 508),
(87, 509),
(87, 510),
(87, 511),
(87, 512),
(87, 513),
(87, 514),
(87, 515),
(87, 517),
(87, 518),
(87, 519),
(87, 520),
(87, 521),
(87, 522),
(87, 523),
(87, 524),
(87, 525),
(87, 526),
(87, 527),
(87, 528),
(87, 529),
(87, 530),
(87, 531),
(87, 532),
(87, 533),
(87, 534),
(87, 535),
(89, 201),
(89, 207),
(89, 227),
(89, 229),
(89, 234),
(89, 242),
(89, 243),
(89, 244),
(89, 249),
(89, 251),
(89, 252),
(89, 253),
(89, 254),
(89, 255),
(89, 256),
(89, 257),
(89, 259),
(89, 260),
(89, 262),
(89, 263),
(89, 265),
(89, 266),
(89, 267),
(89, 268),
(89, 270),
(89, 271),
(89, 272),
(89, 273),
(89, 274),
(89, 275),
(89, 276),
(89, 277),
(89, 278),
(89, 279),
(89, 280),
(89, 281),
(89, 282),
(89, 283),
(89, 284),
(89, 285),
(89, 286),
(89, 296),
(89, 300),
(89, 301),
(89, 302),
(89, 303),
(89, 304),
(89, 305),
(89, 306),
(89, 307),
(89, 309),
(89, 310),
(89, 311),
(89, 312),
(89, 313),
(89, 316),
(89, 317),
(89, 318),
(89, 319),
(89, 320),
(89, 321),
(89, 322),
(89, 323),
(89, 324),
(89, 325),
(89, 326),
(89, 399),
(89, 400),
(89, 402),
(89, 403),
(89, 404),
(89, 405),
(89, 406),
(89, 409),
(89, 410),
(89, 411),
(89, 412),
(89, 413),
(89, 414),
(89, 415),
(89, 416),
(89, 417),
(89, 418),
(89, 419),
(89, 421),
(89, 422),
(89, 423),
(89, 424),
(89, 427),
(89, 429),
(89, 430),
(89, 431),
(89, 432),
(89, 433),
(89, 435),
(89, 436),
(89, 437),
(89, 443),
(89, 447),
(89, 449),
(89, 451),
(89, 452),
(89, 453),
(89, 456),
(89, 457),
(89, 458),
(89, 459),
(89, 462),
(89, 463),
(89, 464),
(89, 506),
(89, 507),
(89, 508),
(89, 509),
(89, 510),
(89, 511),
(89, 529),
(89, 530),
(89, 531),
(89, 532),
(89, 533),
(89, 534),
(89, 535),
(89, 555),
(90, 0),
(91, 0),
(92, 201),
(92, 207),
(92, 227),
(92, 229),
(92, 234),
(92, 242),
(92, 243),
(92, 244),
(92, 249),
(92, 251),
(92, 252),
(92, 253),
(92, 254),
(92, 255),
(92, 256),
(92, 257),
(92, 259),
(92, 260),
(92, 262),
(92, 263),
(92, 265),
(92, 266),
(92, 267),
(92, 268),
(92, 270),
(92, 271),
(92, 272),
(92, 273),
(92, 274),
(92, 275),
(92, 276),
(92, 277),
(92, 278),
(92, 279),
(92, 280),
(92, 281),
(92, 282),
(92, 283),
(92, 284),
(92, 285),
(92, 286),
(92, 296),
(92, 300),
(92, 301),
(92, 302),
(92, 303),
(92, 304),
(92, 305),
(92, 306),
(92, 307),
(92, 309),
(92, 310),
(92, 311),
(92, 312),
(92, 313),
(92, 316),
(92, 317),
(92, 318),
(92, 319),
(92, 320),
(92, 321),
(92, 322),
(92, 323),
(92, 324),
(92, 325),
(92, 326),
(92, 399),
(92, 400),
(92, 402),
(92, 403),
(92, 404),
(92, 405),
(92, 406),
(92, 409),
(92, 410),
(92, 411),
(92, 412),
(92, 413),
(92, 414),
(92, 415),
(92, 416),
(92, 417),
(92, 418),
(92, 419),
(92, 421),
(92, 422),
(92, 423),
(92, 424),
(92, 427),
(92, 429),
(92, 430),
(92, 431),
(92, 432),
(92, 433),
(92, 435),
(92, 436),
(92, 437),
(92, 443),
(92, 447),
(92, 449),
(92, 451),
(92, 452),
(92, 453),
(92, 456),
(92, 457),
(92, 458),
(92, 459),
(92, 462),
(92, 463),
(92, 464),
(92, 506),
(92, 507),
(92, 508),
(92, 509),
(92, 510),
(92, 511),
(92, 529),
(92, 530),
(92, 531),
(92, 532),
(92, 533),
(92, 534),
(92, 535),
(92, 537),
(92, 538),
(92, 539),
(92, 540),
(92, 541),
(92, 544),
(92, 545),
(92, 546),
(92, 547),
(92, 548),
(92, 549),
(92, 550),
(92, 551),
(92, 555),
(92, 556),
(93, 201),
(93, 207),
(93, 227),
(93, 229),
(93, 234),
(93, 242),
(93, 243),
(93, 244),
(93, 249),
(93, 251),
(93, 252),
(93, 253),
(93, 254),
(93, 255),
(93, 256),
(93, 257),
(93, 259),
(93, 260),
(93, 262),
(93, 263),
(93, 265),
(93, 266),
(93, 267),
(93, 268),
(93, 270),
(93, 271),
(93, 272),
(93, 273),
(93, 274),
(93, 275),
(93, 276),
(93, 277),
(93, 278),
(93, 279),
(93, 280),
(93, 281),
(93, 282),
(93, 283),
(93, 284),
(93, 285),
(93, 286),
(93, 296),
(93, 300),
(93, 301),
(93, 302),
(93, 303),
(93, 304),
(93, 305),
(93, 306),
(93, 307),
(93, 309),
(93, 310),
(93, 311),
(93, 312),
(93, 313),
(93, 316),
(93, 317),
(93, 318),
(93, 319),
(93, 320),
(93, 321),
(93, 322),
(93, 323),
(93, 324),
(93, 325),
(93, 326),
(93, 399),
(93, 400),
(93, 402),
(93, 403),
(93, 404),
(93, 405),
(93, 406),
(93, 409),
(93, 410),
(93, 411),
(93, 412),
(93, 413),
(93, 414),
(93, 415),
(93, 416),
(93, 417),
(93, 418),
(93, 419),
(93, 421),
(93, 422),
(93, 423),
(93, 424),
(93, 427),
(93, 429),
(93, 430),
(93, 431),
(93, 432),
(93, 433),
(93, 435),
(93, 436),
(93, 437),
(93, 443),
(93, 447),
(93, 449),
(93, 451),
(93, 452),
(93, 453),
(93, 456),
(93, 457),
(93, 458),
(93, 459),
(93, 462),
(93, 463),
(93, 464),
(93, 506),
(93, 507),
(93, 508),
(93, 537),
(93, 538),
(93, 539),
(93, 540),
(93, 542),
(93, 544),
(93, 546),
(93, 547),
(93, 548),
(93, 551),
(93, 555),
(93, 556),
(94, 201),
(94, 207),
(94, 227),
(94, 229),
(94, 234),
(94, 242),
(94, 243),
(94, 244),
(94, 249),
(94, 251),
(94, 252),
(94, 253),
(94, 254),
(94, 255),
(94, 256),
(94, 257),
(94, 259),
(94, 260),
(94, 262),
(94, 263),
(94, 265),
(94, 266),
(94, 267),
(94, 268),
(94, 270),
(94, 271),
(94, 272),
(94, 273),
(94, 274),
(94, 275),
(94, 276),
(94, 277),
(94, 278),
(94, 279),
(94, 280),
(94, 281),
(94, 282),
(94, 283),
(94, 284),
(94, 285),
(94, 286),
(94, 296),
(94, 300),
(94, 301),
(94, 302),
(94, 303),
(94, 304),
(94, 305),
(94, 306),
(94, 307),
(94, 309),
(94, 310),
(94, 311),
(94, 312),
(94, 313),
(94, 316),
(94, 317),
(94, 318),
(94, 319),
(94, 320),
(94, 321),
(94, 322),
(94, 323),
(94, 324),
(94, 325),
(94, 326),
(94, 399),
(94, 400),
(94, 402),
(94, 403),
(94, 404),
(94, 405),
(94, 406),
(94, 409),
(94, 410),
(94, 411),
(94, 412),
(94, 413),
(94, 414),
(94, 415),
(94, 416),
(94, 417),
(94, 418),
(94, 419),
(94, 421),
(94, 422),
(94, 423),
(94, 424),
(94, 427),
(94, 429),
(94, 430),
(94, 431),
(94, 432),
(94, 433),
(94, 435),
(94, 436),
(94, 437),
(94, 443),
(94, 447),
(94, 449),
(94, 451),
(94, 452),
(94, 453),
(94, 456),
(94, 457),
(94, 458),
(94, 459),
(94, 462),
(94, 463),
(94, 464),
(94, 506),
(94, 507),
(94, 508),
(94, 509),
(94, 511),
(94, 537),
(94, 538),
(94, 539),
(94, 540),
(94, 544),
(94, 546),
(94, 550),
(94, 551),
(94, 555),
(95, 0),
(96, 201),
(96, 207),
(96, 227),
(96, 229),
(96, 234),
(96, 242),
(96, 243),
(96, 244),
(96, 249),
(96, 251),
(96, 252),
(96, 253),
(96, 254),
(96, 255),
(96, 256),
(96, 257),
(96, 259),
(96, 260),
(96, 262),
(96, 263),
(96, 265),
(96, 266),
(96, 267),
(96, 268),
(96, 270),
(96, 271),
(96, 272),
(96, 273),
(96, 274),
(96, 275),
(96, 276),
(96, 277),
(96, 278),
(96, 279),
(96, 280),
(96, 281),
(96, 282),
(96, 283),
(96, 284),
(96, 285),
(96, 286),
(96, 296),
(96, 300),
(96, 301),
(96, 302),
(96, 303),
(96, 304),
(96, 305),
(96, 306),
(96, 307),
(96, 309),
(96, 310),
(96, 311),
(96, 312),
(96, 313),
(96, 316),
(96, 317),
(96, 318),
(96, 319),
(96, 320),
(96, 321),
(96, 322),
(96, 323),
(96, 324),
(96, 325),
(96, 326),
(96, 399),
(96, 400),
(96, 402),
(96, 403),
(96, 404),
(96, 405),
(96, 406),
(96, 409),
(96, 410),
(96, 411),
(96, 412),
(96, 413),
(96, 414),
(96, 415),
(96, 416),
(96, 417),
(96, 418),
(96, 419),
(96, 421),
(96, 422),
(96, 423),
(96, 424),
(96, 427),
(96, 429),
(96, 430),
(96, 431),
(96, 432),
(96, 433),
(96, 435),
(96, 436),
(96, 437),
(96, 443),
(96, 447),
(96, 449),
(96, 451),
(96, 452),
(96, 453),
(96, 456),
(96, 457),
(96, 458),
(96, 459),
(96, 462),
(96, 463),
(96, 464),
(96, 506),
(96, 507),
(96, 508),
(96, 509),
(96, 537),
(96, 538),
(96, 539),
(96, 540),
(96, 544),
(96, 546),
(96, 547),
(96, 548),
(96, 549),
(96, 550),
(96, 551),
(96, 555),
(96, 556),
(97, 201),
(97, 207),
(97, 227),
(97, 229),
(97, 234),
(97, 242),
(97, 243),
(97, 244),
(97, 249),
(97, 251),
(97, 252),
(97, 253),
(97, 254),
(97, 255),
(97, 256),
(97, 257),
(97, 259),
(97, 260),
(97, 262),
(97, 263),
(97, 265),
(97, 266),
(97, 267),
(97, 268),
(97, 270),
(97, 271),
(97, 272),
(97, 273),
(97, 274),
(97, 275),
(97, 276),
(97, 277),
(97, 278),
(97, 279),
(97, 280),
(97, 281),
(97, 282),
(97, 283),
(97, 284),
(97, 285),
(97, 286),
(97, 296),
(97, 300),
(97, 301),
(97, 302),
(97, 303),
(97, 304),
(97, 305),
(97, 306),
(97, 307),
(97, 309),
(97, 310),
(97, 311),
(97, 312),
(97, 313),
(97, 316),
(97, 317),
(97, 318),
(97, 319),
(97, 320),
(97, 321),
(97, 322),
(97, 323),
(97, 324),
(97, 325),
(97, 326),
(97, 399),
(97, 400),
(97, 402),
(97, 403),
(97, 404),
(97, 405),
(97, 406),
(97, 409),
(97, 410),
(97, 411),
(97, 412),
(97, 413),
(97, 414),
(97, 415),
(97, 416),
(97, 417),
(97, 418),
(97, 419),
(97, 421),
(97, 422),
(97, 423),
(97, 424),
(97, 427),
(97, 429),
(97, 430),
(97, 431),
(97, 432),
(97, 433),
(97, 435),
(97, 436),
(97, 437),
(97, 443),
(97, 444),
(97, 447),
(97, 449),
(97, 451),
(97, 452),
(97, 453),
(97, 456),
(97, 457),
(97, 458),
(97, 459),
(97, 462),
(97, 463),
(97, 464),
(97, 506),
(97, 507),
(97, 508),
(97, 509),
(97, 510),
(97, 511),
(97, 529),
(97, 530),
(97, 531),
(97, 532),
(97, 533),
(97, 534),
(97, 535),
(97, 537),
(97, 538),
(97, 539),
(97, 540),
(97, 541),
(97, 544),
(97, 545),
(97, 546),
(97, 547),
(97, 548),
(97, 549),
(97, 550),
(97, 551),
(98, 201),
(98, 207),
(98, 227),
(98, 229),
(98, 234),
(98, 242),
(98, 243),
(98, 244),
(98, 249),
(98, 251),
(98, 252),
(98, 253),
(98, 254),
(98, 255),
(98, 256),
(98, 257),
(98, 259),
(98, 260),
(98, 262),
(98, 263),
(98, 265),
(98, 266),
(98, 267),
(98, 268),
(98, 270),
(98, 271),
(98, 272),
(98, 273),
(98, 274),
(98, 275),
(98, 276),
(98, 277),
(98, 278),
(98, 279),
(98, 280),
(98, 281),
(98, 282),
(98, 283),
(98, 284),
(98, 285),
(98, 286),
(98, 296),
(98, 300),
(98, 301),
(98, 302),
(98, 303),
(98, 304),
(98, 305),
(98, 306),
(98, 307),
(98, 309),
(98, 310),
(98, 311),
(98, 312),
(98, 313),
(98, 316),
(98, 317),
(98, 318),
(98, 319),
(98, 320),
(98, 321),
(98, 322),
(98, 323),
(98, 324),
(98, 325),
(98, 326),
(98, 399),
(98, 400),
(98, 402),
(98, 403),
(98, 404),
(98, 405),
(98, 406),
(98, 409),
(98, 410),
(98, 411),
(98, 412),
(98, 413),
(98, 414),
(98, 415),
(98, 416),
(98, 417),
(98, 418),
(98, 419),
(98, 421),
(98, 422),
(98, 423),
(98, 424),
(98, 427),
(98, 429),
(98, 430),
(98, 431),
(98, 432),
(98, 433),
(98, 435),
(98, 436),
(98, 437),
(98, 443),
(98, 447),
(98, 449),
(98, 451),
(98, 452),
(98, 453),
(98, 456),
(98, 457),
(98, 458),
(98, 459),
(98, 462),
(98, 463),
(98, 464),
(98, 506),
(98, 507),
(98, 508),
(98, 509),
(98, 537),
(98, 538),
(98, 539),
(98, 540),
(98, 544),
(98, 546),
(98, 550),
(98, 551),
(98, 555),
(99, 435),
(100, 201),
(100, 207),
(100, 227),
(100, 229),
(100, 234),
(100, 242),
(100, 243),
(100, 244),
(100, 249),
(100, 251),
(100, 252),
(100, 253),
(100, 254),
(100, 255),
(100, 256),
(100, 257),
(100, 259),
(100, 260),
(100, 262),
(100, 263),
(100, 265),
(100, 266),
(100, 267),
(100, 268),
(100, 270),
(100, 271),
(100, 272),
(100, 273),
(100, 274),
(100, 275),
(100, 276),
(100, 277),
(100, 278),
(100, 279),
(100, 280),
(100, 281),
(100, 282),
(100, 283),
(100, 284),
(100, 285),
(100, 286),
(100, 296),
(100, 300),
(100, 301),
(100, 302),
(100, 303),
(100, 304),
(100, 305),
(100, 306),
(100, 307),
(100, 309),
(100, 310),
(100, 311),
(100, 312),
(100, 313),
(100, 316),
(100, 317),
(100, 318),
(100, 319),
(100, 320),
(100, 321),
(100, 322),
(100, 323),
(100, 324),
(100, 325),
(100, 326),
(100, 399),
(100, 400),
(100, 402),
(100, 403),
(100, 404),
(100, 405),
(100, 406),
(100, 409),
(100, 410),
(100, 411),
(100, 412),
(100, 413),
(100, 414),
(100, 415),
(100, 416),
(100, 417),
(100, 418),
(100, 419),
(100, 421),
(100, 422),
(100, 423),
(100, 424),
(100, 427),
(100, 429),
(100, 430),
(100, 431),
(100, 432),
(100, 433),
(100, 435),
(100, 436),
(100, 437),
(100, 443),
(100, 447),
(100, 449),
(100, 451),
(100, 452),
(100, 453),
(100, 456),
(100, 457),
(100, 458),
(100, 459),
(100, 462),
(100, 463),
(100, 464),
(100, 506),
(100, 507),
(100, 508),
(100, 509),
(100, 537),
(100, 538),
(100, 539),
(100, 540),
(100, 544),
(100, 546),
(100, 547),
(100, 549),
(100, 550),
(100, 551),
(100, 555),
(100, 556),
(101, 201),
(101, 207),
(101, 227),
(101, 229),
(101, 234),
(101, 242),
(101, 243),
(101, 244),
(101, 249),
(101, 251),
(101, 252),
(101, 253),
(101, 254),
(101, 255),
(101, 256),
(101, 257),
(101, 259),
(101, 260),
(101, 262),
(101, 263),
(101, 265),
(101, 266),
(101, 267),
(101, 268),
(101, 270),
(101, 271),
(101, 272),
(101, 273),
(101, 274),
(101, 275),
(101, 276),
(101, 277),
(101, 278),
(101, 279),
(101, 280),
(101, 281),
(101, 282),
(101, 283),
(101, 284),
(101, 285),
(101, 286),
(101, 296),
(101, 300),
(101, 301),
(101, 302),
(101, 303),
(101, 304),
(101, 305),
(101, 306),
(101, 307),
(101, 309),
(101, 310),
(101, 311),
(101, 312),
(101, 313),
(101, 316),
(101, 317),
(101, 318),
(101, 319),
(101, 320),
(101, 321),
(101, 322),
(101, 323),
(101, 324),
(101, 325),
(101, 326),
(101, 399),
(101, 400),
(101, 402),
(101, 403),
(101, 404),
(101, 405),
(101, 406),
(101, 409),
(101, 410),
(101, 411),
(101, 412),
(101, 413),
(101, 414),
(101, 415),
(101, 416),
(101, 417),
(101, 418),
(101, 419),
(101, 421),
(101, 422),
(101, 423),
(101, 424),
(101, 427),
(101, 429),
(101, 430),
(101, 431),
(101, 432),
(101, 433),
(101, 435),
(101, 436),
(101, 437),
(101, 443),
(101, 447),
(101, 449),
(101, 451),
(101, 452),
(101, 453),
(101, 456),
(101, 457),
(101, 458),
(101, 459),
(101, 462),
(101, 463),
(101, 464),
(101, 506),
(101, 507),
(101, 508),
(101, 509),
(101, 537),
(101, 538),
(101, 539),
(101, 540),
(101, 544),
(101, 546),
(101, 550),
(101, 551),
(101, 555),
(102, 201),
(102, 207),
(102, 227),
(102, 229),
(102, 234),
(102, 242),
(102, 243),
(102, 244),
(102, 249),
(102, 251),
(102, 252),
(102, 253),
(102, 254),
(102, 255),
(102, 256),
(102, 257),
(102, 259),
(102, 260),
(102, 262),
(102, 263),
(102, 265),
(102, 266),
(102, 267),
(102, 268),
(102, 270),
(102, 271),
(102, 272),
(102, 273),
(102, 274),
(102, 275),
(102, 276),
(102, 277),
(102, 278),
(102, 279),
(102, 280),
(102, 281),
(102, 282),
(102, 283),
(102, 284),
(102, 285),
(102, 286),
(102, 296),
(102, 300),
(102, 301),
(102, 302),
(102, 303),
(102, 304),
(102, 305),
(102, 306),
(102, 307),
(102, 309),
(102, 310),
(102, 311),
(102, 312),
(102, 313),
(102, 316),
(102, 317),
(102, 318),
(102, 319),
(102, 320),
(102, 321),
(102, 322),
(102, 323),
(102, 324),
(102, 325),
(102, 326),
(102, 399),
(102, 400),
(102, 402),
(102, 403),
(102, 404),
(102, 405),
(102, 406),
(102, 409),
(102, 410),
(102, 411),
(102, 412),
(102, 413),
(102, 414),
(102, 415),
(102, 416),
(102, 417),
(102, 418),
(102, 419),
(102, 421),
(102, 422),
(102, 423),
(102, 424),
(102, 427),
(102, 429),
(102, 430),
(102, 431),
(102, 432),
(102, 433),
(102, 435),
(102, 436),
(102, 437),
(102, 443),
(102, 447),
(102, 449),
(102, 451),
(102, 452),
(102, 453),
(102, 456),
(102, 457),
(102, 458),
(102, 459),
(102, 462),
(102, 463),
(102, 464),
(102, 506),
(102, 507),
(102, 508),
(102, 509),
(102, 537),
(102, 538),
(102, 539),
(102, 544),
(102, 546),
(102, 551),
(102, 555),
(103, 201),
(103, 207),
(103, 227),
(103, 229),
(103, 234),
(103, 242),
(103, 243),
(103, 244),
(103, 249),
(103, 251),
(103, 252),
(103, 253),
(103, 254),
(103, 255),
(103, 256),
(103, 257),
(103, 259),
(103, 260),
(103, 262),
(103, 263),
(103, 265),
(103, 266),
(103, 267),
(103, 268),
(103, 270),
(103, 271),
(103, 272),
(103, 273),
(103, 274),
(103, 275),
(103, 276),
(103, 277),
(103, 278),
(103, 279),
(103, 280),
(103, 281),
(103, 282),
(103, 283),
(103, 284),
(103, 285),
(103, 286),
(103, 296),
(103, 300),
(103, 301),
(103, 302),
(103, 303),
(103, 304),
(103, 305),
(103, 306),
(103, 307),
(103, 309),
(103, 310),
(103, 311),
(103, 312),
(103, 313),
(103, 316),
(103, 317),
(103, 318),
(103, 319),
(103, 320),
(103, 321),
(103, 322),
(103, 323),
(103, 324),
(103, 325),
(103, 326),
(103, 399),
(103, 400),
(103, 402),
(103, 403),
(103, 404),
(103, 405),
(103, 406),
(103, 409),
(103, 410),
(103, 411),
(103, 412),
(103, 413),
(103, 414),
(103, 415),
(103, 416),
(103, 417),
(103, 418),
(103, 419),
(103, 421),
(103, 422),
(103, 423),
(103, 424),
(103, 427),
(103, 429),
(103, 430),
(103, 431),
(103, 432),
(103, 433),
(103, 435),
(103, 436),
(103, 437),
(103, 443),
(103, 447),
(103, 449),
(103, 451),
(103, 452),
(103, 453),
(103, 456),
(103, 457),
(103, 458),
(103, 459),
(103, 462),
(103, 463),
(103, 464),
(103, 506),
(103, 507),
(103, 508),
(103, 509),
(103, 537),
(103, 538),
(103, 539),
(103, 544),
(103, 551),
(103, 555),
(104, 201),
(104, 207),
(104, 227),
(104, 229),
(104, 234),
(104, 242),
(104, 243),
(104, 244),
(104, 249),
(104, 251),
(104, 252),
(104, 253),
(104, 254),
(104, 255),
(104, 256),
(104, 257),
(104, 259),
(104, 260),
(104, 262),
(104, 263),
(104, 265),
(104, 266),
(104, 267),
(104, 268),
(104, 270),
(104, 271),
(104, 272),
(104, 273),
(104, 274),
(104, 275),
(104, 276),
(104, 277),
(104, 278),
(104, 279),
(104, 280),
(104, 281),
(104, 282),
(104, 283),
(104, 284),
(104, 285),
(104, 286),
(104, 296),
(104, 300),
(104, 301),
(104, 302),
(104, 303),
(104, 304),
(104, 305),
(104, 306),
(104, 307),
(104, 309),
(104, 310),
(104, 311),
(104, 312),
(104, 313),
(104, 316),
(104, 317),
(104, 318),
(104, 319),
(104, 320),
(104, 321),
(104, 322),
(104, 323),
(104, 324),
(104, 325),
(104, 326),
(104, 399),
(104, 400),
(104, 402),
(104, 403),
(104, 404),
(104, 405),
(104, 406),
(104, 409),
(104, 410),
(104, 411),
(104, 412),
(104, 413),
(104, 414),
(104, 415),
(104, 416),
(104, 417),
(104, 418),
(104, 419),
(104, 421),
(104, 422),
(104, 423),
(104, 424),
(104, 427),
(104, 429),
(104, 430),
(104, 431),
(104, 432),
(104, 433),
(104, 435),
(104, 436),
(104, 437),
(104, 443),
(104, 447),
(104, 449),
(104, 451),
(104, 452),
(104, 453),
(104, 456),
(104, 457),
(104, 458),
(104, 459),
(104, 462),
(104, 463),
(104, 464),
(104, 506),
(104, 507),
(104, 508),
(104, 509),
(104, 510),
(104, 511),
(104, 529),
(104, 530),
(104, 531),
(104, 532),
(104, 533),
(104, 534),
(104, 535),
(104, 537),
(104, 538),
(104, 539),
(104, 540),
(104, 541),
(104, 542),
(104, 544),
(104, 545),
(104, 546),
(104, 547),
(104, 548),
(104, 549),
(104, 550),
(104, 551),
(104, 555),
(104, 556),
(105, 201),
(105, 207),
(105, 227),
(105, 229),
(105, 234),
(105, 242),
(105, 243),
(105, 244),
(105, 249),
(105, 251),
(105, 252),
(105, 253),
(105, 254),
(105, 255),
(105, 256),
(105, 257),
(105, 259),
(105, 260),
(105, 262),
(105, 263),
(105, 265),
(105, 266),
(105, 267),
(105, 268),
(105, 270),
(105, 271),
(105, 272),
(105, 273),
(105, 274),
(105, 275),
(105, 276),
(105, 277),
(105, 278),
(105, 279),
(105, 280),
(105, 281),
(105, 282),
(105, 283),
(105, 284),
(105, 285),
(105, 286),
(105, 296),
(105, 300),
(105, 301),
(105, 302),
(105, 303),
(105, 304),
(105, 305),
(105, 306),
(105, 307),
(105, 309),
(105, 310),
(105, 311),
(105, 312),
(105, 313),
(105, 316),
(105, 317),
(105, 318),
(105, 319),
(105, 320),
(105, 321),
(105, 322),
(105, 323),
(105, 324),
(105, 325),
(105, 326),
(105, 399),
(105, 400),
(105, 402),
(105, 403),
(105, 404),
(105, 405),
(105, 406),
(105, 409),
(105, 410),
(105, 411),
(105, 412),
(105, 413),
(105, 414),
(105, 415),
(105, 416),
(105, 417),
(105, 418),
(105, 419),
(105, 421),
(105, 422),
(105, 423),
(105, 424),
(105, 427),
(105, 429),
(105, 430),
(105, 431),
(105, 432),
(105, 433),
(105, 435),
(105, 436),
(105, 437),
(105, 443),
(105, 447),
(105, 449),
(105, 451),
(105, 452),
(105, 453),
(105, 456),
(105, 457),
(105, 458),
(105, 459),
(105, 462),
(105, 463),
(105, 464),
(105, 506),
(105, 507),
(105, 508),
(105, 509),
(105, 537),
(105, 538),
(105, 539),
(105, 540),
(105, 544),
(105, 546),
(105, 550),
(105, 551),
(105, 555),
(105, 556),
(106, 201),
(106, 207),
(106, 227),
(106, 229),
(106, 234),
(106, 242),
(106, 243),
(106, 244),
(106, 249),
(106, 251),
(106, 252),
(106, 253),
(106, 254),
(106, 255),
(106, 256),
(106, 257),
(106, 259),
(106, 260),
(106, 262),
(106, 263),
(106, 265),
(106, 266),
(106, 267),
(106, 268),
(106, 270),
(106, 271),
(106, 272),
(106, 273),
(106, 274),
(106, 275),
(106, 276),
(106, 277),
(106, 278),
(106, 279),
(106, 280),
(106, 281),
(106, 282),
(106, 283),
(106, 284),
(106, 285),
(106, 286),
(106, 296),
(106, 300),
(106, 301),
(106, 302),
(106, 303),
(106, 304),
(106, 305),
(106, 306),
(106, 307),
(106, 309),
(106, 310),
(106, 311),
(106, 312),
(106, 313),
(106, 316),
(106, 317),
(106, 318),
(106, 319),
(106, 320),
(106, 321),
(106, 322),
(106, 323),
(106, 324),
(106, 325),
(106, 326),
(106, 399),
(106, 400),
(106, 402),
(106, 403),
(106, 404),
(106, 405),
(106, 406),
(106, 409),
(106, 410),
(106, 411),
(106, 412),
(106, 413),
(106, 414),
(106, 415),
(106, 416),
(106, 417),
(106, 418),
(106, 419),
(106, 421),
(106, 422),
(106, 423),
(106, 424),
(106, 427),
(106, 429),
(106, 430),
(106, 431),
(106, 432),
(106, 433),
(106, 435),
(106, 436),
(106, 437),
(106, 443),
(106, 447),
(106, 449),
(106, 451),
(106, 452),
(106, 453),
(106, 456),
(106, 457),
(106, 458),
(106, 459),
(106, 462),
(106, 463),
(106, 464),
(106, 506),
(106, 507),
(106, 508),
(106, 509),
(106, 537),
(106, 538),
(106, 539),
(106, 540),
(106, 541),
(106, 544),
(106, 546),
(106, 547),
(106, 548),
(106, 549),
(106, 550),
(106, 551),
(106, 555),
(106, 556),
(107, 201),
(107, 207),
(107, 227),
(107, 229),
(107, 234),
(107, 242),
(107, 243),
(107, 244),
(107, 249),
(107, 251),
(107, 252),
(107, 253),
(107, 254),
(107, 255),
(107, 256),
(107, 257),
(107, 259),
(107, 260),
(107, 262),
(107, 263),
(107, 265),
(107, 266),
(107, 267),
(107, 268),
(107, 270),
(107, 271),
(107, 272),
(107, 273),
(107, 274),
(107, 275),
(107, 276),
(107, 277),
(107, 278),
(107, 279),
(107, 280),
(107, 281),
(107, 282),
(107, 283),
(107, 284),
(107, 285),
(107, 286),
(107, 296),
(107, 300),
(107, 301),
(107, 302),
(107, 303),
(107, 304),
(107, 305),
(107, 306),
(107, 307),
(107, 309),
(107, 310),
(107, 311),
(107, 312),
(107, 313),
(107, 316),
(107, 317),
(107, 318),
(107, 319),
(107, 320),
(107, 321),
(107, 322),
(107, 323),
(107, 324),
(107, 325),
(107, 326),
(107, 399),
(107, 400),
(107, 402),
(107, 403),
(107, 404),
(107, 405),
(107, 406),
(107, 409),
(107, 410),
(107, 411),
(107, 412),
(107, 413),
(107, 414),
(107, 415),
(107, 416),
(107, 417),
(107, 418),
(107, 419),
(107, 421),
(107, 422),
(107, 423),
(107, 424),
(107, 427),
(107, 429),
(107, 430),
(107, 431),
(107, 432),
(107, 433),
(107, 435),
(107, 436),
(107, 437),
(107, 443),
(107, 447),
(107, 449),
(107, 451),
(107, 452),
(107, 453),
(107, 456),
(107, 457),
(107, 458),
(107, 459),
(107, 462),
(107, 463),
(107, 464),
(107, 506),
(107, 507),
(107, 508),
(107, 509),
(107, 537),
(107, 538),
(107, 539),
(107, 540),
(107, 544),
(107, 546),
(107, 551),
(107, 555),
(108, 201),
(108, 207),
(108, 227),
(108, 229),
(108, 234),
(108, 242),
(108, 243),
(108, 244),
(108, 249),
(108, 251),
(108, 252),
(108, 253),
(108, 254),
(108, 255),
(108, 256),
(108, 257),
(108, 259),
(108, 260),
(108, 262),
(108, 263),
(108, 265),
(108, 266),
(108, 267),
(108, 268),
(108, 270),
(108, 271),
(108, 272),
(108, 273),
(108, 274),
(108, 275),
(108, 276),
(108, 277),
(108, 278),
(108, 279),
(108, 280),
(108, 281),
(108, 282),
(108, 283),
(108, 284),
(108, 285),
(108, 286),
(108, 296),
(108, 300),
(108, 301),
(108, 302),
(108, 303),
(108, 304),
(108, 305),
(108, 306),
(108, 307),
(108, 309),
(108, 310),
(108, 311),
(108, 312),
(108, 313),
(108, 316),
(108, 317),
(108, 318),
(108, 319),
(108, 320),
(108, 321),
(108, 322),
(108, 323),
(108, 324),
(108, 325),
(108, 326),
(108, 399),
(108, 400),
(108, 402),
(108, 403),
(108, 404),
(108, 405),
(108, 406),
(108, 409),
(108, 410),
(108, 411),
(108, 412),
(108, 413),
(108, 414),
(108, 415),
(108, 416),
(108, 417),
(108, 418),
(108, 419),
(108, 421),
(108, 422),
(108, 423),
(108, 424),
(108, 427),
(108, 429),
(108, 430),
(108, 431),
(108, 432),
(108, 433),
(108, 435),
(108, 436),
(108, 437),
(108, 443),
(108, 444),
(108, 447),
(108, 449),
(108, 451),
(108, 452),
(108, 453),
(108, 456),
(108, 457),
(108, 458),
(108, 459),
(108, 462),
(108, 463),
(108, 464),
(108, 506),
(108, 507),
(108, 508),
(108, 509),
(108, 510),
(108, 511),
(108, 529),
(108, 530),
(108, 531),
(108, 532),
(108, 533),
(108, 534),
(108, 535),
(108, 537),
(108, 538),
(108, 539),
(108, 540),
(108, 541),
(108, 544),
(108, 545),
(108, 546),
(108, 547),
(108, 548),
(108, 549),
(108, 550),
(108, 551),
(109, 201),
(109, 207),
(109, 227),
(109, 229),
(109, 234),
(109, 242),
(109, 243),
(109, 244),
(109, 249),
(109, 251),
(109, 252),
(109, 253),
(109, 254),
(109, 255),
(109, 256),
(109, 257),
(109, 259),
(109, 260),
(109, 262),
(109, 263),
(109, 265),
(109, 266),
(109, 267),
(109, 268),
(109, 270),
(109, 271),
(109, 272),
(109, 273),
(109, 274),
(109, 275),
(109, 276),
(109, 277),
(109, 278),
(109, 279),
(109, 280),
(109, 281),
(109, 282),
(109, 283),
(109, 284),
(109, 285),
(109, 286),
(109, 296),
(109, 300),
(109, 301),
(109, 302),
(109, 303),
(109, 304),
(109, 305),
(109, 306),
(109, 307),
(109, 309),
(109, 310),
(109, 311),
(109, 312),
(109, 313),
(109, 316),
(109, 317),
(109, 318),
(109, 319),
(109, 320),
(109, 321),
(109, 322),
(109, 323),
(109, 324),
(109, 325),
(109, 326),
(109, 399),
(109, 400),
(109, 402),
(109, 403),
(109, 404),
(109, 405),
(109, 406),
(109, 409),
(109, 410),
(109, 411),
(109, 412),
(109, 413),
(109, 414),
(109, 415),
(109, 416),
(109, 417),
(109, 418),
(109, 419),
(109, 421),
(109, 422),
(109, 423),
(109, 424),
(109, 427),
(109, 429),
(109, 430),
(109, 431),
(109, 432),
(109, 433),
(109, 435),
(109, 436),
(109, 437),
(109, 443),
(109, 447),
(109, 449),
(109, 451),
(109, 452),
(109, 453),
(109, 456),
(109, 457),
(109, 458),
(109, 459),
(109, 462),
(109, 463),
(109, 464),
(109, 506),
(109, 507),
(109, 508),
(109, 509),
(109, 510),
(109, 511),
(109, 529),
(109, 530),
(109, 531),
(109, 532),
(109, 533),
(109, 534),
(109, 535),
(109, 537),
(109, 538),
(109, 539),
(109, 540),
(109, 541),
(109, 542),
(109, 543),
(109, 544),
(109, 545),
(109, 546),
(109, 547),
(109, 548),
(109, 549),
(109, 550),
(109, 551),
(109, 555),
(109, 556),
(110, 0),
(111, 0),
(112, 435),
(113, 0),
(116, 555),
(116, 556),
(117, 556);

DROP TABLE IF EXISTS `#__newsfeeds`;
CREATE TABLE `#__newsfeeds` (
  `catid` int(11) NOT NULL DEFAULT 0,
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `alias` varchar(400) binary NOT NULL DEFAULT '',
  `link` varchar(2048) NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 0,
  `numarticles` int(10) unsigned NOT NULL DEFAULT 1,
  `cache_time` int(10) unsigned NOT NULL DEFAULT 3600,
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT 0,
  `rtl` tinyint(4) NOT NULL DEFAULT 0,
  `access` int(10) unsigned DEFAULT NULL,
  `language` char(7) NOT NULL DEFAULT '',
  `params` mediumtext NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `metakey` mediumtext NOT NULL,
  `metadesc` mediumtext NOT NULL,
  `metadata` mediumtext NOT NULL,
  `xreference` varchar(50) NOT NULL DEFAULT '',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `description` mediumtext NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  `images` mediumtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `#__newsfeeds` (`catid`, `id`, `name`, `alias`, `link`, `published`, `numarticles`, `cache_time`, `checked_out`, `checked_out_time`, `ordering`, `rtl`, `access`, `language`, `params`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `metakey`, `metadesc`, `metadata`, `xreference`, `publish_up`, `publish_down`, `description`, `version`, `hits`, `images`) VALUES
(17, 1, 'Joomla! Announcements', 'joomla-announcements', 'http://www.joomla.org/announcements.feed?type=rss', 1, 5, 3600, 0, '0000-00-00 00:00:00', 1, 0, 1, 'en-GB', '{"show_feed_image":"","show_feed_description":"","show_item_description":"","feed_character_count":"0"}', '0000-00-00 00:00:00', 42, '', '2020-02-06 08:15:05', 42, '', '', '{"robots":"","author":"","rights":""}', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 1, 0, ''),
(17, 2, 'New Joomla! Extensions', 'new-joomla-extensions', 'http://feeds.joomla.org/JoomlaExtensions', 1, 5, 3600, 0, '0000-00-00 00:00:00', 4, 0, 1, 'en-GB', '{"show_feed_image":"","show_feed_description":"","show_item_description":"","feed_character_count":"0"}', '0000-00-00 00:00:00', 42, '', '2020-02-06 08:15:05', 42, '', '', '{"robots":"","author":"","rights":""}', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 1, 0, ''),
(17, 3, 'Joomla! Security News', 'joomla-security-news', 'http://feeds.joomla.org/JoomlaSecurityNews', 1, 5, 3600, 0, '0000-00-00 00:00:00', 2, 0, 1, 'en-GB', '{"show_feed_image":"","show_feed_description":"","show_item_description":"","feed_character_count":"0"}', '0000-00-00 00:00:00', 42, '', '2020-02-06 08:15:05', 42, '', '', '{"robots":"","author":"","rights":""}', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 1, 0, ''),
(17, 4, 'Joomla! Connect', 'joomla-connect', 'http://feeds.joomla.org/JoomlaConnect', 1, 5, 3600, 0, '0000-00-00 00:00:00', 3, 0, 1, 'en-GB', '{"show_feed_image":"","show_feed_description":"","show_item_description":"","feed_character_count":"0"}', '0000-00-00 00:00:00', 42, '', '2020-02-06 08:15:05', 42, '', '', '{"robots":"","author":"","rights":""}', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 1, 0, '');

DROP TABLE IF EXISTS `#__overrider`;
CREATE TABLE `#__overrider` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `constant` varchar(255) NOT NULL,
  `string` mediumtext NOT NULL,
  `file` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `#__postinstall_messages`;
CREATE TABLE `#__postinstall_messages` (
  `postinstall_message_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `extension_id` bigint(20) NOT NULL DEFAULT 700 COMMENT 'FK to #__extensions',
  `title_key` varchar(255) NOT NULL DEFAULT '' COMMENT 'Lang key for the title',
  `description_key` varchar(255) NOT NULL DEFAULT '' COMMENT 'Lang key for description',
  `action_key` varchar(255) NOT NULL DEFAULT '',
  `language_extension` varchar(255) NOT NULL DEFAULT 'com_postinstall' COMMENT 'Extension holding lang keys',
  `language_client_id` tinyint(3) NOT NULL DEFAULT 1,
  `type` varchar(10) NOT NULL DEFAULT 'link' COMMENT 'Message type - message, link, action',
  `action_file` varchar(255) DEFAULT '' COMMENT 'RAD URI to the PHP file containing action method',
  `action` varchar(255) DEFAULT '' COMMENT 'Action method name or URL',
  `condition_file` varchar(255) DEFAULT NULL COMMENT 'RAD URI to file holding display condition method',
  `condition_method` varchar(255) DEFAULT NULL COMMENT 'Display condition method, must return boolean',
  `version_introduced` varchar(50) NOT NULL DEFAULT '3.2.0' COMMENT 'Version when this message was introduced',
  `enabled` tinyint(3) NOT NULL DEFAULT 1,
  PRIMARY KEY (`postinstall_message_id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

INSERT INTO `#__postinstall_messages` (`postinstall_message_id`, `extension_id`, `title_key`, `description_key`, `action_key`, `language_extension`, `language_client_id`, `type`, `action_file`, `action`, `condition_file`, `condition_method`, `version_introduced`, `enabled`) VALUES
(1, 700, 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_TITLE', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_BODY', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_ACTION', 'plg_twofactorauth_totp', 1, 'action', 'site://plugins/twofactorauth/totp/postinstall/actions.php', 'twofactorauth_postinstall_action', 'site://plugins/twofactorauth/totp/postinstall/actions.php', 'twofactorauth_postinstall_condition', '3.2.0', 1),
(2, 700, 'COM_CPANEL_MSG_EACCELERATOR_TITLE', 'COM_CPANEL_MSG_EACCELERATOR_BODY', 'COM_CPANEL_MSG_EACCELERATOR_BUTTON', 'com_cpanel', 1, 'action', 'admin://components/com_admin/postinstall/eaccelerator.php', 'admin_postinstall_eaccelerator_action', 'admin://components/com_admin/postinstall/eaccelerator.php', 'admin_postinstall_eaccelerator_condition', '3.2.0', 1),
(3, 700, 'COM_CPANEL_MSG_HTACCESS_TITLE', 'COM_CPANEL_MSG_HTACCESS_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/htaccess.php', 'admin_postinstall_htaccess_condition', '3.4.0', 1),
(4, 700, 'COM_CPANEL_MSG_ROBOTS_TITLE', 'COM_CPANEL_MSG_ROBOTS_BODY', '', 'com_cpanel', 1, 'message', '', '', '', '', '3.3.0', 1),
(5, 700, 'COM_CPANEL_MSG_LANGUAGEACCESS340_TITLE', 'COM_CPANEL_MSG_LANGUAGEACCESS340_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/languageaccess340.php', 'admin_postinstall_languageaccess340_condition', '3.4.1', 1),
(6, 700, 'COM_CPANEL_MSG_STATS_COLLECTION_TITLE', 'COM_CPANEL_MSG_STATS_COLLECTION_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/statscollection.php', 'admin_postinstall_statscollection_condition', '3.5.0', 1),
(7, 700, 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME', 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME_BODY', 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME_ACTION', 'plg_system_updatenotification', 1, 'action', 'site://plugins/system/updatenotification/postinstall/updatecachetime.php', 'updatecachetime_postinstall_action', 'site://plugins/system/updatenotification/postinstall/updatecachetime.php', 'updatecachetime_postinstall_condition', '3.6.3', 1),
(8, 700, 'COM_CPANEL_MSG_JOOMLA40_PRE_CHECKS_TITLE', 'COM_CPANEL_MSG_JOOMLA40_PRE_CHECKS_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/joomla40checks.php', 'admin_postinstall_joomla40checks_condition', '3.7.0', 1),
(9, 700, 'TPL_HATHOR_MESSAGE_POSTINSTALL_TITLE', 'TPL_HATHOR_MESSAGE_POSTINSTALL_BODY', 'TPL_HATHOR_MESSAGE_POSTINSTALL_ACTION', 'tpl_hathor', 1, 'action', 'admin://templates/hathor/postinstall/hathormessage.php', 'hathormessage_postinstall_action', 'admin://templates/hathor/postinstall/hathormessage.php', 'hathormessage_postinstall_condition', '3.7.0', 1),
(10, 700, 'PLG_PLG_RECAPTCHA_VERSION_1_POSTINSTALL_TITLE', 'PLG_PLG_RECAPTCHA_VERSION_1_POSTINSTALL_BODY', 'PLG_PLG_RECAPTCHA_VERSION_1_POSTINSTALL_ACTION', 'plg_captcha_recaptcha', 1, 'action', 'site://plugins/captcha/recaptcha/postinstall/actions.php', 'recaptcha_postinstall_action', 'site://plugins/captcha/recaptcha/postinstall/actions.php', 'recaptcha_postinstall_condition', '3.8.6', 1),
(11, 700, 'COM_CPANEL_MSG_UPDATEDEFAULTSETTINGS_TITLE', 'COM_CPANEL_MSG_UPDATEDEFAULTSETTINGS_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/updatedefaultsettings.php', 'admin_postinstall_updatedefaultsettings_condition', '3.8.8', 1),
(12, 700, 'COM_ACTIONLOGS_POSTINSTALL_TITLE', 'COM_ACTIONLOGS_POSTINSTALL_BODY', '', 'com_actionlogs', 1, 'message', '', '', '', '', '3.9.0', 1),
(13, 700, 'COM_PRIVACY_POSTINSTALL_TITLE', 'COM_PRIVACY_POSTINSTALL_BODY', '', 'com_privacy', 1, 'message', '', '', '', '', '3.9.0', 1),
(14, 700, 'COM_CPANEL_MSG_ADDNOSNIFF_TITLE', 'COM_CPANEL_MSG_ADDNOSNIFF_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/addnosniff.php', 'admin_postinstall_addnosniff_condition', '3.9.3', 1);

DROP TABLE IF EXISTS `#__privacy_consents`;
CREATE TABLE `#__privacy_consents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `state` int(10) NOT NULL DEFAULT 1,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `subject` varchar(255) NOT NULL DEFAULT '',
  `body` text NOT NULL,
  `remind` tinyint(4) NOT NULL DEFAULT 0,
  `token` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `#__privacy_requests`;
CREATE TABLE `#__privacy_requests` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(100) NOT NULL DEFAULT '',
  `requested_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` tinyint(4) NOT NULL DEFAULT 0,
  `request_type` varchar(25) NOT NULL DEFAULT '',
  `confirm_token` varchar(100) NOT NULL DEFAULT '',
  `confirm_token_created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `#__schemas`;
CREATE TABLE `#__schemas` (
  `extension_id` int(11) NOT NULL,
  `version_id` varchar(20) NOT NULL,
  PRIMARY KEY (`extension_id`,`version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__schemas` (`extension_id`, `version_id`) VALUES
(700, '3.9.10-2019-07-09');

DROP TABLE IF EXISTS `#__tags`;
CREATE TABLE `#__tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL DEFAULT 0,
  `lft` int(11) NOT NULL DEFAULT 0,
  `rgt` int(11) NOT NULL DEFAULT 0,
  `level` int(10) unsigned NOT NULL DEFAULT 0,
  `path` varchar(400) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL,
  `alias` varchar(400) binary NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 0,
  `checked_out` int(11) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `params` mediumtext NOT NULL,
  `metadesc` varchar(1024) NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) NOT NULL COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` mediumtext NOT NULL,
  `urls` mediumtext NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  `language` char(7) NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `tag_idx` (`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_alias` (`alias`(100))
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;

INSERT INTO `#__tags` (`id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `created_by_alias`, `modified_user_id`, `modified_time`, `images`, `urls`, `hits`, `language`, `version`, `publish_up`, `publish_down`) VALUES
(1, 0, 0, 29, 0, '', 'ROOT', 'root', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{}', '', '', '', 42, '2020-02-06 08:15:05', '', 0, '0000-00-00 00:00:00', '', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(2, 1, 1, 2, 1, 'template', 'Template', 'template', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"tag_layout":"","tag_link_class":"label label-info"}', '', '', '{"author":"","robots":""}', 42, '2020-02-06 08:15:05', '', 0, '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(3, 1, 3, 4, 1, 'responsive', 'Responsive', 'responsive', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"tag_layout":"","tag_link_class":"label label-info"}', '', '', '{"author":"","robots":""}', 42, '2020-02-06 08:15:05', '', 0, '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(4, 1, 5, 6, 1, 'feature', 'Feature', 'feature', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"tag_layout":"","tag_link_class":"label label-info"}', '', '', '{"author":"","robots":""}', 42, '2020-02-06 08:15:05', '', 0, '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(5, 1, 7, 8, 1, 'demo', 'Demo', 'demo', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"tag_layout":"","tag_link_class":"label label-info"}', '', '', '{"author":"","robots":""}', 42, '2020-02-06 08:15:05', '', 0, '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(6, 1, 9, 10, 1, 'social', 'Social', 'social', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"tag_layout":"","tag_link_class":"label label-info"}', '', '', '{"author":"","robots":""}', 42, '2020-02-06 08:15:05', '', 0, '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(7, 1, 11, 12, 1, 'userguide', 'Userguide', 'userguide', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"tag_layout":"","tag_link_class":"label label-info"}', '', '', '{"author":"","robots":""}', 42, '2020-02-06 08:15:05', '', 0, '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(8, 1, 13, 14, 1, 'device', 'Device', 'device', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"tag_layout":"","tag_link_class":"label label-info"}', '', '', '{"author":"","robots":""}', 42, '2020-02-06 08:15:05', '', 0, '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(9, 1, 15, 16, 1, 'web-design', 'Web Design', 'web-design', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"tag_layout":"","tag_link_class":"label label-info"}', '', '', '{"author":"","robots":""}', 42, '2020-02-06 08:15:05', '', 0, '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(10, 1, 17, 18, 1, 'tutorial', 'Tutorial', 'tutorial', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"tag_layout":"","tag_link_class":"label label-info"}', '', '', '{"author":"","robots":""}', 42, '2020-02-06 08:15:05', '', 0, '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(11, 1, 19, 20, 1, 'tablet', 'Tablet', 'tablet', '', '', 1, 0, '0000-00-00 00:00:00', 1, '', '', '', '', 42, '2020-02-06 08:15:05', '', 0, '0000-00-00 00:00:00', '', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(12, 1, 21, 22, 1, 'layout', 'Layout', 'layout', '', '', 1, 0, '0000-00-00 00:00:00', 1, '', '', '', '', 42, '2020-02-06 08:15:05', '', 0, '0000-00-00 00:00:00', '', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(13, 1, 23, 24, 1, 'experiments', 'Experiments', 'experiments', '', '', 1, 0, '0000-00-00 00:00:00', 1, '', '', '', '', 42, '2020-02-06 08:15:05', '', 0, '0000-00-00 00:00:00', '', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(14, 1, 25, 26, 1, 'joomla', 'Joomla', 'joomla', '', '', 1, 0, '0000-00-00 00:00:00', 1, '', '', '', '', 42, '2020-02-06 08:15:05', '', 0, '0000-00-00 00:00:00', '', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(15, 1, 27, 28, 1, 'joomlart', 'JoomlArt', 'joomlart', '', '', 1, 0, '0000-00-00 00:00:00', 1, '', '', '', '', 42, '2020-02-06 08:15:05', '', 0, '0000-00-00 00:00:00', '', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00');

DROP TABLE IF EXISTS `#__template_styles`;
CREATE TABLE `#__template_styles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) NOT NULL DEFAULT '',
  `client_id` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `home` char(7) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `params` varchar(10240) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_client_id` (`client_id`),
  KEY `idx_client_id_home` (`client_id`,`home`)
) ENGINE=InnoDB AUTO_INCREMENT=121 DEFAULT CHARSET=utf8;

INSERT INTO `#__template_styles` (`id`, `template`, `client_id`, `home`, `title`, `params`) VALUES
(5, 'hathor', 1, '0', 'Hathor - Default', '{"showSiteName":"0","highContrast":"0","boldText":"0","altMenu":"0"}'),
(117, 'ja_elastica', 0, '1', 'JA_Elastica - Default', '[]'),
(118, 'beez3', 0, '0', 'beez3 - Default', '{"wrapperSmall":"53","wrapperLarge":"72","sitetitle":"","sitedescription":"","navposition":"center","templatecolor":"nature","backgroundcolor":"#eee"}'),
(119, 'isis', 1, '1', 'isis - Default', '{"templateColor":"#13294A","headerColor":"#184A7D","logoFile":"","admin_menus":"1","displayHeader":"1","statusFixed":"1","stickyToolbar":"1"}'),
(120, 'protostar', 0, '0', 'protostar - Default', '{"templateColor":"#08C","templateBackgroundColor":"#F4F6F7","logoFile":"","sitetitle":"","sitedescription":"","googleFont":"1","googleFontName":"Open+Sans","fluidContainer":"0"}');

DROP TABLE IF EXISTS `#__ucm_base`;
CREATE TABLE `#__ucm_base` (
  `ucm_id` int(10) unsigned NOT NULL,
  `ucm_item_id` int(10) NOT NULL,
  `ucm_type_id` int(11) NOT NULL,
  `ucm_language_id` int(11) NOT NULL,
  PRIMARY KEY (`ucm_id`),
  KEY `idx_ucm_item_id` (`ucm_item_id`),
  KEY `idx_ucm_type_id` (`ucm_type_id`),
  KEY `idx_ucm_language_id` (`ucm_language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__ucm_base` (`ucm_id`, `ucm_item_id`, `ucm_type_id`, `ucm_language_id`) VALUES
(1, 83, 1, 0),
(2, 81, 1, 0),
(3, 80, 1, 0),
(4, 79, 1, 0),
(5, 78, 1, 0),
(6, 77, 1, 0),
(7, 85, 1, 0),
(8, 70, 1, 0),
(9, 84, 1, 0),
(10, 72, 1, 0),
(11, 86, 1, 0),
(12, 73, 1, 0),
(13, 69, 1, 0);

DROP TABLE IF EXISTS `#__ucm_content`;
CREATE TABLE `#__ucm_content` (
  `core_content_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `core_type_alias` varchar(400) NOT NULL DEFAULT '' COMMENT 'FK to the content types table',
  `core_title` varchar(400) NOT NULL DEFAULT '',
  `core_alias` varchar(400) binary NOT NULL DEFAULT '',
  `core_body` mediumtext NOT NULL,
  `core_state` tinyint(1) NOT NULL DEFAULT 0,
  `core_checked_out_time` varchar(255) NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_checked_out_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `core_access` int(10) unsigned NOT NULL DEFAULT 0,
  `core_params` text NOT NULL,
  `core_featured` tinyint(4) unsigned NOT NULL DEFAULT 0,
  `core_metadata` varchar(2048) NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `core_created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `core_created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `core_created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_modified_user_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Most recent user that modified',
  `core_modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_language` char(7) NOT NULL DEFAULT '',
  `core_publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_content_item_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'ID from the individual type table',
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `core_images` text NOT NULL,
  `core_urls` text NOT NULL,
  `core_hits` int(10) unsigned NOT NULL DEFAULT 0,
  `core_version` int(10) unsigned NOT NULL DEFAULT 1,
  `core_ordering` int(11) NOT NULL DEFAULT 0,
  `core_metakey` text NOT NULL,
  `core_metadesc` text NOT NULL,
  `core_catid` int(10) unsigned NOT NULL DEFAULT 0,
  `core_xreference` varchar(50) NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `core_type_id` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`core_content_id`),
  KEY `tag_idx` (`core_state`,`core_access`),
  KEY `idx_access` (`core_access`),
  KEY `idx_language` (`core_language`),
  KEY `idx_modified_time` (`core_modified_time`),
  KEY `idx_created_time` (`core_created_time`),
  KEY `idx_core_modified_user_id` (`core_modified_user_id`),
  KEY `idx_core_checked_out_user_id` (`core_checked_out_user_id`),
  KEY `idx_core_created_user_id` (`core_created_user_id`),
  KEY `idx_core_type_id` (`core_type_id`),
  KEY `idx_alias` (`core_alias`(100)),
  KEY `idx_title` (`core_title`(100)),
  KEY `idx_content_type` (`core_type_alias`(100))
) ENGINE=InnoDB AUTO_INCREMENT=14 COMMENT='Contains core content data in name spaced fields' DEFAULT CHARSET=utf8;

INSERT INTO `#__ucm_content` (`core_content_id`, `core_type_alias`, `core_title`, `core_alias`, `core_body`, `core_state`, `core_checked_out_time`, `core_checked_out_user_id`, `core_access`, `core_params`, `core_featured`, `core_metadata`, `core_created_user_id`, `core_created_by_alias`, `core_created_time`, `core_modified_user_id`, `core_modified_time`, `core_language`, `core_publish_up`, `core_publish_down`, `core_content_item_id`, `asset_id`, `core_images`, `core_urls`, `core_hits`, `core_version`, `core_ordering`, `core_metakey`, `core_metadesc`, `core_catid`, `core_xreference`, `core_type_id`) VALUES
(1, 'com_content.article', 'Extra-wide layout', 'extra-wide-layout', '<p><img src="images/stories/guide/layouts.png" alt="All layout" /></p>\r\n<p>There are 2 width size modes of the content block: in Homepage (considered as list page mode) and in detail page mode. In the Homepage, the width of the content block = 2 grids while in the detail page mode, the width of content block is 3 grids. The above image shows you the layout of homepage of our <span class="highlight">template --&gt; content block = 2 grid.</span></p>\r\n', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 0, '{"robots":"","author":"","rights":"","xreference":""}', 42, '', '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', '*', '2020-02-06 08:15:05', '0000-00-00 00:00:00', 83, 194, '', '', 111, 26, 4, '', '', 78, '', 1),
(2, 'com_content.article', '5 Columns - Full width', '5-columns', '<p>Congue consectetuer Phasellus odio non Nulla commodo amet feugiat ligula pede. Convallis felis et sit nec nunc lacus tellus lobortis quam Quisque. Urna mauris magnis venenatis morbi id ullamcorper orci et condimentum adipiscing. Donec sed eu cursus Nullam et facilisis amet justo et ut. Aliquet convallis sed Aliquam Mauris Nam at.</p>\r\n<p>Consequat wisi aliquet Vivamus laoreet Proin mollis malesuada Nam sagittis sodales. Feugiat nulla Aenean lacinia tincidunt lacus Phasellus nec pede et justo. Vel libero Lorem Vestibulum fringilla eu a risus cursus id quis. Dui in pellentesque tempor vel laoreet non Vestibulum nec turpis pede. Adipiscing justo consequat et adipiscing mauris malesuada euismod nibh leo urna. Ut at.</p>\r\n<p>Mus Sed pellentesque risus volutpat consequat montes nibh semper Aenean pellentesque. Pellentesque velit auctor adipiscing orci elit at leo semper mauris tristique. Convallis sit nibh ut ac pellentesque nibh dictumst mauris volutpat pulvinar. Eu nunc Nulla Aliquam elit sit tempus malesuada Nam pretium sapien. Aliquam Vestibulum magna venenatis Aenean odio at penatibus Sed enim vitae. Amet semper nibh dictumst sit tincidunt Mauris Pellentesque eros nibh at. Sem Proin.</p>\r\n<p>Arcu Curabitur mauris felis elit id sed a tellus at nunc. Sapien condimentum eros natoque montes senectus id sit at adipiscing semper. In molestie elit Curabitur tincidunt In nibh quis et mauris metus. Neque Curabitur est Vestibulum consectetuer amet orci lorem ut Nam cursus. Fringilla pede urna tincidunt sem egestas turpis justo adipiscing purus Quisque. Elit.</p>\r\n<p>Non Aenean commodo iaculis ornare sed eget Nulla urna enim elit. At ut Mauris elit quis id a dignissim dignissim urna vel. Ac ipsum consequat orci est magna ornare metus lacus mollis elit. Cursus nulla Fusce cursus facilisi Pellentesque nunc tincidunt lacus ipsum sociis. Pretium consectetuer ut mus est ac id lacus.</p>\r\n<p>Eget Quisque augue justo congue venenatis Curabitur enim Morbi pellentesque ut. Ut felis tincidunt vel lacus in ligula ipsum scelerisque mauris euismod. Vestibulum at id Morbi fames tellus nunc vestibulum Suspendisse lorem est. Turpis tincidunt fringilla purus Vivamus pulvinar quis nibh ridiculus velit at. Wisi egestas lobortis odio pretium ut Vivamus pulvinar hendrerit dis Pellentesque. In sagittis dui elit lacinia pretium Vivamus urna adipiscing hendrerit.</p>\r\n<p>Nam pellentesque ac pulvinar platea eros Pellentesque ac ligula dapibus sociis. Libero Nulla adipiscing magna ante morbi ridiculus at vestibulum accumsan convallis. Et et condimentum velit lorem Cras ac tortor elit pretium ante. Enim porta condimentum Donec congue Sed sed nisl Donec id tincidunt. Nam mollis feugiat magnis convallis fermentum platea magna id ullamcorper nunc. Augue tempus dolor sed commodo nisl pretium.</p>', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 0, '{"robots":"","author":"","rights":"","xreference":""}', 42, '', '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', '*', '2020-02-06 08:15:05', '0000-00-00 00:00:00', 81, 195, '', '', 21, 6, 6, '', '', 78, '', 1),
(3, 'com_content.article', '4 Columns', '4-columns', '<p>Congue consectetuer Phasellus odio non Nulla commodo amet feugiat ligula pede. Convallis felis et sit nec nunc lacus tellus lobortis quam Quisque. Urna mauris magnis venenatis morbi id ullamcorper orci et condimentum adipiscing. Donec sed eu cursus Nullam et facilisis amet justo et ut. Aliquet convallis sed Aliquam Mauris Nam at.</p>\r\n<p>Consequat wisi aliquet Vivamus laoreet Proin mollis malesuada Nam sagittis sodales. Feugiat nulla Aenean lacinia tincidunt lacus Phasellus nec pede et justo. Vel libero Lorem Vestibulum fringilla eu a risus cursus id quis. Dui in pellentesque tempor vel laoreet non Vestibulum nec turpis pede. Adipiscing justo consequat et adipiscing mauris malesuada euismod nibh leo urna. Ut at.</p>\r\n<p>Mus Sed pellentesque risus volutpat consequat montes nibh semper Aenean pellentesque. Pellentesque velit auctor adipiscing orci elit at leo semper mauris tristique. Convallis sit nibh ut ac pellentesque nibh dictumst mauris volutpat pulvinar. Eu nunc Nulla Aliquam elit sit tempus malesuada Nam pretium sapien. Aliquam Vestibulum magna venenatis Aenean odio at penatibus Sed enim vitae. Amet semper nibh dictumst sit tincidunt Mauris Pellentesque eros nibh at. Sem Proin.</p>\r\n<p>Arcu Curabitur mauris felis elit id sed a tellus at nunc. Sapien condimentum eros natoque montes senectus id sit at adipiscing semper. In molestie elit Curabitur tincidunt In nibh quis et mauris metus. Neque Curabitur est Vestibulum consectetuer amet orci lorem ut Nam cursus. Fringilla pede urna tincidunt sem egestas turpis justo adipiscing purus Quisque. Elit.</p>\r\n<p>Non Aenean commodo iaculis ornare sed eget Nulla urna enim elit. At ut Mauris elit quis id a dignissim dignissim urna vel. Ac ipsum consequat orci est magna ornare metus lacus mollis elit. Cursus nulla Fusce cursus facilisi Pellentesque nunc tincidunt lacus ipsum sociis. Pretium consectetuer ut mus est ac id lacus.</p>\r\n<p>Eget Quisque augue justo congue venenatis Curabitur enim Morbi pellentesque ut. Ut felis tincidunt vel lacus in ligula ipsum scelerisque mauris euismod. Vestibulum at id Morbi fames tellus nunc vestibulum Suspendisse lorem est. Turpis tincidunt fringilla purus Vivamus pulvinar quis nibh ridiculus velit at. Wisi egestas lobortis odio pretium ut Vivamus pulvinar hendrerit dis Pellentesque. In sagittis dui elit lacinia pretium Vivamus urna adipiscing hendrerit.</p>\r\n<p>Nam pellentesque ac pulvinar platea eros Pellentesque ac ligula dapibus sociis. Libero Nulla adipiscing magna ante morbi ridiculus at vestibulum accumsan convallis. Et et condimentum velit lorem Cras ac tortor elit pretium ante. Enim porta condimentum Donec congue Sed sed nisl Donec id tincidunt. Nam mollis feugiat magnis convallis fermentum platea magna id ullamcorper nunc. Augue tempus dolor sed commodo nisl pretium.</p>', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 0, '{"robots":"","author":"","rights":"","xreference":""}', 42, '', '2020-02-06 08:15:05', 0, '2020-02-06 08:15:05', '*', '2020-02-06 08:15:05', '0000-00-00 00:00:00', 80, 196, '', '', 15, 3, 7, '', '', 78, '', 1),
(4, 'com_content.article', '3 Columns', '3-columns', '<p>Congue consectetuer Phasellus odio non Nulla commodo amet feugiat ligula pede. Convallis felis et sit nec nunc lacus tellus lobortis quam Quisque. Urna mauris magnis venenatis morbi id ullamcorper orci et condimentum adipiscing. Donec sed eu cursus Nullam et facilisis amet justo et ut. Aliquet convallis sed Aliquam Mauris Nam at.</p>\r\n<p>Consequat wisi aliquet Vivamus laoreet Proin mollis malesuada Nam sagittis sodales. Feugiat nulla Aenean lacinia tincidunt lacus Phasellus nec pede et justo. Vel libero Lorem Vestibulum fringilla eu a risus cursus id quis. Dui in pellentesque tempor vel laoreet non Vestibulum nec turpis pede. Adipiscing justo consequat et adipiscing mauris malesuada euismod nibh leo urna. Ut at.</p>\r\n<p>Mus Sed pellentesque risus volutpat consequat montes nibh semper Aenean pellentesque. Pellentesque velit auctor adipiscing orci elit at leo semper mauris tristique. Convallis sit nibh ut ac pellentesque nibh dictumst mauris volutpat pulvinar. Eu nunc Nulla Aliquam elit sit tempus malesuada Nam pretium sapien. Aliquam Vestibulum magna venenatis Aenean odio at penatibus Sed enim vitae. Amet semper nibh dictumst sit tincidunt Mauris Pellentesque eros nibh at. Sem Proin.</p>\r\n<p>Arcu Curabitur mauris felis elit id sed a tellus at nunc. Sapien condimentum eros natoque montes senectus id sit at adipiscing semper. In molestie elit Curabitur tincidunt In nibh quis et mauris metus. Neque Curabitur est Vestibulum consectetuer amet orci lorem ut Nam cursus. Fringilla pede urna tincidunt sem egestas turpis justo adipiscing purus Quisque. Elit.</p>\r\n<p>Non Aenean commodo iaculis ornare sed eget Nulla urna enim elit. At ut Mauris elit quis id a dignissim dignissim urna vel. Ac ipsum consequat orci est magna ornare metus lacus mollis elit. Cursus nulla Fusce cursus facilisi Pellentesque nunc tincidunt lacus ipsum sociis. Pretium consectetuer ut mus est ac id lacus.</p>\r\n<p>Eget Quisque augue justo congue venenatis Curabitur enim Morbi pellentesque ut. Ut felis tincidunt vel lacus in ligula ipsum scelerisque mauris euismod. Vestibulum at id Morbi fames tellus nunc vestibulum Suspendisse lorem est. Turpis tincidunt fringilla purus Vivamus pulvinar quis nibh ridiculus velit at. Wisi egestas lobortis odio pretium ut Vivamus pulvinar hendrerit dis Pellentesque. In sagittis dui elit lacinia pretium Vivamus urna adipiscing hendrerit.</p>\r\n<p>Nam pellentesque ac pulvinar platea eros Pellentesque ac ligula dapibus sociis. Libero Nulla adipiscing magna ante morbi ridiculus at vestibulum accumsan convallis. Et et condimentum velit lorem Cras ac tortor elit pretium ante. Enim porta condimentum Donec congue Sed sed nisl Donec id tincidunt. Nam mollis feugiat magnis convallis fermentum platea magna id ullamcorper nunc. Augue tempus dolor sed commodo nisl pretium.</p>', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 0, '{"robots":"","author":"","rights":"","xreference":""}', 42, '', '2020-02-06 08:15:05', 0, '2020-02-06 08:15:05', '*', '2020-02-06 08:15:05', '0000-00-00 00:00:00', 79, 197, '', '', 12, 3, 8, '', '', 78, '', 1),
(5, 'com_content.article', '2 Columns', '2-columns-grid', '<p>Lorem ipsum dolor sit amet consectetuer pulvinar eleifend tellus sapien sit. Id consequat ut et pretium quis pede laoreet libero urna laoreet. Mauris in orci urna Vestibulum Maecenas egestas suscipit Nullam vel odio. Sagittis non porttitor tempus leo eget elit consectetuer Aliquam ligula Nullam. Mauris lacus venenatis in Vivamus Aenean Aliquam felis turpis leo mattis. Leo sed pretium.</p>\r\n<p>Lacus laoreet sit at adipiscing orci wisi Morbi elit accumsan dolor. Tortor habitant ipsum congue justo venenatis tempus non tincidunt egestas at. Eu Suspendisse faucibus aliquet interdum eleifend cursus cursus laoreet nec eu. Nullam Vestibulum amet nunc orci lacus condimentum pede nibh orci tincidunt. Auctor lacus adipiscing Nunc nibh cursus sed mus leo Phasellus risus. Dolor Nulla consectetuer gravida elit facilisis Vestibulum eu.</p>\r\n<p>Consectetuer dis scelerisque sapien quis tincidunt elit sit nec congue nunc. Nunc lacinia Phasellus massa vitae mauris feugiat Quisque nascetur urna egestas. Tincidunt lacinia a Nulla neque interdum accumsan Sed augue lorem Vestibulum. Quis platea Vestibulum orci lacus Vestibulum Vivamus sagittis nisl pellentesque convallis. Ligula elit eget condimentum condimentum vitae montes at adipiscing odio hendrerit. Pulvinar sollicitudin cursus nec et.</p>\r\n<p>Congue consectetuer Phasellus odio non Nulla commodo amet feugiat ligula pede. Convallis felis et sit nec nunc lacus tellus lobortis quam Quisque. Urna mauris magnis venenatis morbi id ullamcorper orci et condimentum adipiscing. Donec sed eu cursus Nullam et facilisis amet justo et ut. Aliquet convallis sed Aliquam Mauris Nam at.</p>\r\n<p>Consequat wisi aliquet Vivamus laoreet Proin mollis malesuada Nam sagittis sodales. Feugiat nulla Aenean lacinia tincidunt lacus Phasellus nec pede et justo. Vel libero Lorem Vestibulum fringilla eu a risus cursus id quis. Dui in pellentesque tempor vel laoreet non Vestibulum nec turpis pede. Adipiscing justo consequat et adipiscing mauris malesuada euismod nibh leo urna. Ut at.</p>\r\n<p>Mus Sed pellentesque risus volutpat consequat montes nibh semper Aenean pellentesque. Pellentesque velit auctor adipiscing orci elit at leo semper mauris tristique. Convallis sit nibh ut ac pellentesque nibh dictumst mauris volutpat pulvinar. Eu nunc Nulla Aliquam elit sit tempus malesuada Nam pretium sapien. Aliquam Vestibulum magna venenatis Aenean odio at penatibus Sed enim vitae. Amet semper nibh dictumst sit tincidunt Mauris Pellentesque eros nibh at. Sem Proin.</p>\r\n<p>Arcu Curabitur mauris felis elit id sed a tellus at nunc. Sapien condimentum eros natoque montes senectus id sit at adipiscing semper. In molestie elit Curabitur tincidunt In nibh quis et mauris metus. Neque Curabitur est Vestibulum consectetuer amet orci lorem ut Nam cursus. Fringilla pede urna tincidunt sem egestas turpis justo adipiscing purus Quisque. Elit.</p>', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 0, '{"robots":"","author":"","rights":"","xreference":""}', 42, '', '2020-02-06 08:15:05', 0, '2020-02-06 08:15:05', '*', '2020-02-06 08:15:05', '0000-00-00 00:00:00', 78, 198, '', '', 18, 3, 9, '', '', 78, '', 1),
(6, 'com_content.article', '1 Column', '1-column-grid', '<p>Lacus laoreet sit at adipiscing orci wisi Morbi elit accumsan dolor. Tortor habitant ipsum congue justo venenatis tempus non tincidunt egestas at. Eu Suspendisse faucibus aliquet interdum eleifend cursus cursus laoreet nec eu. Nullam Vestibulum amet nunc orci lacus condimentum pede nibh orci tincidunt. Auctor lacus adipiscing Nunc nibh cursus sed mus leo Phasellus risus. Dolor Nulla consectetuer gravida elit facilisis Vestibulum eu.</p>\r\n<p>Consectetuer dis scelerisque sapien quis tincidunt elit sit nec congue nunc. Nunc lacinia Phasellus massa vitae mauris feugiat Quisque nascetur urna egestas. Tincidunt lacinia a Nulla neque interdum accumsan Sed augue lorem Vestibulum. Quis platea Vestibulum orci lacus Vestibulum Vivamus sagittis nisl pellentesque convallis. Ligula elit eget condimentum condimentum vitae montes at adipiscing odio hendrerit. Pulvinar sollicitudin cursus nec et.</p>\r\n<p>Congue consectetuer Phasellus odio non Nulla commodo amet feugiat ligula pede. Convallis felis et sit nec nunc lacus tellus lobortis quam Quisque.</p>', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 0, '{"robots":"","author":"","rights":"","xreference":""}', 42, '', '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', '*', '2020-02-06 08:15:05', '0000-00-00 00:00:00', 77, 199, '', '', 22, 8, 10, '', '', 78, '', 1),
(7, 'com_content.article', 'Normal layout', 'normal-layout', '<p><img src="images/stories/guide/layouts.png" alt="All layout" /></p>\r\n<p>The normal layout uses 4 grids. In Homepage, the content block width = 2 grids. In Detail page mode, the content block width = 3 grids.</p>\r\n<p>How the modules are changed when layout is changed from Wide layout to Normal layout?</p>\r\n<p>The modules in the grid 5 (in Wide layout) will be moved to available grids in Normal layout [grid 3 and 4 or under the content block (in Homepage) and grid 4 or under the content block (in detail page)] in the order from left to right. The moved modules will be located under the modules already in the grids.</p>\r\n', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 0, '{"robots":"","author":"","rights":"","xreference":""}', 42, '', '2020-02-06 08:15:05', 0, '2020-02-06 08:15:05', '*', '2020-02-06 08:15:05', '0000-00-00 00:00:00', 85, 200, '', '', 25, 9, 2, '', '', 78, '', 1),
(8, 'com_content.article', 'Responsive Joomla 3.x Template', 'responsive-joomla-3-x-template', '<p><img src="images/stories/demo/sam-1.jpg" alt="Sample image" title="Sample image" /></p>\r\n<p>Gravida id at Aenean natoque et consequat a Fusce Suspendisse turpis. Ut platea tincidunt Sed ut nibh justo augue adipiscing ac nibh. In habitasse tellus Vestibulum semper nibh dui In justo Sed consequat. Morbi id turpis enim et eget Nam at orci sapien scelerisque. Odio id dictum id elit Donec Vestibulum at nec in a. Hendrerit eleifend vel enim rutrum id.</p>\r\n', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, '{"robots":"","author":"","rights":"","xreference":""}', 42, '', '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', '*', '2020-02-06 08:15:05', '0000-00-00 00:00:00', 70, 201, '', '', 206, 28, 15, 'Responsive Joomla 3.x Template, Responsive Web Design, Mobile Joomla 3.x template', 'Responsive Joomla 3.x template for works on most mobile devices.', 78, '', 1),
(9, 'com_content.article', 'Wide layout', 'wide-layout', '<p><img src="images/stories/guide/layouts.png" alt="All layout" /></p>\r\n<p>This layout is quite similar to the extra-wide layout, except the extra-column is removed.</p>\r\n<p>To define width of the layout, please navigate to: <span class="highlight">[your_site] / templates / ja_elastica / core / etc / layouts / default.xml</span>. The file <strong>default.xml</strong> is to define width range of each layout.</p>\r\n', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 0, '{"robots":"","author":"","rights":"","xreference":""}', 42, '', '2020-02-06 08:15:05', 0, '2020-02-06 08:15:05', '*', '2020-02-06 08:15:05', '0000-00-00 00:00:00', 84, 202, '', '', 33, 17, 3, '', '', 78, '', 1),
(10, 'com_content.article', 'Three-D Experiments', 'three-d-experiments', '<p>Tellus massa Vivamus orci habitant adipiscing cursus nonummy pretium nunc ipsum. Praesent justo tempor egestas eget id nulla Maecenas convallis odio nibh. Eleifend Vivamus odio Integer ut id malesuada nonummy elit pede Donec. Vivamus vel consectetuer pellentesque eu malesuada vitae parturient ante quis dui. Vestibulum ac Nulla risus magna ornare neque Quisque pellentesque sed Curabitur. Mattis sodales faucibus In Morbi lorem Sed.</p>\r\n', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 0, '{"robots":"","author":"","rights":"","xreference":""}', 42, '', '2020-02-06 08:15:05', 42, '2020-02-06 08:15:05', '*', '2020-02-06 08:15:05', '0000-00-00 00:00:00', 72, 203, '', '', 11, 6, 14, '', '', 78, '', 1),
(11, 'com_content.article', 'Tablet layout', 'tablet-layout', '<img src="images/stories/guide/layouts.png" alt="All layout" />\r\n\r\n<p>There are 2 layout types for tablet. The first one is Tablet Portrait layout and Tablet Lanscape layout ( the Landscape layout is the Normal Layout).</p>\r\n\r\n<p>The Portrait layout uses 3 grids. The content block has width of 3 grids in both homepage and detail page so all modules will be displayed under the content block.</p>\r\n\r\n', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 0, '{"robots":"","author":"","rights":"","xreference":""}', 42, '', '2020-02-06 08:15:05', 0, '2020-02-06 08:15:05', '*', '2020-02-06 08:15:05', '0000-00-00 00:00:00', 86, 204, '', '', 28, 11, 1, '', '', 78, '', 1),
(12, 'com_content.article', 'Responsive Template Joomla 3.x', 'responsive-template-joomla-3-x', '<p><img src="images/stories/demo/sam-2.jpg" border="0" alt="Sample image" title="Sample image" /></p>\r\n<p>Ut et ante pretium ornare natoque ut eget urna non in. Risus congue Maecenas laoreet gravida id in augue malesuada id id. Feugiat vitae Suspendisse ut id nonummy dapibus molestie at rutrum et. Dui dolor vel accumsan In interdum non sapien et <a href="#" title="Sample link">Phasellus odio.</a></p>\r\n', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, '{"robots":"","author":"","rights":"","xreference":""}', 42, '', '2020-02-06 08:15:05', 0, '2020-02-06 08:15:05', '*', '2020-02-06 08:15:05', '0000-00-00 00:00:00', 73, 205, '', '', 45, 23, 13, 'Joomla 3.x templates design, 3.x Joomla design template, Joomla 3.x mobile design', 'Joomla 3.x responsive design user guide for Joomla lovers.', 78, '', 1),
(13, 'com_content.article', 'Joomla 3.x Fluid & Responsive Design template', 'joomla-3-x-fluid-responsive-design-template', '<p><img src="images/stories/demo/sam-3.jpg" border="0" alt="Sample image" title="Sample image" /></p>\r\n<p><strong>Lorem ipsum</strong> dolor sit amet consectetuer velit nunc tellus gravida Lorem. Orci neque mauris nibh ligula mauris Aenean eu sit sem laoreet. Et ipsum accumsan dis et semper rhoncus Vestibulum ut et est. Leo In Praesent sed Lorem nascetur id tempus et ac semper.</p>\r\n', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, '{"robots":"","author":"","rights":"","xreference":""}', 42, '', '2020-02-06 08:15:05', 0, '2020-02-06 08:15:05', '*', '2020-02-06 08:15:05', '0000-00-00 00:00:00', 69, 206, '', '', 67, 20, 16, 'design Joomla 3.x responsive template, mobile design Joomla 3.x template, Joomla 3.x web design', '3.x Joomla responsive design features on handheld devices.', 78, '', 1);

DROP TABLE IF EXISTS `#__ucm_history`;
CREATE TABLE `#__ucm_history` (
  `version_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ucm_item_id` int(10) unsigned NOT NULL,
  `ucm_type_id` int(10) unsigned NOT NULL,
  `version_note` varchar(255) NOT NULL DEFAULT '' COMMENT 'Optional version name',
  `save_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editor_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `character_count` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Number of characters in this version.',
  `sha1_hash` varchar(50) NOT NULL DEFAULT '' COMMENT 'SHA1 hash of the version_data column.',
  `version_data` longtext NOT NULL COMMENT 'json-encoded string of version data',
  `keep_forever` tinyint(4) NOT NULL DEFAULT 0 COMMENT '0=auto delete; 1=keep',
  PRIMARY KEY (`version_id`),
  KEY `idx_ucm_item_id` (`ucm_type_id`,`ucm_item_id`),
  KEY `idx_save_date` (`save_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `#__update_categories`;
CREATE TABLE `#__update_categories` (
  `categoryid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) DEFAULT '',
  `description` text NOT NULL,
  `parent` int(11) DEFAULT 0,
  `updatesite` int(11) DEFAULT 0,
  PRIMARY KEY (`categoryid`)
) ENGINE=InnoDB COMMENT='Update Categories' DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `#__update_sites`;
CREATE TABLE `#__update_sites` (
  `update_site_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT '',
  `type` varchar(20) DEFAULT '',
  `location` mediumtext NOT NULL,
  `enabled` int(11) DEFAULT 0,
  `last_check_timestamp` bigint(20) DEFAULT 0,
  `extra_query` varchar(1000) DEFAULT '',
  PRIMARY KEY (`update_site_id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 COMMENT='Update Sites' DEFAULT CHARSET=utf8;

INSERT INTO `#__update_sites` (`update_site_id`, `name`, `type`, `location`, `enabled`, `last_check_timestamp`, `extra_query`) VALUES
(1, 'Joomla! Core', 'collection', 'https://update.joomla.org/core/list.xml', 1, 1580976906, ''),
(10, 'Joomla! Update Component Update Site', 'extension', 'https://update.joomla.org/core/extensions/com_joomlaupdate.xml', 1, 1580976950, ''),
(11, 'Accredited Joomla! Translations', 'collection', 'https://update.joomla.org/language/translationlist_3.xml', 1, 1580976919, ''),
(14, 'Accredited Joomla! Translations', 'collection', 'https://update.joomla.org/language/translationlist_3.xml', 1, 1580976920, ''),
(29, '', 'extension', 'http://update.joomlart.com/service/tracking/j16/plg_system_jat3.xml', 1, 1580976920, ''),
(30, '', 'extension', 'http://update.joomlart.com/service/tracking/j16/ja_elastica.xml', 1, 1580976921, ''),
(31, 'JA Extension Manager', 'extension', 'http://update.joomlart.com/service/tracking/j16/com_jaextmanager.xml', 1, 1580976921, '');

DROP TABLE IF EXISTS `#__update_sites_extensions`;
CREATE TABLE `#__update_sites_extensions` (
  `update_site_id` int(11) NOT NULL DEFAULT 0,
  `extension_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`update_site_id`,`extension_id`)
) ENGINE=InnoDB COMMENT='Links extensions to update sites' DEFAULT CHARSET=utf8;

INSERT INTO `#__update_sites_extensions` (`update_site_id`, `extension_id`) VALUES
(1, 700),
(2, 700),
(3, 600),
(10, 10035),
(11, 802),
(14, 10044),
(29, 10001),
(30, 10013),
(31, 10002);
INSERT IGNORE INTO `#__update_sites_extensions` VALUES
(1, 700),
(2, 700),
(3, 600);

DROP TABLE IF EXISTS `#__updates`;
CREATE TABLE `#__updates` (
  `update_id` int(11) NOT NULL AUTO_INCREMENT,
  `update_site_id` int(11) DEFAULT 0,
  `extension_id` int(11) DEFAULT 0,
  `name` varchar(100) DEFAULT '',
  `description` mediumtext NOT NULL,
  `element` varchar(100) DEFAULT '',
  `type` varchar(20) DEFAULT '',
  `folder` varchar(20) DEFAULT '',
  `client_id` tinyint(3) DEFAULT 0,
  `version` varchar(32) DEFAULT '',
  `data` mediumtext NOT NULL,
  `detailsurl` mediumtext NOT NULL,
  `infourl` mediumtext NOT NULL,
  `extra_query` varchar(1000) DEFAULT '',
  PRIMARY KEY (`update_id`)
) ENGINE=InnoDB AUTO_INCREMENT=80 COMMENT='Available Updates' DEFAULT CHARSET=utf8;

INSERT INTO `#__updates` (`update_id`, `update_site_id`, `extension_id`, `name`, `description`, `element`, `type`, `folder`, `client_id`, `version`, `data`, `detailsurl`, `infourl`, `extra_query`) VALUES
(2, 11, 0, 'Armenian', '', 'pkg_hy-AM', 'package', '', 0, '3.4.4.1', '', 'https://update.joomla.org/language/details3/hy-AM_details.xml', '', ''),
(3, 11, 0, 'Malay', '', 'pkg_ms-MY', 'package', '', 0, '3.4.1.2', '', 'https://update.joomla.org/language/details3/ms-MY_details.xml', '', ''),
(4, 11, 0, 'Romanian', '', 'pkg_ro-RO', 'package', '', 0, '3.9.13.1', '', 'https://update.joomla.org/language/details3/ro-RO_details.xml', '', ''),
(5, 11, 0, 'Flemish', '', 'pkg_nl-BE', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/nl-BE_details.xml', '', ''),
(6, 11, 0, 'Chinese Traditional', '', 'pkg_zh-TW', 'package', '', 0, '3.8.0.1', '', 'https://update.joomla.org/language/details3/zh-TW_details.xml', '', ''),
(7, 11, 0, 'French', '', 'pkg_fr-FR', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/fr-FR_details.xml', '', ''),
(8, 11, 0, 'Galician', '', 'pkg_gl-ES', 'package', '', 0, '3.3.1.2', '', 'https://update.joomla.org/language/details3/gl-ES_details.xml', '', ''),
(9, 11, 0, 'Georgian', '', 'pkg_ka-GE', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/ka-GE_details.xml', '', ''),
(10, 11, 0, 'Greek', '', 'pkg_el-GR', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/el-GR_details.xml', '', ''),
(11, 11, 0, 'Japanese', '', 'pkg_ja-JP', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/ja-JP_details.xml', '', ''),
(12, 11, 0, 'Hebrew', '', 'pkg_he-IL', 'package', '', 0, '3.1.1.2', '', 'https://update.joomla.org/language/details3/he-IL_details.xml', '', ''),
(13, 11, 0, 'Bengali', '', 'pkg_bn-BD', 'package', '', 0, '3.8.10.1', '', 'https://update.joomla.org/language/details3/bn-BD_details.xml', '', ''),
(14, 11, 0, 'Hungarian', '', 'pkg_hu-HU', 'package', '', 0, '3.9.12.1', '', 'https://update.joomla.org/language/details3/hu-HU_details.xml', '', ''),
(15, 11, 0, 'Afrikaans', '', 'pkg_af-ZA', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/af-ZA_details.xml', '', ''),
(16, 11, 0, 'Arabic Unitag', '', 'pkg_ar-AA', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/ar-AA_details.xml', '', ''),
(17, 11, 0, 'Belarusian', '', 'pkg_be-BY', 'package', '', 0, '3.2.1.2', '', 'https://update.joomla.org/language/details3/be-BY_details.xml', '', ''),
(18, 11, 0, 'Bulgarian', '', 'pkg_bg-BG', 'package', '', 0, '3.6.5.2', '', 'https://update.joomla.org/language/details3/bg-BG_details.xml', '', ''),
(19, 11, 0, 'Catalan', '', 'pkg_ca-ES', 'package', '', 0, '3.9.11.2', '', 'https://update.joomla.org/language/details3/ca-ES_details.xml', '', ''),
(20, 11, 0, 'Chinese Simplified', '', 'pkg_zh-CN', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/zh-CN_details.xml', '', ''),
(21, 11, 0, 'Croatian', '', 'pkg_hr-HR', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/hr-HR_details.xml', '', ''),
(22, 11, 0, 'Czech', '', 'pkg_cs-CZ', 'package', '', 0, '3.9.13.1', '', 'https://update.joomla.org/language/details3/cs-CZ_details.xml', '', ''),
(23, 11, 0, 'Danish', '', 'pkg_da-DK', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/da-DK_details.xml', '', ''),
(24, 11, 0, 'Dutch', '', 'pkg_nl-NL', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/nl-NL_details.xml', '', ''),
(25, 11, 0, 'Esperanto', '', 'pkg_eo-XX', 'package', '', 0, '3.8.11.1', '', 'https://update.joomla.org/language/details3/eo-XX_details.xml', '', ''),
(26, 11, 0, 'Estonian', '', 'pkg_et-EE', 'package', '', 0, '3.9.14.2', '', 'https://update.joomla.org/language/details3/et-EE_details.xml', '', ''),
(27, 11, 0, 'Italian', '', 'pkg_it-IT', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/it-IT_details.xml', '', ''),
(28, 11, 0, 'Khmer', '', 'pkg_km-KH', 'package', '', 0, '3.4.5.1', '', 'https://update.joomla.org/language/details3/km-KH_details.xml', '', ''),
(29, 11, 0, 'Korean', '', 'pkg_ko-KR', 'package', '', 0, '3.8.9.1', '', 'https://update.joomla.org/language/details3/ko-KR_details.xml', '', ''),
(30, 11, 0, 'Latvian', '', 'pkg_lv-LV', 'package', '', 0, '3.7.3.1', '', 'https://update.joomla.org/language/details3/lv-LV_details.xml', '', ''),
(31, 11, 0, 'Lithuanian', '', 'pkg_lt-LT', 'package', '', 0, '3.9.6.1', '', 'https://update.joomla.org/language/details3/lt-LT_details.xml', '', ''),
(32, 11, 0, 'Macedonian', '', 'pkg_mk-MK', 'package', '', 0, '3.6.5.1', '', 'https://update.joomla.org/language/details3/mk-MK_details.xml', '', ''),
(33, 11, 0, 'Norwegian Bokmal', '', 'pkg_nb-NO', 'package', '', 0, '3.8.11.1', '', 'https://update.joomla.org/language/details3/nb-NO_details.xml', '', ''),
(34, 11, 0, 'Norwegian Nynorsk', '', 'pkg_nn-NO', 'package', '', 0, '3.4.2.1', '', 'https://update.joomla.org/language/details3/nn-NO_details.xml', '', ''),
(35, 11, 0, 'Persian', '', 'pkg_fa-IR', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/fa-IR_details.xml', '', ''),
(36, 11, 0, 'Polish', '', 'pkg_pl-PL', 'package', '', 0, '3.9.13.1', '', 'https://update.joomla.org/language/details3/pl-PL_details.xml', '', ''),
(37, 11, 0, 'Portuguese', '', 'pkg_pt-PT', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/pt-PT_details.xml', '', ''),
(38, 11, 0, 'Russian', '', 'pkg_ru-RU', 'package', '', 0, '3.9.12.1', '', 'https://update.joomla.org/language/details3/ru-RU_details.xml', '', ''),
(39, 11, 0, 'English AU', '', 'pkg_en-AU', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/en-AU_details.xml', '', ''),
(40, 11, 0, 'Slovak', '', 'pkg_sk-SK', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/sk-SK_details.xml', '', ''),
(41, 11, 0, 'English US', '', 'pkg_en-US', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/en-US_details.xml', '', ''),
(42, 11, 0, 'Swedish', '', 'pkg_sv-SE', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/sv-SE_details.xml', '', ''),
(43, 11, 0, 'Syriac', '', 'pkg_sy-IQ', 'package', '', 0, '3.4.5.1', '', 'https://update.joomla.org/language/details3/sy-IQ_details.xml', '', ''),
(44, 11, 0, 'Tamil', '', 'pkg_ta-IN', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/ta-IN_details.xml', '', ''),
(45, 11, 0, 'Thai', '', 'pkg_th-TH', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/th-TH_details.xml', '', ''),
(46, 11, 0, 'Turkish', '', 'pkg_tr-TR', 'package', '', 0, '3.9.4.1', '', 'https://update.joomla.org/language/details3/tr-TR_details.xml', '', ''),
(47, 11, 0, 'Ukrainian', '', 'pkg_uk-UA', 'package', '', 0, '3.7.1.1', '', 'https://update.joomla.org/language/details3/uk-UA_details.xml', '', ''),
(48, 11, 0, 'Uyghur', '', 'pkg_ug-CN', 'package', '', 0, '3.7.5.2', '', 'https://update.joomla.org/language/details3/ug-CN_details.xml', '', ''),
(49, 11, 0, 'Albanian', '', 'pkg_sq-AL', 'package', '', 0, '3.1.1.2', '', 'https://update.joomla.org/language/details3/sq-AL_details.xml', '', ''),
(50, 11, 0, 'Basque', '', 'pkg_eu-ES', 'package', '', 0, '3.7.5.1', '', 'https://update.joomla.org/language/details3/eu-ES_details.xml', '', ''),
(51, 11, 0, 'Hindi', '', 'pkg_hi-IN', 'package', '', 0, '3.3.6.2', '', 'https://update.joomla.org/language/details3/hi-IN_details.xml', '', ''),
(52, 11, 0, 'German DE', '', 'pkg_de-DE', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/de-DE_details.xml', '', ''),
(53, 11, 0, 'Portuguese Brazil', '', 'pkg_pt-BR', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/pt-BR_details.xml', '', ''),
(54, 11, 0, 'Serbian Latin', '', 'pkg_sr-YU', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/sr-YU_details.xml', '', ''),
(55, 11, 0, 'Spanish', '', 'pkg_es-ES', 'package', '', 0, '3.9.11.1', '', 'https://update.joomla.org/language/details3/es-ES_details.xml', '', ''),
(56, 11, 0, 'Bosnian', '', 'pkg_bs-BA', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/bs-BA_details.xml', '', ''),
(57, 11, 0, 'Serbian Cyrillic', '', 'pkg_sr-RS', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/sr-RS_details.xml', '', ''),
(58, 11, 0, 'Vietnamese', '', 'pkg_vi-VN', 'package', '', 0, '3.2.1.2', '', 'https://update.joomla.org/language/details3/vi-VN_details.xml', '', ''),
(59, 11, 0, 'Bahasa Indonesia', '', 'pkg_id-ID', 'package', '', 0, '3.6.2.1', '', 'https://update.joomla.org/language/details3/id-ID_details.xml', '', ''),
(60, 11, 0, 'Finnish', '', 'pkg_fi-FI', 'package', '', 0, '3.9.14.1', '', 'https://update.joomla.org/language/details3/fi-FI_details.xml', '', ''),
(61, 11, 0, 'Swahili', '', 'pkg_sw-KE', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/sw-KE_details.xml', '', ''),
(62, 11, 0, 'Montenegrin', '', 'pkg_srp-ME', 'package', '', 0, '3.3.1.2', '', 'https://update.joomla.org/language/details3/srp-ME_details.xml', '', ''),
(63, 11, 0, 'English CA', '', 'pkg_en-CA', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/en-CA_details.xml', '', ''),
(64, 11, 0, 'French CA', '', 'pkg_fr-CA', 'package', '', 0, '3.6.5.1', '', 'https://update.joomla.org/language/details3/fr-CA_details.xml', '', ''),
(65, 11, 0, 'Welsh', '', 'pkg_cy-GB', 'package', '', 0, '3.9.14.1', '', 'https://update.joomla.org/language/details3/cy-GB_details.xml', '', ''),
(66, 11, 0, 'Sinhala', '', 'pkg_si-LK', 'package', '', 0, '3.3.1.2', '', 'https://update.joomla.org/language/details3/si-LK_details.xml', '', ''),
(67, 11, 0, 'Dari Persian', '', 'pkg_prs-AF', 'package', '', 0, '3.4.4.3', '', 'https://update.joomla.org/language/details3/prs-AF_details.xml', '', ''),
(68, 11, 0, 'Turkmen', '', 'pkg_tk-TM', 'package', '', 0, '3.5.0.2', '', 'https://update.joomla.org/language/details3/tk-TM_details.xml', '', ''),
(69, 11, 0, 'Irish', '', 'pkg_ga-IE', 'package', '', 0, '3.8.13.1', '', 'https://update.joomla.org/language/details3/ga-IE_details.xml', '', ''),
(70, 11, 0, 'Dzongkha', '', 'pkg_dz-BT', 'package', '', 0, '3.6.2.1', '', 'https://update.joomla.org/language/details3/dz-BT_details.xml', '', ''),
(71, 11, 0, 'Slovenian', '', 'pkg_sl-SI', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/sl-SI_details.xml', '', ''),
(72, 11, 0, 'Spanish CO', '', 'pkg_es-CO', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/es-CO_details.xml', '', ''),
(73, 11, 0, 'German CH', '', 'pkg_de-CH', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/de-CH_details.xml', '', ''),
(74, 11, 0, 'German AT', '', 'pkg_de-AT', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/de-AT_details.xml', '', ''),
(75, 11, 0, 'German LI', '', 'pkg_de-LI', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/de-LI_details.xml', '', ''),
(76, 11, 0, 'German LU', '', 'pkg_de-LU', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/de-LU_details.xml', '', ''),
(77, 11, 0, 'English NZ', '', 'pkg_en-NZ', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/en-NZ_details.xml', '', ''),
(78, 11, 0, 'Kazakh', '', 'pkg_kk-KZ', 'package', '', 0, '3.9.15.1', '', 'https://update.joomla.org/language/details3/kk-KZ_details.xml', '', '');

DROP TABLE IF EXISTS `#__user_keys`;
CREATE TABLE `#__user_keys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` varchar(150) NOT NULL,
  `token` varchar(255) NOT NULL,
  `series` varchar(191) NOT NULL,
  `invalid` tinyint(4) NOT NULL,
  `time` varchar(200) NOT NULL,
  `uastring` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `series` (`series`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `#__user_notes`;
CREATE TABLE `#__user_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `catid` int(10) unsigned NOT NULL DEFAULT 0,
  `subject` varchar(100) NOT NULL DEFAULT '',
  `body` mediumtext NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) unsigned NOT NULL,
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `review_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_category_id` (`catid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `#__user_profiles`;
CREATE TABLE `#__user_profiles` (
  `user_id` int(11) NOT NULL,
  `profile_key` varchar(100) NOT NULL,
  `profile_value` mediumtext NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  UNIQUE KEY `idx_user_id_profile_key` (`user_id`,`profile_key`)
) ENGINE=InnoDB COMMENT='Simple user profile storage table' DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `#__user_usergroup_map`;
CREATE TABLE `#__user_usergroup_map` (
  `user_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Foreign Key to #__users.id',
  `group_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Foreign Key to #__usergroups.id',
  PRIMARY KEY (`user_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `#__usergroups`;
CREATE TABLE `#__usergroups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Adjacency List Reference Id',
  `lft` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set rgt.',
  `title` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_usergroup_title_lookup` (`title`),
  KEY `idx_usergroup_adjacency_lookup` (`parent_id`),
  KEY `idx_usergroup_nested_set_lookup` (`lft`,`rgt`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO `#__usergroups` (`id`, `parent_id`, `lft`, `rgt`, `title`) VALUES
(1, 0, 1, 20, 'Public'),
(2, 1, 6, 17, 'Registered'),
(3, 2, 7, 14, 'Author'),
(4, 3, 8, 11, 'Editor'),
(5, 4, 9, 10, 'Publisher'),
(6, 1, 2, 5, 'Manager'),
(7, 6, 3, 4, 'Administrator'),
(8, 1, 18, 19, 'Super Users'),
(10, 3, 12, 13, 'Shop Suppliers'),
(12, 2, 15, 16, 'Customer Group');

DROP TABLE IF EXISTS `#__users`;
CREATE TABLE `#__users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(400) NOT NULL DEFAULT '',
  `username` varchar(150) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `password` varchar(100) NOT NULL DEFAULT '',
  `block` tinyint(4) NOT NULL DEFAULT 0,
  `sendEmail` tinyint(4) DEFAULT 0,
  `registerDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastvisitDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `activation` varchar(100) NOT NULL DEFAULT '',
  `params` mediumtext NOT NULL,
  `lastResetTime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Date of last password reset',
  `resetCount` int(11) NOT NULL DEFAULT 0 COMMENT 'Count of password resets since lastResetTime',
  `otpKey` varchar(1000) NOT NULL DEFAULT '' COMMENT 'Two factor authentication encrypted keys',
  `otep` varchar(1000) NOT NULL DEFAULT '' COMMENT 'One time emergency passwords',
  `requireReset` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'Require user to reset password on next login',
  PRIMARY KEY (`id`),
  KEY `idx_block` (`block`),
  KEY `username` (`username`),
  KEY `email` (`email`),
  KEY `idx_name` (`name`(100))
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `#__utf8_conversion`;
CREATE TABLE `#__utf8_conversion` (
  `converted` tinyint(4) NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__utf8_conversion` (`converted`) VALUES
(2);

DROP TABLE IF EXISTS `#__viewlevels`;
CREATE TABLE `#__viewlevels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `title` varchar(100) NOT NULL DEFAULT '',
  `ordering` int(11) NOT NULL DEFAULT 0,
  `rules` varchar(5120) NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_assetgroup_title_lookup` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `#__viewlevels` (`id`, `title`, `ordering`, `rules`) VALUES
(1, 'Public', 0, '[]'),
(2, 'Registered', 1, '[6,2,8]'),
(3, 'Special', 2, '[6,7,8]'),
(4, 'Customer Access Level', 3, '[6,3,12]');

