<?php

/**
T4 Overide
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;

if (!class_exists('ContentHelperRoute')) {
  if (version_compare(JVERSION, '4', 'ge')) {
    abstract class ContentHelperRoute extends \Joomla\Component\Content\Site\Helper\RouteHelper
    {
    };
  } else {
    JLoader::register('ContentHelperRoute', $com_path . '/helpers/route.php');
  }
}
//compatible params on joomla 4
$this->columns = !empty($this->columns) ? $this->columns : $this->params->get('num_columns');
$this->blog_class_leading = $this->params->get('blog_class_leading', '');
$this->blog_class = $this->params->get('blog_class', '');

$app = Factory::getApplication();

$this->category->text = $this->category->description;
$app->triggerEvent('onContentPrepare', array($this->category->extension . '.categories', &$this->category, &$this->params, 0));
$this->category->description = $this->category->text;

$results = $app->triggerEvent('onContentAfterTitle', array($this->category->extension . '.categories', &$this->category, &$this->params, 0));
$afterDisplayTitle = trim(implode("\n", $results));

$results = $app->triggerEvent('onContentBeforeDisplay', array($this->category->extension . '.categories', &$this->category, &$this->params, 0));
$beforeDisplayContent = trim(implode("\n", $results));

$results = $app->triggerEvent('onContentAfterDisplay', array($this->category->extension . '.categories', &$this->category, &$this->params, 0));
$afterDisplayContent = trim(implode("\n", $results));

$htag    = $this->params->get('show_page_heading') ? 'h2' : 'h1';

// init columns value if not set
if (empty($this->columns)) $this->columns = 1;

?>
<div class="com-content-category-blog blog projects <?php echo $this->pageclass_sfx; ?>" itemscope itemtype="https://schema.org/Blog">
  <?php if ($this->params->get('show_page_heading')) : ?>
    <div class="page-header">
      <h1> <?php echo $this->escape($this->params->get('page_heading')); ?> </h1>
    </div>
  <?php endif; ?>

  <?php if ($this->params->get('show_category_title', 1) or $this->params->get('page_subheading')) : ?>
    <div class="page-subheader clearfix">
      <<?php echo $htag; ?> class="page-subtitle"> <?php echo $this->escape($this->params->get('page_subheading')); ?>
        <?php if ($this->params->get('show_category_title')) : ?>
          <span class="subheading-category"><?php echo $this->category->title; ?></span>
        <?php endif; ?>
      </<?php echo $htag; ?>>
    </div>
  <?php endif; ?>

  <?php echo $afterDisplayTitle; ?>

  <?php if ($this->params->get('show_cat_tags', 1) && !empty($this->category->tags->itemTags)) : ?>
    <?php $this->category->tagLayout = new FileLayout('joomla.content.tags'); ?>
    <?php echo $this->category->tagLayout->render($this->category->tags->itemTags); ?>
  <?php endif; ?>

  <?php if ($beforeDisplayContent || $afterDisplayContent || $this->params->get('show_description', 1) || $this->params->def('show_description_image', 1)) : ?>
    <div class="category-desc clearfix">
      <?php if ($this->params->get('show_description_image') && $this->category->getParams()->get('image')) : ?>
        <?php $alt = empty($this->category->getParams()->get('image_alt')) && empty($this->category->getParams()->get('image_alt_empty')) ? '' : 'alt="' . htmlspecialchars($this->category->getParams()->get('image_alt'), ENT_COMPAT, 'UTF-8') . '"'; ?>
        <img src="<?php echo $this->category->getParams()->get('image'); ?>" <?php echo $alt; ?>>
      <?php endif; ?>
      <?php echo $beforeDisplayContent; ?>
      <?php if ($this->params->get('show_description') && $this->category->description) : ?>
        <?php echo HTMLHelper::_('content.prepare', $this->category->description, '', 'com_content.category'); ?>
      <?php endif; ?>
      <?php echo $afterDisplayContent; ?>
    </div>
  <?php endif; ?>

  <?php if (empty($this->lead_items) && empty($this->link_items) && empty($this->intro_items)) : ?>
    <?php if ($this->params->get('show_no_articles', 1)) : ?>
      <p><?php echo Text::_('COM_CONTENT_NO_ARTICLES'); ?></p>
    <?php endif; ?>
  <?php endif; ?>

  <?php $leadingcount = 0; ?>
  <?php if (!empty($this->lead_items)) : ?>
    <div class="com-content-category-blog__items blog-items items-leading <?php echo $this->blog_class_leading; ?>">
      <?php foreach ($this->lead_items as &$item) : ?>
        <div class="com-content-category-blog__item blog-item" itemprop="blogPost" itemscope itemtype="https://schema.org/BlogPosting">
          <div class="blog-item-content"><!-- Double divs required for IE11 grid fallback -->
            <?php
            $this->item = &$item;
            echo $this->loadTemplate('item');
            ?>
          </div>
        </div>
        <?php $leadingcount++; ?>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>

  <?php
  $introcount = count($this->intro_items);
  $counter = 0;
  ?>

  <?php if (!empty($this->intro_items)) : ?>
    <?php foreach ($this->intro_items as $key => &$item) : ?>
      <?php $rowcount = ((int) $key % (int) $this->columns) + 1; ?>
      <?php if ($rowcount === 1) : ?>
        <?php $row = $counter / $this->columns; ?>
        <div class="items-row cols-<?php echo (int) $this->columns; ?> <?php echo 'row-' . $row; ?> row">
        <?php endif; ?>
        <div class="col-lg-<?php echo round(12 / $this->columns); ?>">
          <div class="item column-<?php echo $rowcount; ?><?php echo $item->state == 0 ? ' system-unpublished' : null; ?>" itemprop="blogPost" itemscope itemtype="https://schema.org/BlogPosting">
            <?php
            $this->item = &$item;
            echo $this->loadTemplate('item');
            ?>
          </div><!-- end item -->
          <?php $counter++; ?>
        </div><!-- end span -->
        <?php if (($rowcount == $this->columns) or ($counter == $introcount)) : ?>
        </div><!-- end row -->
      <?php endif; ?>
    <?php endforeach; ?>

  <?php endif; ?>

  <?php if (!empty($this->link_items)) : ?>
    <div class="com-content-category-blog__items-more items-more">
      <?php echo $this->loadTemplate('links'); ?>
    </div>
  <?php endif; ?>

  <?php if ($this->maxLevel != 0 && !empty($this->children[$this->category->id])) : ?>
    <div class="com-content-category-blog__children cat-children">
      <?php if ($this->params->get('show_category_heading_title_text', 1) == 1) : ?>
        <h3> <?php echo Text::_('JGLOBAL_SUBCATEGORIES'); ?> </h3>
      <?php endif; ?>
      <?php echo $this->loadTemplate('children'); ?>
    </div>
  <?php endif; ?>
  <?php if (($this->params->def('show_pagination', 1) == 1 || ($this->params->get('show_pagination') == 2)) && ($this->pagination->pagesTotal > 1)) : ?>
    <div class="pagination-wrap">
      <?php echo $this->pagination->getPagesLinks(); ?>
      <?php if ($this->params->def('show_pagination_results', 1)) : ?>
        <p class="counter">
          <?php echo $this->pagination->getPagesCounter(); ?>
        </p>
      <?php endif; ?>
    </div>
  <?php endif; ?>
</div>